/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.hbase;

import com.mapr.baseutils.BinaryString;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.hbase.HTableDescriptorProxy;
import com.mapr.fs.hbase.HTableProperties;
import com.mapr.fs.hbase.MapRDBConstants;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.proto.Marlincommon;
import com.mapr.fs.proto.Marlinserver;
import com.mapr.fs.tables.TableProperties;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.regionserver.BloomType;

public class SchemaHelper
implements MapRDBConstants {
    private static final long MILLISECONDS_TO_SECONDS = 1000L;
    private static final String COMPRESSION_RAW = "compression_raw";

    public static HColumnDescriptor toHColumnDescriptor(Dbserver.SchemaFamily schemaFamily) {
        return new HColumnDescriptor(schemaFamily.getName()).setValueInt("BLOCKSIZE", 8192).setValueBool("IN_MEMORY", schemaFamily.getInMemory()).setValueInt("VERSIONS", schemaFamily.getMaxVersions()).setValueInt("MIN_VERSIONS", schemaFamily.getMinVersions()).setValueStr("BLOOMFILTER", BloomType.ROW.toString()).setValueStr("COMPRESSION", SchemaHelper.toAlgorithmStr(schemaFamily.getCompression())).setValueInt("TTL", schemaFamily.hasTtl() ? (int)(schemaFamily.getTtl() / 1000L) : Integer.MAX_VALUE).setValue(COMPRESSION_RAW, Integer.toString(schemaFamily.getCompression().getNumber()));
    }

    public static Dbserver.ColumnFamilyAttr toColumnFamilyAttr(HColumnDescriptor newcf, boolean setName) {
        return SchemaHelper.toColumnFamilyAttr(null, newcf, setName);
    }

    public static Dbserver.ColumnFamilyAttr toColumnFamilyAttr(HColumnDescriptor oldcf, HColumnDescriptor newcf, boolean setName) {
        return Dbserver.ColumnFamilyAttr.newBuilder().setSchFamily(SchemaHelper.toSchemaFamily(oldcf, newcf, setName)).build();
    }

    private static Dbserver.SchemaFamily toSchemaFamily(HColumnDescriptor oldcf, HColumnDescriptor newcf, boolean setName) {
        Dbserver.SchemaFamily.Builder builder = Dbserver.SchemaFamily.newBuilder();
        if (setName && (oldcf == null || !oldcf.getNameAsString().equals(newcf.getNameAsString()))) {
            builder.setName(newcf.getNameAsString());
        }
        if (oldcf == null || oldcf.isInMemory() != newcf.isInMemory()) {
            builder.setInMemory(newcf.isInMemory());
        }
        if (oldcf == null || oldcf.getMinVersions() != newcf.getMinVersions()) {
            builder.setMinVersions(newcf.getMinVersions());
        }
        if (oldcf == null || oldcf.getMaxVersions() != newcf.getMaxVersions()) {
            builder.setMaxVersions(newcf.getMaxVersions());
        }
        if (oldcf == null || oldcf.getTimeToLive() != newcf.getTimeToLive()) {
            builder.setTtl((long)newcf.getTimeToLive() * 1000L);
        }
        if (oldcf == null && newcf.getValue(COMPRESSION_RAW) != null) {
            builder.setCompression(Common.FileCompressionType.valueOf((int)Integer.parseInt(newcf.getValue(COMPRESSION_RAW))));
        } else if (oldcf == null || oldcf.getCompression() != newcf.getCompression()) {
            builder.setCompression(SchemaHelper.toFileCompressionType(newcf.getCompression()));
        }
        return builder.build();
    }

    public boolean validCompressionType(Compression.Algorithm algorithm) {
        switch (algorithm) {
            case NONE: 
            case GZ: 
            case LZO: 
            case LZ4: {
                return true;
            }
        }
        return false;
    }

    public static Common.FileCompressionType toFileCompressionType(Compression.Algorithm algorithm) {
        switch (algorithm) {
            case NONE: {
                return Common.FileCompressionType.FCT_OFF;
            }
            case GZ: {
                return Common.FileCompressionType.FCT_ZLIB;
            }
        }
        return Common.FileCompressionType.FCT_LZ4;
    }

    public static Compression.Algorithm toAlgorithm(Common.FileCompressionType fct) {
        switch (fct) {
            case FCT_ZLIB: {
                return Compression.Algorithm.GZ;
            }
            case FCT_OFF: {
                return Compression.Algorithm.NONE;
            }
        }
        return Compression.Algorithm.LZ4;
    }

    public static String toAlgorithmStr(Common.FileCompressionType fct) {
        switch (fct) {
            case FCT_ZLIB: {
                return "GZ";
            }
            case FCT_OFF: {
                return "NONE";
            }
        }
        return "LZ4";
    }

    public static HTableDescriptor toHTableDescriptor(MapRFileSystem mfs, Path path) throws IOException {
        return SchemaHelper.toHTableDescriptor(mfs, path, false);
    }

    public static HTableDescriptor toHTableDescriptor(MapRFileSystem mfs, Path path, boolean useName) throws IOException {
        HTableDescriptor desc = new HTableDescriptor(useName ? path.getName() : path.toUri().getPath());
        HTableDescriptorProxy.setValue(desc, "IS_META", FALSE);
        HTableDescriptorProxy.setValue(desc, "IS_ROOT", FALSE);
        TableProperties tableProp = mfs.getTableProperties(path);
        byte[] uuid = tableProp.getUuid();
        if (uuid != null && uuid.length != 0) {
            HTableDescriptorProxy.setValue(desc, "MAPR_UUID", BinaryString.toUUIDString((byte[])uuid));
        }
        SchemaHelper.fromTableAttr(tableProp.getAttr(), desc);
        List cfAttributes = mfs.listColumnFamily(mfs.resolveTablePath(path), false);
        for (Dbserver.ColumnFamilyAttr cfAttr : cfAttributes) {
            HTableDescriptorProxy.addFamily(desc, SchemaHelper.toHColumnDescriptor(cfAttr.getSchFamily()));
        }
        HTableProperties.addPropertiesToTableDescriptor(path, desc);
        return desc;
    }

    public static void fromTableAttr(Dbserver.TableAttr attr, HTableDescriptor desc) {
        Marlinserver.MarlinInternalDefaults mdef = Marlinserver.MarlinInternalDefaults.getDefaultInstance();
        if (attr.hasBulkLoad()) {
            HTableDescriptorProxy.setValue(desc, "BULKLOAD", attr.getBulkLoad() ? "true" : "false");
        }
        if (attr.hasAutoSplit()) {
            HTableDescriptorProxy.setValue(desc, "AUTOSPLIT", attr.getAutoSplit() ? "true" : "false");
        }
        if (attr.hasRegionSizeMB()) {
            HTableDescriptorProxy.setValue(desc, "MAX_FILESIZE", Long.toString(attr.getRegionSizeMB() * 1024L * 1024L));
        }
        if (attr.hasMaxValueSzInMemIndex()) {
            HTableDescriptorProxy.setValue(desc, "MAX_VALUE_SIZE_IN_MEM", Integer.toString(attr.getMaxValueSzInMemIndex()));
        }
        if (attr.hasReclaimThreshPcntForPack()) {
            HTableDescriptorProxy.setValue(desc, "RECLAIM_THRESH_PCNT_FOR_PACK", Integer.toString(attr.getReclaimThreshPcntForPack()));
        }
        if (attr.hasMaxSpills()) {
            HTableDescriptorProxy.setValue(desc, "MAXSPILLS", Integer.toString(attr.getMaxSpills()));
        }
        if (attr.hasMiniPack()) {
            HTableDescriptorProxy.setValue(desc, "MINIPACK", attr.getMiniPack() ? "true" : "false");
        }
        if (attr.hasSizeThreshPcntForPack()) {
            HTableDescriptorProxy.setValue(desc, "SIZE_THRESH_PCNT_FOR_PACK", Integer.toString(attr.getSizeThreshPcntForPack()));
        }
        if (attr.hasDeleteTTL()) {
            HTableDescriptorProxy.setValue(desc, "DELETE_TTL", Long.toString(attr.getDeleteTTL()));
        }
        if (attr.hasIsMarlinTable()) {
            HTableDescriptorProxy.setValue(desc, mdef.getHattrIsMarlinTable(), attr.getIsMarlinTable() ? "true" : "false");
        }
        if (attr.hasMarlinAttr()) {
            Marlincommon.MarlinTableAttr mattr = attr.getMarlinAttr();
            if (mattr.hasAutoCreateTopics()) {
                HTableDescriptorProxy.setValue(desc, mdef.getHattrAutoCreateTopics(), mattr.getAutoCreateTopics() ? "true" : "false");
            }
            if (mattr.hasDefaultNumFeedsPerTopic()) {
                HTableDescriptorProxy.setValue(desc, mdef.getHattrDefaultPartitions(), Integer.toString(mattr.getDefaultNumFeedsPerTopic()));
            }
        }
        if (attr.hasJson()) {
            HTableDescriptorProxy.setValue(desc, "TABLETYPE", attr.getJson() ? "JSON" : "BINARY");
            if (attr.hasInsertionOrder()) {
                HTableDescriptorProxy.setValue(desc, "JSON_INSERT_ORDER", attr.getInsertionOrder() ? "true" : "false");
            }
        }
    }

    public static enum Compression {
        LZF,
        LZO,
        LZ4,
        ZLIB,
        GZ,
        OFF,
        NONE;

    }
}

