/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.util;

import com.mapr.db.rowcol.SerializationContext;
import com.mapr.db.rowcol.TimeAndUniq;
import com.mapr.db.rowcol.TimeDescriptor;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.ojai.Value;

public class MCFTreeNode2 {
    Map<String, MCFTreeNode2> children_ = new HashMap<String, MCFTreeNode2>();
    MCFTreeNode2 parent_;
    ByteBuffer dataBuf_;
    Value.Type type_;
    String fieldName_;
    int fieldIndex_;
    TimeAndUniq fieldIndexTime_;
    int currentParseIndex_;
    boolean visited_;
    SerializationContext ctx_;
    boolean doneParsingDataBuffer_;
    TimeAndUniq[] cudTimes_;
    TimeDescriptor.TimeStampState[] timeStates_;
    TimeAndUniq[] rootTimes_;
    boolean hasDeletesAtOrBelow_;
    boolean hasCreatesAtOrAbove_;
    boolean isExplicitlyDeleted_;

    public MCFTreeNode2(MCFTreeNode2 p) {
        this.parent_ = p;
        this.dataBuf_ = null;
        this.type_ = Value.Type.MAP;
        this.fieldName_ = null;
        this.fieldIndex_ = -1;
        this.fieldIndexTime_ = null;
        this.currentParseIndex_ = -1;
        this.visited_ = false;
        this.ctx_ = null;
        this.doneParsingDataBuffer_ = false;
        this.cudTimes_ = new TimeAndUniq[3];
        this.timeStates_ = new TimeDescriptor.TimeStampState[3];
        this.rootTimes_ = null;
        this.hasDeletesAtOrBelow_ = false;
        this.hasCreatesAtOrAbove_ = false;
        this.isExplicitlyDeleted_ = false;
        this.clearCudTimeAndStates();
    }

    public void setFieldName(String str) {
        this.fieldName_ = str;
    }

    public void setFieldIndex(int idx) {
        this.fieldIndex_ = idx;
    }

    public void setFieldIndexTime(TimeAndUniq tu) {
        this.fieldIndexTime_ = tu == null ? null : new TimeAndUniq(tu);
    }

    public void setDataBuffer(ByteBuffer data) {
        this.dataBuf_ = data;
    }

    public ByteBuffer getDataBuffer() {
        return this.dataBuf_;
    }

    public void addChild(String s, MCFTreeNode2 c) {
        this.children_.put(s, c);
    }

    public MCFTreeNode2 getChild(String s) {
        return this.children_.get(s);
    }

    public void setType(Value.Type t) {
        this.type_ = t;
    }

    public Value.Type getType() {
        return this.type_;
    }

    public String getFieldName() {
        return this.fieldName_;
    }

    public MCFTreeNode2 getParent() {
        return this.parent_;
    }

    public void incrementCurrentParseIndex() {
        ++this.currentParseIndex_;
    }

    public int currentParseIndex() {
        return this.currentParseIndex_;
    }

    public int getFieldIndex() {
        return this.fieldIndex_;
    }

    public TimeAndUniq getFieldIndexTime() {
        return this.fieldIndexTime_;
    }

    public void markVisited() {
        this.visited_ = true;
    }

    public boolean isVisited() {
        return this.visited_;
    }

    public void setContext(SerializationContext ctx) {
        this.ctx_ = ctx;
    }

    public SerializationContext getContext() {
        return this.ctx_;
    }

    public void removeChild(String child) {
        this.children_.remove(child);
    }

    public Map<String, MCFTreeNode2> getChildren() {
        return this.children_;
    }

    public void setDoneParsingDataBuffer() {
        this.doneParsingDataBuffer_ = true;
    }

    public boolean doneParsingDataBuffer() {
        return this.doneParsingDataBuffer_;
    }

    public void setCudTimesAndStates(TimeAndUniq[] cudTimes, TimeDescriptor.TimeStampState[] timeStates) {
        for (int i = 0; i < 3; ++i) {
            this.cudTimes_[i].setTime(cudTimes[i].time());
            this.cudTimes_[i].setUniq(cudTimes[i].uniq());
            this.timeStates_[i] = timeStates[i];
        }
        if (this.ctx_.getKeyValueSize() == null) {
            this.hasDeletesAtOrBelow_ = true;
        }
        if (this.timeStates_[2] != TimeDescriptor.TimeStampState.NOT_VALID) {
            if (this.timeStates_[0] != TimeDescriptor.TimeStampState.NOT_VALID) {
                this.hasCreatesAtOrAbove_ = true;
            } else {
                this.isExplicitlyDeleted_ = true;
            }
        }
    }

    private void clearCudTimeAndStates() {
        for (int i = 0; i < 3; ++i) {
            this.cudTimes_[i] = new TimeAndUniq();
            this.cudTimes_[i].setTime(0L);
            this.cudTimes_[i].setUniq(0);
            this.timeStates_[i] = TimeDescriptor.TimeStampState.NOT_SET;
        }
    }

    public TimeAndUniq[] getCudTimes() {
        return this.cudTimes_;
    }

    public TimeDescriptor.TimeStampState[] getCudTimeStates() {
        return this.timeStates_;
    }

    public TimeAndUniq[] getRootTimes() {
        return this.rootTimes_;
    }

    public void setRootTimes(TimeAndUniq[] baseCudTimes, TimeDescriptor.TimeStampState[] baseCudTimeStates) {
        this.rootTimes_ = new TimeAndUniq[3];
        TimeDescriptor.TimeStampState ctState = baseCudTimeStates[0];
        switch (ctState) {
            case NOT_SET: 
            case NOT_VALID: {
                this.rootTimes_[0] = null;
                break;
            }
            case VALID_WITH_REFTIME: 
            case VALID_WITH_EXTERNAL_TIME: {
                this.rootTimes_[0] = new TimeAndUniq(baseCudTimes[0]);
            }
        }
        TimeDescriptor.TimeStampState utState = baseCudTimeStates[1];
        switch (utState) {
            case NOT_SET: 
            case NOT_VALID: {
                this.rootTimes_[1] = null;
                break;
            }
            case VALID_WITH_REFTIME: 
            case VALID_WITH_EXTERNAL_TIME: {
                this.rootTimes_[1] = new TimeAndUniq(baseCudTimes[1]);
            }
        }
        TimeDescriptor.TimeStampState dtState = baseCudTimeStates[2];
        switch (dtState) {
            case NOT_SET: 
            case NOT_VALID: {
                this.rootTimes_[2] = null;
                break;
            }
            case VALID_WITH_REFTIME: 
            case VALID_WITH_EXTERNAL_TIME: {
                this.rootTimes_[2] = new TimeAndUniq(baseCudTimes[2]);
            }
        }
    }

    public boolean checkAndSetHasDeletes(boolean childDeleted) {
        boolean curState = this.hasDeletesAtOrBelow_;
        if (!childDeleted) {
            this.hasDeletesAtOrBelow_ = false;
        } else if (this.dataBuf_ == null && this.children_.size() == 1) {
            this.hasDeletesAtOrBelow_ = childDeleted;
        }
        return curState == this.hasDeletesAtOrBelow_;
    }

    public boolean hasDeletesAtOrBelow() {
        return this.hasDeletesAtOrBelow_;
    }

    public boolean hasCreatesAtOrAbove() {
        return this.hasCreatesAtOrAbove_;
    }

    public boolean isExplicitlyDeleted() {
        return this.isExplicitlyDeleted_;
    }

    public void checkAndSetHasCreatesAtOrAbove(boolean parentHasCreate) {
        this.hasCreatesAtOrAbove_ |= parentHasCreate;
    }
}

