/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.indexrowkeyfmt;

import com.mapr.db.indexrowkeyfmt.IndexRowKeyComponent;
import com.mapr.utils.ByteReader;
import java.nio.ByteBuffer;
import org.apache.commons.lang.mutable.MutableInt;

public class NumericComponent
extends IndexRowKeyComponent {
    private static final int FLOAT_EXPONENT_BIAS = 127;
    private static final int FLOAT_EXPONENT_MASK = 2139095040;
    private static final int FLOAT_MANTISSA_SIZE = 23;
    private static final int FLOAT_MANTISSA_MASK = 0x7FFFFF;
    private static final int FLOAT_POS_INFINITY = 2139095040;
    private static final int DOUBLE_EXPONENT_BIAS = 1023;
    private static final long DOUBLE_EXPONENT_MASK = 0x7FF0000000000000L;
    private static final int DOUBLE_MANTISSA_SIZE = 52;
    private static final long DOUBLE_MANTISSA_MASK = 0xFFFFFFFFFFFFFL;
    private static final long DOUBLE_POS_INFINITY = 0x7FF0000000000000L;
    private static final long THIRTY_TWO_LSB_MASK = -1L;
    private static final int exponentSize = 2;
    private static final int mantissaSize = 8;
    private static final int ENCODING_SIZE_ESTIMATE = 26;
    private byte origType_;
    private short exponent_;
    private long mantissa_;
    private boolean isNegative_;
    private boolean isInfinity_;
    private boolean isNaN_;
    private boolean isZero_;
    int encodingSize_;

    @Override
    public byte getMarker(boolean biggest) {
        if (this.descendingOrder_) {
            return biggest ? (byte)-91 : 78;
        }
        return biggest ? (byte)-79 : 90;
    }

    private int encodeNumber(ByteBuffer buf) {
        int bufferContentSize;
        byte b;
        int BUFFER_SIZE = 20;
        ByteBuffer buffer = ByteBuffer.allocate(20);
        if (this.exponent_ < 0) {
            b = -126;
            buffer.putShort(this.exponent_);
            buffer.putLong(this.mantissa_);
        } else if (this.exponent_ < 32 || this.isNaN_) {
            b = this.isNaN_ ? (byte)(this.isNegative_ ? -80 : -79) : (byte)(-125 + this.exponent_);
            buffer.putLong(this.mantissa_);
        } else {
            b = -93;
            buffer.putShort(this.exponent_);
            buffer.putLong(this.mantissa_);
        }
        for (bufferContentSize = buffer.position() - 1; bufferContentSize >= 0 && buffer.get(bufferContentSize) == 0; --bufferContentSize) {
        }
        ++bufferContentSize;
        int encodingSize = 0;
        if (this.isNegative_ && !this.descendingOrder_ || !this.isNegative_ && this.descendingOrder_) {
            buf.put(~b);
            if (bufferContentSize > 0) {
                encodingSize = this.encodeByteArrayOnesComplement(buffer.array(), bufferContentSize, buf);
                assert (encodingSize != 0);
            }
            this.separator_ = -1;
        } else {
            buf.put(b);
            if (bufferContentSize > 0) {
                encodingSize = this.encodeByteArray(buffer.array(), bufferContentSize, buf);
                assert (encodingSize != 0);
            }
            this.separator_ = 0;
        }
        return 1 + encodingSize;
    }

    private int decodeNumber(ByteReader buf, int offset, int bufSize) {
        byte componentEncodingMarker;
        int BUFFER_SIZE = 20;
        ByteBuffer buffer = ByteBuffer.allocate(20);
        boolean bl = this.isNaN_ = buf.getByte(offset) == -80 || buf.getByte(offset) == -79 || buf.getByte(offset) == 79 || buf.getByte(offset) == 78;
        if (this.isNaN_) {
            this.isNegative_ = buf.getByte(offset) == -80 || buf.getByte(offset) == 79;
        } else {
            boolean bl2 = this.descendingOrder_ ? (buf.getByte(offset) & 0xFF) > 128 : (this.isNegative_ = (buf.getByte(offset) & 0xFF) < 128);
        }
        if (this.isNegative_ && !this.descendingOrder_ || !this.isNegative_ && this.descendingOrder_) {
            componentEncodingMarker = ~buf.getByte(offset);
            if (--bufSize > 0 && this.decodeByteArrayOnesComplement(buf, offset + 1, bufSize, buffer) <= 0) {
                return -1;
            }
        } else {
            componentEncodingMarker = buf.getByte(offset);
            if (--bufSize > 0 && this.decodeByteArray(buf, offset + 1, bufSize, buffer) <= 0) {
                return -1;
            }
        }
        int bufferContentSize = buffer.position();
        if (componentEncodingMarker == -93 || componentEncodingMarker == -126) {
            for (int i = buffer.position(); i < 10; ++i) {
                buffer.put((byte)0);
            }
            buffer.position(0);
            this.exponent_ = buffer.getShort();
            this.mantissa_ = buffer.getLong();
        } else {
            for (int i = buffer.position(); i < 8; ++i) {
                buffer.put((byte)0);
            }
            buffer.position(0);
            this.exponent_ = this.isNaN_ ? (short)0 : (short)((componentEncodingMarker & 0xFF) - 131);
            this.mantissa_ = buffer.getLong();
        }
        this.setIsDecoded();
        return 1 + bufferContentSize;
    }

    @Override
    public int calculateEncodingSize(ByteReader buf, int offset) {
        switch (buf.getByte(offset)) {
            case -128: 
            case -91: 
            case 90: 
            case 127: {
                this.encodingSize_ = 1;
                return this.encodingSize_;
            }
            case -80: 
            case 79: {
                this.isNegative_ = true;
                break;
            }
            case -79: 
            case 78: {
                this.isNegative_ = false;
                break;
            }
            default: {
                this.isNegative_ = this.descendingOrder_ ? (buf.getByte(offset) & 0xFF) > 128 : (buf.getByte(offset) & 0xFF) < 128;
            }
        }
        boolean onesCmpl = this.isNegative_ && !this.descendingOrder_ || !this.isNegative_ && this.descendingOrder_;
        this.separator_ = onesCmpl ? (byte)-1 : 0;
        int separatorIdx = this.findIdx(buf, offset, this.separator_);
        this.encodingSize_ = separatorIdx < 0 ? -1 : separatorIdx;
        return this.encodingSize_;
    }

    private short findMostSignificantBit32(int u) {
        assert (u != 0);
        return (short)(31 - Integer.numberOfLeadingZeros(u));
    }

    private short findMostSignificantBit64(long u) {
        assert (u != 0L);
        return (short)(63 - Long.numberOfLeadingZeros(u));
    }

    NumericComponent(boolean descendingOrder) {
        super((byte)11, descendingOrder);
        this.isNegative_ = false;
        this.isInfinity_ = false;
        this.isNaN_ = false;
        this.isZero_ = true;
        this.exponent_ = 0;
        this.mantissa_ = 0L;
        this.origType_ = (byte)5;
    }

    NumericComponent(byte bt, boolean descendingOrder) {
        super((byte)11, descendingOrder);
        this.isNegative_ = bt < 0;
        this.isInfinity_ = false;
        this.isNaN_ = false;
        this.isZero_ = bt == 0;
        long aux = bt;
        if (this.isNegative_) {
            aux = -aux;
        }
        if (aux != 0L) {
            this.exponent_ = this.findMostSignificantBit64(aux);
            this.mantissa_ = this.exponent_ != 0 ? aux << 64 - this.exponent_ : 0L;
        }
        this.origType_ = (byte)5;
    }

    NumericComponent(short shrt, boolean descendingOrder) {
        super((byte)11, descendingOrder);
        this.isNegative_ = shrt < 0;
        this.isInfinity_ = false;
        this.isNaN_ = false;
        this.isZero_ = shrt == 0;
        long aux = shrt;
        if (this.isNegative_) {
            aux = -aux;
        }
        if (aux != 0L) {
            this.exponent_ = this.findMostSignificantBit64(aux);
            this.mantissa_ = this.exponent_ != 0 ? aux << 64 - this.exponent_ : 0L;
        }
        this.origType_ = (byte)6;
    }

    NumericComponent(int intgr, boolean descendingOrder) {
        super((byte)11, descendingOrder);
        this.isNegative_ = intgr < 0;
        this.isInfinity_ = false;
        this.isNaN_ = false;
        this.isZero_ = intgr == 0;
        long aux = intgr;
        if (this.isNegative_) {
            aux = -aux;
        }
        if (aux != 0L) {
            this.exponent_ = this.findMostSignificantBit64(aux);
            this.mantissa_ = this.exponent_ != 0 ? aux << 64 - this.exponent_ : 0L;
        }
        this.origType_ = (byte)7;
    }

    NumericComponent(long lng, boolean descendingOrder) {
        super((byte)11, descendingOrder);
        this.isNegative_ = lng < 0L;
        this.isInfinity_ = false;
        this.isNaN_ = false;
        this.isZero_ = lng == 0L;
        long aux = lng;
        if (this.isNegative_) {
            aux = -aux;
        }
        if (aux != 0L) {
            this.exponent_ = this.findMostSignificantBit64(aux);
            this.mantissa_ = this.exponent_ != 0 ? aux << 64 - this.exponent_ : 0L;
        }
        this.origType_ = (byte)8;
    }

    NumericComponent(float flt, boolean descendingOrder) {
        super((byte)11, descendingOrder);
        int ui = Float.floatToRawIntBits(flt);
        boolean bl = this.isNegative_ = (ui & Integer.MIN_VALUE) != 0;
        if ((ui & 0x7F800000) == 2139095040) {
            this.isInfinity_ = (ui & 0x7FFFFF) == 0;
            this.isNaN_ = !this.isInfinity_;
        } else {
            this.isInfinity_ = false;
            this.isNaN_ = false;
        }
        boolean bl2 = this.isZero_ = flt == 0.0f;
        if (flt != 0.0f) {
            this.exponent_ = (short)((ui & 0x7F800000) >> 23);
            this.exponent_ = (short)(this.exponent_ - 127);
            this.mantissa_ = ui;
            this.mantissa_ <<= 41;
        }
        this.origType_ = (byte)9;
    }

    NumericComponent(double dbl, boolean descendingOrder) {
        super((byte)11, descendingOrder);
        long ui = Double.doubleToRawLongBits(dbl);
        boolean bl = this.isNegative_ = (ui & Long.MIN_VALUE) != 0L;
        if ((ui & 0x7FF0000000000000L) == 0x7FF0000000000000L) {
            this.isInfinity_ = (ui & 0xFFFFFFFFFFFFFL) == 0L;
            this.isNaN_ = !this.isInfinity_;
        } else {
            this.isInfinity_ = false;
            this.isNaN_ = false;
        }
        boolean bl2 = this.isZero_ = dbl == 0.0;
        if (dbl != 0.0) {
            this.exponent_ = (short)((ui & 0x7FF0000000000000L) >> 52);
            this.exponent_ = (short)(this.exponent_ - 1023);
            this.mantissa_ = ui;
            this.mantissa_ <<= 12;
        }
        this.origType_ = (byte)10;
    }

    @Override
    public void setOrigType(byte type) {
        this.origType_ = type;
    }

    @Override
    public byte getOrigType() {
        return this.origType_;
    }

    @Override
    public int encode(ByteBuffer buf) {
        if (this.isZero_) {
            buf.put(this.descendingOrder_ ? (byte)127 : -128);
            this.encodingSize_ = 1;
        } else if (this.isInfinity_) {
            byte b = this.descendingOrder_ ? (this.isNegative_ ? (byte)-91 : 90) : (this.isNegative_ ? (byte)90 : -91);
            buf.put(b);
            this.encodingSize_ = 1;
        } else {
            this.encodingSize_ = this.encodeNumber(buf);
        }
        return this.encodingSize_;
    }

    @Override
    public int decode(ByteReader buf, int offset, int bufSize, MutableInt origTypeIndex) {
        this.setOrigType(buf.getByte(origTypeIndex.intValue()));
        origTypeIndex.increment();
        if (this.descendingOrder_ && buf.getByte(offset) == 127 || !this.descendingOrder_ && buf.getByte(offset) == -128) {
            this.setIsDecoded();
            return 1;
        }
        this.isZero_ = false;
        if (this.descendingOrder_) {
            switch (buf.getByte(offset)) {
                case -91: {
                    this.isNegative_ = true;
                }
                case 90: {
                    this.isInfinity_ = true;
                    this.setIsDecoded();
                    return 1;
                }
            }
            return this.decodeNumber(buf, offset, bufSize);
        }
        switch (buf.getByte(offset)) {
            case 90: {
                this.isNegative_ = true;
            }
            case -91: {
                this.isInfinity_ = true;
                this.setIsDecoded();
                return 1;
            }
        }
        return this.decodeNumber(buf, offset, bufSize);
    }

    @Override
    public int getEncodingSize() {
        return this.encodingSize_;
    }

    @Override
    public int getEncodingSizeEstimate() {
        return 26;
    }

    public boolean getIsNegative() {
        return this.isNegative_;
    }

    public boolean getIsInfinity() {
        return this.isInfinity_;
    }

    public boolean getIsNaN() {
        return this.isNaN_;
    }

    public boolean getIsZero() {
        return this.isZero_;
    }

    public short getExponent() {
        return this.exponent_;
    }

    public long getMantissa() {
        return this.mantissa_;
    }

    @Override
    public byte getByte() {
        byte bt = this.isZero_ ? (byte)0 : (byte)((this.mantissa_ >>> 1 | Long.MIN_VALUE) >>> 63 - this.exponent_);
        return this.isNegative_ ? (byte)(-bt) : bt;
    }

    @Override
    public short getShort() {
        short shrt = this.isZero_ ? (short)0 : (short)((this.mantissa_ >>> 1 | Long.MIN_VALUE) >>> 63 - this.exponent_);
        return this.isNegative_ ? (short)(-shrt) : shrt;
    }

    @Override
    public int getInt() {
        int intgr = this.isZero_ ? 0 : (int)((this.mantissa_ >>> 1 | Long.MIN_VALUE) >>> 63 - this.exponent_);
        return this.isNegative_ ? -intgr : intgr;
    }

    @Override
    public long getLong() {
        long lng = this.isZero_ ? 0L : (this.mantissa_ >>> 1 | Long.MIN_VALUE) >>> 63 - this.exponent_;
        return this.isNegative_ ? -lng : lng;
    }

    @Override
    public float getFloat() {
        if (this.isZero_) {
            return 0.0f;
        }
        int ui = this.isInfinity_ ? 2139095040 : (int)((long)(this.exponent_ + 127 << 23) | this.mantissa_ >>> 41);
        if (this.isNegative_) {
            ui |= Integer.MIN_VALUE;
        }
        return Float.intBitsToFloat(ui);
    }

    @Override
    public double getDouble() {
        if (this.isZero_) {
            return 0.0;
        }
        long ui = this.isInfinity_ ? 0x7FF0000000000000L : (long)(this.exponent_ + 1023) << 52 | this.mantissa_ >>> 12;
        if (this.isNegative_) {
            ui |= Long.MIN_VALUE;
        }
        return Double.longBitsToDouble(ui);
    }
}

