/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.indexrowkeyfmt;

import com.mapr.db.indexrowkeyfmt.Error;
import com.mapr.db.indexrowkeyfmt.IndexRowKeyComponent;
import com.mapr.db.indexrowkeyfmt.IndexRowKeyComponentArray;
import com.mapr.db.indexrowkeyfmt.Null;
import com.mapr.db.indexrowkeyfmt.OArray;
import com.mapr.db.indexrowkeyfmt.OMap;
import com.mapr.utils.ByteReader;
import org.apache.commons.lang.mutable.MutableInt;
import org.ojai.types.ODate;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

public class IndexRowKeyDecoder {
    private int version_;
    private ByteReader encodedData_;
    private int numComponents_;
    private boolean[] descendingOrder_;
    private byte[] primaryKey_;
    private int origTypeOffset_;
    private IndexRowKeyComponentArray indexRowKeyComponentArray_;
    private boolean isHashed_;
    private boolean missingAndNullFirst_;
    private static Null n = new Null();
    private static String s = new String("");
    private static byte[] ba = new byte[1];
    private static ODate d = new ODate(0L);
    private static OTimestamp ts = new OTimestamp(0L);
    private static OTime t = new OTime(0L);
    private static Error e = new Error(0);
    private static OMap m = new OMap();
    private static OArray a = new OArray();
    private static final int ROW_KEY_TYPE_ENCODING_SIZE = 1;
    private static final int INDEX_HASH_ENCODING_SIZE = 2;

    public IndexRowKeyDecoder() {
        this.init1(false, false);
        this.init2();
    }

    public IndexRowKeyDecoder(boolean isHashed) {
        this.init1(isHashed, false);
        this.init2();
    }

    public IndexRowKeyDecoder(boolean isHashed, boolean missingAndNullFirst) {
        this.init1(isHashed, missingAndNullFirst);
        this.init2();
    }

    private void init1(boolean isHashed, boolean missingAndNullFirst) {
        this.isHashed_ = isHashed;
        this.missingAndNullFirst_ = missingAndNullFirst;
    }

    private void init2() {
        this.encodedData_ = null;
        this.numComponents_ = 0;
        this.descendingOrder_ = null;
        this.primaryKey_ = null;
        this.origTypeOffset_ = 0;
        this.indexRowKeyComponentArray_ = null;
    }

    public void init(int version, boolean[] descendingOrder) {
        this.version_ = version;
        this.numComponents_ = descendingOrder.length;
        this.indexRowKeyComponentArray_ = new IndexRowKeyComponentArray(this.numComponents_, this.missingAndNullFirst_);
        this.descendingOrder_ = descendingOrder;
    }

    private boolean isErrorEncoding(ByteReader encodedData) {
        return encodedData.getByte(1 + (this.isHashed_ ? 2 : 0)) == -1;
    }

    public int setRowKey(ByteReader encodedData) {
        int numComponents = this.numComponents_;
        this.encodedData_ = encodedData;
        if (this.isErrorEncoding(encodedData)) {
            numComponents = 1;
            this.indexRowKeyComponentArray_.init(numComponents);
        }
        int offset = 0;
        int origTypeEncodingSize = 0;
        ++offset;
        if (this.isHashed_) {
            offset += 2;
        }
        for (int i = 0; i < numComponents; ++i) {
            IndexRowKeyComponent irkc = this.getComponentAwareOfItsLocation(i, offset, this.descendingOrder_[i]);
            if (irkc == null) {
                return -1;
            }
            offset += irkc.getFullEncodingSize();
            origTypeEncodingSize += irkc.getOrigTypeEncodingSize();
        }
        int primaryKeySize = this.encodedData_.length() - offset - origTypeEncodingSize;
        this.origTypeOffset_ = offset + primaryKeySize;
        this.primaryKey_ = this.encodedData_.copyOfRange(offset, this.origTypeOffset_);
        return 0;
    }

    private IndexRowKeyComponent getComponentAwareOfItsLocation(int idx, int offset, boolean descendingOrder) {
        byte firstByte = this.encodedData_.getByte(offset);
        IndexRowKeyComponent component = null;
        switch (firstByte) {
            case -5: 
            case 4: {
                this.indexRowKeyComponentArray_.set(idx, descendingOrder);
                component = this.indexRowKeyComponentArray_.get(idx);
                break;
            }
            case -6: 
            case 5: {
                this.indexRowKeyComponentArray_.set(idx, n, descendingOrder);
                component = this.indexRowKeyComponentArray_.get(idx);
                break;
            }
            case -8: 
            case -7: 
            case 6: 
            case 7: {
                this.indexRowKeyComponentArray_.set(idx, false, descendingOrder);
                component = this.indexRowKeyComponentArray_.get(idx);
                break;
            }
            case -9: 
            case 8: {
                this.indexRowKeyComponentArray_.set(idx, s.getBytes(), descendingOrder);
                component = this.indexRowKeyComponentArray_.get(idx);
                break;
            }
            case -10: 
            case 9: {
                this.indexRowKeyComponentArray_.set(idx, ba, ba.length, descendingOrder);
                component = this.indexRowKeyComponentArray_.get(idx);
                break;
            }
            case -11: 
            case 10: {
                this.indexRowKeyComponentArray_.set(idx, d, descendingOrder);
                component = this.indexRowKeyComponentArray_.get(idx);
                break;
            }
            case -13: 
            case 12: {
                this.indexRowKeyComponentArray_.set(idx, ts, descendingOrder);
                component = this.indexRowKeyComponentArray_.get(idx);
                break;
            }
            case -12: 
            case 11: {
                this.indexRowKeyComponentArray_.set(idx, t, descendingOrder);
                component = this.indexRowKeyComponentArray_.get(idx);
                break;
            }
            case -17: 
            case 16: {
                if (this.version_ == 0) {
                    return null;
                }
                this.indexRowKeyComponentArray_.set(idx, m, descendingOrder, true);
                component = this.indexRowKeyComponentArray_.get(idx);
                break;
            }
            case -18: 
            case 17: {
                if (this.version_ == 0) {
                    return null;
                }
                this.indexRowKeyComponentArray_.set(idx, a, descendingOrder, true);
                component = this.indexRowKeyComponentArray_.get(idx);
                break;
            }
            case -1: {
                this.indexRowKeyComponentArray_.init(1);
                this.indexRowKeyComponentArray_.set(idx, e, descendingOrder);
                component = this.indexRowKeyComponentArray_.get(idx);
                break;
            }
            default: {
                if (90 <= firstByte || firstByte <= -91 || 90 <= firstByte || firstByte <= -91 || firstByte == -80 || firstByte == 79 || firstByte == -79 || firstByte == 78) {
                    this.indexRowKeyComponentArray_.set(idx, 0, descendingOrder);
                    component = this.indexRowKeyComponentArray_.get(idx);
                    break;
                }
                return null;
            }
        }
        if (component != null) {
            if (component.calculateEncodingSize(this.encodedData_, offset) == 0) {
                return null;
            }
            assert (this.encodedData_.length() >= this.indexRowKeyComponentArray_.getNumComponents());
            component.setOffset(offset);
        }
        return component;
    }

    public IndexRowKeyComponent getComponent(int idx) throws IllegalArgumentException {
        IndexRowKeyComponent irkc = this.indexRowKeyComponentArray_.get(idx);
        if (irkc == null) {
            return null;
        }
        if (!irkc.isDecoded()) {
            int offset = 0;
            for (int i = 0; i < idx; ++i) {
                offset += this.indexRowKeyComponentArray_.get(i).getOrigTypeEncodingSize();
            }
            MutableInt origTypeOffset = new MutableInt(this.origTypeOffset_ + offset);
            int origTypeOffsetInit = origTypeOffset.intValue();
            int decodedDataSize = irkc.decode(this.encodedData_, irkc.getOffset(), irkc.getEncodingSize(), origTypeOffset);
            if (decodedDataSize < 0 || origTypeOffset.intValue() - origTypeOffsetInit != irkc.getOrigTypeEncodingSize()) {
                throw new IllegalArgumentException("Unable to decode row key component at offset " + irkc.getOffset());
            }
        }
        return irkc;
    }

    public byte[] getPrimaryTableRowKey() {
        return this.primaryKey_;
    }
}

