/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.indexrowkeyfmt;

import com.mapr.db.indexrowkeyfmt.IndexRowKeyComponent;
import com.mapr.utils.ByteReader;
import java.nio.ByteBuffer;
import org.apache.commons.lang.mutable.MutableInt;

public class BooleanComponent
extends IndexRowKeyComponent {
    private static final byte BOOLEAN_ENCODED_SIZE = 1;
    private static final byte BOOLEAN_DECODED_SIZE = 1;
    private boolean value_;

    BooleanComponent(boolean descendingOrder) {
        super((byte)3, descendingOrder);
        this.value_ = false;
    }

    BooleanComponent(boolean b, boolean descendingOrder) {
        super((byte)3, descendingOrder);
        this.value_ = b;
    }

    @Override
    public byte getMarker(boolean biggest) {
        if (this.descendingOrder_) {
            return biggest ? (byte)-7 : -8;
        }
        return biggest ? (byte)7 : 6;
    }

    @Override
    public int encode(ByteBuffer dst) {
        dst.put(this.getMarker(this.descendingOrder_ ? !this.value_ : this.value_));
        return 1;
    }

    @Override
    public int decode(ByteReader buf, int offset, int bufSize, MutableInt origTypeIndex) {
        if (buf.getByte(offset) != 7 && buf.getByte(offset) != -8 && buf.getByte(offset) != 6 && buf.getByte(offset) != -7) {
            return -1;
        }
        this.value_ = this.descendingOrder_ ? buf.getByte(offset) == -8 : buf.getByte(offset) == 7;
        this.setOrigType(buf.getByte(origTypeIndex.intValue()));
        origTypeIndex.increment();
        this.setIsDecoded();
        return 1;
    }

    @Override
    public boolean getBoolean() {
        return this.value_;
    }
}

