/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mapr.db.exceptions.DBException;
import com.mapr.db.exceptions.ExceptionHandler;
import com.mapr.db.impl.BaseJsonTable;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.impl.TabletInfoImpl;
import com.mapr.db.scan.ScanRange;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.ojai.Document;
import org.ojai.DocumentStream;

public class TabletSegmentScanner {
    public static final String CORE_POOL_SIZE_PROP = "com.mapr.db.tabletsegmentscanner.core-pool-size";
    private static final int CORE_POOL_SIZE = Integer.parseInt(System.getProperty("com.mapr.db.tabletsegmentscanner.core-pool-size", "32"));
    public static final String MAX_POOL_SIZE_PROP = "com.mapr.db.tabletsegmentscanner.max-pool-size";
    private static final int MAX_POOL_SIZE = Integer.parseInt(System.getProperty("com.mapr.db.tabletsegmentscanner.max-pool-size", "32"));
    private static final int KEEP_ALIVE_TIME_SEC = 60;
    private static volatile ExecutorService defaultExecutorService;
    private final ExecutorService executorService;
    private final BaseJsonTable baseTable;
    private final List<TabletInfoImpl> tabletInfos = Lists.newArrayList();
    private final int chunkSizeMBs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ExecutorService getExecutorService() {
        if (defaultExecutorService != null) return defaultExecutorService;
        Class<TabletSegmentScanner> clazz = TabletSegmentScanner.class;
        synchronized (TabletSegmentScanner.class) {
            if (defaultExecutorService != null) return defaultExecutorService;
            defaultExecutorService = new ThreadPoolExecutor(CORE_POOL_SIZE, MAX_POOL_SIZE, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable);
                    String threadName = "MaprTabletSegmentScanner-" + thread.getName();
                    thread.setName(threadName);
                    thread.setDaemon(true);
                    return thread;
                }
            });
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultExecutorService;
        }
    }

    public TabletSegmentScanner(BaseJsonTable table, int approximateChunkSize) {
        this(table, approximateChunkSize, TabletSegmentScanner.getExecutorService());
    }

    private TabletSegmentScanner(BaseJsonTable table, int approximateChunkSize, ExecutorService executor) {
        this.baseTable = table;
        this.executorService = executor;
        this.chunkSizeMBs = approximateChunkSize;
    }

    public void addTabletInfo(TabletInfoImpl tabletInfo) {
        this.tabletInfos.add(tabletInfo);
    }

    public List<ScanRange> getScanRanges() throws DBException {
        ArrayList scanRanges = Lists.newArrayList();
        ArrayList responses = Lists.newArrayList();
        for (final TabletInfoImpl tabletInfo : this.tabletInfos) {
            responses.add(this.executorService.submit(new Callable<List<ScanRange>>(){

                @Override
                public List<ScanRange> call() throws Exception {
                    return TabletSegmentScanner.this.findScanRanges(tabletInfo);
                }
            }));
        }
        for (Future future : responses) {
            try {
                scanRanges.addAll((Collection)future.get());
            }
            catch (InterruptedException | ExecutionException e) {
                ExceptionHandler.handle(e, "TabletSegmentScanner.getScanRanges()");
            }
        }
        return scanRanges;
    }

    private List<ScanRange> findScanRanges(TabletInfoImpl tabletInfo) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        byte[] startRow = tabletInfo.getStartRow();
        byte[] stopRow = tabletInfo.getStopRow();
        try (DocumentStream stream = this.baseTable.segmentKeyScan(startRow, stopRow, this.chunkSizeMBs);){
            byte[] currentStartRow = startRow;
            for (Document document : stream) {
                byte[] currentStopRow = IdCodec.encodeAsBytes(document.getId());
                assert (Bytes.compareTo((byte[])currentStopRow, (byte[])currentStartRow) > 0);
                builder.add((Object)this.subScanRange(tabletInfo, currentStartRow, currentStopRow));
                currentStartRow = currentStopRow;
            }
            builder.add((Object)this.subScanRange(tabletInfo, currentStartRow, stopRow));
        }
        return builder.build();
    }

    private ScanRange subScanRange(TabletInfoImpl tabletInfo, byte[] startKey, byte[] stopKey) {
        ConditionImpl subRangeCondition = this.baseTable.getRangeCondition(startKey, stopKey);
        return new TabletInfoImpl(subRangeCondition, subRangeCondition.getRowkeyRanges().get(0), tabletInfo.getLocations(), -1L, -1L, tabletInfo.getFid());
    }
}

