/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.google.common.base.Preconditions;
import com.mapr.db.exceptions.DBException;
import com.mapr.db.exceptions.ExceptionHandler;
import com.mapr.db.impl.BaseJsonTable;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.impl.MapRDBTableImplHelper;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.RowcolCodec;
import com.mapr.fs.MapRHTable;
import com.mapr.fs.jni.MapRGet;
import com.mapr.fs.jni.MapRResult;
import com.mapr.fs.jni.MapRRowConstraint;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.ojai.Document;
import org.ojai.FieldPath;
import org.ojai.store.QueryCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiGet {
    private static final Logger logger = LoggerFactory.getLogger(MapRDBTableImpl.class);
    private static final String USE_SINGLETABLET_GET_NAME = "ojai.mapr.multiget.use-singletablet-get";
    private static final boolean USE_SINGLETABLET_GET = System.getProperty("ojai.mapr.multiget.use-singletablet-get") != null;
    private final boolean excludeId;
    private final MapRRowConstraint rowConstraint;
    private final boolean shouldPrunePaths;
    private final byte[] serFilt;
    private final MapRHTable hTable;
    private final Map<FieldPath, Integer> sortedByPath;
    private final Map<Integer, String> idToCFNameMap;
    private final boolean isKeepInsertionOrder;
    private final boolean decodeTimestamp;
    private final String[] prunePaths;

    public MultiGet(BaseJsonTable table, QueryCondition cond, boolean excludeId, String ... paths) {
        this.excludeId = excludeId;
        MapRDBTableImplHelper.CondAndProjPaths bothpaths = new MapRDBTableImplHelper.CondAndProjPaths();
        MapRDBTableImplHelper.setPaths(cond, paths, bothpaths);
        this.rowConstraint = MapRDBTableImplHelper.toRowConstraint(table, bothpaths.allPaths);
        boolean bl = this.shouldPrunePaths = bothpaths.condPaths != null && bothpaths.condPaths.size() != 0;
        if (cond != null && !cond.isEmpty()) {
            ByteBuffer serCond = ((ConditionImpl)cond).cloneOptimized().getDescriptor(table.idPathMap(), null).getSerialized();
            this.serFilt = new byte[serCond.capacity()];
            serCond.get(this.serFilt);
        } else {
            this.serFilt = null;
        }
        this.hTable = table.maprTable();
        this.sortedByPath = table.sortedByPath();
        this.idToCFNameMap = table.idToCFNameMap();
        this.isKeepInsertionOrder = table.isKeepInsertionOrder();
        this.decodeTimestamp = table.decodeTimestamp();
        this.prunePaths = this.shouldPrunePaths ? paths : null;
    }

    public Document doGet(ByteBuffer id) throws DBException {
        ByteBuffer[] ids = new ByteBuffer[]{id};
        List<Document> docList = this.doGet(ids);
        if (docList.size() > 0) {
            return docList.get(0);
        }
        return null;
    }

    public List<Document> doGet(ByteBuffer[] ids) throws DBException {
        return this.doGet(ids, ids.length);
    }

    public List<Document> doGet(ByteBuffer[] ids, int nIds) throws DBException {
        Preconditions.checkArgument((nIds >= 0 ? 1 : 0) != 0);
        ArrayList<Document> docList = new ArrayList<Document>(nIds);
        if (nIds == 0) {
            return docList;
        }
        Object[] mrgets = new MapRGet[nIds];
        for (int i = 0; i < nIds; ++i) {
            MapRGet mrget = new MapRGet();
            mrgets[i] = mrget;
            mrget.result = new MapRResult();
            mrget.rowConstraint = this.rowConstraint;
            mrget.setFilter(this.serFilt);
            mrget.setEncodedResult(true);
            if (USE_SINGLETABLET_GET) {
                mrget.listIndex = i;
            }
            ByteBuffer id = ids[i];
            mrget.key = new byte[id.remaining()];
            int currentPosition = id.position();
            id.get(mrget.key);
            id.position(currentPosition);
        }
        if (USE_SINGLETABLET_GET) {
            Arrays.sort(mrgets);
        }
        try {
            if (USE_SINGLETABLET_GET) {
                this.hTable.getJson((MapRGet[])mrgets);
            } else {
                this.hTable.getMultiTabletJson((MapRGet[])mrgets);
            }
            for (Object mrget : mrgets) {
                Map cfbufs = mrget.getResult().getJsonByteBufs();
                if (cfbufs == null) continue;
                ByteBuffer keyBuf = ByteBuffer.wrap(((MapRGet)mrget).key);
                DBDocumentImpl record = RowcolCodec.decode(cfbufs, this.sortedByPath, this.idToCFNameMap, keyBuf, this.excludeId, true, this.isKeepInsertionOrder, this.decodeTimestamp, false, this.prunePaths, null);
                if (this.shouldPrunePaths) {
                    record.getDOMFromCachedBuffer();
                    if (record.size() == 0) continue;
                }
                if (USE_SINGLETABLET_GET) {
                    while (docList.size() <= ((MapRGet)mrget).listIndex) {
                        docList.add(null);
                    }
                    docList.set(((MapRGet)mrget).listIndex, record);
                    continue;
                }
                docList.add(record);
            }
            ArrayList<Document> outList = new ArrayList<Document>(docList.size());
            for (int i = 0; i < docList.size(); ++i) {
                if (docList.get(i) == null) continue;
                outList.add((Document)docList.get(i));
            }
            if (outList.size() < docList.size()) {
                logger.debug(docList.size() - outList.size() + " documents not found");
            }
            ArrayList<Document> arrayList = outList;
            return arrayList;
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "MultiGet.doGet()");
        }
        finally {
            for (Object mrget : mrgets) {
                if (mrget.getArena() == 0L) continue;
                this.hTable.freeArena(mrget.getArena());
            }
        }
    }
}

