/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.util;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MCFTree {
    private List<Map<String, Node>> root = new ArrayList<Map<String, Node>>();
    private int nodeCount;

    public MCFTree() {
        HashMap<String, Node> m = new HashMap<String, Node>();
        m.put(new String(""), new Node("", null, null, 1));
        this.root.add(m);
        this.nodeCount = 1;
    }

    private Node getParent(int level, String fieldName) {
        Map<String, Node> m = level > 0 ? this.root.get(level - 1) : null;
        return m == null ? null : m.get(fieldName);
    }

    public void addBuffer(int level, String fieldName, ByteBuffer buff) {
        Map<String, Node> m = this.root.get(level - 1);
        Node n = m.get(fieldName);
        n.docBuffer = buff;
    }

    public void insertNode(int level, String fieldName, String p, ByteBuffer buff) throws Exception {
        if (level > this.root.size() + 1) {
            throw new Exception("Can not add to the current node");
        }
        if (this.search(level - 1, fieldName) != null) {
            return;
        }
        Node parent = this.getParent(level - 1, p);
        if (level > 1 && parent == null) {
            throw new Exception("Can not find parent. Can not add " + fieldName);
        }
        Node newNode = new Node(fieldName, p, buff, level);
        if (parent != null) {
            parent.addChild(newNode);
        }
        Map<String, Node> currentLevel = null;
        if (level <= this.root.size()) {
            currentLevel = this.root.get(level - 1);
        }
        if (currentLevel == null) {
            currentLevel = new HashMap<String, Node>();
            this.root.add(currentLevel);
        }
        currentLevel.put(fieldName, newNode);
        ++this.nodeCount;
    }

    public Node search(int level, String f) {
        if (level < 0 || level >= this.root.size()) {
            return null;
        }
        Map<String, Node> m = this.root.get(level);
        return m == null ? null : m.get(f);
    }

    public int getNumNodes() {
        return this.nodeCount;
    }

    public class Node {
        String field;
        Map<String, Node> children;
        String parent;
        ByteBuffer docBuffer;
        boolean visited;
        int level;

        Node(String n, String s, ByteBuffer buff, int l) {
            this.field = n;
            this.children = new HashMap<String, Node>();
            this.parent = s;
            this.docBuffer = buff;
            this.visited = false;
            this.level = l - 1;
        }

        public String getFieldName() {
            return this.field;
        }

        public void addChild(Node n) {
            this.children.put(n.getFieldName(), n);
        }

        public Node findChild(String fname) {
            Node n = this.children.get(fname);
            return n != null && n.isVisited() ? null : n;
        }

        public boolean hasBuffer() {
            return this.docBuffer != null;
        }

        public ByteBuffer getBuffer() {
            return this.docBuffer;
        }

        public void setVisited() {
            this.visited = true;
        }

        public boolean isSubtreeVisited() {
            for (Map.Entry<String, Node> c : this.children.entrySet()) {
                if (c.getValue().isVisited()) continue;
                return false;
            }
            return true;
        }

        public boolean isVisited() {
            return this.visited;
        }

        public String getParent() {
            return this.parent;
        }

        public Map<String, Node> getChildren() {
            return this.children;
        }

        public int getLevel() {
            return this.level;
        }

        public boolean isRoot() {
            return this.level == 0;
        }
    }
}

