/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.util;

import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.rowcol.DBValueBuilderImpl;
import com.mapr.db.util.SubDocumentParser;
import java.util.ArrayList;
import java.util.List;
import org.ojai.Document;
import org.ojai.DocumentReader;
import org.ojai.Value;
import org.ojai.exceptions.DecodingException;
import org.ojai.exceptions.TypeException;
import org.ojai.json.Json;
import org.ojai.store.QueryCondition;

public class ConditionParser {
    private QueryCondition condition = MapRDBImpl.newCondition();
    private Value rowid = null;
    private DocumentReader.EventType et = null;
    private String key = null;
    private DocumentReader reader = null;
    private boolean isIdInCommandLine = false;
    private SubDocumentParser cUtils = null;
    private final long INVALIDSIZEVAL = -1L;

    private Document parseSubDoc() {
        if (this.cUtils == null) {
            this.cUtils = new SubDocumentParser();
        }
        return this.cUtils.parseSubDocument(this.reader);
    }

    private void processExists(boolean isExists) {
        if (this.et != DocumentReader.EventType.STRING) {
            throw new DecodingException("$exists subcommand expect fieldpath as String, found " + this.et);
        }
        String fieldPath = this.reader.getString();
        this.checkIDFieldDup(fieldPath);
        if (isExists) {
            this.condition.exists(fieldPath);
        } else {
            this.condition.notExists(fieldPath);
        }
    }

    private Value.Type valueTypeFromString(String type) {
        try {
            return Value.Type.valueOf((String)type.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new DecodingException("Unknown type " + type);
        }
    }

    private void processTypeOf(boolean isTypeOf) {
        this.et = this.reader.next();
        this.checkContext(DocumentReader.EventType.STRING);
        Value.Type t = this.valueTypeFromString(this.reader.getString());
        String fieldKey = this.reader.getFieldName();
        this.checkIDFieldDup(fieldKey);
        if (isTypeOf) {
            this.condition.typeOf(fieldKey, t);
        } else {
            this.condition.notTypeOf(fieldKey, t);
        }
        this.et = this.reader.next();
        this.checkContext(DocumentReader.EventType.END_MAP);
    }

    private void processLike(boolean isLike) {
        this.et = this.reader.next();
        String fieldKey = this.reader.getFieldName();
        this.checkIDFieldDup(fieldKey);
        if (isLike) {
            this.condition.like(fieldKey, this.reader.getString());
        } else {
            this.condition.notLike(fieldKey, this.reader.getString());
        }
        this.et = this.reader.next();
        this.checkContext(DocumentReader.EventType.END_MAP);
    }

    private long checkIfRounded(double val) {
        if (val != Math.floor(val)) {
            throw new DecodingException("size should be given as an integer.");
        }
        return (long)this.reader.getDouble();
    }

    private long getNumericValue() {
        long sizeVal = -1L;
        switch (this.et) {
            case BYTE: {
                sizeVal = this.reader.getByte();
                break;
            }
            case SHORT: {
                sizeVal = this.reader.getShort();
                break;
            }
            case LONG: {
                sizeVal = this.reader.getLong();
                break;
            }
            case INT: {
                sizeVal = this.reader.getInt();
                break;
            }
            case DOUBLE: {
                sizeVal = this.checkIfRounded(this.reader.getDouble());
                break;
            }
            default: {
                throw new DecodingException("sizeof parameter must be numeric.");
            }
        }
        return sizeVal;
    }

    private void checkIDFieldDup(String fieldName) {
        if (fieldName.equals("_id") && this.isIdInCommandLine) {
            throw new DecodingException("ID field can not be in condition if already present in command line");
        }
    }

    private void processSizeOf() {
        this.et = this.reader.next();
        String fieldKey = this.reader.getFieldName();
        this.checkIDFieldDup(fieldKey);
        if (this.et != DocumentReader.EventType.START_MAP) {
            throw new DecodingException("Invalid format for $sizeof");
        }
        this.et = this.reader.next();
        this.key = this.reader.getFieldName();
        long sizeVal = this.getNumericValue();
        if (sizeVal <= -1L) {
            throw new DecodingException("size of a field can not be negative.");
        }
        QueryCondition.Op op = this.getConditionOp();
        this.condition.sizeOf(fieldKey, op, sizeVal);
        this.et = this.reader.next();
        this.checkContext(DocumentReader.EventType.END_MAP);
    }

    private Value getValue() {
        switch (this.et) {
            case NULL: {
                return DBValueBuilderImpl.KeyValueBuilder.initFromNull();
            }
            case BOOLEAN: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.reader.getBoolean());
            }
            case STRING: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.reader.getString());
            }
            case BYTE: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.reader.getByte());
            }
            case SHORT: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.reader.getShort());
            }
            case INT: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.reader.getInt());
            }
            case LONG: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.reader.getLong());
            }
            case DOUBLE: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.reader.getDouble());
            }
            case FLOAT: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.reader.getFloat());
            }
            case DECIMAL: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.reader.getDecimal());
            }
            case DATE: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.reader.getDate());
            }
            case TIME: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.reader.getTime());
            }
            case TIMESTAMP: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.reader.getTimestamp());
            }
            case BINARY: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.reader.getBinary());
            }
            case INTERVAL: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.reader.getInterval());
            }
            case START_ARRAY: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.parseListOfValues());
            }
            case START_MAP: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.parseSubDoc());
            }
        }
        throw new DecodingException("Invalid type " + this.et);
    }

    private List<Object> parseListOfValues() {
        ArrayList<Object> l = new ArrayList<Object>();
        this.et = this.reader.next();
        while (this.et != DocumentReader.EventType.END_ARRAY) {
            l.add(this.getValue());
            this.et = this.reader.next();
        }
        return l;
    }

    private void processIn(boolean doIn) {
        this.et = this.reader.next();
        String fieldName = this.reader.getFieldName();
        this.checkIDFieldDup(fieldName);
        if (this.et == DocumentReader.EventType.START_ARRAY) {
            List<Object> l = this.parseListOfValues();
            if (doIn) {
                this.condition.in(fieldName, l);
            } else {
                this.condition.notIn(fieldName, l);
            }
        } else {
            throw new DecodingException("Invalid format for $in condition, expecting START_ARRAY, found " + this.et);
        }
        this.et = this.reader.next();
        this.checkContext(DocumentReader.EventType.END_MAP);
    }

    private void processMatches(boolean isMatch) {
        this.et = this.reader.next();
        String fieldKey = this.reader.getFieldName();
        this.checkIDFieldDup(fieldKey);
        if (isMatch) {
            this.condition.matches(fieldKey, this.reader.getString());
        } else {
            this.condition.notMatches(fieldKey, this.reader.getString());
        }
        this.et = this.reader.next();
        this.checkContext(DocumentReader.EventType.END_MAP);
    }

    private void setConditionWithDecoratedOp() {
        switch (this.key.toLowerCase()) {
            case "$exists": {
                this.processExists(true);
                break;
            }
            case "$notexists": {
                this.processExists(false);
                break;
            }
            case "$typeof": {
                this.processTypeOf(true);
                break;
            }
            case "$nottypeof": {
                this.processTypeOf(false);
                break;
            }
            case "$like": {
                this.processLike(true);
                break;
            }
            case "$notlike": {
                this.processLike(false);
                break;
            }
            case "$sizeof": {
                this.processSizeOf();
                break;
            }
            case "$in": {
                this.processIn(true);
                break;
            }
            case "$notin": {
                this.processIn(false);
                break;
            }
            case "$matches": {
                this.processMatches(true);
                break;
            }
            case "$notmatches": {
                this.processMatches(false);
                break;
            }
            case "$eq": 
            case "$ne": 
            case "$gt": 
            case "$lt": 
            case "$ge": 
            case "$le": {
                this.setIsCondition();
                break;
            }
            case "$between": {
                this.setBetweenCondition();
                break;
            }
        }
    }

    private void parseSingleCondition() {
        if (!this.key.startsWith("$")) {
            throw new DecodingException("Expecting an operator");
        }
        this.setConditionWithDecoratedOp();
    }

    private QueryCondition.Op getConditionOp() {
        QueryCondition.Op op = null;
        switch (this.key) {
            case "$eq": {
                op = QueryCondition.Op.EQUAL;
                break;
            }
            case "$ne": {
                op = QueryCondition.Op.NOT_EQUAL;
                break;
            }
            case "$lt": {
                op = QueryCondition.Op.LESS;
                break;
            }
            case "$le": {
                op = QueryCondition.Op.LESS_OR_EQUAL;
                break;
            }
            case "$gt": {
                op = QueryCondition.Op.GREATER;
                break;
            }
            case "$ge": {
                op = QueryCondition.Op.GREATER_OR_EQUAL;
                break;
            }
        }
        return op;
    }

    private void addConditionWithOp(String fieldKey, QueryCondition.Op op) {
        switch (this.et) {
            case BOOLEAN: {
                this.condition.is(fieldKey, op, this.reader.getBoolean());
                break;
            }
            case BYTE: {
                this.condition.is(fieldKey, op, this.reader.getByte());
                break;
            }
            case SHORT: {
                this.condition.is(fieldKey, op, this.reader.getShort());
                break;
            }
            case INT: {
                this.condition.is(fieldKey, op, this.reader.getInt());
                break;
            }
            case LONG: {
                this.condition.is(fieldKey, op, this.reader.getLong());
                break;
            }
            case FLOAT: {
                this.condition.is(fieldKey, op, this.reader.getFloat());
                break;
            }
            case DOUBLE: {
                this.condition.is(fieldKey, op, this.reader.getDouble());
                break;
            }
            case DECIMAL: {
                this.condition.is(fieldKey, op, this.reader.getDecimal());
                break;
            }
            case STRING: {
                this.condition.is(fieldKey, op, this.reader.getString());
                break;
            }
            case DATE: {
                this.condition.is(fieldKey, op, this.reader.getDate());
                break;
            }
            case TIME: {
                this.condition.is(fieldKey, op, this.reader.getTime());
                break;
            }
            case TIMESTAMP: {
                this.condition.is(fieldKey, op, this.reader.getTimestamp());
                break;
            }
            case INTERVAL: {
                this.condition.is(fieldKey, op, this.reader.getInterval());
                break;
            }
            case BINARY: {
                this.condition.is(fieldKey, op, this.reader.getBinary());
                break;
            }
            case START_ARRAY: {
                List<Object> l = this.parseListOfValues();
                if (op != QueryCondition.Op.EQUAL && op != QueryCondition.Op.NOT_EQUAL) {
                    throw new DecodingException("Invalid operator " + op + " used for equality with list");
                }
                if (op == QueryCondition.Op.EQUAL) {
                    this.condition.equals(fieldKey, l);
                    break;
                }
                this.condition.notEquals(fieldKey, l);
                break;
            }
            case START_MAP: {
                Document subDoc = this.parseSubDoc();
                if (op == QueryCondition.Op.EQUAL) {
                    this.condition.equals(fieldKey, subDoc.asMap());
                    break;
                }
                this.condition.notEquals(fieldKey, subDoc.asMap());
                break;
            }
            default: {
                throw new TypeException("Invalid data type : " + this.et);
            }
        }
    }

    private void setBetweenCondition() {
        this.et = this.reader.next();
        String fieldKey = this.reader.getFieldName();
        this.checkIDFieldDup(fieldKey);
        this.checkContext(DocumentReader.EventType.START_ARRAY);
        this.condition.and();
        this.et = this.reader.next();
        this.addConditionWithOp(fieldKey, QueryCondition.Op.GREATER_OR_EQUAL);
        this.et = this.reader.next();
        this.addConditionWithOp(fieldKey, QueryCondition.Op.LESS_OR_EQUAL);
        this.et = this.reader.next();
        this.condition.close();
        this.checkContext(DocumentReader.EventType.END_ARRAY);
        this.et = this.reader.next();
        this.checkContext(DocumentReader.EventType.END_MAP);
    }

    private void setIsCondition() {
        this.et = this.reader.next();
        String fieldKey = this.reader.getFieldName();
        this.checkIDFieldDup(fieldKey);
        QueryCondition.Op op = this.getConditionOp();
        this.addConditionWithOp(fieldKey, op);
        this.et = this.reader.next();
        this.checkContext(DocumentReader.EventType.END_MAP);
    }

    private boolean isCompositeCondition(String k) {
        switch (k) {
            case "$and": {
                this.condition.and();
                return true;
            }
            case "$or": {
                this.condition.or();
                return true;
            }
        }
        return false;
    }

    private void checkContext(DocumentReader.EventType currentType) {
        if (this.et != currentType) {
            throw new DecodingException("Error in context, expected " + currentType + " ,actual " + this.et);
        }
    }

    private void parseCompositeCondition() {
        this.checkContext(DocumentReader.EventType.START_ARRAY);
        this.et = this.reader.next();
        while (this.et != DocumentReader.EventType.END_ARRAY) {
            this.checkContext(DocumentReader.EventType.START_MAP);
            this.et = this.reader.next();
            this.key = this.reader.getFieldName();
            if (this.isCompositeCondition(this.key)) {
                this.parseCompositeCondition();
            } else {
                this.parseSingleCondition();
            }
            this.et = this.reader.next();
            this.checkContext(DocumentReader.EventType.END_MAP);
            this.et = this.reader.next();
        }
        this.condition.close();
    }

    public QueryCondition parseCondition(String jsonCondition) {
        this.reader = Json.newDocumentReader((String)jsonCondition);
        this.et = this.reader.next();
        this.checkContext(DocumentReader.EventType.START_MAP);
        this.et = this.reader.next();
        while (this.et != null) {
            if (this.et == DocumentReader.EventType.END_MAP) {
                this.et = this.reader.next();
                continue;
            }
            this.key = this.reader.getFieldName();
            if (this.isCompositeCondition(this.key)) {
                this.parseCompositeCondition();
            } else {
                this.parseSingleCondition();
            }
            this.et = this.reader.next();
        }
        this.condition.build();
        return this.condition;
    }

    public Value getId() {
        return this.rowid;
    }

    public void setIdInCmdLine(boolean isId) {
        this.isIdInCommandLine = isId;
    }
}

