/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.util;

import com.google.common.annotations.VisibleForTesting;
import com.mapr.db.util.ByteBufferHashKey;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteBufferToStringHashMap {
    private static final Logger logger = LoggerFactory.getLogger(ByteBufferToStringHashMap.class);
    private static final String CACHE_MAX_SIZE_NAME = "maprdb.mapr.fieldname.cachemaxsize";
    private static final String CACHE_CHECK_COUNT_NAME = "maprdb.mapr.fieldname.cachecheckcount";
    private static final int DEFAULT_CACHE_MAX_SIZE = 2048;
    private static final int DEFAULT_CACHE_CHECK_COUNT = 131072;
    private static int cacheMaxSize;
    private static int cacheCheckCount;
    private int putCount_ = 0;
    private long queryCount_ = 0L;
    private int clearMapCount_ = 0;
    private final ByteBufferHashKey queryField_ = new ByteBufferHashKey();
    private final HashMap<ByteBufferHashKey, String> bytesToStrMap_ = new HashMap();

    private void clearMap() {
        this.bytesToStrMap_.clear();
        ++this.clearMapCount_;
        logger.debug("clearMapCount " + this.clearMapCount_ + " putCount " + this.putCount_ + " queryCount " + this.queryCount_);
        this.queryCount_ = 0L;
        this.putCount_ = 0;
    }

    @VisibleForTesting
    HashMap<ByteBufferHashKey, String> getHashMap() {
        return this.bytesToStrMap_;
    }

    public String get(ByteBuffer bb, int len) {
        if (bb == null) {
            return null;
        }
        return this.get(bb, bb.position(), len);
    }

    public String get(ByteBuffer bb, int offset, int len) {
        if (bb == null) {
            return null;
        }
        this.queryField_.wrap(bb, offset, len);
        String retstr = this.getFromMap();
        bb.position(offset + len);
        return retstr;
    }

    private String getFromMap() {
        String retstr = this.bytesToStrMap_.get(this.queryField_);
        if (retstr == null) {
            if (this.queryCount_ > (long)cacheCheckCount && this.putCount_ > cacheMaxSize) {
                this.clearMap();
            }
            ByteBufferHashKey putField = new ByteBufferHashKey();
            putField.set(this.queryField_);
            retstr = new String(putField.getByteArray());
            this.bytesToStrMap_.put(putField, retstr);
            ++this.putCount_;
        }
        ++this.queryCount_;
        if (this.queryCount_ % (long)cacheCheckCount == 0L) {
            logger.debug("BytesToStrCache size={}, putCount={}, queryCount={}", new Object[]{this.bytesToStrMap_.size(), this.putCount_, this.queryCount_});
        }
        return retstr;
    }

    static {
        String strInputSize = System.getProperty(CACHE_MAX_SIZE_NAME);
        cacheMaxSize = strInputSize != null ? Integer.parseInt(strInputSize) : 2048;
        String strInputCheckCount = System.getProperty(CACHE_CHECK_COUNT_NAME);
        cacheCheckCount = strInputCheckCount != null ? Integer.parseInt(strInputCheckCount) : 131072;
    }
}

