/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.rowcol;

import com.mapr.db.impl.Constants;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.impl.MapRDBIndexImpl;
import com.mapr.db.index.IndexFieldDesc;
import com.mapr.db.indexrowkeyfmt.IndexRowKeyComponent;
import com.mapr.db.indexrowkeyfmt.IndexRowKeyDecoder;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.DBValueBuilderImpl;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.MutationImpl;
import com.mapr.db.rowcol.SerializationContext;
import com.mapr.db.rowcol.SerializedFamilyInfo;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ojai.Document;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.store.DocumentMutation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowcolCodec {
    static Logger logger = LoggerFactory.getLogger(RowcolCodec.class);

    public static DBDocumentImpl getDBDocument(Document r) {
        if (r instanceof DBDocumentImpl) {
            return (DBDocumentImpl)r;
        }
        return (DBDocumentImpl)DBValueBuilderImpl.KeyValueBuilder.initFrom(r);
    }

    private static Map<Integer, ByteBuffer> getUpdatedCachedBufferMap(Map<FieldPath, Integer> newJsonPathMap, DBDocumentImpl origRec) {
        if (origRec.cachedBuffer == null) {
            return null;
        }
        Map<FieldPath, Integer> origJsonPathMap = origRec.cachedBuffer.jsonPathMap;
        Map<Integer, ByteBuffer> origCachedBufferMap = origRec.cachedBuffer.map;
        if (newJsonPathMap == null) {
            return origCachedBufferMap;
        }
        HashMap<Integer, Integer> fidMap = new HashMap<Integer, Integer>();
        boolean jsonPathMapChanged = false;
        for (Map.Entry<FieldPath, Integer> kv : origJsonPathMap.entrySet()) {
            Integer oldInt = kv.getValue();
            Integer newInt = newJsonPathMap.get(kv.getKey());
            if (newInt == null) {
                jsonPathMapChanged = true;
                continue;
            }
            if (oldInt.compareTo(newInt) != 0) {
                jsonPathMapChanged = true;
            }
            fidMap.put(oldInt, newInt);
        }
        if (!jsonPathMapChanged) {
            return origCachedBufferMap;
        }
        LinkedHashMap<Integer, ByteBuffer> newCachedBufferMap = new LinkedHashMap<Integer, ByteBuffer>();
        for (Map.Entry<Integer, ByteBuffer> kv : origCachedBufferMap.entrySet()) {
            Integer oldInt = kv.getKey();
            Integer newInt = (Integer)fidMap.get(oldInt);
            if (newInt == null) {
                return null;
            }
            ByteBuffer buf = kv.getValue();
            newCachedBufferMap.put(newInt, buf);
        }
        return newCachedBufferMap;
    }

    public static SerializedFamilyInfo[] encode(Document document, Map<FieldPath, Integer> jsonPathMap, boolean isBulkLoad, boolean useCached) {
        DBDocumentImpl rec = RowcolCodec.getDBDocument(document);
        if (useCached && rec.cachedBuffer != null) {
            SerializationContext ctx = new SerializationContext();
            Map<Integer, ByteBuffer> cachedBufferMap = RowcolCodec.getUpdatedCachedBufferMap(jsonPathMap, rec);
            if (cachedBufferMap != null) {
                return ctx.getSerializedBuffers(jsonPathMap, cachedBufferMap);
            }
        }
        if (rec.getNeedDOMStruct()) {
            rec.getDOMFromCachedBuffer();
        }
        return new SerializationContext().setFullRecordOp(true).setStoreRowTS(isBulkLoad).serializeFamilies(rec, jsonPathMap).getSerializedBuffers();
    }

    public static SerializedFamilyInfo[] encode(Document document, Map<FieldPath, Integer> jsonPathMap) {
        return RowcolCodec.encode(document, jsonPathMap, false, false);
    }

    public static ByteBuffer encode(Document document) {
        SerializedFamilyInfo[] familyInfo = RowcolCodec.encode(document, Constants.DEFAULT_FAMILY_MAP, false, false);
        assert (familyInfo.length == 1);
        return familyInfo[0].getByteBuffer();
    }

    public static void decodeInternalWithFieldPath(Map<Integer, ByteBuffer> map, Map<FieldPath, Integer> jsonPathMap, Map<Integer, String> idToCFNameMap, boolean decodeTimestamp, boolean preserveDeleteFlags, DBDocumentImpl outDoc, FieldPath[] paths, Map<String, FieldPath> fieldPathMap) {
        SerializationContext ctx = new SerializationContext();
        if (decodeTimestamp) {
            ctx.setDecodeTimestamp(decodeTimestamp);
        }
        ctx.setPreserveDeleteTime(preserveDeleteFlags);
        if (paths != null && paths.length > 0) {
            ctx.setProjectedPaths(paths);
        }
        ctx.decode(map, jsonPathMap, idToCFNameMap, fieldPathMap, outDoc);
    }

    public static void decodeInternal(Map<Integer, ByteBuffer> map, Map<FieldPath, Integer> jsonPathMap, Map<Integer, String> idToCFNameMap, boolean decodeTimestamp, boolean preserveDeleteFlags, DBDocumentImpl outDoc, String[] paths, Map<String, FieldPath> fieldPathMap) {
        SerializationContext ctx = new SerializationContext();
        if (decodeTimestamp) {
            ctx.setDecodeTimestamp(decodeTimestamp);
        }
        ctx.setPreserveDeleteTime(preserveDeleteFlags);
        if (paths != null && paths.length > 0) {
            ctx.setProjectedPaths(paths);
        }
        ctx.decode(map, jsonPathMap, idToCFNameMap, fieldPathMap, outDoc);
    }

    public static DBDocumentImpl decode(Map<Integer, ByteBuffer> map, Map<FieldPath, Integer> jsonPathMap, Map<Integer, String> idToCFNameMap) {
        DBDocumentImpl doc = new DBDocumentImpl();
        RowcolCodec.decodeInternal(map, jsonPathMap, idToCFNameMap, false, false, doc, null, null);
        return doc;
    }

    public static DBDocumentImpl decode(Map<Integer, ByteBuffer> map, Map<FieldPath, Integer> jsonPathMap, Map<Integer, String> idToCFNameMap, ByteBuffer rowKey, boolean excludeId, boolean cacheEncoded, boolean decodeTimestamp, boolean preserveDeleteFlags, String[] paths, Map<String, FieldPath> fieldPathMap) {
        return RowcolCodec.decode(map, jsonPathMap, idToCFNameMap, rowKey, excludeId, cacheEncoded, decodeTimestamp, preserveDeleteFlags, false, paths, fieldPathMap);
    }

    public static DBDocumentImpl decode(Map<Integer, ByteBuffer> map, Map<FieldPath, Integer> jsonPathMap, Map<Integer, String> idToCFNameMap, ByteBuffer rowKeyBuffer, boolean excludeId, boolean cacheEncoded, boolean insertionOrder, boolean decodeTimestamp, boolean preserveDeleteFlags, String[] paths, Map<String, FieldPath> fieldPathMap) {
        if (rowKeyBuffer != null && !rowKeyBuffer.hasRemaining()) {
            KeyValue kv = DBValueBuilderImpl.KeyValueBuilder.initFrom("");
            DBDocumentImpl doc = new DBDocumentImpl();
            doc.setId(kv, excludeId);
            return doc;
        }
        if (!cacheEncoded) {
            DBDocumentImpl doc = new DBDocumentImpl();
            doc.setId(IdCodec.decode(rowKeyBuffer), excludeId);
            RowcolCodec.decodeInternal(map, jsonPathMap, idToCFNameMap, decodeTimestamp, preserveDeleteFlags, doc, paths, fieldPathMap);
            return doc;
        }
        DBDocumentImpl r = new DBDocumentImpl();
        r.setSerializedJson(map, jsonPathMap, idToCFNameMap, rowKeyBuffer, excludeId, insertionOrder, decodeTimestamp, preserveDeleteFlags, paths, fieldPathMap);
        return r;
    }

    public static DBDocumentImpl decodeIndexData(Map<Integer, ByteBuffer> map, Map<FieldPath, Integer> jsonPathMap, Map<Integer, String> idToCFNameMap, Map<Integer, FieldPath> fpIdxTofpMap, ByteBuffer rowKey, boolean excludeId, List<IndexFieldDesc> indexedFields, boolean insertionOrder, boolean decodeTimestamp, boolean preserveDeleteFlags, FieldPath[] paths, MapRDBIndexImpl IndexTable, Map<String, FieldPath> fieldPathMap) {
        DBDocumentImpl coveringDoc = new DBDocumentImpl();
        DBDocumentImpl doc = new DBDocumentImpl();
        if (rowKey != null && !rowKey.hasRemaining()) {
            KeyValue kv = DBValueBuilderImpl.KeyValueBuilder.initFrom("");
            doc.setId(kv, excludeId);
        } else {
            int numComponents = indexedFields.size();
            boolean[] descendingOrder = new boolean[numComponents];
            for (int i = 0; i < numComponents; ++i) {
                descendingOrder[i] = indexedFields.get(i).getSortOrder() == IndexFieldDesc.Order.Desc;
            }
            IndexRowKeyDecoder keyDecoder = new IndexRowKeyDecoder(IndexTable.isHashed());
            keyDecoder.init(descendingOrder);
            keyDecoder.setRowKey(Bytes.getBytes((ByteBuffer)rowKey));
            Value idField = IdCodec.decode(keyDecoder.getPrimaryTableRowKey());
            doc.setId(idField, excludeId);
            RowcolCodec.decodeInternalWithFieldPath(map, jsonPathMap, idToCFNameMap, decodeTimestamp, preserveDeleteFlags, coveringDoc, paths, fieldPathMap);
            Set<String> ks = coveringDoc.keySet();
            for (String key : ks) {
                if (key == null || key == "") continue;
                FieldPath fp = null;
                if (fieldPathMap != null) {
                    fp = fieldPathMap.get(key);
                    if (fp == null) {
                        fp = FieldPath.parseFrom((String)key);
                        fieldPathMap.put(key, fp);
                    }
                } else {
                    fp = FieldPath.parseFrom((String)key);
                }
                doc.set(fpIdxTofpMap.get(Integer.parseInt(key)), coveringDoc.getValue(fp));
            }
            Iterator<IndexFieldDesc> fieldItr = indexedFields.iterator();
            block30: for (int cIdx = 0; cIdx < numComponents; ++cIdx) {
                IndexRowKeyComponent encodedFieldValue = keyDecoder.getComponent(cIdx);
                FieldPath fp = null;
                IndexFieldDesc fieldInfo = indexedFields.get(cIdx);
                boolean isUpdateTS = false;
                if (!isUpdateTS) {
                    if (fieldInfo.isFunctional()) {
                        fp = FieldPath.parseFrom((String)("$" + String.valueOf(cIdx)));
                        fieldItr.next();
                    } else {
                        fp = fieldItr.next().getFieldPath();
                    }
                } else {
                    fieldItr.next();
                }
                switch (encodedFieldValue.getType()) {
                    case 1: {
                        try {
                            doc.set(fp, encodedFieldValue.getString());
                            continue block30;
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new UnsupportedOperationException("Encoding UTF-8 is not a supported.");
                        }
                    }
                    case 3: {
                        doc.set(fp, encodedFieldValue.getBoolean());
                        continue block30;
                    }
                    case 4: {
                        doc.set(fp, encodedFieldValue.getByteArray());
                        continue block30;
                    }
                    case 11: {
                        switch (encodedFieldValue.getOrigType()) {
                            case 5: {
                                doc.set(fp, encodedFieldValue.getByte());
                                continue block30;
                            }
                            case 6: {
                                doc.set(fp, encodedFieldValue.getShort());
                                continue block30;
                            }
                            case 7: {
                                doc.set(fp, encodedFieldValue.getInt());
                                continue block30;
                            }
                            case 8: {
                                doc.set(fp, encodedFieldValue.getLong());
                                continue block30;
                            }
                            case 9: {
                                doc.set(fp, encodedFieldValue.getFloat());
                                continue block30;
                            }
                            case 10: {
                                doc.set(fp, encodedFieldValue.getDouble());
                                continue block30;
                            }
                        }
                        throw new UnsupportedOperationException(encodedFieldValue.getOrigType() + " is not a supported original type for index field.");
                    }
                    case 13: {
                        if (!isUpdateTS) {
                            doc.set(fp, encodedFieldValue.getTimestamp());
                            continue block30;
                        }
                        doc.set(Constants.LAST_MODIFIED_TIMESTAMP_FP, encodedFieldValue.getTimestamp());
                        continue block30;
                    }
                    case 14: {
                        doc.set(fp, encodedFieldValue.getDate());
                        continue block30;
                    }
                    case 12: {
                        doc.set(fp, encodedFieldValue.getTime());
                        continue block30;
                    }
                    case 15: {
                        doc.setNull(fp);
                        continue block30;
                    }
                    case 2: {
                        continue block30;
                    }
                    case 16: {
                        String errMsgPrefix = "Indexed field " + encodedFieldValue.getError().idx + ": ";
                        switch (encodedFieldValue.getError().id) {
                            case 1: {
                                doc.set("$ERROR", "KEY_IS_TOO_LONG");
                                break;
                            }
                            case -2: {
                                doc.set("$ERROR", errMsgPrefix + "ARRAYS_ARE_NOT_SUPPORTED");
                                break;
                            }
                            case -1: {
                                doc.set("$ERROR", errMsgPrefix + "MAPS_ARE_NOT_SUPPORTED");
                                break;
                            }
                            case 2: {
                                doc.set("$ERROR", errMsgPrefix + "INVALID_CAST");
                            }
                        }
                        numComponents = 1;
                        continue block30;
                    }
                    default: {
                        throw new UnsupportedOperationException(encodedFieldValue.getType() + " is not a supported type for index field.");
                    }
                }
            }
        }
        return doc;
    }

    public static Document decode(ByteBuffer input) {
        return RowcolCodec.decode(input, null, true, false, true);
    }

    public static Document decode(ByteBuffer input, ByteBuffer rowKey, boolean excludeId, boolean decodeTimestamp, boolean preserveDeleteFlags) {
        assert (input.order() == ByteOrder.LITTLE_ENDIAN);
        if (input.position() == input.limit()) {
            return null;
        }
        HashMap<Integer, ByteBuffer> bufferMap = new HashMap<Integer, ByteBuffer>();
        ByteBuffer cachedBuffer = input.duplicate();
        cachedBuffer.mark();
        cachedBuffer.order(ByteOrder.LITTLE_ENDIAN);
        bufferMap.put(0, cachedBuffer);
        DBDocumentImpl doc = new DBDocumentImpl();
        doc.setId(IdCodec.decode(rowKey), excludeId);
        RowcolCodec.decodeInternal(bufferMap, Constants.DEFAULT_FAMILY_MAP, Constants.DEFAULT_NAME_MAP, decodeTimestamp, preserveDeleteFlags, doc, null, null);
        return doc;
    }

    public static DocumentMutation decodeMutation(ByteBuffer input, boolean needsRead) {
        return MutationImpl.fromSerializedValue(input, needsRead);
    }
}

