/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.rowcol;

import com.mapr.db.rowcol.ByteWriter;
import java.nio.ByteBuffer;
import org.ojai.Value;

public class KeyValueSizeDescriptor {
    static int varIntSize(int value) {
        if (value < 0) {
            return 4;
        }
        if (value <= 255) {
            return 1;
        }
        if (value <= 65535) {
            return 2;
        }
        return 4;
    }

    public static int getKeySizeOfSize(int numBitsForValue, int keySize) {
        if (numBitsForValue == 8) {
            return 0;
        }
        int maxInlineKeySize = (1 << 8 - numBitsForValue) - 4;
        if (keySize <= 0) {
            return 0;
        }
        if (keySize < maxInlineKeySize) {
            return 0;
        }
        return KeyValueSizeDescriptor.varIntSize(keySize);
    }

    public static int getValueSizeOfSize(int numBitsForValue, int valueSize) {
        if (numBitsForValue == 0 || valueSize == 0) {
            return 0;
        }
        int maxInlineValueSize = (1 << numBitsForValue) - 4;
        if (valueSize < maxInlineValueSize) {
            return 0;
        }
        return KeyValueSizeDescriptor.varIntSize(valueSize);
    }

    public static int encodeKeyValueSize(int numBitsForValue, int keySizeOfSize, int valueSizeOfSize, int keySize, int valueSize, ByteWriter output) {
        int sizeDesc = 0;
        sizeDesc = keySizeOfSize == 0 ? keySize : (1 << 8 - numBitsForValue) - 4 - 1 + keySizeOfSize;
        sizeDesc = valueSizeOfSize == 0 ? (sizeDesc |= valueSize << 8 - numBitsForValue & 0xFF) : (sizeDesc |= (1 << numBitsForValue) - 4 - 1 + valueSizeOfSize << 8 - numBitsForValue);
        output.put((byte)sizeDesc);
        KeyValueSizeDescriptor.encodeVarInt(keySize, keySizeOfSize, output);
        int valueOffset = output.position();
        KeyValueSizeDescriptor.encodeVarInt(valueSize, valueSizeOfSize, output);
        return valueOffset;
    }

    public static void encodeVarInt(int value, int numBytes, ByteWriter output) {
        switch (numBytes) {
            case 0: {
                break;
            }
            case 1: {
                output.put((byte)value);
                break;
            }
            case 2: {
                output.putShort((short)value);
                break;
            }
            default: {
                output.putInt(value);
            }
        }
    }

    public static int readVarInt(int numBytes, ByteBuffer input) {
        switch (numBytes) {
            case 0: {
                return 0;
            }
            case 1: {
                return input.get() & 0xFF;
            }
            case 2: {
                return input.getShort() & 0xFFFF;
            }
        }
        return input.getInt();
    }

    public static int[] decodeKeyValueSize(int numBitsForValue, ByteBuffer b) {
        int[] output = new int[2];
        int sizeDesc = b.get() & 0xFF;
        int keySize = sizeDesc & (1 << 8 - numBitsForValue) - 1;
        int valueSize = sizeDesc >> 8 - numBitsForValue & 0xFF;
        int maxInlineKeySize = (1 << 8 - numBitsForValue) - 4;
        int maxInlineValueSize = (1 << numBitsForValue) - 4;
        if (maxInlineKeySize < 0) {
            maxInlineKeySize = 1;
        }
        if (maxInlineValueSize < 0) {
            maxInlineValueSize = 1 << numBitsForValue;
        }
        output[0] = keySize < maxInlineKeySize ? keySize : KeyValueSizeDescriptor.readVarInt(keySize - maxInlineKeySize + 1, b);
        output[1] = valueSize < maxInlineValueSize ? valueSize : KeyValueSizeDescriptor.readVarInt(valueSize - maxInlineValueSize + 1, b);
        return output;
    }

    public static int valueSizeBitsForType(Value.Type type) {
        switch (type) {
            case BOOLEAN: {
                return 1;
            }
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case NULL: {
                return 0;
            }
        }
        return 4;
    }
}

