/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.rowcol;

import com.mapr.db.rowcol.DBList;
import com.mapr.db.rowcol.DBValueBuilderBase;
import com.mapr.db.rowcol.InsertContext;
import com.mapr.db.rowcol.KeyValue;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.List;
import org.ojai.Value;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

public class DBValueBuilderImpl
extends DBValueBuilderBase {
    public static DBValueBuilderImpl KeyValueBuilder = new DBValueBuilderImpl();

    private DBValueBuilderImpl() {
    }

    @Override
    public KeyValue initFromNull() {
        return new KeyValue(Value.Type.NULL);
    }

    @Override
    public KeyValue initFrom(boolean value) {
        KeyValue v = new KeyValue(Value.Type.BOOLEAN);
        v.setPrimValue(value ? 1L : 0L);
        return v;
    }

    @Override
    public KeyValue initFrom(String value) {
        KeyValue v = new KeyValue(Value.Type.STRING);
        v.setObjValue(value);
        return v;
    }

    @Override
    public KeyValue initFrom(byte value) {
        KeyValue v = new KeyValue(Value.Type.BYTE);
        v.setPrimValue(value);
        return v;
    }

    @Override
    public KeyValue initFrom(short value) {
        KeyValue v = new KeyValue(Value.Type.SHORT);
        v.setPrimValue(value);
        return v;
    }

    @Override
    public KeyValue initFrom(int value) {
        KeyValue v = new KeyValue(Value.Type.INT);
        v.setPrimValue(value);
        return v;
    }

    @Override
    public KeyValue initFrom(long value) {
        KeyValue v = new KeyValue(Value.Type.LONG);
        v.setPrimValue(value);
        return v;
    }

    @Override
    public KeyValue initFrom(float value) {
        KeyValue v = new KeyValue(Value.Type.FLOAT);
        v.setPrimValue(Float.floatToIntBits(value));
        return v;
    }

    @Override
    public KeyValue initFrom(double value) {
        KeyValue v = new KeyValue(Value.Type.DOUBLE);
        v.setPrimValue(Double.doubleToLongBits(value));
        return v;
    }

    @Override
    public KeyValue initFrom(OTime value) {
        KeyValue v = new KeyValue(Value.Type.TIME);
        v.setPrimValue(value.toTimeInMillis());
        return v;
    }

    @Override
    public KeyValue initFrom(ODate value) {
        KeyValue v = new KeyValue(Value.Type.DATE);
        v.setPrimValue(value.toDaysSinceEpoch());
        return v;
    }

    @Override
    public KeyValue initFrom(BigDecimal value) {
        KeyValue v = new KeyValue(Value.Type.DECIMAL);
        v.setObjValue(value);
        return v;
    }

    @Override
    public KeyValue initFrom(OTimestamp value) {
        KeyValue v = new KeyValue(Value.Type.TIMESTAMP);
        v.setPrimValue(value.getMillis());
        return v;
    }

    @Override
    public KeyValue initFrom(OInterval value) {
        KeyValue v = new KeyValue(Value.Type.INTERVAL);
        v.setPrimValue(value.getTimeInMillis());
        return v;
    }

    @Override
    public KeyValue initFrom(ByteBuffer value) {
        KeyValue v = new KeyValue(Value.Type.BINARY);
        v.setObjValue(value.duplicate());
        return v;
    }

    @Override
    public KeyValue initFrom(List<? extends Object> list) {
        if (list instanceof DBList) {
            return ((DBList)list).shallowCopy();
        }
        DBList l = new DBList(InsertContext.OpType.NONE);
        for (Object object : list) {
            KeyValue child = this.initFromObject(object);
            child.setOpTypeAndFlags(null, false);
            l.addToDBList(child);
        }
        return l;
    }

    @Override
    public KeyValue initFrom(Value value) {
        if (value instanceof KeyValue) {
            return ((KeyValue)value).shallowCopy();
        }
        return this.initFromObject(value.getObject());
    }

    @Override
    public KeyValue initFromObject(Object value) {
        if (value instanceof KeyValue) {
            return ((KeyValue)value).shallowCopy();
        }
        if (value == null) {
            return new KeyValue(Value.Type.NULL);
        }
        return this.initFromObjectType(value);
    }

    @Override
    public KeyValue newDBValue() {
        return new KeyValue();
    }
}

