/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.rowcol;

import com.mapr.db.util.ByteBufs;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteWriter {
    static final int minBufferSize = 1024;
    static final int maxBufferSize = 0x1000000;
    static int lastBufferSize = 1024;
    ByteBuffer buf;

    public ByteWriter() {
        if (lastBufferSize > 0x1000000) {
            lastBufferSize = 0x1000000;
        }
        this.buf = ByteBufs.allocatePreferred(lastBufferSize);
        this.buf.order(ByteOrder.LITTLE_ENDIAN);
    }

    public ByteBuffer getByteBuffer() {
        int savedPos = this.buf.position();
        int savedLimit = this.buf.limit();
        this.buf.flip();
        ByteBuffer newbuf = this.buf.slice();
        newbuf.order(ByteOrder.LITTLE_ENDIAN);
        this.buf.position(savedPos);
        this.buf.limit(savedLimit);
        if (this.buf.remaining() < lastBufferSize / 2 && lastBufferSize > 1024) {
            lastBufferSize = 1024;
        }
        if (lastBufferSize < 1024) {
            lastBufferSize = 1024;
        }
        return newbuf;
    }

    void grow(int size) {
        if (this.buf.capacity() - this.buf.position() < size) {
            int newSize;
            for (newSize = this.buf.capacity(); newSize < this.buf.capacity() + size; newSize *= 2) {
            }
            ByteBuffer newBuffer = ByteBufs.allocatePreferred(newSize);
            newBuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.buf.flip();
            newBuffer.put(this.buf);
            newBuffer.position(this.buf.limit());
            this.buf = newBuffer;
            lastBufferSize = newSize;
        }
    }

    ByteWriter put(ByteBuffer value) {
        int rem = value.remaining();
        this.grow(rem);
        assert (this.buf.capacity() - this.buf.position() >= rem);
        assert (rem == value.remaining());
        try {
            this.buf.put(value);
        }
        catch (IllegalArgumentException iae) {
            System.out.println("BUG 21703 INFO - " + this.buf + " " + rem + " " + value);
        }
        return this;
    }

    ByteWriter put(byte[] value) {
        this.grow(value.length);
        this.buf.put(value);
        return this;
    }

    ByteWriter put(byte value) {
        this.grow(1);
        this.buf.put(value);
        return this;
    }

    public int position() {
        return this.buf.position();
    }

    public void putShort(short value) {
        this.grow(2);
        this.buf.putShort(value);
    }

    public void putInt(int value) {
        this.grow(4);
        this.buf.putInt(value);
    }

    public void putAtOffset(int offset, int value) {
        int curOff = this.buf.position();
        this.buf.position(offset);
        this.buf.putInt(value);
        this.buf.position(curOff);
    }

    public void putByteAtOffset(int offset, byte value) {
        int curOff = this.buf.position();
        this.buf.position(offset);
        this.buf.put(value);
        this.buf.position(curOff);
    }

    public void put(byte[] value, int off, int len) {
        this.grow(len - off);
        this.buf.put(value, off, len);
    }

    public void putLong(long value) {
        this.grow(8);
        this.buf.putLong(value);
    }

    public void order(ByteOrder o) {
        this.buf.order(o);
    }
}

