/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.ojai;

import com.mapr.db.ControlInfo;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.ojai.DBDocumentReaderBase;
import com.mapr.db.ojai.EventTypeWithTime;
import com.mapr.db.rowcol.BigDecimalSizeDescriptor;
import com.mapr.db.rowcol.ControlInfoImpl;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.KeyValueDeserializeHelper;
import com.mapr.db.rowcol.RootTimeDescriptor;
import com.mapr.db.rowcol.SerializationContext;
import com.mapr.db.rowcol.TimeAndUniq;
import com.mapr.db.rowcol.TimeDescriptor;
import com.mapr.db.util.ByteBufs;
import com.mapr.db.util.MCFTreeNode2;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.ojai.DocumentReader;
import org.ojai.FieldPath;
import org.ojai.FieldSegment;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.ojai.exceptions.DecodingException;
import org.ojai.exceptions.TypeException;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;
import org.ojai.util.Types;

@API.Internal
public class DBDocumentReader2
extends DBDocumentReaderBase {
    private boolean decodeTimestamp_ = false;
    private boolean preserveDeleteTime_ = false;
    private boolean emitId_;
    private KeyValue idValue_;
    private ByteBuffer idBuffer_;
    private final Map<Integer, ByteBuffer> dataMap_;
    private MCFTreeNode2 root_;
    private MCFTreeNode2 curNode_;
    private EventTypeWithTime currentEvent_;
    private String currentFieldName_;
    private int currentFieldIndex_;
    private TimeAndUniq currentFieldIndexTime_;
    private Object currentObjValue_;
    private long currentLongValue_;
    private int currentDecimalPrecision_;
    private int currentDecimalScale_;
    private byte[] currentDecimalUnscaledValue_;
    boolean doneCompleteDocParsing_;

    public DBDocumentReader2(Map<Integer, ByteBuffer> data, Map<FieldPath, Integer> pathMap, KeyValue _id, boolean excludeId) {
        this(data, pathMap, _id, excludeId, false, false);
    }

    public DBDocumentReader2(Map<Integer, ByteBuffer> dataMap, Map<FieldPath, Integer> pathMap, KeyValue _id, boolean excludeId, boolean decodeTimestamp, boolean preserveDeleteTime) {
        this.dataMap_ = dataMap;
        this.emitId_ = !excludeId;
        this.idValue_ = _id;
        this.decodeTimestamp_ = decodeTimestamp;
        this.preserveDeleteTime_ = preserveDeleteTime;
        this.root_ = new MCFTreeNode2(null);
        this.initMCFTree(dataMap, pathMap);
        this.curNode_ = null;
        this.currentEvent_ = new EventTypeWithTime();
        this.currentFieldName_ = null;
        this.currentFieldIndex_ = -1;
        this.currentFieldIndexTime_ = null;
        this.currentObjValue_ = null;
        this.currentDecimalPrecision_ = -1;
        this.currentDecimalScale_ = -1;
        this.currentDecimalUnscaledValue_ = null;
        this.doneCompleteDocParsing_ = false;
    }

    private void initMCFTree(Map<Integer, ByteBuffer> dataMap, Map<FieldPath, Integer> jsonPathMap) {
        for (Map.Entry<FieldPath, Integer> jsonPath : jsonPathMap.entrySet()) {
            boolean parentSwitched;
            MCFTreeNode2 cur = this.root_;
            FieldPath p = jsonPath.getKey();
            ByteBuffer buf = dataMap.get(jsonPath.getValue());
            if (buf == null) continue;
            ByteBuffer dataBuf = buf.duplicate().order(buf.order());
            if (dataBuf.order() != ByteOrder.LITTLE_ENDIAN) {
                throw new DecodingException("Byte order of serialized buffer for cf " + jsonPath.getValue() + " not little endian.");
            }
            if (!p.asPathString().isEmpty()) {
                Iterator iter = p.iterator();
                while (iter.hasNext()) {
                    String segment = ((FieldSegment)iter.next()).getNameSegment().getName();
                    MCFTreeNode2 child = cur.getChild(segment);
                    if (child == null) {
                        child = new MCFTreeNode2(cur);
                        child.setFieldName(segment);
                        cur.addChild(segment, child);
                    }
                    cur = child;
                }
            }
            cur.setDataBuffer(dataBuf);
            SerializationContext context = new SerializationContext();
            context.setNewRecord(true);
            context.setDecodeTimestamp(this.decodeTimestamp_);
            context.setPreserveDeleteTime(this.preserveDeleteTime_);
            cur.setContext(context);
            if (cur == this.root_) {
                cur.setType(Value.Type.MAP);
                context.setNewRecord(false);
                RootTimeDescriptor.deserialize(dataBuf, context);
                TimeDescriptor.deserialize(null, dataBuf, context, true);
            } else {
                String k;
                KeyValueDeserializeHelper.deserializeWithoutKeyValue(context, dataBuf);
                cur.setType(context.getType());
                if (context.getKeyValueSize() != null && (k = Bytes.toString((ByteBuffer)cur.getDataBuffer(), (int)context.getKeyValueSize()[0])).compareTo("v") != 0) {
                    throw new DecodingException("Expecting `v` for new column-family buffer");
                }
            }
            if (this.decodeTimestamp_) {
                cur.setRootTimes(context.getBaseCudTime(), context.getBaseCudTimeState());
                cur.setCudTimesAndStates(context.getCudTime(), context.getCudTimeState());
            }
            boolean childDeleted = cur.hasDeletesAtOrBelow();
            for (MCFTreeNode2 ancestor = cur.getParent(); ancestor != null && (parentSwitched = ancestor.checkAndSetHasDeletes(childDeleted)); ancestor = ancestor.getParent()) {
            }
        }
    }

    private void verifyCurrentEvent(DocumentReader.EventType eventType) throws TypeException {
        if (this.currentEvent_.getType() != eventType) {
            throw new TypeException("Event type mismatch");
        }
    }

    private void cacheCurrentValue() {
        if (this.curNode_ == null) {
            return;
        }
        ByteBuffer rowBuf = this.curNode_.getDataBuffer();
        SerializationContext context = this.curNode_.getContext();
        if (context == null) {
            return;
        }
        int valueSize = context.getKeyValueSize()[1];
        switch (context.getType()) {
            case BOOLEAN: {
                this.currentLongValue_ = valueSize;
                break;
            }
            case STRING: {
                this.currentObjValue_ = Bytes.toString((ByteBuffer)rowBuf, (int)valueSize);
                break;
            }
            case BYTE: {
                this.currentLongValue_ = rowBuf.get();
                break;
            }
            case SHORT: {
                this.currentLongValue_ = rowBuf.getShort();
                break;
            }
            case FLOAT: 
            case INT: {
                this.currentLongValue_ = rowBuf.getInt();
                break;
            }
            case DOUBLE: 
            case LONG: {
                this.currentLongValue_ = rowBuf.getLong();
                break;
            }
            case DECIMAL: {
                byte sizeDesc = rowBuf.get();
                int unscaledValueSize = BigDecimalSizeDescriptor.getBigDecimalUnscaledValueSize(sizeDesc, rowBuf);
                this.currentDecimalPrecision_ = BigDecimalSizeDescriptor.getBigDecimalPrecision(sizeDesc, rowBuf);
                this.currentDecimalScale_ = BigDecimalSizeDescriptor.getBigDecimalScale(sizeDesc, rowBuf);
                this.currentDecimalUnscaledValue_ = BigDecimalSizeDescriptor.getBigDecimalUnscaledValue(unscaledValueSize, rowBuf);
                this.currentObjValue_ = null;
                break;
            }
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case INTERVAL: {
                this.currentLongValue_ = KeyValueDeserializeHelper.deserializeVarLong(valueSize, this.curNode_.getDataBuffer());
                break;
            }
            case BINARY: {
                byte[] bytes = new byte[valueSize];
                this.curNode_.getDataBuffer().get(bytes);
                ByteBuffer b = ByteBuffer.wrap(bytes);
                this.currentObjValue_ = b;
                break;
            }
            case NULL: {
                this.currentObjValue_ = null;
                break;
            }
        }
    }

    private void moveToChildNode(MCFTreeNode2 child) {
        if (this.curNode_ != null) {
            child.checkAndSetHasCreatesAtOrAbove(this.curNode_.hasCreatesAtOrAbove());
        }
        this.curNode_ = child;
        boolean moveToParent = false;
        if (this.curNode_.getType() != Value.Type.MAP && this.curNode_.getType() != Value.Type.ARRAY) {
            if (this.curNode_.getContext().getKeyValueSize() != null) {
                this.cacheCurrentValue();
            }
            moveToParent = true;
        }
        this.currentEvent_.setTypeAndCudTime(Types.getEventTypeForType((Value.Type)this.curNode_.getType()), this.curNode_.getCudTimes(), this.curNode_.getCudTimeStates());
        this.currentFieldName_ = this.curNode_.getFieldName();
        this.currentFieldIndex_ = this.curNode_.getFieldIndex();
        this.currentFieldIndexTime_ = this.curNode_.getFieldIndexTime();
        if (moveToParent) {
            this.curNode_.markVisited();
            this.curNode_ = this.curNode_.getParent();
            if (this.curNode_ == null) {
                this.doneCompleteDocParsing_ = true;
            } else {
                this.curNode_.removeChild(this.currentFieldName_);
            }
        }
    }

    public DocumentReader.EventType next() {
        return this.nextInternal(null);
    }

    private DocumentReader.EventType nextInternal(EventTypeWithTime etwt) {
        if (this.doneCompleteDocParsing_) {
            this.currentEvent_.setTypeAndCudTime(null, null, null);
            this.currentFieldName_ = null;
            this.currentFieldIndex_ = -1;
            this.currentFieldIndexTime_ = null;
            return this.currentEvent_.getType();
        }
        if (this.curNode_ == null) {
            this.root_.setType(Value.Type.MAP);
            this.root_.setFieldName(null);
            this.root_.setFieldIndex(-1);
            this.moveToChildNode(this.root_);
        } else if (this.emitId_) {
            this.currentEvent_.setType(Types.getEventTypeForType((Value.Type)this.idValue_.getType()));
            this.currentEvent_.setCudTimesAndStates(this.curNode_.getCudTimes(), this.curNode_.getCudTimeStates());
            this.currentFieldName_ = "_id";
            this.currentObjValue_ = this.idValue_.getObject();
            this.emitId_ = false;
        } else if (this.curNode_.getDataBuffer() != null && !this.curNode_.doneParsingDataBuffer()) {
            SerializationContext context = this.curNode_.getContext();
            context.setIsArrayElement(this.curNode_.getType() == Value.Type.ARRAY);
            KeyValueDeserializeHelper.deserializeWithoutKeyValue(context, this.curNode_.getDataBuffer());
            Value.Type t = context.getType();
            if (t == null) {
                if (this.curNode_.getType() == Value.Type.MAP) {
                    this.currentEvent_.setType(DocumentReader.EventType.END_MAP);
                } else {
                    this.currentEvent_.setType(DocumentReader.EventType.END_ARRAY);
                }
                this.curNode_.setDoneParsingDataBuffer();
                this.parseNextChildInTree();
            } else {
                int[] keyValueSize = context.getKeyValueSize();
                this.currentEvent_.setType(Types.getEventTypeForType((Value.Type)t));
                this.currentEvent_.setCudTimesAndStates(context.getCudTime(), context.getCudTimeState());
                String lookupFieldName = null;
                if (this.curNode_.getType() == Value.Type.ARRAY) {
                    if (context.isAbsoluteIndex()) {
                        this.currentFieldIndex_ = context.getArrayIndex();
                        this.currentFieldIndexTime_ = context.getArrayIndexTime();
                    } else {
                        this.curNode_.incrementCurrentParseIndex();
                        this.currentFieldIndex_ = this.curNode_.currentParseIndex();
                    }
                    lookupFieldName = "[" + this.currentFieldIndex_ + "]";
                } else {
                    lookupFieldName = this.currentFieldName_ = Bytes.toString((ByteBuffer)this.curNode_.getDataBuffer(), (int)keyValueSize[0]);
                }
                MCFTreeNode2 newChild = this.curNode_.getChild(lookupFieldName);
                if (t == Value.Type.MAP || t == Value.Type.ARRAY) {
                    if (newChild == null) {
                        newChild = new MCFTreeNode2(this.curNode_);
                        newChild.setFieldName(this.currentFieldName_);
                        this.curNode_.addChild(this.currentFieldName_, newChild);
                    }
                    newChild.setDataBuffer(this.curNode_.getDataBuffer());
                    newChild.setContext(context);
                    newChild.setFieldIndex(this.currentFieldIndex_);
                    newChild.setFieldIndexTime(this.currentFieldIndexTime_);
                    newChild.setContext(context);
                    newChild.setCudTimesAndStates(this.currentEvent_.getCudTime(), this.currentEvent_.getCudTimeState());
                    newChild.setType(t);
                    this.moveToChildNode(newChild);
                } else {
                    this.cacheCurrentValue();
                }
            }
        } else {
            this.parseNextChildInTree();
        }
        if (etwt != null) {
            etwt.setTypeAndCudTime(this.currentEvent_.getType(), this.currentEvent_.getCudTime(), this.currentEvent_.getCudTimeState());
        }
        return this.currentEvent_.getType();
    }

    private void parseNextChildInTree() {
        MCFTreeNode2 child = null;
        Map<String, MCFTreeNode2> children = this.curNode_.getChildren();
        Iterator<Map.Entry<String, MCFTreeNode2>> it = children.entrySet().iterator();
        while (!this.curNode_.isExplicitlyDeleted() && it.hasNext()) {
            MCFTreeNode2 ch = it.next().getValue();
            if (!this.curNode_.hasCreatesAtOrAbove() || !ch.hasDeletesAtOrBelow()) {
                child = ch;
                break;
            }
            it.remove();
        }
        if (child == null) {
            if (this.curNode_.getType() == Value.Type.ARRAY) {
                this.currentEvent_.setType(DocumentReader.EventType.END_ARRAY);
            } else {
                this.currentEvent_.setType(DocumentReader.EventType.END_MAP);
            }
            this.currentEvent_.setCudTimesAndStates(this.curNode_.getCudTimes(), this.curNode_.getCudTimeStates());
            this.currentObjValue_ = null;
            this.currentFieldName_ = this.curNode_.getFieldName();
            this.currentFieldIndex_ = this.curNode_.getFieldIndex();
            this.curNode_.markVisited();
            this.curNode_ = this.curNode_.getParent();
            if (this.curNode_ == null) {
                this.doneCompleteDocParsing_ = true;
            } else {
                this.curNode_.removeChild(this.currentFieldName_);
            }
        } else {
            this.moveToChildNode(child);
        }
    }

    public int getArrayIndex() {
        return this.currentFieldIndex_;
    }

    public ByteBuffer getBinary() {
        this.verifyCurrentEvent(DocumentReader.EventType.BINARY);
        return (ByteBuffer)this.currentObjValue_;
    }

    public boolean getBoolean() {
        this.verifyCurrentEvent(DocumentReader.EventType.BOOLEAN);
        return this.currentLongValue_ != 0L;
    }

    public byte getByte() {
        this.verifyCurrentEvent(DocumentReader.EventType.BYTE);
        return (byte)this.currentLongValue_;
    }

    public ODate getDate() {
        this.verifyCurrentEvent(DocumentReader.EventType.DATE);
        return ODate.fromDaysSinceEpoch((int)((int)this.currentLongValue_));
    }

    public int getDateInt() {
        this.verifyCurrentEvent(DocumentReader.EventType.DATE);
        return (int)this.currentLongValue_;
    }

    public BigDecimal getDecimal() {
        this.verifyCurrentEvent(DocumentReader.EventType.DECIMAL);
        if (this.currentObjValue_ == null) {
            this.currentObjValue_ = new BigDecimal(new BigInteger(this.currentDecimalUnscaledValue_), this.currentDecimalScale_, new MathContext(this.currentDecimalPrecision_));
        }
        return (BigDecimal)this.currentObjValue_;
    }

    public int getDecimalPrecision() {
        this.verifyCurrentEvent(DocumentReader.EventType.DECIMAL);
        return this.currentDecimalPrecision_;
    }

    public int getDecimalScale() {
        this.verifyCurrentEvent(DocumentReader.EventType.DECIMAL);
        return this.currentDecimalScale_;
    }

    public ByteBuffer getDecimalValueAsBytes() {
        BigDecimal decimal = this.getDecimal();
        return ByteBufs.decimalValueToBytes(decimal);
    }

    public int getDecimalValueAsInt() {
        BigDecimal decimal = this.getDecimal();
        if (decimal != null) {
            return decimal.intValueExact();
        }
        return 0;
    }

    public long getDecimalValueAsLong() {
        BigDecimal decimal = this.getDecimal();
        if (decimal != null) {
            return decimal.longValueExact();
        }
        return 0L;
    }

    public double getDouble() {
        this.verifyCurrentEvent(DocumentReader.EventType.DOUBLE);
        return Double.longBitsToDouble(this.currentLongValue_);
    }

    public String getFieldName() {
        return this.currentFieldName_;
    }

    public float getFloat() {
        this.verifyCurrentEvent(DocumentReader.EventType.FLOAT);
        return Float.intBitsToFloat((int)(this.currentLongValue_ & 0xFFFFFFFFL));
    }

    public int getInt() {
        this.verifyCurrentEvent(DocumentReader.EventType.INT);
        return (int)this.currentLongValue_;
    }

    public OInterval getInterval() {
        this.verifyCurrentEvent(DocumentReader.EventType.INTERVAL);
        return new OInterval(this.currentLongValue_);
    }

    public int getIntervalDays() {
        this.verifyCurrentEvent(DocumentReader.EventType.INTERVAL);
        return (int)(this.currentLongValue_ / 86400000L);
    }

    public long getIntervalMillis() {
        this.verifyCurrentEvent(DocumentReader.EventType.INTERVAL);
        return this.currentLongValue_;
    }

    public long getLong() {
        this.verifyCurrentEvent(DocumentReader.EventType.LONG);
        return this.currentLongValue_;
    }

    public short getShort() {
        this.verifyCurrentEvent(DocumentReader.EventType.SHORT);
        return (short)this.currentLongValue_;
    }

    public String getString() {
        this.verifyCurrentEvent(DocumentReader.EventType.STRING);
        return (String)this.currentObjValue_;
    }

    public OTime getTime() {
        this.verifyCurrentEvent(DocumentReader.EventType.TIME);
        return OTime.fromMillisOfDay((int)((int)this.currentLongValue_));
    }

    public int getTimeInt() {
        this.verifyCurrentEvent(DocumentReader.EventType.TIME);
        return (int)(this.currentLongValue_ % 86400000L);
    }

    public OTimestamp getTimestamp() {
        this.verifyCurrentEvent(DocumentReader.EventType.TIMESTAMP);
        return new OTimestamp(this.currentLongValue_);
    }

    public long getTimestampLong() {
        this.verifyCurrentEvent(DocumentReader.EventType.TIMESTAMP);
        return this.currentLongValue_;
    }

    public boolean inMap() {
        if (this.curNode_ == null || this.curNode_ == this.root_) {
            return true;
        }
        if (this.currentEvent_.getType() == DocumentReader.EventType.START_ARRAY || this.currentEvent_.getType() == DocumentReader.EventType.START_MAP) {
            return this.curNode_.getParent().getType() == Value.Type.MAP;
        }
        return this.curNode_.getType() == Value.Type.MAP;
    }

    @Override
    public ControlInfo getControlInfo() {
        if (this.curNode_.getContext() == null) {
            throw new UnsupportedOperationException("Can not return timeDescriptor for eventType END_MAP or END_ARRAY");
        }
        return new ControlInfoImpl(this.curNode_.getContext().getTimeDescriptor());
    }

    @Override
    public Value getId() {
        return this.idValue_;
    }

    @Override
    public ByteBuffer getIdData() {
        if (this.idBuffer_ == null) {
            this.idBuffer_ = IdCodec.encode(this.idValue_);
        }
        return this.idBuffer_.duplicate();
    }

    @Override
    public Map<Integer, ByteBuffer> getDataMap() {
        return Collections.unmodifiableMap(this.dataMap_);
    }

    @Override
    public DocumentReader.EventType getCurrentEvent() {
        return this.currentEvent_.getType();
    }

    public DocumentReader.EventType nextEventWithTime(EventTypeWithTime etwt) {
        return this.nextInternal(etwt);
    }

    public TimeAndUniq[] getRootTS() {
        return this.root_.getRootTimes();
    }

    public TimeAndUniq getArrayIndexTime() {
        return this.currentFieldIndexTime_;
    }

    public boolean hasRootTS() {
        return this.curNode_ == null || this.curNode_ == this.root_;
    }
}

