/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.rowcol;

import com.mapr.db.rowcol.ByteWriter;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.SerializationContext;
import com.mapr.db.rowcol.TimeAndUniq;
import com.mapr.db.rowcol.TimeDescriptor;
import java.nio.ByteBuffer;

class ArrayIndexDescriptor {
    static final int INDEX_TYPE_SHIFT = 0;
    static final int INDEX_TYPE_MASK = 1;
    static final int INDEX_TIMESTAMP_SIZE_SHIFT = 1;
    static final int INDEX_TIMESTAMP_SIZE_MASK = 14;
    static final int INDEX_TIMESTAMP_UNIQ_SIZE_SHIFT = 4;
    static final int INDEX_TIMESTAMP_UNIQ_SIZE_MASK = 48;
    static final int INDEX_UNIQ_SIZE_SHIFT = 6;
    static final int INDEX_UNIQ_SIZE_MASK = 192;

    ArrayIndexDescriptor() {
    }

    static void serialize(ArrayIndexType type, int index, int totalIndex, ByteWriter w) {
        byte[] uniq;
        if (type == ArrayIndexType.ARRAY_INDEX_TYPE_ABSOLUTE) {
            byte desc = (byte)type.ordinal();
            int size = 3;
            desc = (byte)(desc | size << 1);
            w.put(desc);
            w.putInt(index);
            return;
        }
        byte desc = (byte)type.ordinal();
        int encodedUniqSize = 0;
        if (totalIndex <= 255) {
            encodedUniqSize = 0;
            uniq = new byte[]{(byte)index};
        } else if (totalIndex <= 65535) {
            encodedUniqSize = 1;
            uniq = new byte[]{(byte)(index >> 8 & 0xFF), (byte)(index & 0xFF)};
        } else if (totalIndex <= 0xFFFFFF) {
            encodedUniqSize = 2;
            uniq = new byte[]{(byte)(index >> 16 & 0xFF), (byte)(index >> 8 & 0xFF), (byte)(index & 0xFF)};
        } else {
            encodedUniqSize = 3;
            uniq = new byte[]{(byte)(index >> 24 & 0xFF), (byte)(index >> 16 & 0xFF), (byte)(index >> 8 & 0xFF), (byte)(index & 0xFF)};
        }
        desc = (byte)(desc | encodedUniqSize << 6);
        w.put(desc);
        if (encodedUniqSize == 3) {
            w.put((byte)1);
            w.put((byte)4);
        }
        w.put(uniq);
    }

    static void deserialize(KeyValue kv, ByteBuffer r, SerializationContext ctx) {
        byte desc = r.get();
        ArrayIndexType type = ArrayIndexType.values()[desc & 1];
        if (type == ArrayIndexType.ARRAY_INDEX_TYPE_ABSOLUTE) {
            int index = r.getInt();
            if (kv != null) {
                kv.setArrayIndex(type, index);
            }
            return;
        }
        if (ctx.getDecodeTimestamp()) {
            kv.arrayIndex = new TimeAndUniq();
        }
        short timeSizeInfo = (short)((desc & 0xE) >> 1);
        short uniqSizeInfo = (short)((desc & 0x30) >> 4);
        if (kv != null) {
            TimeDescriptor.readTimeAndUniq(r, timeSizeInfo, uniqSizeInfo, kv.arrayIndex, ctx);
        }
        int uniqSize = (desc & 0xC0) >> 6;
        byte[] arrayIndexUniq = null;
        switch (uniqSize) {
            case 0: {
                arrayIndexUniq = new byte[1];
                break;
            }
            case 1: {
                arrayIndexUniq = new byte[2];
                break;
            }
            case 2: {
                arrayIndexUniq = new byte[3];
                break;
            }
            case 3: {
                byte sizeOfSize = r.get();
                assert (sizeOfSize == 1);
                byte size = r.get();
                assert (size == 4);
                arrayIndexUniq = new byte[size];
                break;
            }
        }
        r.get(arrayIndexUniq);
        if (ctx.getDecodeTimestamp()) {
            kv.arrayIndexUniq = arrayIndexUniq;
        }
    }

    public static String toStringWithTimestamp(KeyValue kv) {
        StringBuilder b = new StringBuilder();
        b.append("[");
        TimeAndUniq t = kv.arrayIndex;
        String s = String.format("%d.%d", t.time(), t.uniq());
        b.append(s).append(", \"0x");
        for (int i = 0; i < kv.arrayIndexUniq.length; ++i) {
            b.append(String.format("%02x", kv.arrayIndexUniq[i]));
        }
        b.append("\"");
        b.append("]");
        return b.toString();
    }

    public static int compareIndexTimeAndUniq(TimeAndUniq index1, byte[] index1Uniq, TimeAndUniq index2, byte[] index2Uniq) {
        if (index1.time() != index2.time()) {
            return index1.time() > index2.time() ? 1 : -1;
        }
        if (index1.uniq() != index2.uniq()) {
            return index1.uniq() > index2.uniq() ? 1 : -1;
        }
        return ByteBuffer.wrap(index1Uniq).compareTo(ByteBuffer.wrap(index2Uniq));
    }

    static enum ArrayIndexType {
        ARRAY_INDEX_TYPE_ABSOLUTE,
        ARRAY_INDEX_TYPE_ASSOCIATIVE;

    }
}

