/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.ojai;

import com.mapr.db.rowcol.KeyValue;
import org.ojai.Value;

class ContainerContext {
    private final Value.Type type;
    private int index;
    private final String fieldName;
    private final KeyValue kv;
    static final ContainerContext NULL = new ContainerContext(null);

    ContainerContext(Value.Type t) {
        this(t, null, null);
    }

    ContainerContext(Value.Type t, String v) {
        this(t, v, null);
    }

    ContainerContext(Value.Type t, KeyValue v) {
        this(t, v.getKey(), v);
    }

    ContainerContext(Value.Type t, String n, KeyValue v) {
        this.kv = v;
        this.type = t;
        this.index = -1;
        this.fieldName = n;
    }

    public Value.Type getType() {
        return this.type;
    }

    int getIndex() {
        if (this.type != Value.Type.ARRAY) {
            throw new IllegalStateException("getIndex() called on a map");
        }
        return this.index;
    }

    void incrementIndex() {
        if (this.type != Value.Type.ARRAY) {
            throw new IllegalStateException("incrementIndex() called on a map");
        }
        ++this.index;
    }

    public String toString() {
        return "[" + this.type + ", " + this.index + ", " + this.fieldName + "]@" + this.hashCode();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public KeyValue getKv() {
        return this.kv;
    }

    public boolean isMap() {
        return this.type == Value.Type.MAP;
    }
}

