/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.scanners;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.mangofactory.swagger.authorization.AuthorizationContext;
import com.mangofactory.swagger.configuration.SwaggerGlobalSettings;
import com.mangofactory.swagger.core.CommandExecutor;
import com.mangofactory.swagger.core.RequestMappingEvaluator;
import com.mangofactory.swagger.core.ResourceGroupingStrategy;
import com.mangofactory.swagger.models.ModelProvider;
import com.mangofactory.swagger.models.dto.ApiDescription;
import com.mangofactory.swagger.models.dto.ApiListing;
import com.mangofactory.swagger.models.dto.builder.ApiListingBuilder;
import com.mangofactory.swagger.ordering.ApiDescriptionLexicographicalOrdering;
import com.mangofactory.swagger.paths.SwaggerPathProvider;
import com.mangofactory.swagger.readers.ApiDescriptionReader;
import com.mangofactory.swagger.readers.ApiModelReader;
import com.mangofactory.swagger.readers.MediaTypeReader;
import com.mangofactory.swagger.readers.operation.RequestMappingReader;
import com.mangofactory.swagger.scanners.RequestMappingContext;
import com.mangofactory.swagger.scanners.ResourceGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiListingScanner {
    private static final Logger log = LoggerFactory.getLogger(ApiListingScanner.class);
    private static final String SWAGGER_VERSION = "1.2";
    private Map<ResourceGroup, List<RequestMappingContext>> resourceGroupRequestMappings;
    private SwaggerPathProvider swaggerPathProvider;
    private SwaggerGlobalSettings swaggerGlobalSettings;
    private AuthorizationContext authorizationContext;
    private final ModelProvider modelProvider;
    private Ordering<ApiDescription> apiDescriptionOrdering = new ApiDescriptionLexicographicalOrdering();
    private Collection<RequestMappingReader> customAnnotationReaders;
    private final RequestMappingEvaluator requestMappingEvaluator;
    private final String apiVersion;

    public ApiListingScanner(Map<ResourceGroup, List<RequestMappingContext>> resourceGroupRequestMappings, SwaggerPathProvider swaggerPathProvider, ModelProvider modelProvider, AuthorizationContext authorizationContext, Collection<RequestMappingReader> customAnnotationReaders, RequestMappingEvaluator requestMappingEvaluator, String apiVersion) {
        this.resourceGroupRequestMappings = resourceGroupRequestMappings;
        this.swaggerPathProvider = swaggerPathProvider;
        this.authorizationContext = authorizationContext;
        this.modelProvider = modelProvider;
        this.customAnnotationReaders = customAnnotationReaders;
        this.requestMappingEvaluator = requestMappingEvaluator;
        this.apiVersion = apiVersion;
    }

    public Map<String, ApiListing> scan() {
        HashMap apiListingMap = Maps.newHashMap();
        int position = 0;
        if (null == this.resourceGroupRequestMappings) {
            log.error("resourceGroupRequestMappings should not be null.");
        } else {
            for (Map.Entry<ResourceGroup, List<RequestMappingContext>> entry : this.resourceGroupRequestMappings.entrySet()) {
                ResourceGroup resourceGroup = entry.getKey();
                LinkedHashSet produces = new LinkedHashSet(2);
                LinkedHashSet consumes = new LinkedHashSet(2);
                HashSet apiDescriptions = Sets.newHashSet();
                ArrayList readers = Lists.newArrayList();
                readers.add(new MediaTypeReader());
                readers.add(new ApiDescriptionReader(this.swaggerPathProvider, this.customAnnotationReaders, this.requestMappingEvaluator));
                readers.add(new ApiModelReader(this.modelProvider));
                LinkedHashMap models = new LinkedHashMap();
                for (RequestMappingContext each : entry.getValue()) {
                    CommandExecutor commandExecutor = new CommandExecutor();
                    each.put("authorizationContext", this.authorizationContext);
                    each.put("swaggerGlobalSettings", this.swaggerGlobalSettings);
                    each.put("currentResourceGroup", resourceGroup);
                    Map<String, Object> results = commandExecutor.execute(readers, each);
                    List producesMediaTypes = (List)results.get("produces");
                    List consumesMediaTypes = (List)results.get("consumes");
                    Map swaggerModels = (Map)results.get("models");
                    if (null != swaggerModels) {
                        models.putAll(swaggerModels);
                    }
                    produces.addAll(producesMediaTypes);
                    consumes.addAll(consumesMediaTypes);
                    List apiDescriptionList = (List)results.get("apiDescriptionList");
                    apiDescriptions.addAll(apiDescriptionList);
                }
                List<Object> authorizations = new ArrayList();
                if (null != this.authorizationContext) {
                    authorizations = this.authorizationContext.getScalaAuthorizations();
                }
                ArrayList<ApiDescription> sortedDescriptions = new ArrayList<ApiDescription>(apiDescriptions);
                Collections.sort(sortedDescriptions, this.apiDescriptionOrdering);
                String resourcePath = this.longestCommonPath(sortedDescriptions);
                ApiListing apiListing = new ApiListingBuilder().apiVersion(this.apiVersion).swaggerVersion(SWAGGER_VERSION).basePath(this.swaggerPathProvider.getApplicationBasePath()).resourcePath(resourcePath).produces((List)Lists.newArrayList(produces)).consumes((List)Lists.newArrayList(consumes)).protocol(new ArrayList()).authorizations(authorizations).apis(sortedDescriptions).models(models).description(null).position(position++).build();
                apiListingMap.put(resourceGroup.getGroupName(), apiListing);
            }
        }
        return apiListingMap;
    }

    private String longestCommonPath(ArrayList<ApiDescription> apiDescriptions) {
        ArrayList commons = Lists.newArrayList();
        if (null == apiDescriptions || apiDescriptions.isEmpty()) {
            return null;
        }
        List<String> firstWords = this.urlParts(apiDescriptions.get(0));
        for (int position = 0; position < firstWords.size(); ++position) {
            String word = firstWords.get(position);
            boolean allContain = true;
            for (int i = 1; i < apiDescriptions.size(); ++i) {
                List<String> words = this.urlParts(apiDescriptions.get(i));
                if (words.size() >= position + 1 && words.get(position).equals(word)) continue;
                allContain = false;
                break;
            }
            if (!allContain) continue;
            commons.add(word);
        }
        Joiner joiner = Joiner.on((String)"/").skipNulls();
        return "/" + joiner.join((Iterable)commons);
    }

    private List<String> urlParts(ApiDescription apiDescription) {
        return Splitter.on((char)'/').omitEmptyStrings().trimResults().splitToList((CharSequence)apiDescription.getPath());
    }

    public SwaggerGlobalSettings getSwaggerGlobalSettings() {
        return this.swaggerGlobalSettings;
    }

    public void setSwaggerGlobalSettings(SwaggerGlobalSettings swaggerGlobalSettings) {
        this.swaggerGlobalSettings = swaggerGlobalSettings;
    }

    @Deprecated
    public void setResourceGroupingStrategy(ResourceGroupingStrategy resourceGroupingStrategy) {
    }

    public void setAuthorizationContext(AuthorizationContext authorizationContext) {
        this.authorizationContext = authorizationContext;
    }

    public void setApiDescriptionOrdering(Ordering<ApiDescription> apiDescriptionOrdering) {
        this.apiDescriptionOrdering = apiDescriptionOrdering;
    }
}

