/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.readers;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.mangofactory.swagger.configuration.SwaggerGlobalSettings;
import com.mangofactory.swagger.readers.operation.HandlerMethodResolver;
import com.mangofactory.swagger.readers.operation.RequestMappingReader;
import com.mangofactory.swagger.readers.operation.ResolvedMethodParameter;
import com.mangofactory.swagger.scanners.RequestMappingContext;
import com.wordnik.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.condition.ConsumesRequestCondition;
import org.springframework.web.servlet.mvc.condition.ProducesRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

public class MediaTypeReader
implements RequestMappingReader {
    @Override
    public void execute(RequestMappingContext context) {
        SwaggerGlobalSettings swaggerGlobalSettings = (SwaggerGlobalSettings)context.get("swaggerGlobalSettings");
        RequestMappingInfo requestMappingInfo = context.getRequestMappingInfo();
        ConsumesRequestCondition consumesCondition = requestMappingInfo.getConsumesCondition();
        ProducesRequestCondition producesRequestCondition = requestMappingInfo.getProducesCondition();
        Set consumesMediaTypes = consumesCondition.getConsumableMediaTypes();
        Set producesMediaTypes = producesRequestCondition.getProducibleMediaTypes();
        List<String> consumesList = this.toList(consumesMediaTypes);
        List<String> producesList = this.toList(producesMediaTypes);
        ApiOperation annotation = context.getApiOperationAnnotation();
        if (null != annotation && StringUtils.hasText((String)annotation.consumes())) {
            consumesList = this.asList(annotation.consumes());
        }
        if (this.handlerMethodHasFileParameter(context, swaggerGlobalSettings)) {
            consumesList = Arrays.asList("multipart/form-data");
        }
        if (null != annotation && StringUtils.hasText((String)annotation.produces())) {
            producesList = this.asList(annotation.produces());
        }
        if (producesList.isEmpty()) {
            producesList.add("*/*");
        }
        if (consumesList.isEmpty()) {
            consumesList.add("application/json");
        }
        context.put("consumes", consumesList);
        context.put("produces", producesList);
    }

    private boolean handlerMethodHasFileParameter(RequestMappingContext context, SwaggerGlobalSettings swaggerGlobalSettings) {
        HandlerMethodResolver handlerMethodResolver = new HandlerMethodResolver(swaggerGlobalSettings.getTypeResolver());
        List<ResolvedMethodParameter> methodParameters = handlerMethodResolver.methodParameters(context.getHandlerMethod());
        for (ResolvedMethodParameter resolvedMethodParameter : methodParameters) {
            if (!MultipartFile.class.isAssignableFrom(resolvedMethodParameter.getResolvedParameterType().getErasedType())) continue;
            return true;
        }
        return false;
    }

    private List<String> asList(String mediaTypes) {
        return Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)mediaTypes);
    }

    private List<String> toList(Set<MediaType> mediaTypeSet) {
        ArrayList mediaTypes = Lists.newArrayList();
        for (MediaType mediaType : mediaTypeSet) {
            mediaTypes.add(mediaType.toString());
        }
        return mediaTypes;
    }
}

