/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.paths;

import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class SwaggerPathProvider {
    private String apiResourcePrefix = "";

    public String getApiResourcePrefix() {
        return this.apiResourcePrefix;
    }

    public void setApiResourcePrefix(String apiResourcePrefix) {
        Assert.notNull((Object)apiResourcePrefix);
        Assert.isTrue((!apiResourcePrefix.startsWith("/") ? 1 : 0) != 0);
        Assert.isTrue((!apiResourcePrefix.endsWith("/") ? 1 : 0) != 0);
        this.apiResourcePrefix = apiResourcePrefix;
    }

    protected abstract String applicationPath();

    protected abstract String getDocumentationPath();

    public String getApplicationBasePath() {
        return this.applicationPath();
    }

    public String getOperationPath(String operationPath) {
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromPath((String)"/");
        if (StringUtils.hasText((String)this.apiResourcePrefix)) {
            uriComponentsBuilder.path(this.apiResourcePrefix);
        }
        return this.sanitiseUrl(uriComponentsBuilder.path(operationPath).build().toString());
    }

    public String getResourceListingPath(String swaggerGroup, String apiDeclaration) {
        String candidate = this.agnosticUriComponentBuilder(this.getDocumentationPath()).pathSegment(new String[]{swaggerGroup, apiDeclaration}).build().toString();
        return this.sanitiseUrl(candidate);
    }

    public String sanitiseUrl(String candidate) {
        return candidate.replaceAll("(?<!(http:|https:))//", "/");
    }

    private UriComponentsBuilder agnosticUriComponentBuilder(String url) {
        UriComponentsBuilder uriComponentsBuilder = url.startsWith("http") ? UriComponentsBuilder.fromHttpUrl((String)url) : UriComponentsBuilder.fromPath((String)url);
        return uriComponentsBuilder;
    }
}

