/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.models.property.field;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.members.ResolvedField;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mangofactory.swagger.models.Annotations;
import com.mangofactory.swagger.models.BeanPropertyNamingStrategy;
import com.mangofactory.swagger.models.alternates.AlternateTypeProvider;
import com.mangofactory.swagger.models.property.BeanPropertyDefinitions;
import com.mangofactory.swagger.models.property.ModelProperty;
import com.mangofactory.swagger.models.property.field.FieldModelProperty;
import com.mangofactory.swagger.models.property.field.FieldProvider;
import com.mangofactory.swagger.models.property.provider.ModelPropertiesProvider;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FieldModelPropertyProvider
implements ModelPropertiesProvider {
    private final FieldProvider fieldProvider;
    private final AlternateTypeProvider alternateTypeProvider;
    private final BeanPropertyNamingStrategy namingStrategy;
    private ObjectMapper objectMapper;

    @Autowired
    public FieldModelPropertyProvider(FieldProvider fieldProvider, AlternateTypeProvider alternateTypeProvider, BeanPropertyNamingStrategy namingStrategy) {
        this.fieldProvider = fieldProvider;
        this.alternateTypeProvider = alternateTypeProvider;
        this.namingStrategy = namingStrategy;
    }

    @Override
    public Iterable<? extends ModelProperty> propertiesForSerialization(ResolvedType resolvedType) {
        ArrayList serializationCandidates = Lists.newArrayList();
        SerializationConfig serializationConfig = this.objectMapper.getSerializationConfig();
        BeanDescription beanDescription = serializationConfig.introspect(TypeFactory.defaultInstance().constructType((Type)resolvedType.getErasedType()));
        ImmutableMap propertyLookup = Maps.uniqueIndex((Iterable)beanDescription.findProperties(), BeanPropertyDefinitions.beanPropertyByInternalName());
        for (ResolvedField resolvedField : this.fieldProvider.in(resolvedType)) {
            if (!propertyLookup.containsKey(resolvedField.getName())) continue;
            BeanPropertyDefinition propertyDefinition = (BeanPropertyDefinition)propertyLookup.get(resolvedField.getName());
            Optional<BeanPropertyDefinition> jacksonProperty = BeanPropertyDefinitions.jacksonPropertyWithSameInternalName(beanDescription, propertyDefinition);
            AnnotatedMember member = propertyDefinition.getPrimaryMember();
            serializationCandidates.addAll(Lists.newArrayList(this.addSerializationCandidates(member, resolvedField, jacksonProperty)));
        }
        return serializationCandidates;
    }

    @Override
    public Iterable<? extends ModelProperty> propertiesForDeserialization(ResolvedType resolvedType) {
        ArrayList serializationCandidates = Lists.newArrayList();
        DeserializationConfig serializationConfig = this.objectMapper.getDeserializationConfig();
        BeanDescription beanDescription = serializationConfig.introspect(TypeFactory.defaultInstance().constructType((Type)resolvedType.getErasedType()));
        ImmutableMap propertyLookup = Maps.uniqueIndex((Iterable)beanDescription.findProperties(), BeanPropertyDefinitions.beanPropertyByInternalName());
        for (ResolvedField resolvedField : this.fieldProvider.in(resolvedType)) {
            if (!propertyLookup.containsKey(resolvedField.getName())) continue;
            BeanPropertyDefinition propertyDefinition = (BeanPropertyDefinition)propertyLookup.get(resolvedField.getName());
            Optional<BeanPropertyDefinition> jacksonProperty = BeanPropertyDefinitions.jacksonPropertyWithSameInternalName(beanDescription, propertyDefinition);
            AnnotatedMember member = propertyDefinition.getPrimaryMember();
            serializationCandidates.addAll(Lists.newArrayList(this.addDeserializationCandidates(member, resolvedField, jacksonProperty)));
        }
        return serializationCandidates;
    }

    @VisibleForTesting
    Iterable<? extends ModelProperty> addDeserializationCandidates(AnnotatedMember member, ResolvedField childField, Optional<BeanPropertyDefinition> jacksonProperty) {
        if (this.memberIsAField(member)) {
            if (Annotations.memberIsUnwrapped(member)) {
                return Lists.newArrayList(this.propertiesForDeserialization(childField.getType()));
            }
            String fieldName = BeanPropertyDefinitions.name((BeanPropertyDefinition)jacksonProperty.get(), true, this.namingStrategy);
            return Lists.newArrayList((Object[])new FieldModelProperty[]{new FieldModelProperty(fieldName, childField, this.alternateTypeProvider)});
        }
        return Lists.newArrayList();
    }

    @VisibleForTesting
    Iterable<? extends ModelProperty> addSerializationCandidates(AnnotatedMember member, ResolvedField childField, Optional<BeanPropertyDefinition> jacksonProperty) {
        if (this.memberIsAField(member)) {
            if (Annotations.memberIsUnwrapped(member)) {
                return Lists.newArrayList(this.propertiesForSerialization(childField.getType()));
            }
            String fieldName = BeanPropertyDefinitions.name((BeanPropertyDefinition)jacksonProperty.get(), true, this.namingStrategy);
            return Lists.newArrayList((Object[])new FieldModelProperty[]{new FieldModelProperty(fieldName, childField, this.alternateTypeProvider)});
        }
        return Lists.newArrayList();
    }

    @Override
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    protected boolean memberIsAField(AnnotatedMember member) {
        return member != null && member.getMember() != null && Field.class.isAssignableFrom(member.getMember().getClass());
    }
}

