/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.models.alternates;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeBindings;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class WildcardType {
    public static boolean hasWildcards(ResolvedType type) {
        return Iterables.any((Iterable)type.getTypeBindings().getTypeParameters(), WildcardType.thatAreWildcards());
    }

    private static Predicate<ResolvedType> thatAreWildcards() {
        return new Predicate<ResolvedType>(){

            public boolean apply(ResolvedType input) {
                return WildcardType.class.equals((Object)input.getErasedType()) || WildcardType.hasWildcards(input);
            }
        };
    }

    public static boolean exactMatch(ResolvedType first, ResolvedType second) {
        return first.equals((Object)second);
    }

    public static boolean wildcardMatch(ResolvedType toMatch, ResolvedType wildcardType) {
        if (!toMatch.getErasedType().equals(wildcardType.getErasedType())) {
            return false;
        }
        if (!WildcardType.typeBindingsAreOfSameSize(wildcardType, toMatch)) {
            return false;
        }
        TypeBindings wildcardTypeBindings = wildcardType.getTypeBindings();
        TypeBindings bindingsToMatch = toMatch.getTypeBindings();
        for (int index = 0; index < bindingsToMatch.size(); ++index) {
            ResolvedType wildcardTypeBindingsBoundType = wildcardTypeBindings.getBoundType(index);
            ResolvedType bindingsToMatchBoundType = bindingsToMatch.getBoundType(index);
            if (wildcardTypeBindingsBoundType.getErasedType().equals(WildcardType.class) || WildcardType.wildcardMatch(bindingsToMatchBoundType, wildcardTypeBindingsBoundType)) continue;
            return false;
        }
        return true;
    }

    private static boolean typeBindingsAreOfSameSize(ResolvedType toMatch, ResolvedType wildcardType) {
        TypeBindings wildcardTypeBindings = wildcardType.getTypeBindings();
        TypeBindings bindingsToMatch = toMatch.getTypeBindings();
        return bindingsToMatch.size() == wildcardTypeBindings.size();
    }

    static ResolvedType replaceWildcardsFrom(Iterable<ResolvedType> replaceables, ResolvedType wildcardType) {
        Iterator<ResolvedType> replaceableIterator = replaceables.iterator();
        return WildcardType.breadthFirstReplace(replaceableIterator, wildcardType);
    }

    private static ResolvedType breadthFirstReplace(Iterator<ResolvedType> replaceableIterator, ResolvedType wildcardType) {
        if (WildcardType.class.equals((Object)wildcardType.getErasedType())) {
            if (replaceableIterator.hasNext()) {
                return replaceableIterator.next();
            }
            throw new IllegalStateException("Expecting the same number of wildcard types as the replaceables");
        }
        TypeBindings wildcardTypeBindings = wildcardType.getTypeBindings();
        ArrayList bindings = Lists.newArrayList();
        for (int index = 0; index < wildcardTypeBindings.size(); ++index) {
            if (WildcardType.class.equals((Object)wildcardTypeBindings.getBoundType(index).getErasedType())) {
                if (replaceableIterator.hasNext()) {
                    bindings.add(replaceableIterator.next());
                    continue;
                }
                throw new IllegalStateException("Count of wildcards to candidates do not match");
            }
            bindings.add(WildcardType.breadthFirstReplace(replaceableIterator, wildcardTypeBindings.getBoundType(index)));
        }
        return new TypeResolver().resolve((Type)wildcardType.getErasedType(), (Type[])Iterables.toArray((Iterable)bindings, Type.class));
    }

    static List<ResolvedType> collectReplaceables(ResolvedType replacingType, ResolvedType wildcardType) {
        return WildcardType.breadthFirstSearch(replacingType, wildcardType);
    }

    private static List<ResolvedType> breadthFirstSearch(ResolvedType replacingType, ResolvedType wildcardType) {
        TypeBindings wildcardTypeBindings = wildcardType.getTypeBindings();
        TypeBindings bindingsToMatch = replacingType.getTypeBindings();
        Preconditions.checkArgument((boolean)WildcardType.typeBindingsAreOfSameSize(wildcardType, replacingType));
        ArrayList bindings = Lists.newArrayList();
        for (int index = 0; index < bindingsToMatch.size(); ++index) {
            if (WildcardType.class.equals((Object)wildcardTypeBindings.getBoundType(index).getErasedType())) {
                bindings.add(bindingsToMatch.getBoundType(index));
                continue;
            }
            bindings.addAll(WildcardType.breadthFirstSearch(bindingsToMatch.getBoundType(index), wildcardTypeBindings.getBoundType(index)));
        }
        return bindings;
    }
}

