/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.models.alternates;

import com.fasterxml.classmate.ResolvedType;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.mangofactory.swagger.models.alternates.AlternateTypeRule;
import java.util.List;

public class AlternateTypeProvider {
    private List<AlternateTypeRule> rules = Lists.newArrayList();

    public ResolvedType alternateFor(ResolvedType type) {
        Optional matchingRule = FluentIterable.from(this.rules).firstMatch(this.thatAppliesTo(type));
        if (matchingRule.isPresent()) {
            return ((AlternateTypeRule)matchingRule.get()).alternateFor(type);
        }
        return type;
    }

    private Predicate<AlternateTypeRule> thatAppliesTo(final ResolvedType type) {
        return new Predicate<AlternateTypeRule>(){

            public boolean apply(AlternateTypeRule input) {
                return input.appliesTo(type);
            }
        };
    }

    public void addRule(AlternateTypeRule rule) {
        this.rules.add(rule);
    }
}

