/*
 * Decompiled with CFR 0.152.
 */
package com.lunatech.doclets.jax.jaxrs.model;

import com.lunatech.doclets.jax.Utils;
import com.sun.javadoc.Doc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;

public class MethodOutput {
    private MethodDoc declaringMethod;
    private Tag[] returnWrappedTags;

    public MethodOutput(MethodDoc declaringMethod) {
        this.declaringMethod = declaringMethod;
        this.returnWrappedTags = Utils.getTags((Doc)declaringMethod, "returnWrapped");
    }

    public Type getOutputType() {
        return this.declaringMethod.returnType();
    }

    public boolean isOutputWrapped() {
        Type returnType = this.declaringMethod.returnType();
        if (returnType.isPrimitive()) {
            return false;
        }
        if (this.returnWrappedTags == null) {
            return false;
        }
        return this.returnWrappedTags.length != 0;
    }

    public int getOutputWrappedCount() {
        return this.returnWrappedTags != null ? this.returnWrappedTags.length : 0;
    }

    public String getWrappedOutputType(int index) {
        if (!this.isOutputWrapped()) {
            return null;
        }
        String text = this.returnWrappedTags[index].text();
        int ws = text.indexOf(32);
        if (ws > -1) {
            return text.substring(0, ws);
        }
        return text;
    }

    public String getOutputTypeString() {
        Type returnType = this.getOutputType();
        return returnType.qualifiedTypeName() + returnType.dimension();
    }

    public String getOutputDoc(int index) {
        String doc;
        String text;
        int ws;
        if (this.isOutputWrapped() && (ws = (text = this.returnWrappedTags[index].text()).indexOf(32)) > -1 && !Utils.isEmptyOrNull((doc = text.substring(ws)).trim())) {
            return doc;
        }
        return this.getOutputDoc();
    }

    public String getOutputDoc() {
        Tag returnDoc = Utils.getTag((Doc)this.declaringMethod, "return");
        if (returnDoc != null) {
            return returnDoc.text();
        }
        return null;
    }
}

