/*
 * Decompiled with CFR 0.152.
 */
package com.lunatech.doclets.jax.jaxrs;

import com.lunatech.doclets.jax.JAXDoclet;
import com.lunatech.doclets.jax.Utils;
import com.lunatech.doclets.jax.jaxrs.JAXRSConfiguration;
import com.lunatech.doclets.jax.jaxrs.model.JAXRSApplication;
import com.lunatech.doclets.jax.jaxrs.model.PojoTypes;
import com.lunatech.doclets.jax.jaxrs.model.Resource;
import com.lunatech.doclets.jax.jaxrs.tags.ExcludeTaglet;
import com.lunatech.doclets.jax.jaxrs.tags.HTTPTaglet;
import com.lunatech.doclets.jax.jaxrs.tags.IncludeTaglet;
import com.lunatech.doclets.jax.jaxrs.tags.InputWrappedTaglet;
import com.lunatech.doclets.jax.jaxrs.tags.RequestHeaderTaglet;
import com.lunatech.doclets.jax.jaxrs.tags.ResponseHeaderTaglet;
import com.lunatech.doclets.jax.jaxrs.tags.ReturnWrappedTaglet;
import com.lunatech.doclets.jax.jaxrs.writers.DataObjectIndexWriter;
import com.lunatech.doclets.jax.jaxrs.writers.IndexWriter;
import com.lunatech.doclets.jax.jaxrs.writers.PojoClassWriter;
import com.lunatech.doclets.jax.jaxrs.writers.SummaryWriter;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SourcePosition;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.HtmlDoclet;
import com.sun.tools.doclets.internal.toolkit.AbstractDoclet;
import com.sun.tools.doclets.internal.toolkit.taglets.LegacyTaglet;
import com.sun.tools.doclets.internal.toolkit.taglets.Taglet;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXRSDoclet
extends JAXDoclet<JAXRSConfiguration> {
    public final HtmlDoclet htmlDoclet = new HtmlDoclet();

    public static int optionLength(String option) {
        if ("-jaxrscontext".equals(option) || "-matchingpojonamesonly".equals(option) || "-matchingresourcesonly".equals(option) || "-pathexcludefilter".equals(option)) {
            return 2;
        }
        if ("-disablehttpexample".equals(option) || "-disablejavascriptexample".equals(option) || "-enablepojojson".equals(option)) {
            return 1;
        }
        return HtmlDoclet.optionLength((String)option);
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) {
        if (!HtmlDoclet.validOptions((String[][])options, (DocErrorReporter)reporter)) {
            return false;
        }
        List<String> values = Utils.getOptions(options, "-pathexcludefilter");
        for (String value : values) {
            try {
                Pattern.compile(value);
            }
            catch (Throwable t) {
                reporter.printError("Invalid pattern for '-pathexcludefilter' option: '" + value + "' (not a valid regex)");
                return false;
            }
        }
        return true;
    }

    public static LanguageVersion languageVersion() {
        return AbstractDoclet.languageVersion();
    }

    public static boolean start(RootDoc rootDoc) {
        new JAXRSDoclet(rootDoc).start();
        return true;
    }

    public JAXRSDoclet(RootDoc rootDoc) {
        super(rootDoc);
        if (this.htmlDoclet.configuration.tagletManager != null) {
            this.htmlDoclet.configuration.tagletManager.addCustomTag((Taglet)new LegacyTaglet((com.sun.tools.doclets.Taglet)new ResponseHeaderTaglet()));
            this.htmlDoclet.configuration.tagletManager.addCustomTag((Taglet)new LegacyTaglet((com.sun.tools.doclets.Taglet)new RequestHeaderTaglet()));
            this.htmlDoclet.configuration.tagletManager.addCustomTag((Taglet)new LegacyTaglet((com.sun.tools.doclets.Taglet)new HTTPTaglet()));
            this.htmlDoclet.configuration.tagletManager.addCustomTag((Taglet)new LegacyTaglet((com.sun.tools.doclets.Taglet)new ReturnWrappedTaglet()));
            this.htmlDoclet.configuration.tagletManager.addCustomTag((Taglet)new LegacyTaglet((com.sun.tools.doclets.Taglet)new InputWrappedTaglet()));
            this.htmlDoclet.configuration.tagletManager.addCustomTag((Taglet)new LegacyTaglet((com.sun.tools.doclets.Taglet)new IncludeTaglet()));
            this.htmlDoclet.configuration.tagletManager.addCustomTag((Taglet)new ExcludeTaglet());
        }
    }

    @Override
    protected JAXRSConfiguration makeConfiguration(ConfigurationImpl configuration) {
        return new JAXRSConfiguration(configuration);
    }

    public void start() {
        JAXRSApplication app = new JAXRSApplication((JAXRSConfiguration)this.conf);
        Resource rootResource = app.getRootResource();
        PojoTypes types = new PojoTypes((JAXRSConfiguration)this.conf);
        rootResource.write(this, this.conf, app, types);
        new IndexWriter(this.conf, app, this).write();
        new SummaryWriter(this.conf, app, this).write();
        if (((JAXRSConfiguration)this.conf).enablePojoJsonDataObjects) {
            types.resolveSubclassDtos();
            new DataObjectIndexWriter(this.conf, app, this, types).write();
            for (ClassDoc cDoc : types.getResolvedTypes()) {
                new PojoClassWriter(this.conf, app, cDoc, types, rootResource, this).write();
            }
        }
        Utils.copyResources(this.conf);
    }

    public void warn(String warning) {
        ((JAXRSConfiguration)this.conf).parentConfiguration.root.printWarning(warning);
    }

    public void printError(SourcePosition position, String error) {
        ((JAXRSConfiguration)this.conf).parentConfiguration.root.printError(position, error);
    }
}

