/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGState;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.tools.arguments.FileArgument;
import com.lowagie.tools.arguments.PdfFilter;
import com.lowagie.tools.arguments.ToolArgument;
import com.lowagie.tools.plugins.AbstractTool;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class Watermarker
extends AbstractTool {
    static /* synthetic */ Class class$java$lang$String;

    public Watermarker() {
        this.arguments.add(new FileArgument(this, "srcfile", "The file you want to watermark", false, new PdfFilter()));
        this.arguments.add(new ToolArgument(this, "watermark", "The text that can be used as watermark", (class$java$lang$String == null ? (class$java$lang$String = Watermarker.class$("java.lang.String")) : class$java$lang$String).getName()));
        this.arguments.add(new ToolArgument(this, "fontsize", "The fontsize of the watermark text", (class$java$lang$String == null ? (class$java$lang$String = Watermarker.class$("java.lang.String")) : class$java$lang$String).getName()));
        this.arguments.add(new FileArgument(this, "destfile", "The file to which the watermarked PDF has to be written", true, new PdfFilter()));
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Watermark", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Watermark OPENED ===");
    }

    public void execute() {
        try {
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            if (this.getValue("watermark") == null) {
                throw new InstantiationException("You need to add a text for the watermark");
            }
            int n = Integer.parseInt((String)this.getValue("fontsize"));
            BaseFont baseFont = BaseFont.createFont("Helvetica", "Cp1252", false);
            PdfReader pdfReader = new PdfReader(((File)this.getValue("srcfile")).getAbsolutePath());
            int n2 = pdfReader.getNumberOfPages();
            PdfGState pdfGState = new PdfGState();
            pdfGState.setFillOpacity(0.5f);
            String string = (String)this.getValue("watermark");
            PdfStamper pdfStamper = new PdfStamper(pdfReader, new FileOutputStream((File)this.getValue("destfile")));
            float f = baseFont.getWidthPoint(string, (float)n);
            for (int i = 1; i <= n2; ++i) {
                PdfContentByte pdfContentByte = pdfStamper.getOverContent(i);
                Rectangle rectangle = pdfReader.getCropBox(i);
                float f2 = (float)Math.atan(rectangle.height() / rectangle.width());
                float f3 = (float)Math.cos(f2);
                float f4 = (float)(-Math.sin(f2));
                float f5 = (float)Math.sin(f2);
                float f6 = (float)Math.cos(f2);
                float f7 = (float)(-Math.cos(f2) * (double)f / 2.0 - Math.sin(f2) * (double)n / 2.0);
                float f8 = (float)(Math.sin(f2) * (double)f / 2.0 - Math.cos(f2) * (double)n / 2.0);
                pdfContentByte.saveState();
                pdfContentByte.setGState(pdfGState);
                pdfContentByte.beginText();
                pdfContentByte.setFontAndSize(baseFont, n);
                pdfContentByte.setTextMatrix(f3, f4, f5, f6, f7 + rectangle.width() / 2.0f, f8 + rectangle.height() / 2.0f);
                pdfContentByte.showText(string);
                pdfContentByte.endText();
                pdfContentByte.restoreState();
            }
            pdfStamper.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.internalFrame, exception.getMessage(), exception.getClass().getName(), 0);
            System.err.println(exception.getMessage());
        }
    }

    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }

    public void valueHasChanged(ToolArgument toolArgument) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] stringArray) {
        Watermarker watermarker = new Watermarker();
        if (stringArray.length != 4) {
            System.err.println(watermarker.getUsage());
        }
        watermarker.setArguments(stringArray);
        watermarker.execute();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Watermarker.addVersion("$Id: Watermarker.java,v 1.5 2005/11/29 21:05:02 blowagie Exp $");
    }
}

