/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfFont;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfChunk
extends RtfElement {
    private static final byte[] FONT_SUBSCRIPT = "\\sub".getBytes();
    private static final byte[] FONT_SUPERSCRIPT = "\\super".getBytes();
    private static final byte[] FONT_END_SUPER_SUBSCRIPT = "\\nosupersub".getBytes();
    private RtfFont font = null;
    private String content = "";
    private boolean softLineBreaks = false;
    private float superSubScript = 0.0f;

    public RtfChunk(RtfDocument rtfDocument, Chunk chunk) {
        super(rtfDocument);
        if (chunk == null) {
            return;
        }
        if (chunk.getAttributes() != null && chunk.getAttributes().get("SUBSUPSCRIPT") != null) {
            this.superSubScript = ((Float)chunk.getAttributes().get("SUBSUPSCRIPT")).floatValue();
        }
        this.font = new RtfFont(rtfDocument, chunk.font());
        this.content = chunk.content();
    }

    public byte[] write() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(this.font.writeBegin());
            if (this.superSubScript < 0.0f) {
                byteArrayOutputStream.write(FONT_SUBSCRIPT);
            } else if (this.superSubScript > 0.0f) {
                byteArrayOutputStream.write(FONT_SUPERSCRIPT);
            }
            byteArrayOutputStream.write(RtfBasicElement.DELIMITER);
            byteArrayOutputStream.write(this.document.filterSpecialChar(this.content, false, this.softLineBreaks).getBytes());
            if (this.superSubScript != 0.0f) {
                byteArrayOutputStream.write(FONT_END_SUPER_SUBSCRIPT);
            }
            byteArrayOutputStream.write(this.font.writeEnd());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void setRtfDocument(RtfDocument rtfDocument) {
        super.setRtfDocument(rtfDocument);
        this.font.setRtfDocument(this.document);
    }

    public void setSoftLineBreaks(boolean bl) {
        this.softLineBreaks = bl;
    }

    public boolean getSoftLineBreaks() {
        return this.softLineBreaks;
    }
}

