/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.codec;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.codec.CCITTG4Encoder;
import com.lowagie.text.pdf.codec.TIFFDirectory;
import com.lowagie.text.pdf.codec.TIFFFaxDecoder;
import com.lowagie.text.pdf.codec.TIFFField;
import com.lowagie.text.pdf.codec.TIFFLZWDecoder;
import java.awt.color.ICC_Profile;
import java.io.ByteArrayOutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;

public class TiffImage {
    public static int getNumberOfPages(RandomAccessFileOrArray randomAccessFileOrArray) {
        try {
            return TIFFDirectory.getNumDirectories(randomAccessFileOrArray);
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    static int getDpi(TIFFField tIFFField, int n) {
        if (tIFFField == null) {
            return 0;
        }
        long[] lArray = tIFFField.getAsRational(0);
        float f = (float)lArray[0] / (float)lArray[1];
        int n2 = 0;
        switch (n) {
            case 1: 
            case 2: {
                n2 = (int)f;
                break;
            }
            case 3: {
                n2 = (int)((double)f * 2.54);
            }
        }
        return n2;
    }

    public static Image getTiffImage(RandomAccessFileOrArray randomAccessFileOrArray, int n) {
        return TiffImage.getTiffImage(randomAccessFileOrArray, n, false);
    }

    public static Image getTiffImage(RandomAccessFileOrArray randomAccessFileOrArray, int n, boolean bl) {
        if (n < 1) {
            throw new IllegalArgumentException("The page number must be >= 1.");
        }
        try {
            Object object;
            Object object2;
            long l;
            TIFFDirectory tIFFDirectory = new TIFFDirectory(randomAccessFileOrArray, n - 1);
            if (tIFFDirectory.isTagPresent(322)) {
                throw new IllegalArgumentException("Tiles are not supported.");
            }
            int n2 = (int)tIFFDirectory.getFieldAsLong(259);
            switch (n2) {
                case 2: 
                case 3: 
                case 4: 
                case 32771: {
                    break;
                }
                default: {
                    return TiffImage.getTiffImageColor(tIFFDirectory, randomAccessFileOrArray);
                }
            }
            Image image = null;
            long l2 = 0L;
            long l3 = 0L;
            int n3 = 1;
            int n4 = (int)tIFFDirectory.getFieldAsLong(257);
            int n5 = (int)tIFFDirectory.getFieldAsLong(256);
            int n6 = 0;
            int n7 = 0;
            float f = 0.0f;
            int n8 = 2;
            if (tIFFDirectory.isTagPresent(296)) {
                n8 = (int)tIFFDirectory.getFieldAsLong(296);
            }
            n6 = TiffImage.getDpi(tIFFDirectory.getField(282), n8);
            n7 = TiffImage.getDpi(tIFFDirectory.getField(283), n8);
            if (n8 == 1) {
                if (n7 != 0) {
                    f = (float)n6 / (float)n7;
                }
                n6 = 0;
                n7 = 0;
            }
            long l4 = 0xFFFFFFFFL;
            if (tIFFDirectory.isTagPresent(278)) {
                l4 = tIFFDirectory.getFieldAsLong(278);
            }
            int n9 = (int)Math.min((long)n4, l4);
            TIFFField tIFFField = tIFFDirectory.getField(273);
            long[] lArray = TiffImage.getArrayLongShort(tIFFDirectory, 273);
            long[] lArray2 = TiffImage.getArrayLongShort(tIFFDirectory, 279);
            boolean bl2 = false;
            TIFFField tIFFField2 = tIFFDirectory.getField(266);
            if (tIFFField2 != null) {
                n3 = tIFFField2.getAsInt(0);
            }
            bl2 = n3 == 2;
            int n10 = 0;
            if (tIFFDirectory.isTagPresent(262) && (l = tIFFDirectory.getFieldAsLong(262)) == 1L) {
                n10 |= 1;
            }
            int n11 = 0;
            switch (n2) {
                case 2: 
                case 32771: {
                    n11 = 257;
                    n10 |= 0xA;
                    break;
                }
                case 3: {
                    n11 = 257;
                    n10 |= 0xC;
                    object2 = tIFFDirectory.getField(292);
                    if (object2 == null) break;
                    l2 = ((TIFFField)object2).getAsLong(0);
                    if ((l2 & 1L) != 0L) {
                        n2 = 258;
                    }
                    if ((l2 & 4L) == 0L) break;
                    n10 |= 2;
                    break;
                }
                case 4: {
                    n11 = 256;
                    object = tIFFDirectory.getField(293);
                    if (object == null) break;
                    l3 = ((TIFFField)object).getAsLong(0);
                }
            }
            if (bl && n9 == n4) {
                object2 = new byte[(int)lArray2[0]];
                randomAccessFileOrArray.seek(lArray[0]);
                randomAccessFileOrArray.readFully((byte[])object2);
                image = Image.getInstance(n5, n4, bl2, n11, n10, (byte[])object2);
                image.setInverted(true);
            } else {
                int n12 = n4;
                object = new CCITTG4Encoder(n5);
                for (int i = 0; i < lArray.length; ++i) {
                    byte[] byArray = new byte[(int)lArray2[i]];
                    randomAccessFileOrArray.seek(lArray[i]);
                    randomAccessFileOrArray.readFully(byArray);
                    int n13 = Math.min(n9, n12);
                    TIFFFaxDecoder tIFFFaxDecoder = new TIFFFaxDecoder(n3, n5, n13);
                    byte[] byArray2 = new byte[(n5 + 7) / 8 * n13];
                    switch (n2) {
                        case 2: 
                        case 32771: {
                            tIFFFaxDecoder.decode1D(byArray2, byArray, 0, n13);
                            ((CCITTG4Encoder)object).encodeT6Lines(byArray2, 0, n13);
                            break;
                        }
                        case 3: {
                            try {
                                tIFFFaxDecoder.decode2D(byArray2, byArray, 0, n13, l2);
                            }
                            catch (Exception exception) {
                                l2 ^= 4L;
                                try {
                                    tIFFFaxDecoder.decode2D(byArray2, byArray, 0, n13, l2);
                                }
                                catch (Exception exception2) {
                                    throw exception;
                                }
                            }
                            ((CCITTG4Encoder)object).encodeT6Lines(byArray2, 0, n13);
                            break;
                        }
                        case 4: {
                            tIFFFaxDecoder.decodeT6(byArray2, byArray, 0, n13, l3);
                            ((CCITTG4Encoder)object).encodeT6Lines(byArray2, 0, n13);
                        }
                    }
                    n12 -= n9;
                }
                byte[] byArray = ((CCITTG4Encoder)object).close();
                image = Image.getInstance(n5, n4, false, 256, n10 & 1, byArray);
            }
            image.setDpi(n6, n7);
            image.setXYRatio(f);
            if (tIFFDirectory.isTagPresent(34675)) {
                try {
                    TIFFField tIFFField3 = tIFFDirectory.getField(34675);
                    object = ICC_Profile.getInstance(tIFFField3.getAsBytes());
                    if (((ICC_Profile)object).getNumComponents() == 1) {
                        image.tagICC((ICC_Profile)object);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            image.setOriginalType(5);
            return image;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    protected static Image getTiffImageColor(TIFFDirectory tIFFDirectory, RandomAccessFileOrArray randomAccessFileOrArray) {
        try {
            Object object;
            int n = (int)tIFFDirectory.getFieldAsLong(259);
            int n2 = 1;
            TIFFLZWDecoder tIFFLZWDecoder = null;
            switch (n) {
                case 1: 
                case 5: 
                case 32773: 
                case 32946: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The compression " + n + " is not supported.");
                }
            }
            int n3 = (int)tIFFDirectory.getFieldAsLong(262);
            switch (n3) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The photometric " + n3 + " is not supported.");
                }
            }
            if (tIFFDirectory.isTagPresent(284) && tIFFDirectory.getFieldAsLong(284) == 2L) {
                throw new IllegalArgumentException("Planar images are not supported.");
            }
            if (tIFFDirectory.isTagPresent(338)) {
                throw new IllegalArgumentException("Extra samples are not supported.");
            }
            int n4 = 1;
            if (tIFFDirectory.isTagPresent(277)) {
                n4 = (int)tIFFDirectory.getFieldAsLong(277);
            }
            int n5 = 1;
            if (tIFFDirectory.isTagPresent(258)) {
                n5 = (int)tIFFDirectory.getFieldAsLong(258);
            }
            switch (n5) {
                case 1: 
                case 2: 
                case 4: 
                case 8: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bits per sample " + n5 + " is not supported.");
                }
            }
            Image image = null;
            int n6 = (int)tIFFDirectory.getFieldAsLong(257);
            int n7 = (int)tIFFDirectory.getFieldAsLong(256);
            int n8 = 0;
            int n9 = 0;
            int n10 = 2;
            if (tIFFDirectory.isTagPresent(296)) {
                n10 = (int)tIFFDirectory.getFieldAsLong(296);
            }
            n8 = TiffImage.getDpi(tIFFDirectory.getField(282), n10);
            n9 = TiffImage.getDpi(tIFFDirectory.getField(283), n10);
            int n11 = (int)tIFFDirectory.getFieldAsLong(278);
            long[] lArray = TiffImage.getArrayLongShort(tIFFDirectory, 273);
            long[] lArray2 = TiffImage.getArrayLongShort(tIFFDirectory, 279);
            if (n == 5) {
                TIFFField tIFFField = tIFFDirectory.getField(317);
                if (tIFFField != null) {
                    n2 = tIFFField.getAsInt(0);
                    if (n2 != 1 && n2 != 2) {
                        throw new RuntimeException("Illegal value for Predictor in TIFF file.");
                    }
                    if (n2 == 2 && n5 != 8) {
                        throw new RuntimeException(n5 + "-bit samples are not supported for Horizontal differencing Predictor.");
                    }
                }
                tIFFLZWDecoder = new TIFFLZWDecoder(n7, n2, n4);
            }
            int n12 = n6;
            ByteArrayOutputStream byteArrayOutputStream = null;
            DeflaterOutputStream deflaterOutputStream = null;
            CCITTG4Encoder cCITTG4Encoder = null;
            if (n5 == 1 && n4 == 1) {
                cCITTG4Encoder = new CCITTG4Encoder(n7);
            } else {
                byteArrayOutputStream = new ByteArrayOutputStream();
                deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
            }
            for (int i = 0; i < lArray.length; ++i) {
                object = new byte[(int)lArray2[i]];
                randomAccessFileOrArray.seek(lArray[i]);
                randomAccessFileOrArray.readFully((byte[])object);
                int n13 = Math.min(n11, n12);
                byte[] byArray = null;
                if (n != 1) {
                    byArray = new byte[(n7 * n5 * n4 + 7) / 8 * n13];
                }
                switch (n) {
                    case 32946: {
                        TiffImage.inflate(object, byArray);
                        break;
                    }
                    case 1: {
                        byArray = object;
                        break;
                    }
                    case 32773: {
                        TiffImage.decodePackbits(object, byArray);
                        break;
                    }
                    case 5: {
                        tIFFLZWDecoder.decode((byte[])object, byArray, n13);
                    }
                }
                if (n5 == 1 && n4 == 1) {
                    cCITTG4Encoder.encodeT6Lines(byArray, 0, n13);
                } else {
                    deflaterOutputStream.write(byArray);
                }
                n12 -= n11;
            }
            if (n5 == 1 && n4 == 1) {
                image = Image.getInstance(n7, n6, false, 256, n3 == 1 ? 1 : 0, cCITTG4Encoder.close());
            } else {
                deflaterOutputStream.close();
                image = Image.getInstance(n7, n6, n4, n5, byteArrayOutputStream.toByteArray());
                image.setDeflated(true);
            }
            image.setDpi(n8, n9);
            if (tIFFDirectory.isTagPresent(34675)) {
                try {
                    TIFFField tIFFField = tIFFDirectory.getField(34675);
                    object = ICC_Profile.getInstance(tIFFField.getAsBytes());
                    if (n4 == object.getNumComponents()) {
                        image.tagICC((ICC_Profile)object);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (tIFFDirectory.isTagPresent(320)) {
                TIFFField tIFFField = tIFFDirectory.getField(320);
                object = tIFFField.getAsChars();
                byte[] byArray = new byte[((byte[])object).length];
                int n14 = ((byte[])object).length / 3;
                int n15 = n14 * 2;
                for (int i = 0; i < n14; ++i) {
                    byArray[i * 3] = (byte)(object[i] >>> 8);
                    byArray[i * 3 + 1] = (byte)(object[i + n14] >>> 8);
                    byArray[i * 3 + 2] = (byte)(object[i + n15] >>> 8);
                }
                PdfArray pdfArray = new PdfArray();
                pdfArray.add(PdfName.INDEXED);
                pdfArray.add(PdfName.DEVICERGB);
                pdfArray.add(new PdfNumber(n14 - 1));
                pdfArray.add(new PdfString(byArray));
                PdfDictionary pdfDictionary = new PdfDictionary();
                pdfDictionary.put(PdfName.COLORSPACE, pdfArray);
                image.setAdditional(pdfDictionary);
            }
            if (n3 == 0) {
                image.setInverted(true);
            }
            image.setOriginalType(5);
            return image;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    static long[] getArrayLongShort(TIFFDirectory tIFFDirectory, int n) {
        long[] lArray;
        TIFFField tIFFField = tIFFDirectory.getField(n);
        if (tIFFField == null) {
            return null;
        }
        if (tIFFField.getType() == 4) {
            lArray = tIFFField.getAsLongs();
        } else {
            char[] cArray = tIFFField.getAsChars();
            lArray = new long[cArray.length];
            for (int i = 0; i < cArray.length; ++i) {
                lArray[i] = cArray[i];
            }
        }
        return lArray;
    }

    public static void decodePackbits(byte[] byArray, byte[] byArray2) {
        int n = 0;
        int n2 = 0;
        while (n2 < byArray2.length) {
            int n3;
            byte by;
            if ((by = byArray[n++]) >= 0 && by <= 127) {
                for (n3 = 0; n3 < by + 1; ++n3) {
                    byArray2[n2++] = byArray[n++];
                }
                continue;
            }
            if (by <= -1 && by >= -127) {
                byte by2 = byArray[n++];
                for (n3 = 0; n3 < -by + 1; ++n3) {
                    byArray2[n2++] = by2;
                }
                continue;
            }
            ++n;
        }
    }

    public static void inflate(byte[] byArray, byte[] byArray2) {
        Inflater inflater = new Inflater();
        inflater.setInput(byArray);
        try {
            inflater.inflate(byArray2);
        }
        catch (DataFormatException dataFormatException) {
            throw new ExceptionConverter(dataFormatException);
        }
    }
}

