/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNull;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.SimpleNamedDestination;
import com.lowagie.text.pdf.SimpleXMLDocHandler;
import com.lowagie.text.pdf.SimpleXMLParser;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import java.util.StringTokenizer;

public class SimpleBookmark
implements SimpleXMLDocHandler {
    private ArrayList topList;
    private Stack attr = new Stack();

    private SimpleBookmark() {
    }

    private static List bookmarkDepth(PdfReader pdfReader, PdfDictionary pdfDictionary, IntHashtable intHashtable) {
        ArrayList arrayList = new ArrayList();
        while (pdfDictionary != null) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            PdfString pdfString = (PdfString)PdfReader.getPdfObject(pdfDictionary.get(PdfName.TITLE));
            hashMap.put("Title", pdfString.toUnicodeString());
            PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.C));
            if (pdfArray != null && pdfArray.getArrayList().size() == 3) {
                object5 = new ByteBuffer();
                object4 = pdfArray.getArrayList();
                ((ByteBuffer)object5).append(((PdfNumber)((ArrayList)object4).get(0)).floatValue()).append(' ');
                ((ByteBuffer)object5).append(((PdfNumber)((ArrayList)object4).get(1)).floatValue()).append(' ');
                ((ByteBuffer)object5).append(((PdfNumber)((ArrayList)object4).get(2)).floatValue());
                hashMap.put("Color", PdfEncodings.convertToString(((ByteBuffer)object5).toByteArray(), null));
            }
            if ((object5 = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.F))) != null) {
                int n = ((PdfNumber)object5).intValue();
                object3 = "";
                if ((n & 1) != 0) {
                    object3 = (String)object3 + "italic ";
                }
                if ((n & 2) != 0) {
                    object3 = (String)object3 + "bold ";
                }
                if (((String)(object3 = ((String)object3).trim())).length() != 0) {
                    hashMap.put("Style", object3);
                }
            }
            if ((object4 = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.COUNT))) != null && ((PdfNumber)object4).intValue() < 0) {
                hashMap.put("Open", "false");
            }
            if ((object3 = PdfReader.getPdfObject(pdfDictionary.get(PdfName.DEST))) != null) {
                if (((PdfObject)object3).isString()) {
                    hashMap.put("Named", ((PdfObject)object3).toString());
                } else if (((PdfObject)object3).isName()) {
                    hashMap.put("Named", PdfName.decodeName(((PdfObject)object3).toString()));
                } else if (((PdfObject)object3).isArray()) {
                    object2 = ((PdfArray)object3).getArrayList();
                    object = new StringBuffer();
                    ((StringBuffer)object).append(intHashtable.get(((PdfIndirectReference)((ArrayList)object2).get(0)).getNumber()));
                    ((StringBuffer)object).append(' ').append(((ArrayList)object2).get(1).toString().substring(1));
                    for (int i = 2; i < ((ArrayList)object2).size(); ++i) {
                        ((StringBuffer)object).append(' ').append(((ArrayList)object2).get(i).toString());
                    }
                    hashMap.put("Page", ((StringBuffer)object).toString());
                }
                hashMap.put("Action", "GoTo");
            } else {
                object2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.A));
                if (object2 != null) {
                    int n;
                    if (PdfName.GOTO.equals(PdfReader.getPdfObject(((PdfDictionary)object2).get(PdfName.S)))) {
                        object3 = PdfReader.getPdfObject(((PdfDictionary)object2).get(PdfName.D));
                        if (object3 != null) {
                            if (((PdfObject)object3).isString()) {
                                hashMap.put("Named", ((PdfObject)object3).toString());
                            } else if (((PdfObject)object3).isName()) {
                                hashMap.put("Named", PdfName.decodeName(((PdfObject)object3).toString()));
                            } else if (((PdfObject)object3).isArray()) {
                                object = ((PdfArray)object3).getArrayList();
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append(intHashtable.get(((PdfIndirectReference)((ArrayList)object).get(0)).getNumber()));
                                stringBuffer.append(' ').append(((ArrayList)object).get(1).toString().substring(1));
                                for (n = 2; n < ((ArrayList)object).size(); ++n) {
                                    stringBuffer.append(' ').append(((ArrayList)object).get(n).toString());
                                }
                                hashMap.put("Page", stringBuffer.toString());
                            }
                            hashMap.put("Action", "GoTo");
                        }
                    } else if (PdfName.URI.equals(PdfReader.getPdfObject(((PdfDictionary)object2).get(PdfName.S)))) {
                        hashMap.put("Action", "URI");
                        hashMap.put("URI", ((PdfString)PdfReader.getPdfObject(((PdfDictionary)object2).get(PdfName.URI))).toUnicodeString());
                    } else if (PdfName.GOTOR.equals(PdfReader.getPdfObject(((PdfDictionary)object2).get(PdfName.S)))) {
                        PdfObject pdfObject;
                        object3 = PdfReader.getPdfObject(((PdfDictionary)object2).get(PdfName.D));
                        if (object3 != null) {
                            if (((PdfObject)object3).isString()) {
                                hashMap.put("Named", ((PdfObject)object3).toString());
                            } else if (((PdfObject)object3).isName()) {
                                hashMap.put("NamedN", PdfName.decodeName(((PdfObject)object3).toString()));
                            } else if (((PdfObject)object3).isArray()) {
                                object = ((PdfArray)object3).getArrayList();
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append(((ArrayList)object).get(0).toString());
                                stringBuffer.append(' ').append(((ArrayList)object).get(1).toString());
                                for (n = 2; n < ((ArrayList)object).size(); ++n) {
                                    stringBuffer.append(' ').append(((ArrayList)object).get(n).toString());
                                }
                                hashMap.put("Page", stringBuffer.toString());
                            }
                        }
                        hashMap.put("Action", "GoToR");
                        object = PdfReader.getPdfObject(((PdfDictionary)object2).get(PdfName.F));
                        if (object != null) {
                            if (((PdfObject)object).isString()) {
                                hashMap.put("File", ((PdfString)object).toUnicodeString());
                            } else if (((PdfObject)object).isDictionary() && ((PdfObject)(object = PdfReader.getPdfObject(((PdfDictionary)object).get(PdfName.F)))).isString()) {
                                hashMap.put("File", ((PdfString)object).toUnicodeString());
                            }
                        }
                        if ((pdfObject = PdfReader.getPdfObject(((PdfDictionary)object2).get(PdfName.NEWWINDOW))) != null) {
                            hashMap.put("NewWindow", pdfObject.toString());
                        }
                    } else if (PdfName.LAUNCH.equals(PdfReader.getPdfObject(((PdfDictionary)object2).get(PdfName.S)))) {
                        hashMap.put("Action", "Launch");
                        object = PdfReader.getPdfObject(((PdfDictionary)object2).get(PdfName.F));
                        if (object == null) {
                            object = PdfReader.getPdfObject(((PdfDictionary)object2).get(PdfName.WIN));
                        }
                        if (object != null) {
                            if (((PdfObject)object).isString()) {
                                hashMap.put("File", ((PdfString)object).toUnicodeString());
                            } else if (((PdfObject)object).isDictionary() && ((PdfObject)(object = PdfReader.getPdfObject(((PdfDictionary)object).get(PdfName.F)))).isString()) {
                                hashMap.put("File", ((PdfString)object).toUnicodeString());
                            }
                        }
                    }
                }
            }
            object2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FIRST));
            if (object2 != null) {
                hashMap.put("Kids", SimpleBookmark.bookmarkDepth(pdfReader, (PdfDictionary)object2, intHashtable));
            }
            arrayList.add(hashMap);
            pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.NEXT));
        }
        return arrayList;
    }

    public static List getBookmark(PdfReader pdfReader) {
        PdfDictionary pdfDictionary = pdfReader.getCatalog();
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.OUTLINES));
        if (pdfDictionary2 == null) {
            return null;
        }
        IntHashtable intHashtable = new IntHashtable();
        int n = pdfReader.getNumberOfPages();
        for (int i = 1; i <= n; ++i) {
            intHashtable.put(pdfReader.getPageOrigRef(i).getNumber(), i);
        }
        return SimpleBookmark.bookmarkDepth(pdfReader, (PdfDictionary)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.FIRST)), intHashtable);
    }

    public static void eliminatePages(List list, int[] nArray) {
        if (list == null) {
            return;
        }
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Object object;
            HashMap hashMap = (HashMap)listIterator.next();
            boolean bl = false;
            if ("GoTo".equals(hashMap.get("Action")) && (object = (String)hashMap.get("Page")) != null) {
                int n = ((String)(object = ((String)object).trim())).indexOf(32);
                int n2 = n < 0 ? Integer.parseInt((String)object) : Integer.parseInt(((String)object).substring(0, n));
                int n3 = nArray.length & 0xFFFFFFFE;
                for (int i = 0; i < n3; i += 2) {
                    if (n2 < nArray[i] || n2 > nArray[i + 1]) continue;
                    bl = true;
                    break;
                }
            }
            if ((object = (List)hashMap.get("Kids")) != null) {
                SimpleBookmark.eliminatePages((List)object, nArray);
                if (object.size() == 0) {
                    hashMap.remove("Kids");
                    object = null;
                }
            }
            if (!bl) continue;
            if (object == null) {
                listIterator.remove();
                continue;
            }
            hashMap.remove("Action");
            hashMap.remove("Page");
            hashMap.remove("Named");
        }
    }

    public static void shiftPageNumbers(List list, int n, int[] nArray) {
        if (list == null) {
            return;
        }
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Object object;
            HashMap hashMap = (HashMap)listIterator.next();
            if ("GoTo".equals(hashMap.get("Action")) && (object = (String)hashMap.get("Page")) != null) {
                int n2 = ((String)(object = ((String)object).trim())).indexOf(32);
                int n3 = n2 < 0 ? Integer.parseInt((String)object) : Integer.parseInt(((String)object).substring(0, n2));
                boolean bl = false;
                if (nArray == null) {
                    bl = true;
                } else {
                    int n4 = nArray.length & 0xFFFFFFFE;
                    for (int i = 0; i < n4; i += 2) {
                        if (n3 < nArray[i] || n3 > nArray[i + 1]) continue;
                        bl = true;
                        break;
                    }
                }
                if (bl) {
                    object = n2 < 0 ? n3 + n + "" : n3 + n + ((String)object).substring(n2);
                }
                hashMap.put("Page", object);
            }
            if ((object = (List)hashMap.get("Kids")) == null) continue;
            SimpleBookmark.shiftPageNumbers((List)object, n, nArray);
        }
    }

    static void createOutlineAction(PdfDictionary pdfDictionary, HashMap hashMap, PdfWriter pdfWriter, boolean bl) throws IOException {
        try {
            String string;
            String string2 = (String)hashMap.get("Action");
            if ("GoTo".equals(string2)) {
                String string3 = (String)hashMap.get("Named");
                if (string3 != null) {
                    if (bl) {
                        pdfDictionary.put(PdfName.DEST, new PdfName(string3));
                    } else {
                        pdfDictionary.put(PdfName.DEST, new PdfString(string3, null));
                    }
                } else {
                    string3 = (String)hashMap.get("Page");
                    if (string3 != null) {
                        PdfArray pdfArray = new PdfArray();
                        StringTokenizer stringTokenizer = new StringTokenizer(string3);
                        int n = Integer.parseInt(stringTokenizer.nextToken());
                        pdfArray.add(pdfWriter.getPageReference(n));
                        if (!stringTokenizer.hasMoreTokens()) {
                            pdfArray.add(PdfName.XYZ);
                            pdfArray.add(new float[]{0.0f, 10000.0f, 0.0f});
                        } else {
                            String string4 = stringTokenizer.nextToken();
                            if (string4.startsWith("/")) {
                                string4 = string4.substring(1);
                            }
                            pdfArray.add(new PdfName(string4));
                            for (int i = 0; i < 4 && stringTokenizer.hasMoreTokens(); ++i) {
                                string4 = stringTokenizer.nextToken();
                                if (string4.equals("null")) {
                                    pdfArray.add(PdfNull.PDFNULL);
                                    continue;
                                }
                                pdfArray.add(new PdfNumber(string4));
                            }
                        }
                        pdfDictionary.put(PdfName.DEST, pdfArray);
                    }
                }
            } else if ("GoToR".equals(string2)) {
                Object object;
                Object object2;
                PdfDictionary pdfDictionary2 = new PdfDictionary();
                String string5 = (String)hashMap.get("Named");
                if (string5 != null) {
                    pdfDictionary2.put(PdfName.D, new PdfString(string5, null));
                } else {
                    string5 = (String)hashMap.get("NamedN");
                    if (string5 != null) {
                        pdfDictionary2.put(PdfName.D, new PdfName(string5));
                    } else {
                        string5 = (String)hashMap.get("Page");
                        if (string5 != null) {
                            object2 = new PdfArray();
                            object = new StringTokenizer(string5);
                            ((PdfArray)object2).add(new PdfNumber(((StringTokenizer)object).nextToken()));
                            if (!((StringTokenizer)object).hasMoreTokens()) {
                                ((PdfArray)object2).add(PdfName.XYZ);
                                ((PdfArray)object2).add(new float[]{0.0f, 10000.0f, 0.0f});
                            } else {
                                String string6 = ((StringTokenizer)object).nextToken();
                                if (string6.startsWith("/")) {
                                    string6 = string6.substring(1);
                                }
                                ((PdfArray)object2).add(new PdfName(string6));
                                for (int i = 0; i < 4 && ((StringTokenizer)object).hasMoreTokens(); ++i) {
                                    string6 = ((StringTokenizer)object).nextToken();
                                    if (string6.equals("null")) {
                                        ((PdfArray)object2).add(PdfNull.PDFNULL);
                                        continue;
                                    }
                                    ((PdfArray)object2).add(new PdfNumber(string6));
                                }
                            }
                            pdfDictionary2.put(PdfName.D, (PdfObject)object2);
                        }
                    }
                }
                object2 = (String)hashMap.get("File");
                if (pdfDictionary2.size() > 0 && object2 != null) {
                    pdfDictionary2.put(PdfName.S, PdfName.GOTOR);
                    pdfDictionary2.put(PdfName.F, new PdfString((String)object2));
                    object = (String)hashMap.get("NewWindow");
                    if (object != null) {
                        if (((String)object).equals("true")) {
                            pdfDictionary2.put(PdfName.NEWWINDOW, PdfBoolean.PDFTRUE);
                        } else if (((String)object).equals("false")) {
                            pdfDictionary2.put(PdfName.NEWWINDOW, PdfBoolean.PDFFALSE);
                        }
                    }
                    pdfDictionary.put(PdfName.A, pdfDictionary2);
                }
            } else if ("URI".equals(string2)) {
                String string7 = (String)hashMap.get("URI");
                if (string7 != null) {
                    PdfDictionary pdfDictionary3 = new PdfDictionary();
                    pdfDictionary3.put(PdfName.S, PdfName.URI);
                    pdfDictionary3.put(PdfName.URI, new PdfString(string7));
                    pdfDictionary.put(PdfName.A, pdfDictionary3);
                }
            } else if ("Launch".equals(string2) && (string = (String)hashMap.get("File")) != null) {
                PdfDictionary pdfDictionary4 = new PdfDictionary();
                pdfDictionary4.put(PdfName.S, PdfName.LAUNCH);
                pdfDictionary4.put(PdfName.F, new PdfString(string));
                pdfDictionary.put(PdfName.A, pdfDictionary4);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static Object[] iterateOutlines(PdfWriter pdfWriter, PdfIndirectReference pdfIndirectReference, List list, boolean bl) throws IOException {
        int n;
        PdfIndirectReference[] pdfIndirectReferenceArray = new PdfIndirectReference[list.size()];
        for (n = 0; n < pdfIndirectReferenceArray.length; ++n) {
            pdfIndirectReferenceArray[n] = pdfWriter.getPdfIndirectReference();
        }
        n = 0;
        int n2 = 0;
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Object object;
            HashMap hashMap = (HashMap)listIterator.next();
            Object[] objectArray = null;
            List list2 = (List)hashMap.get("Kids");
            if (list2 != null && list2.size() > 0) {
                objectArray = SimpleBookmark.iterateOutlines(pdfWriter, pdfIndirectReferenceArray[n], list2, bl);
            }
            PdfDictionary pdfDictionary = new PdfDictionary();
            ++n2;
            if (objectArray != null) {
                pdfDictionary.put(PdfName.FIRST, (PdfIndirectReference)objectArray[0]);
                pdfDictionary.put(PdfName.LAST, (PdfIndirectReference)objectArray[1]);
                int n3 = (Integer)objectArray[2];
                if ("false".equals(hashMap.get("Open"))) {
                    pdfDictionary.put(PdfName.COUNT, new PdfNumber(-n3));
                } else {
                    pdfDictionary.put(PdfName.COUNT, new PdfNumber(n3));
                    n2 += n3;
                }
            }
            pdfDictionary.put(PdfName.PARENT, pdfIndirectReference);
            if (n > 0) {
                pdfDictionary.put(PdfName.PREV, pdfIndirectReferenceArray[n - 1]);
            }
            if (n < pdfIndirectReferenceArray.length - 1) {
                pdfDictionary.put(PdfName.NEXT, pdfIndirectReferenceArray[n + 1]);
            }
            pdfDictionary.put(PdfName.TITLE, new PdfString((String)hashMap.get("Title"), "UnicodeBig"));
            String string = (String)hashMap.get("Color");
            if (string != null) {
                try {
                    object = new PdfArray();
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    for (int i = 0; i < 3; ++i) {
                        float f = Float.valueOf(stringTokenizer.nextToken()).intValue();
                        if (f < 0.0f) {
                            f = 0.0f;
                        }
                        if (f > 1.0f) {
                            f = 1.0f;
                        }
                        ((PdfArray)object).add(new PdfNumber(f));
                    }
                    pdfDictionary.put(PdfName.C, (PdfObject)object);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((object = (String)hashMap.get("Style")) != null) {
                object = ((String)object).toLowerCase();
                int n4 = 0;
                if (((String)object).indexOf("italic") >= 0) {
                    n4 |= 1;
                }
                if (((String)object).indexOf("bold") >= 0) {
                    n4 |= 2;
                }
                if (n4 != 0) {
                    pdfDictionary.put(PdfName.F, new PdfNumber(n4));
                }
            }
            SimpleBookmark.createOutlineAction(pdfDictionary, hashMap, pdfWriter, bl);
            pdfWriter.addToBody((PdfObject)pdfDictionary, pdfIndirectReferenceArray[n]);
            ++n;
        }
        return new Object[]{pdfIndirectReferenceArray[0], pdfIndirectReferenceArray[pdfIndirectReferenceArray.length - 1], new Integer(n2)};
    }

    public static void exportToXMLNode(List list, Writer writer, int n, boolean bl) throws IOException {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + "  ";
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            HashMap hashMap = (HashMap)iterator.next();
            String string2 = null;
            writer.write(string);
            writer.write("<Title ");
            List list2 = null;
            Iterator iterator2 = hashMap.keySet().iterator();
            while (iterator2.hasNext()) {
                String string3 = (String)iterator2.next();
                if (string3.equals("Title")) {
                    string2 = (String)hashMap.get(string3);
                    continue;
                }
                if (string3.equals("Kids")) {
                    list2 = (List)hashMap.get(string3);
                    continue;
                }
                writer.write(string3);
                writer.write("=\"");
                String string4 = (String)hashMap.get(string3);
                if (string3.equals("Named") || string3.equals("NamedN")) {
                    string4 = SimpleNamedDestination.escapeBinaryString(string4);
                }
                writer.write(SimpleXMLParser.escapeXML(string4, bl));
                writer.write("\" ");
            }
            writer.write(">");
            if (string2 == null) {
                string2 = "";
            }
            writer.write(SimpleXMLParser.escapeXML(string2, bl));
            if (list2 != null) {
                writer.write("\n");
                SimpleBookmark.exportToXMLNode(list2, writer, n + 1, bl);
                writer.write(string);
            }
            writer.write("</Title>\n");
        }
    }

    public static void exportToXML(List list, OutputStream outputStream, String string, boolean bl) throws IOException {
        String string2 = SimpleXMLParser.getJavaEncoding(string);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, string2));
        SimpleBookmark.exportToXML(list, bufferedWriter, string, bl);
    }

    public static void exportToXML(List list, Writer writer, String string, boolean bl) throws IOException {
        writer.write("<?xml version=\"1.0\" encoding=\"");
        writer.write(SimpleXMLParser.escapeXML(string, bl));
        writer.write("\"?>\n<Bookmark>\n");
        SimpleBookmark.exportToXMLNode(list, writer, 1, bl);
        writer.write("</Bookmark>\n");
        writer.flush();
    }

    public static List importFromXML(InputStream inputStream) throws IOException {
        SimpleBookmark simpleBookmark = new SimpleBookmark();
        SimpleXMLParser.parse((SimpleXMLDocHandler)simpleBookmark, inputStream);
        return simpleBookmark.topList;
    }

    public static List importFromXML(Reader reader) throws IOException {
        SimpleBookmark simpleBookmark = new SimpleBookmark();
        SimpleXMLParser.parse((SimpleXMLDocHandler)simpleBookmark, reader);
        return simpleBookmark.topList;
    }

    public void endDocument() {
    }

    public void endElement(String string) {
        if (string.equals("Bookmark")) {
            if (this.attr.isEmpty()) {
                return;
            }
            throw new RuntimeException("Bookmark end tag out of place.");
        }
        if (!string.equals("Title")) {
            throw new RuntimeException("Invalid end tag - " + string);
        }
        HashMap hashMap = (HashMap)this.attr.pop();
        String string2 = (String)hashMap.get("Title");
        hashMap.put("Title", string2.trim());
        String string3 = (String)hashMap.get("Named");
        if (string3 != null) {
            hashMap.put("Named", SimpleNamedDestination.unEscapeBinaryString(string3));
        }
        if ((string3 = (String)hashMap.get("NamedN")) != null) {
            hashMap.put("NamedN", SimpleNamedDestination.unEscapeBinaryString(string3));
        }
        if (this.attr.isEmpty()) {
            this.topList.add(hashMap);
        } else {
            HashMap hashMap2 = (HashMap)this.attr.peek();
            ArrayList<HashMap> arrayList = (ArrayList<HashMap>)hashMap2.get("Kids");
            if (arrayList == null) {
                arrayList = new ArrayList<HashMap>();
                hashMap2.put("Kids", arrayList);
            }
            arrayList.add(hashMap);
        }
    }

    public void startDocument() {
    }

    public void startElement(String string, HashMap hashMap) {
        if (this.topList == null) {
            if (string.equals("Bookmark")) {
                this.topList = new ArrayList();
                return;
            }
            throw new RuntimeException("Root element is not Bookmark.");
        }
        if (!string.equals("Title")) {
            throw new RuntimeException("Tag " + string + " not allowed.");
        }
        HashMap<String, String> hashMap2 = new HashMap<String, String>(hashMap);
        hashMap2.put("Title", "");
        hashMap2.remove("Kids");
        this.attr.push(hashMap2);
    }

    public void text(String string) {
        if (this.attr.isEmpty()) {
            return;
        }
        HashMap hashMap = (HashMap)this.attr.peek();
        String string2 = (String)hashMap.get("Title");
        string2 = string2 + string;
        hashMap.put("Title", string2);
    }
}

