/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfException;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;

public class PdfFileSpecification
extends PdfDictionary {
    protected PdfWriter writer;
    protected PdfIndirectReference ref;

    public PdfFileSpecification() {
        super(PdfName.FILESPEC);
    }

    public static PdfFileSpecification url(PdfWriter pdfWriter, String string) {
        PdfFileSpecification pdfFileSpecification = new PdfFileSpecification();
        pdfFileSpecification.writer = pdfWriter;
        pdfFileSpecification.put(PdfName.FS, PdfName.URL);
        pdfFileSpecification.put(PdfName.F, new PdfString(string));
        return pdfFileSpecification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PdfFileSpecification fileEmbedded(PdfWriter pdfWriter, String string, String string2, byte[] byArray) throws IOException {
        PdfStream pdfStream;
        Object object;
        Object object2;
        PdfFileSpecification pdfFileSpecification = new PdfFileSpecification();
        pdfFileSpecification.writer = pdfWriter;
        pdfFileSpecification.put(PdfName.F, new PdfString(string2));
        if (byArray == null) {
            object2 = new ByteArrayOutputStream();
            object = new byte[4192];
            FileInputStream fileInputStream = new FileInputStream(string);
            try {
                int n;
                while ((n = fileInputStream.read((byte[])object)) >= 0) {
                    ((ByteArrayOutputStream)object2).write((byte[])object, 0, n);
                }
            }
            finally {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
            pdfStream = new PdfStream(((ByteArrayOutputStream)object2).toByteArray());
        } else {
            pdfStream = new PdfStream(byArray);
        }
        pdfStream.put(PdfName.TYPE, PdfName.EMBEDDEDFILE);
        try {
            pdfStream.flateCompress();
        }
        catch (PdfException pdfException) {
            // empty catch block
        }
        object2 = pdfWriter.addToBody(pdfStream).getIndirectReference();
        object = new PdfDictionary();
        ((PdfDictionary)object).put(PdfName.F, (PdfObject)object2);
        pdfFileSpecification.put(PdfName.EF, (PdfObject)object);
        return pdfFileSpecification;
    }

    public static PdfFileSpecification fileExtern(PdfWriter pdfWriter, String string) {
        PdfFileSpecification pdfFileSpecification = new PdfFileSpecification();
        pdfFileSpecification.writer = pdfWriter;
        pdfFileSpecification.put(PdfName.F, new PdfString(string));
        return pdfFileSpecification;
    }

    public PdfIndirectReference getReference() throws IOException {
        if (this.ref != null) {
            return this.ref;
        }
        this.ref = this.writer.addToBody(this).getIndirectReference();
        return this.ref;
    }

    public void setMultiByteFileName(byte[] byArray) {
        this.put(PdfName.F, new PdfString(byArray).setWritingMode(true));
    }
}

