/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.graphic;

import com.lowagie.text.rtf.RtfAddableElement;
import java.io.IOException;
import java.io.OutputStream;

public class RtfShapePosition
extends RtfAddableElement {
    public static final int POSITION_X_RELATIVE_PAGE = 0;
    public static final int POSITION_X_RELATIVE_MARGIN = 1;
    public static final int POSITION_X_RELATIVE_COLUMN = 2;
    public static final int POSITION_Y_RELATIVE_PAGE = 0;
    public static final int POSITION_Y_RELATIVE_MARGIN = 1;
    public static final int POSITION_Y_RELATIVE_PARAGRAPH = 2;
    private int top = 0;
    private int left = 0;
    private int right = 0;
    private int bottom = 0;
    private int zOrder = 0;
    private int xRelativePos = 0;
    private int yRelativePos = 0;
    private boolean ignoreXRelative = false;
    private boolean ignoreYRelative = false;
    private boolean shapeBelowText = false;

    public RtfShapePosition(int n, int n2, int n3, int n4) {
        this.top = n;
        this.left = n2;
        this.right = n3;
        this.bottom = n4;
    }

    public boolean isShapeBelowText() {
        return this.shapeBelowText;
    }

    public void setShapeBelowText(boolean bl) {
        this.shapeBelowText = bl;
    }

    public void setXRelativePos(int n) {
        this.xRelativePos = n;
    }

    public void setYRelativePos(int n) {
        this.yRelativePos = n;
    }

    public void setZOrder(int n) {
        this.zOrder = n;
    }

    protected void setIgnoreXRelative(boolean bl) {
        this.ignoreXRelative = bl;
    }

    protected void setIgnoreYRelative(boolean bl) {
        this.ignoreYRelative = bl;
    }

    public void writeContent(OutputStream outputStream) throws IOException {
        outputStream.write("\\shpleft".getBytes());
        outputStream.write(this.intToByteArray(this.left));
        outputStream.write("\\shptop".getBytes());
        outputStream.write(this.intToByteArray(this.top));
        outputStream.write("\\shpright".getBytes());
        outputStream.write(this.intToByteArray(this.right));
        outputStream.write("\\shpbottom".getBytes());
        outputStream.write(this.intToByteArray(this.bottom));
        outputStream.write("\\shpz".getBytes());
        outputStream.write(this.intToByteArray(this.zOrder));
        switch (this.xRelativePos) {
            case 0: {
                outputStream.write("\\shpbxpage".getBytes());
                break;
            }
            case 1: {
                outputStream.write("\\shpbxmargin".getBytes());
                break;
            }
            case 2: {
                outputStream.write("\\shpbxcolumn".getBytes());
            }
        }
        if (this.ignoreXRelative) {
            outputStream.write("\\shpbxignore".getBytes());
        }
        switch (this.yRelativePos) {
            case 0: {
                outputStream.write("\\shpbypage".getBytes());
                break;
            }
            case 1: {
                outputStream.write("\\shpbymargin".getBytes());
                break;
            }
            case 2: {
                outputStream.write("\\shpbypara".getBytes());
            }
        }
        if (this.ignoreYRelative) {
            outputStream.write("\\shpbyignore".getBytes());
        }
        if (this.shapeBelowText) {
            outputStream.write("\\shpfblwtxt1".getBytes());
        } else {
            outputStream.write("\\shpfblwtxt0".getBytes());
        }
    }
}

