/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.redis;

import com.lordofthejars.nosqlunit.core.AbstractCustomizableDatabaseOperation;
import com.lordofthejars.nosqlunit.core.NoSqlAssertionError;
import com.lordofthejars.nosqlunit.redis.DefaultRedisComparisonStrategy;
import com.lordofthejars.nosqlunit.redis.DefaultRedisInsertionStrategy;
import com.lordofthejars.nosqlunit.redis.RedisConnectionCallback;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import redis.clients.jedis.BinaryJedisCommands;
import redis.clients.jedis.Jedis;

public class RedisOperation
extends AbstractCustomizableDatabaseOperation<RedisConnectionCallback, Jedis> {
    private Jedis jedis;

    public RedisOperation(Jedis jedis) {
        this.jedis = jedis;
        this.setInsertionStrategy(new DefaultRedisInsertionStrategy());
        this.setComparisonStrategy(new DefaultRedisComparisonStrategy());
    }

    public void insert(InputStream dataScript) {
        this.insertData(dataScript);
    }

    private void insertData(InputStream dataScript) {
        try {
            this.executeInsertion(new RedisConnectionCallback(){

                public List<Jedis> getAllJedis() {
                    return Arrays.asList(RedisOperation.this.jedis);
                }

                @Override
                public Jedis getActiveJedis(byte[] key) {
                    return RedisOperation.this.jedis;
                }

                @Override
                public BinaryJedisCommands insertionJedis() {
                    return RedisOperation.this.jedis;
                }
            }, dataScript);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void deleteAll() {
        this.jedis.flushDB();
    }

    public boolean databaseIs(InputStream expectedData) {
        return this.compareData(expectedData);
    }

    private boolean compareData(InputStream expectedData) throws NoSqlAssertionError {
        try {
            return this.executeComparison(new RedisConnectionCallback(){

                public List<Jedis> getAllJedis() {
                    return Arrays.asList(RedisOperation.this.jedis);
                }

                @Override
                public Jedis getActiveJedis(byte[] key) {
                    return RedisOperation.this.jedis;
                }

                @Override
                public BinaryJedisCommands insertionJedis() {
                    return RedisOperation.this.jedis;
                }
            }, expectedData);
        }
        catch (NoSqlAssertionError e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    public Jedis connectionManager() {
        return this.jedis;
    }
}

