/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.neo4j;

import ch.lambdaj.collection.LambdaCollections;
import com.lordofthejars.nosqlunit.core.PropertyGetter;
import com.lordofthejars.nosqlunit.neo4j.Neo4jConfiguration;
import com.lordofthejars.nosqlunit.neo4j.Neo4jOperation;
import com.lordofthejars.nosqlunit.neo4j.Neo4jRule;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.neo4j.graphdb.GraphDatabaseService;
import org.springframework.context.ApplicationContext;

class SpringGraphDatabaseServiceNeo4jRule
extends Neo4jRule {
    private PropertyGetter<ApplicationContext> propertyGetter = new PropertyGetter();

    public SpringGraphDatabaseServiceNeo4jRule(Neo4jConfiguration neo4jConfiguration) {
        super(neo4jConfiguration);
    }

    public SpringGraphDatabaseServiceNeo4jRule(Neo4jConfiguration neo4jConfiguration, Object object) {
        super(neo4jConfiguration, object);
    }

    public Statement apply(Statement base, FrameworkMethod method, Object testObject) {
        this.databaseOperation = new Neo4jOperation(this.definedGraphDatabaseService(testObject));
        return super.apply(base, method, testObject);
    }

    private GraphDatabaseService definedGraphDatabaseService(Object testObject) {
        ApplicationContext applicationContext = (ApplicationContext)this.propertyGetter.propertyByType(testObject, ApplicationContext.class);
        Map beansOfType = applicationContext.getBeansOfType(GraphDatabaseService.class);
        if (beansOfType == null) {
            throw new IllegalArgumentException("At least one GraphDatabaseService instance should be defined into Spring Application Context.");
        }
        GraphDatabaseService graphDatabaseService = (GraphDatabaseService)LambdaCollections.with((Map)beansOfType).values().first(CoreMatchers.anything());
        if (graphDatabaseService == null) {
            throw new IllegalArgumentException("At least one GraphDatabaseService instance should be defined into Spring Application Context.");
        }
        return graphDatabaseService;
    }
}

