/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.neo4j;

import com.lordofthejars.nosqlunit.core.AbstractNoSqlTestRule;
import com.lordofthejars.nosqlunit.core.DatabaseOperation;
import com.lordofthejars.nosqlunit.neo4j.EmbeddedNeoServerConfigurationBuilder;
import com.lordofthejars.nosqlunit.neo4j.ManagedNeoServerConfigurationBuilder;
import com.lordofthejars.nosqlunit.neo4j.Neo4jConfiguration;
import com.lordofthejars.nosqlunit.neo4j.Neo4jOperation;
import com.lordofthejars.nosqlunit.neo4j.SpringGraphDatabaseServiceNeo4jRule;
import org.neo4j.graphdb.GraphDatabaseService;

public class Neo4jRule
extends AbstractNoSqlTestRule {
    private static final String EXTENSION = "xml";
    protected DatabaseOperation<GraphDatabaseService> databaseOperation;

    public Neo4jRule(Neo4jConfiguration neo4jConfiguration) {
        super(neo4jConfiguration.getConnectionIdentifier());
        this.databaseOperation = new Neo4jOperation(neo4jConfiguration.getGraphDatabaseService());
    }

    public Neo4jRule(Neo4jConfiguration neo4jConfiguration, Object target) {
        super(neo4jConfiguration.getConnectionIdentifier());
        this.setTarget(target);
        this.databaseOperation = new Neo4jOperation(neo4jConfiguration.getGraphDatabaseService());
    }

    public DatabaseOperation<GraphDatabaseService> getDatabaseOperation() {
        return this.databaseOperation;
    }

    public String getWorkingExtension() {
        return EXTENSION;
    }

    public static class Neo4jRuleBuilder {
        private Neo4jConfiguration neo4jConfiguration;
        private Object target;

        private Neo4jRuleBuilder() {
        }

        public static Neo4jRuleBuilder newNeo4jRule() {
            return new Neo4jRuleBuilder();
        }

        public Neo4jRuleBuilder configure(Neo4jConfiguration neo4jConfiguration) {
            this.neo4jConfiguration = neo4jConfiguration;
            return this;
        }

        public Neo4jRuleBuilder unitInstance(Object target) {
            this.target = target;
            return this;
        }

        public Neo4jRule defaultSpringGraphDatabaseServiceNeo4j(Neo4jConfiguration neo4jConfiguration) {
            return new SpringGraphDatabaseServiceNeo4jRule(neo4jConfiguration);
        }

        public Neo4jRule defaultSpringGraphDatabaseServiceNeo4j() {
            return new SpringGraphDatabaseServiceNeo4jRule(new Neo4jConfiguration());
        }

        public Neo4jRule defaultEmbeddedNeo4j() {
            return new Neo4jRule(EmbeddedNeoServerConfigurationBuilder.newEmbeddedNeoServerConfiguration().build());
        }

        @Deprecated
        public Neo4jRule defaultEmbeddedNeo4j(Object target) {
            return new Neo4jRule(EmbeddedNeoServerConfigurationBuilder.newEmbeddedNeoServerConfiguration().build(), target);
        }

        public Neo4jRule defaultManagedNeo4j() {
            return new Neo4jRule(ManagedNeoServerConfigurationBuilder.newManagedNeoServerConfiguration().build());
        }

        public Neo4jRule defaultManagedNeo4j(String uri) {
            return new Neo4jRule(ManagedNeoServerConfigurationBuilder.newManagedNeoServerConfiguration().uri(uri).build());
        }

        @Deprecated
        public Neo4jRule defaultManagedNeo4j(Object target) {
            return new Neo4jRule(ManagedNeoServerConfigurationBuilder.newManagedNeoServerConfiguration().build(), target);
        }

        public Neo4jRule build() {
            if (this.neo4jConfiguration == null) {
                throw new IllegalArgumentException("Configuration object should be provided.");
            }
            return new Neo4jRule(this.neo4jConfiguration, this.target);
        }
    }
}

