/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.neo4j;

import com.lordofthejars.nosqlunit.core.AbstractLifecycleManager;
import com.lordofthejars.nosqlunit.core.IOUtils;
import com.lordofthejars.nosqlunit.neo4j.ManagedWrappingNeoServer;
import java.io.File;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.server.WrappingNeoServerBootstrapper;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.ServerConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedWrappingNeoServerLifecycleManager
extends AbstractLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagedWrappingNeoServer.class);
    protected static final String LOCALHOST = "127.0.0.1";
    protected static final String DEFAULT_NEO4J_TARGET_PATH = "target" + File.separatorChar + "neo4j-temp";
    private String targetPath = DEFAULT_NEO4J_TARGET_PATH;
    private int port = Configurator.DEFAULT_WEBSERVER_PORT;
    private WrappingNeoServerBootstrapper graphDb;

    public String getHost() {
        return LOCALHOST;
    }

    public int getPort() {
        return this.port;
    }

    public void doStart() throws Throwable {
        LOGGER.info("Starting {} wrapped Neo4j instance.", (Object)(this.getHost() + this.getPort()));
        this.cleanDb();
        this.createWrappingEmbeddedGraphDatabaseService();
        this.graphDb.start();
        LOGGER.info("Starting {} wrapped Neo4j instance.", (Object)(this.getHost() + this.getPort()));
    }

    public void doStop() {
        LOGGER.info("Stopping {} wrapped Neo4j instance.", (Object)(this.getHost() + this.getPort()));
        this.stopGraphDb();
        LOGGER.info("Stopped {} wrapped Neo4j instance.", (Object)(this.getHost() + this.getPort()));
    }

    private void stopGraphDb() {
        try {
            this.graphDb.stop();
        }
        finally {
            this.cleanDb();
        }
    }

    private GraphDatabaseService createWrappingEmbeddedGraphDatabaseService() {
        GraphDatabaseService newEmbeddedDatabase = new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.targetPath).newGraphDatabase();
        ServerConfigurator embeddedServerConfigurator = new ServerConfigurator((GraphDatabaseAPI)newEmbeddedDatabase);
        embeddedServerConfigurator.configuration().setProperty(Configurator.WEBSERVER_PORT_PROPERTY_KEY, (Object)this.getPort());
        this.graphDb = new WrappingNeoServerBootstrapper((GraphDatabaseAPI)newEmbeddedDatabase, (Configurator)embeddedServerConfigurator);
        return newEmbeddedDatabase;
    }

    private void cleanDb() {
        File dbPath = new File(this.targetPath);
        if (dbPath.exists()) {
            IOUtils.deleteDir((File)dbPath);
        }
    }

    public void setTargetPath(String targetPath) {
        this.targetPath = targetPath;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

