/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.neo4j;

import com.lordofthejars.nosqlunit.core.AbstractLifecycleManager;
import com.lordofthejars.nosqlunit.core.IOUtils;
import com.lordofthejars.nosqlunit.neo4j.EmbeddedNeo4j;
import com.lordofthejars.nosqlunit.neo4j.EmbeddedNeo4jInstances;
import java.io.File;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.server.configuration.Configurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedNeo4jLifecycleManager
extends AbstractLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbeddedNeo4j.class);
    protected static final String LOCALHOST = "127.0.0.1";
    protected static final int PORT = Configurator.DEFAULT_WEBSERVER_PORT;
    protected static final String DEFAULT_NEO4J_TARGET_PATH = "target" + File.separatorChar + "neo4j-temp";
    private String targetPath = DEFAULT_NEO4J_TARGET_PATH;
    private GraphDatabaseService graphDb;

    public String getHost() {
        return LOCALHOST + this.targetPath;
    }

    public int getPort() {
        return PORT;
    }

    public void doStart() throws Throwable {
        LOGGER.info("Starting Embedded Neo4j instance.");
        this.cleanDb();
        this.createEmbeddedGraphDatabaseService();
        EmbeddedNeo4jInstances.getInstance().addGraphDatabaseService(this.graphDb, this.targetPath);
        this.registerShutdownHook(this.graphDb);
        LOGGER.info("Started Embedded Neo4j instance.");
    }

    public void doStop() {
        LOGGER.info("Stopping Embedded Neo4j instance.");
        this.shutdownGraphDb();
        LOGGER.info("Stopped Embedded Neo4j instance.");
    }

    private void shutdownGraphDb() {
        try {
            this.graphDb.shutdown();
            EmbeddedNeo4jInstances.getInstance().removeGraphDatabaseService(this.targetPath);
        }
        finally {
            this.cleanDb();
        }
    }

    private void createEmbeddedGraphDatabaseService() {
        this.graphDb = new GraphDatabaseFactory().newEmbeddedDatabase(this.targetPath);
    }

    private void cleanDb() {
        File dbPath = new File(this.targetPath);
        if (dbPath.exists()) {
            IOUtils.deleteDir((File)dbPath);
        }
    }

    public void setTargetPath(String targetPath) {
        this.targetPath = targetPath;
    }

    private void registerShutdownHook(final GraphDatabaseService graphDb) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                graphDb.shutdown();
            }
        });
    }

    public String getTargetPath() {
        return this.targetPath;
    }
}

