/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.graph.parser;

import com.google.common.primitives.Primitives;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public final class TypeCaster {
    private static final Map<String, String> types = new HashMap<String, String>();

    private static void putNumberType(Class<?> primitiveClass) throws IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException {
        types.put(primitiveClass.getField("TYPE").get(null).toString(), primitiveClass.getName());
    }

    private TypeCaster() {
    }

    public static String getStringType(Object object) {
        if (object instanceof String) {
            return "string";
        }
        if (object instanceof Integer) {
            return "int";
        }
        if (object instanceof Long) {
            return "long";
        }
        if (object instanceof Float) {
            return "float";
        }
        if (object instanceof Double) {
            return "double";
        }
        if (object instanceof Boolean) {
            return "boolean";
        }
        if (TypeCaster.isArray(object)) {
            Object first = Array.get(object, 0);
            return TypeCaster.getStringType(first) + "[]";
        }
        return "string";
    }

    public static boolean isArray(Object obj) {
        return obj != null && obj.getClass().isArray();
    }

    public static Object typeCastValue(String key, String value, Map<String, String> keyTypes) {
        String type = keyTypes.get(key);
        if (null == type || type.equals("string")) {
            return value;
        }
        if (type.equals("float")) {
            return Float.valueOf(value);
        }
        if (type.equals("int")) {
            return Integer.valueOf(value);
        }
        if (type.equals("double")) {
            return Double.valueOf(value);
        }
        if (type.equals("boolean")) {
            return Boolean.valueOf(value);
        }
        if (type.equals("long")) {
            return Long.valueOf(value);
        }
        if (type.contains("[]")) {
            return TypeCaster.castToArray(type, value);
        }
        return value;
    }

    static Object castToArray(String type, String value) {
        try {
            String[] values = value.split(",");
            String className = types.get(type.replace("[]", ""));
            Class<?> klass = Class.forName(className);
            Constructor<?> konstructor = klass.getDeclaredConstructor(String.class);
            Object array = Array.newInstance(Primitives.unwrap(klass), values.length);
            for (int i = 0; i < values.length; ++i) {
                Array.set(array, i, konstructor.newInstance(values[i].trim()));
            }
            return array;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not cast " + value + " to " + type, e);
        }
    }

    static {
        try {
            TypeCaster.putNumberType(Boolean.class);
            TypeCaster.putNumberType(Character.class);
            TypeCaster.putNumberType(Byte.class);
            TypeCaster.putNumberType(Short.class);
            TypeCaster.putNumberType(Integer.class);
            TypeCaster.putNumberType(Long.class);
            TypeCaster.putNumberType(Float.class);
            TypeCaster.putNumberType(Double.class);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

