/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.demo.redis;

import com.lordofthejars.nosqlunit.demo.model.Book;
import java.util.HashMap;
import java.util.Map;
import redis.clients.jedis.Jedis;

public class BookManager {
    private static final String TITLE_FIELD_NAME = "title";
    private static final String NUMBER_OF_PAGES = "numberOfPages";
    private Jedis jedis;

    public BookManager(Jedis jedis) {
        this.jedis = jedis;
    }

    public void insertBook(Book book) {
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put(TITLE_FIELD_NAME, book.getTitle());
        fields.put(NUMBER_OF_PAGES, Integer.toString(book.getNumberOfPages()));
        this.jedis.hmset(book.getTitle(), fields);
    }

    public Book findBookByTitle(String title) {
        Map fields = this.jedis.hgetAll(title);
        return new Book((String)fields.get(TITLE_FIELD_NAME), Integer.parseInt((String)fields.get(NUMBER_OF_PAGES)));
    }
}

