/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.demo.cassandra;

import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.service.template.ColumnFamilyResult;
import me.prettyprint.cassandra.service.template.ColumnFamilyTemplate;
import me.prettyprint.cassandra.service.template.ColumnFamilyUpdater;
import me.prettyprint.cassandra.service.template.ThriftColumnFamilyTemplate;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.factory.HFactory;

public class PersonManager {
    private ColumnFamilyTemplate<String, String> template;

    public PersonManager(String clusterName, String keyspaceName, String host) {
        Cluster cluster = HFactory.getOrCreateCluster((String)clusterName, (String)host);
        Keyspace keyspace = HFactory.createKeyspace((String)keyspaceName, (Cluster)cluster);
        this.template = new ThriftColumnFamilyTemplate(keyspace, "personFamilyName", (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());
    }

    public String getCarByPersonName(String name) {
        ColumnFamilyResult queryColumns = this.template.queryColumns((Object)name);
        return queryColumns.getString((Object)"car");
    }

    public void updateCarByPersonName(String name, String car) {
        ColumnFamilyUpdater createUpdater = this.template.createUpdater((Object)name);
        createUpdater.setString((Object)"car", car);
        this.template.update(createUpdater);
    }
}

