/*
 * Decompiled with CFR 0.152.
 */
package ujson;

import ujson.MathUtils;

public final class FloatToDecimalChar {
    static final int P = 24;
    private static final int W = 8;
    static final int Q_MIN = -149;
    static final int Q_MAX = 104;
    static final int E_MIN = -44;
    static final int E_MAX = 39;
    static final int C_TINY = 8;
    static final int K_MIN = -45;
    static final int K_MAX = 31;
    static final int H = 9;
    private static final int C_MIN = 0x800000;
    private static final int BQ_MASK = 255;
    private static final int T_MASK = 0x7FFFFF;
    private static final long MASK_32 = 0xFFFFFFFFL;
    private static final int MASK_28 = 0xFFFFFFF;
    private static final int NON_SPECIAL = 0;
    private static final int PLUS_ZERO = 1;
    private static final int MINUS_ZERO = 2;
    private static final int PLUS_INF = 3;
    private static final int MINUS_INF = 4;
    private static final int NAN = 5;
    public final int MAX_CHARS = 15;
    private final char[] bytes;
    private int index;
    private int offset;

    public FloatToDecimalChar(char[] cArray, int n) {
        this.bytes = cArray;
        this.offset = n;
    }

    public static int toString(char[] cArray, int n, float f) {
        FloatToDecimalChar floatToDecimalChar = new FloatToDecimalChar(cArray, n);
        floatToDecimalChar.toDecimal(f);
        return floatToDecimalChar.index + 1;
    }

    private String toDecimalString(float f) {
        switch (this.toDecimal(f)) {
            case 0: {
                return this.charsToString();
            }
            case 1: {
                return "0.0";
            }
            case 2: {
                return "-0.0";
            }
            case 3: {
                return "Infinity";
            }
            case 4: {
                return "-Infinity";
            }
        }
        return "NaN";
    }

    private int toDecimal(float f) {
        int n = Float.floatToRawIntBits(f);
        int n2 = n & 0x7FFFFF;
        int n3 = n >>> 23 & 0xFF;
        if (n3 < 255) {
            this.index = -1;
            if (n < 0) {
                this.append(45);
            }
            if (n3 != 0) {
                int n4;
                int n5 = 150 - n3;
                int n6 = 0x800000 | n2;
                if (0 < n5 & n5 < 24 && (n4 = n6 >> n5) << n5 == n6) {
                    return this.toChars(n4, 0);
                }
                return this.toDecimal(-n5, n6, 0);
            }
            if (n2 != 0) {
                return n2 < 8 ? this.toDecimal(-149, 10 * n2, -1) : this.toDecimal(-149, n2, 0);
            }
            return n == 0 ? 1 : 2;
        }
        if (n2 != 0) {
            return 5;
        }
        return n > 0 ? 3 : 4;
    }

    private int toDecimal(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        long l;
        int n9 = n2 & 1;
        long l2 = n2 << 2;
        long l3 = l2 + 2L;
        if (n2 != 0x800000 | n == -149) {
            l = l2 - 2L;
            n8 = MathUtils.flog10pow2(n);
        } else {
            l = l2 - 1L;
            n8 = MathUtils.flog10threeQuartersPow2(n);
        }
        int n10 = n + MathUtils.flog2pow10(-n8) + 33;
        long l4 = MathUtils.g1(n8) + 1L;
        int n11 = FloatToDecimalChar.rop(l4, l2 << n10);
        int n12 = FloatToDecimalChar.rop(l4, l << n10);
        int n13 = FloatToDecimalChar.rop(l4, l3 << n10);
        int n14 = n11 >> 2;
        if (n14 >= 100) {
            n7 = 10 * (int)((long)n14 * 0x66666667L >>> 34);
            n6 = n7 + 10;
            n5 = n12 + n9 <= n7 << 2 ? 1 : 0;
            int n15 = n4 = (n6 << 2) + n9 <= n13 ? 1 : 0;
            if (n5 != n4) {
                return this.toChars(n5 != 0 ? n7 : n6, n8);
            }
        }
        n7 = n14 + 1;
        n6 = n12 + n9 <= n14 << 2 ? 1 : 0;
        int n16 = n5 = (n7 << 2) + n9 <= n13 ? 1 : 0;
        if (n6 != n5) {
            return this.toChars(n6 != 0 ? n14 : n7, n8 + n3);
        }
        n4 = n11 - (n14 + n7 << 1);
        return this.toChars(n4 < 0 || n4 == 0 && (n14 & 1) == 0 ? n14 : n7, n8 + n3);
    }

    private static int rop(long l, long l2) {
        long l3 = MathUtils.multiplyHigh(l, l2);
        long l4 = l3 >>> 31;
        return (int)(l4 | (l3 & 0xFFFFFFFFL) + 0xFFFFFFFFL >>> 32);
    }

    private int toChars(int n, int n2) {
        int n3 = MathUtils.flog10pow2(32 - Integer.numberOfLeadingZeros(n));
        if ((long)n >= MathUtils.pow10(n3)) {
            ++n3;
        }
        n = (int)((long)n * MathUtils.pow10(9 - n3));
        int n4 = (int)((long)n * 1441151881L >>> 57);
        int n5 = n - 100000000 * n4;
        if (0 < (n2 += n3) && n2 <= 7) {
            return this.toChars1(n4, n5, n2);
        }
        if (-3 < n2 && n2 <= 0) {
            return this.toChars2(n4, n5, n2);
        }
        return this.toChars3(n4, n5, n2);
    }

    private int toChars1(int n, int n2, int n3) {
        int n4;
        int n5;
        this.appendDigit(n);
        int n6 = this.y(n2);
        for (n5 = 1; n5 < n3; ++n5) {
            n4 = 10 * n6;
            this.appendDigit(n4 >>> 28);
            n6 = n4 & 0xFFFFFFF;
        }
        this.append(46);
        while (n5 <= 8) {
            n4 = 10 * n6;
            this.appendDigit(n4 >>> 28);
            n6 = n4 & 0xFFFFFFF;
            ++n5;
        }
        this.removeTrailingZeroes();
        return 0;
    }

    private int toChars2(int n, int n2, int n3) {
        this.appendDigit(0);
        this.append(46);
        while (n3 < 0) {
            this.appendDigit(0);
            ++n3;
        }
        this.appendDigit(n);
        this.append8Digits(n2);
        this.removeTrailingZeroes();
        return 0;
    }

    private int toChars3(int n, int n2, int n3) {
        this.appendDigit(n);
        this.append(46);
        this.append8Digits(n2);
        this.removeTrailingZeroes();
        this.exponent(n3 - 1);
        return 0;
    }

    private void append8Digits(int n) {
        int n2 = this.y(n);
        for (int i = 0; i < 8; ++i) {
            int n3 = 10 * n2;
            this.appendDigit(n3 >>> 28);
            n2 = n3 & 0xFFFFFFF;
        }
    }

    private void removeTrailingZeroes() {
        while (this.bytes[this.offset + this.index] == '0') {
            --this.index;
        }
        if (this.bytes[this.offset + this.index] == '.') {
            ++this.index;
        }
    }

    private int y(int n) {
        return (int)(MathUtils.multiplyHigh((long)(n + 1) << 28, 193428131138340668L) >>> 20) - 1;
    }

    private void exponent(int n) {
        this.append(69);
        if (n < 0) {
            this.append(45);
            n = -n;
        }
        if (n < 10) {
            this.appendDigit(n);
            return;
        }
        int n2 = n * 103 >>> 10;
        this.appendDigit(n2);
        this.appendDigit(n - 10 * n2);
    }

    private void append(int n) {
        this.bytes[this.offset + ++this.index] = (char)n;
    }

    private void appendDigit(int n) {
        this.bytes[this.offset + ++this.index] = (char)(48 + n);
    }

    private String charsToString() {
        return new String(this.bytes, 0, this.index + 1);
    }
}

