/*
 * Decompiled with CFR 0.152.
 */
package ujson;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnce$;
import scala.collection.IterableOnceExtensionMethods$;
import scala.collection.StringOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.runtime.BoxesRunTime;
import ujson.Arr;
import ujson.Arr$;
import ujson.AstTransformer;
import ujson.Bool;
import ujson.Bool$;
import ujson.False$;
import ujson.JsVisitor;
import ujson.Null$;
import ujson.Num;
import ujson.Num$;
import ujson.Obj;
import ujson.Obj$;
import ujson.Readable;
import ujson.Str;
import ujson.Str$;
import ujson.Transformer;
import ujson.True$;
import ujson.Value;
import upickle.core.Util$;
import upickle.core.Visitor;

public final class Value$
implements AstTransformer<Value> {
    public static final Value$ MODULE$ = new Value$();
    private static final Str$ Str;
    private static final Obj$ Obj;
    private static final Arr$ Arr;
    private static final Num$ Num;
    private static final Bool$ Bool;
    private static final True$ True;
    private static final False$ False;
    private static final Null$ Null;

    static {
        Transformer.$init$(MODULE$);
        Visitor.$init$((Visitor)MODULE$);
        JsVisitor.$init$(MODULE$);
        AstTransformer.$init$(MODULE$);
        Str = Str$.MODULE$;
        Obj = Obj$.MODULE$;
        Arr = Arr$.MODULE$;
        Num = Num$.MODULE$;
        Bool = Bool$.MODULE$;
        True = True$.MODULE$;
        False = False$.MODULE$;
        Null = Null$.MODULE$;
    }

    @Override
    public Object apply(Readable t) {
        return AstTransformer.apply$(this, t);
    }

    @Override
    public <T> T transformArray(Visitor<?, T> f, Iterable<Value> items) {
        return (T)AstTransformer.transformArray$(this, f, items);
    }

    @Override
    public <T> T transformObject(Visitor<?, T> f, Iterable<Tuple2<String, Value>> items) {
        return (T)AstTransformer.transformObject$(this, f, items);
    }

    @Override
    public Object visitFloat32(float d, int index) {
        return JsVisitor.visitFloat32$(this, d, index);
    }

    @Override
    public Object visitInt32(int i, int index) {
        return JsVisitor.visitInt32$(this, i, index);
    }

    @Override
    public Object visitInt64(long i, int index) {
        return JsVisitor.visitInt64$(this, i, index);
    }

    @Override
    public Object visitUInt64(long i, int index) {
        return JsVisitor.visitUInt64$(this, i, index);
    }

    @Override
    public Object visitFloat64String(String s, int index) {
        return JsVisitor.visitFloat64String$(this, s, index);
    }

    @Override
    public Object visitBinary(byte[] bytes, int offset, int len, int index) {
        return JsVisitor.visitBinary$(this, bytes, offset, len, index);
    }

    @Override
    public Object visitFloat64StringParts(CharSequence s, int decIndex, int expIndex) {
        return JsVisitor.visitFloat64StringParts$(this, s, decIndex, expIndex);
    }

    @Override
    public Object visitExt(byte tag, byte[] bytes, int offset, int len, int index) {
        return JsVisitor.visitExt$(this, tag, bytes, offset, len, index);
    }

    @Override
    public Object visitChar(char s, int index) {
        return JsVisitor.visitChar$(this, s, index);
    }

    public <Z> Visitor<Value, Z> map(Function1<Value, Z> f) {
        return Visitor.map$((Visitor)this, f);
    }

    public <Z> Visitor<Value, Z> mapNulls(Function1<Value, Z> f) {
        return Visitor.mapNulls$((Visitor)this, f);
    }

    @Override
    public Readable.fromTransformer transformable(Object j) {
        return Transformer.transformable$(this, j);
    }

    public Str$ Str() {
        return Str;
    }

    public Obj$ Obj() {
        return Obj;
    }

    public Arr$ Arr() {
        return Arr;
    }

    public Num$ Num() {
        return Num;
    }

    public Bool$ Bool() {
        return Bool;
    }

    public True$ True() {
        return True;
    }

    public False$ False() {
        return False;
    }

    public Null$ Null() {
        return Null;
    }

    public <T> Arr JsonableSeq(IterableOnce<T> items, Function1<T, Value> f) {
        return this.Arr().from(IterableOnceExtensionMethods$.MODULE$.map$extension(IterableOnce$.MODULE$.iterableOnceExtensionMethods(items), f), Predef$.MODULE$.$conforms());
    }

    public <T> Obj JsonableDict(IterableOnce<Tuple2<String, T>> items, Function1<T, Value> f) {
        return this.Obj().from((IterableOnce<Tuple2<String, Value>>)IterableOnceExtensionMethods$.MODULE$.map$extension(IterableOnce$.MODULE$.iterableOnceExtensionMethods(items), (Function1 & Serializable)x -> new Tuple2(x._1(), f.apply(x._2()))));
    }

    public Bool JsonableBoolean(boolean i) {
        return i ? True$.MODULE$ : False$.MODULE$;
    }

    public Num JsonableByte(byte i) {
        return this.Num().apply(i);
    }

    public Num JsonableShort(short i) {
        return this.Num().apply(i);
    }

    public Num JsonableInt(int i) {
        return this.Num().apply(i);
    }

    public Str JsonableLong(long i) {
        return this.Str().apply(((Object)BoxesRunTime.boxToLong((long)i)).toString());
    }

    public Num JsonableFloat(float i) {
        return this.Num().apply(i);
    }

    public Num JsonableDouble(double i) {
        return this.Num().apply(i);
    }

    public Null$ JsonableNull(scala.runtime.Null$ i) {
        return this.Null();
    }

    public Str JsonableString(CharSequence s) {
        return this.Str().apply(((Object)s).toString());
    }

    @Override
    public <T> T transform(Value j, Visitor<?, T> f) {
        Object object;
        Value value = j;
        if (Null$.MODULE$.equals(value)) {
            object = f.visitNull(-1);
        } else if (True$.MODULE$.equals(value)) {
            object = f.visitTrue(-1);
        } else if (False$.MODULE$.equals(value)) {
            object = f.visitFalse(-1);
        } else if (value instanceof Str) {
            Str str = (Str)value;
            String s = str.value();
            object = f.visitString((CharSequence)s, -1);
        } else if (value instanceof Num) {
            Num num = (Num)value;
            double d = num.value();
            object = f.visitFloat64(d, -1);
        } else if (value instanceof Arr) {
            Arr arr = (Arr)value;
            ArrayBuffer<Value> items = arr.value();
            object = this.transformArray(f, (Iterable<Value>)items);
        } else if (value instanceof Obj) {
            Obj obj = (Obj)value;
            LinkedHashMap<String, Value> items = obj.value();
            object = this.transformObject(f, (Iterable<Tuple2<String, Value>>)items);
        } else {
            throw new MatchError((Object)value);
        }
        return (T)object;
    }

    public AstTransformer.AstArrVisitor<ArrayBuffer> visitArray(int length, int index) {
        return new AstTransformer.AstArrVisitor<ArrayBuffer>(this, (Function1 & Serializable)xs -> new Arr((ArrayBuffer<Value>)xs), ArrayBuffer$.MODULE$.iterableFactory());
    }

    public AstTransformer.AstObjVisitor<LinkedHashMap<String, Value>> visitObject(int length, int index) {
        return new AstTransformer.AstObjVisitor<LinkedHashMap<String, Value>>(this, (Function1 & Serializable)xs -> new Obj((LinkedHashMap<String, Value>)xs), LinkedHashMap$.MODULE$.mapFactory());
    }

    public Null$ visitNull(int index) {
        return Null$.MODULE$;
    }

    public False$ visitFalse(int index) {
        return False$.MODULE$;
    }

    public True$ visitTrue(int index) {
        return this.True();
    }

    public Num visitFloat64StringParts(CharSequence s, int decIndex, int expIndex, int index) {
        return new Num(decIndex != -1 || expIndex != -1 ? StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(((Object)s).toString())) : (double)Util$.MODULE$.parseIntegralNum(s, decIndex, expIndex, index));
    }

    @Override
    public Num visitFloat64(double d, int index) {
        return new Num(d);
    }

    public Str visitString(CharSequence s, int index) {
        return new Str(((Object)s).toString());
    }

    private Value$() {
    }
}

