/*
 * Decompiled with CFR 0.152.
 */
package akka.pki.kubernetes;

import akka.annotation.InternalApi;
import akka.pki.pem.DERPrivateKeyLoader$;
import akka.pki.pem.PEMDecoder$;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import scala.Function0;
import scala.Function1;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.concurrent.package$;
import scala.runtime.BoxedUnit;
import scala.util.Random$;

@InternalApi
public final class PemManagersProvider$ {
    public static PemManagersProvider$ MODULE$;
    private final CertificateFactory certFactory;

    static {
        new PemManagersProvider$();
    }

    @InternalApi
    public TrustManager[] buildTrustManagers(Iterable<Certificate> cacerts) {
        KeyStore trustStore = KeyStore.getInstance("JKS");
        trustStore.load(null);
        cacerts.foreach((Function1 & Serializable & scala.Serializable)cert -> {
            trustStore.setCertificateEntry(new StringBuilder(7).append("cacert-").append(Random$.MODULE$.alphanumeric().take(6).mkString("")).toString(), cert);
            return BoxedUnit.UNIT;
        });
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(trustStore);
        return tmf.getTrustManagers();
    }

    @InternalApi
    public PrivateKey loadPrivateKey(String filename) {
        return (PrivateKey)package$.MODULE$.blocking((Function0 & Serializable & scala.Serializable)() -> {
            byte[] bytes = Files.readAllBytes(new File(filename).toPath());
            String pemData = new String(bytes, Charset.forName("UTF-8"));
            return DERPrivateKeyLoader$.MODULE$.load(PEMDecoder$.MODULE$.decode(pemData));
        });
    }

    private CertificateFactory certFactory() {
        return this.certFactory;
    }

    @InternalApi
    public Iterable<Certificate> loadCertificates(String filename) {
        return (Iterable)package$.MODULE$.blocking((Function0 & Serializable & scala.Serializable)() -> {
            byte[] bytes = Files.readAllBytes(new File(filename).toPath());
            return (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(MODULE$.certFactory().generateCertificates(new ByteArrayInputStream(bytes))).asScala();
        });
    }

    private PemManagersProvider$() {
        MODULE$ = this;
        this.certFactory = CertificateFactory.getInstance("X.509");
    }
}

