/*
 * Decompiled with CFR 0.152.
 */
package akka.management.cluster.bootstrap;

import akka.AkkaVersion$;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.Props;
import akka.annotation.InternalApi;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import akka.discovery.Discovery$;
import akka.discovery.ServiceDiscovery;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.RouteResult;
import akka.management.cluster.bootstrap.ClusterBootstrap$;
import akka.management.cluster.bootstrap.ClusterBootstrapSettings;
import akka.management.cluster.bootstrap.ClusterBootstrapSettings$;
import akka.management.cluster.bootstrap.JoinDecider;
import akka.management.cluster.bootstrap.contactpoint.HttpClusterBootstrapRoutes;
import akka.management.cluster.bootstrap.internal.BootstrapCoordinator;
import akka.management.cluster.bootstrap.internal.BootstrapCoordinator$;
import akka.management.scaladsl.AkkaManagement;
import akka.management.scaladsl.AkkaManagement$;
import akka.management.scaladsl.ManagementRouteProvider;
import akka.management.scaladsl.ManagementRouteProviderSettings;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005f\u0001B\u000e\u001d\u0005\u0015B\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006Y!\u000f\u0005\u0006y\u0001!\t!\u0010\u0005\b\u0005\u0002\u0011\r\u0011\"\u0003D\u0011\u0019Q\u0005\u0001)A\u0005\t\"91\n\u0001b\u0001\n\u001ba\u0005BB-\u0001A\u00035Q\nC\u0004[\u0001\t\u0007I\u0011A.\t\r}\u0003\u0001\u0015!\u0003]\u0011!\u0001\u0007\u0001#b\u0001\n\u0003\t\u0007bB4\u0001\u0005\u0004%I\u0001\u001b\u0005\u0007Y\u0002\u0001\u000b\u0011B5\t\r5\u0004\u0001\u0015!\u0003o\u0011\u001da\bA1A\u0005\nuDq!a\u0001\u0001A\u0003%a\u0010C\u0004\u0002\u0006\u0001!\t%a\u0002\t\u000f\u0005m\u0002\u0001\"\u0001\u0002>!A\u0011Q\t\u0001\u0005\u0002q\ti\u0004\u0003\u0005\u0002V\u0001!\tAIA,\u0011!\ty\u0006\u0001C\u0001E\u0005\u0005taBA69!\u0005\u0011Q\u000e\u0004\u00077qA\t!a\u001c\t\rq*B\u0011AA?\u0011\u001d\ty(\u0006C!\u0003\u0003Cq!!\"\u0016\t\u0003\n9\tC\u0004\u0002\u0006V!\t%!%\t\u000f\u0005mU\u0003\"\u0011\u0002\u001e\n\u00012\t\\;ti\u0016\u0014(i\\8ugR\u0014\u0018\r\u001d\u0006\u0003;y\t\u0011BY8piN$(/\u00199\u000b\u0005}\u0001\u0013aB2mkN$XM\u001d\u0006\u0003C\t\n!\"\\1oC\u001e,W.\u001a8u\u0015\u0005\u0019\u0013\u0001B1lW\u0006\u001c\u0001a\u0005\u0003\u0001M1\u0012\u0004CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#AB!osJ+g\r\u0005\u0002.a5\taF\u0003\u00020E\u0005)\u0011m\u0019;pe&\u0011\u0011G\f\u0002\n\u000bb$XM\\:j_:\u0004\"a\r\u001c\u000e\u0003QR!!\u000e\u0011\u0002\u0011M\u001c\u0017\r\\1eg2L!a\u000e\u001b\u0003/5\u000bg.Y4f[\u0016tGOU8vi\u0016\u0004&o\u001c<jI\u0016\u0014\u0018AB:zgR,W\u000e\u0005\u0002.u%\u00111H\f\u0002\u0014\u000bb$XM\u001c3fI\u0006\u001bGo\u001c:TsN$X-\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003y\"\"aP!\u0011\u0005\u0001\u0003Q\"\u0001\u000f\t\u000ba\u0012\u00019A\u001d\u0002\u00071|w-F\u0001E!\t)\u0005*D\u0001G\u0015\t9%%A\u0003fm\u0016tG/\u0003\u0002J\r\nqAj\\4hS:<\u0017\tZ1qi\u0016\u0014\u0018\u0001\u00027pO\u0002\nQBY8piN$(/\u00199Ti\u0016\u0004X#A'\u0011\u00059;V\"A(\u000b\u0005A\u000b\u0016AB1u_6L7M\u0003\u0002S'\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005Q+\u0016\u0001B;uS2T\u0011AV\u0001\u0005U\u00064\u0018-\u0003\u0002Y\u001f\ni\u0011\t^8nS\u000e\u0014un\u001c7fC:\faBY8piN$(/\u00199Ti\u0016\u0004\b%\u0001\u0005tKR$\u0018N\\4t+\u0005a\u0006C\u0001!^\u0013\tqFD\u0001\rDYV\u001cH/\u001a:C_>$8\u000f\u001e:baN+G\u000f^5oON\f\u0011b]3ui&twm\u001d\u0011\u0002\u0013\u0011L7oY8wKJLX#\u00012\u0011\u0005\r,W\"\u00013\u000b\u0005\u0001\u0014\u0013B\u00014e\u0005A\u0019VM\u001d<jG\u0016$\u0015n]2pm\u0016\u0014\u00180A\u0006k_&tG)Z2jI\u0016\u0014X#A5\u0011\u0005\u0001S\u0017BA6\u001d\u0005-Qu.\u001b8EK\u000eLG-\u001a:\u0002\u0019)|\u0017N\u001c#fG&$WM\u001d\u0011\u0002)}\u001bX\r\u001c4D_:$\u0018m\u0019;Q_&tG/\u0016:j!\ry\u0017o]\u0007\u0002a*\u0011!\u000bK\u0005\u0003eB\u0014q\u0001\u0015:p[&\u001cX\r\u0005\u0002uu6\tQO\u0003\u0002wo\u0006)Qn\u001c3fY*\u0011Q\u0007\u001f\u0006\u0003s\n\nA\u0001\u001b;ua&\u001110\u001e\u0002\u0004+JL\u0017!C1vi>\u001cH/\u0019:u+\u0005q\bCA\u0014\u0000\u0013\r\t\t\u0001\u000b\u0002\b\u0005>|G.Z1o\u0003)\tW\u000f^8ti\u0006\u0014H\u000fI\u0001\u0007e>,H/Z:\u0015\t\u0005%\u0011\u0011\u0007\t\u0005\u0003\u0017\tYC\u0004\u0003\u0002\u000e\u0005\u0015b\u0002BA\b\u0003CqA!!\u0005\u0002 9!\u00111CA\u000f\u001d\u0011\t)\"a\u0007\u000e\u0005\u0005]!bAA\rI\u00051AH]8pizJ\u0011aI\u0005\u0003s\nJ!!\u000e=\n\u0007\u0005\rr/\u0001\u0004tKJ4XM]\u0005\u0005\u0003O\tI#A\u0004qC\u000e\\\u0017mZ3\u000b\u0007\u0005\rr/\u0003\u0003\u0002.\u0005=\"!\u0002*pkR,'\u0002BA\u0014\u0003SAq!a\r\u0010\u0001\u0004\t)$A\u000bs_V$X\r\u0015:pm&$WM]*fiRLgnZ:\u0011\u0007M\n9$C\u0002\u0002:Q\u0012q$T1oC\u001e,W.\u001a8u%>,H/\u001a)s_ZLG-\u001a:TKR$\u0018N\\4t\u0003\u0015\u0019H/\u0019:u)\t\ty\u0004E\u0002(\u0003\u0003J1!a\u0011)\u0005\u0011)f.\u001b;\u0002-\u0015t7/\u001e:f'\u0016dgmQ8oi\u0006\u001cG\u000fU8j]RD3!EA%!\u0011\tY%!\u0015\u000e\u0005\u00055#bAA(E\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0013Q\n\u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018.A\ntKR\u001cV\r\u001c4D_:$\u0018m\u0019;Q_&tG\u000f\u0006\u0003\u0002@\u0005e\u0003BBA.%\u0001\u00071/A\u0004cCN,WK]5)\u0007I\tI%\u0001\ttK247i\u001c8uC\u000e$\bk\\5oiV\u0011\u00111\r\t\u0005_\u0006\u00154/C\u0002\u0002hA\u0014aAR;ukJ,\u0007fA\n\u0002J\u0005\u00012\t\\;ti\u0016\u0014(i\\8ugR\u0014\u0018\r\u001d\t\u0003\u0001V\u0019b!\u0006\u0014\u0002r\u0005]\u0004\u0003B\u0017\u0002t}J1!!\u001e/\u0005-)\u0005\u0010^3og&|g.\u00133\u0011\u00075\nI(C\u0002\u0002|9\u00121#\u0012=uK:\u001c\u0018n\u001c8JIB\u0013xN^5eKJ$\"!!\u001c\u0002\r1|wn[;q+\t\t\u0019I\u0004\u0002A)\u0005\u0019q-\u001a;\u0015\u0007}\nI\t\u0003\u000491\u0001\u0007\u00111\u0012\t\u0004[\u00055\u0015bAAH]\tY\u0011i\u0019;peNK8\u000f^3n)\ry\u00141\u0013\u0005\u0007qe\u0001\r!!&\u0011\u00075\n9*C\u0002\u0002\u001a:\u0012!d\u00117bgNL7-Q2u_J\u001c\u0016p\u001d;f[B\u0013xN^5eKJ\fqb\u0019:fCR,W\t\u001f;f]NLwN\u001c\u000b\u0004\u007f\u0005}\u0005\"\u0002\u001d\u001b\u0001\u0004I\u0004")
public final class ClusterBootstrap
implements ManagementRouteProvider {
    private ServiceDiscovery discovery;
    private final ExtendedActorSystem system;
    private final LoggingAdapter log;
    private final AtomicBoolean bootstrapStep;
    private final ClusterBootstrapSettings settings;
    private final JoinDecider joinDecider;
    private final Promise<Uri> _selfContactPointUri;
    private final boolean autostart;
    private volatile boolean bitmap$0;

    public static ClusterBootstrap createExtension(ExtendedActorSystem extendedActorSystem) {
        return ClusterBootstrap$.MODULE$.createExtension(extendedActorSystem);
    }

    public static ClusterBootstrap get(ClassicActorSystemProvider classicActorSystemProvider) {
        return ClusterBootstrap$.MODULE$.get(classicActorSystemProvider);
    }

    public static ClusterBootstrap get(ActorSystem actorSystem) {
        return ClusterBootstrap$.MODULE$.get(actorSystem);
    }

    public static ClusterBootstrap$ lookup() {
        return ClusterBootstrap$.MODULE$.lookup();
    }

    public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return ClusterBootstrap$.MODULE$.apply(classicActorSystemProvider);
    }

    public static Extension apply(ActorSystem actorSystem) {
        return ClusterBootstrap$.MODULE$.apply(actorSystem);
    }

    private LoggingAdapter log() {
        return this.log;
    }

    private final AtomicBoolean bootstrapStep() {
        return this.bootstrapStep;
    }

    public ClusterBootstrapSettings settings() {
        return this.settings;
    }

    private ServiceDiscovery discovery$lzycompute() {
        ClusterBootstrap clusterBootstrap = this;
        synchronized (clusterBootstrap) {
            if (!this.bitmap$0) {
                ServiceDiscovery serviceDiscovery;
                String string = this.settings().contactPointDiscovery().discoveryMethod();
                if ("akka.discovery".equals(string)) {
                    ServiceDiscovery discovery = Discovery$.MODULE$.apply((ActorSystem)this.system).discovery();
                    this.log().info("Bootstrap using default `akka.discovery` method: {}", (Object)Logging$.MODULE$.simpleName((Object)discovery));
                    serviceDiscovery = discovery;
                } else {
                    this.log().info("Bootstrap using `akka.discovery` method: {}", (Object)string);
                    serviceDiscovery = Discovery$.MODULE$.apply((ActorSystem)this.system).loadServiceDiscovery(string);
                }
                this.discovery = serviceDiscovery;
                this.bitmap$0 = true;
            }
        }
        return this.discovery;
    }

    public ServiceDiscovery discovery() {
        if (!this.bitmap$0) {
            return this.discovery$lzycompute();
        }
        return this.discovery;
    }

    private JoinDecider joinDecider() {
        return this.joinDecider;
    }

    private boolean autostart() {
        return this.autostart;
    }

    public Function1<RequestContext, Future<RouteResult>> routes(ManagementRouteProviderSettings routeProviderSettings) {
        this.log().info(new StringBuilder(34).append("Using self contact point address: ").append(routeProviderSettings.selfBaseUri()).toString());
        this.setSelfContactPoint(routeProviderSettings.selfBaseUri());
        return new HttpClusterBootstrapRoutes(this.settings()).routes();
    }

    public void start() {
        if (((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system)).settings().SeedNodes().nonEmpty()) {
            this.log().warning("Application is configured with specific `akka.cluster.seed-nodes`: {}, bailing out of the bootstrap process! If you want to use the automatic bootstrap mechanism, make sure to NOT set explicit seed nodes in the configuration. This node will attempt to join the configured seed nodes.", (Object)((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system)).settings().SeedNodes().mkString("[", ", ", "]"));
            return;
        }
        if (this.bootstrapStep().compareAndSet(false, true)) {
            this.log().info("Initiating bootstrap procedure using {} method...", (Object)this.settings().contactPointDiscovery().discoveryMethod());
            this.ensureSelfContactPoint();
            Props bootstrapProps = BootstrapCoordinator$.MODULE$.props(this.discovery(), this.joinDecider(), this.settings());
            ActorRef bootstrap = this.system.systemActorOf(bootstrapProps, "bootstrapCoordinator");
            this.selfContactPoint().foreach((Function1 & Serializable & scala.Serializable)uri -> {
                ClusterBootstrap.$anonfun$start$1(bootstrap, uri);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)this.system.dispatcher());
            return;
        }
        this.log().warning("Bootstrap already initiated, yet start() method was called again. Ignoring.");
    }

    @InternalApi
    public void ensureSelfContactPoint() {
        this.system.scheduler().scheduleOnce(new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (!this.selfContactPoint().isCompleted()) {
                $this._selfContactPointUri.failure((Throwable)new TimeoutException("Awaiting Bootstrap.selfContactPoint timed out."));
                this.log().error("'Bootstrap.selfContactPoint' was NOT set, but is required for the bootstrap to work if binding bootstrap routes manually and not via akka-management.");
                return;
            }
        }, (ExecutionContext)this.system.dispatcher());
    }

    @InternalApi
    public void setSelfContactPoint(Uri baseUri) {
        this._selfContactPointUri.success((Object)baseUri);
    }

    @InternalApi
    public Future<Uri> selfContactPoint() {
        return this._selfContactPointUri.future();
    }

    private final void autostartFailed$1(Throwable ex) {
        this.log().error(ex, "Failed to autostart cluster bootstrap, terminating system");
        this.system.terminate();
    }

    public static final /* synthetic */ void $anonfun$start$1(ActorRef bootstrap$1, Uri uri) {
        BootstrapCoordinator.Protocol.InitiateBootstrapping x$1 = new BootstrapCoordinator.Protocol.InitiateBootstrapping(uri);
        ActorRef x$2 = bootstrap$1.$bang$default$2((Object)x$1);
        bootstrap$1.$bang((Object)x$1, x$2);
    }

    public ClusterBootstrap(ExtendedActorSystem system) {
        BoxedUnit boxedUnit;
        this.system = system;
        this.log = Logging$.MODULE$.apply((ActorSystem)system, ClusterBootstrap.class, LogSource$.MODULE$.fromAnyClass());
        this.bootstrapStep = new AtomicBoolean(false);
        AkkaVersion$.MODULE$.require("cluster-bootstrap", "2.5.27");
        this.settings = ClusterBootstrapSettings$.MODULE$.apply(system.settings().config(), this.log());
        this.joinDecider = (JoinDecider)system.dynamicAccess().createInstanceFor(this.settings().joinDecider().implClass(), (Seq)new .colon.colon((Object)new Tuple2(ActorSystem.class, (Object)system), (List)new .colon.colon((Object)new Tuple2(ClusterBootstrapSettings.class, (Object)this.settings()), (List)Nil$.MODULE$)), ClassTag$.MODULE$.apply(JoinDecider.class)).get();
        this._selfContactPointUri = Promise$.MODULE$.apply();
        this.autostart = system.settings().config().getStringList("akka.extensions").contains(ClusterBootstrap.class.getName());
        if (this.autostart()) {
            this.log().info("ClusterBootstrap loaded through 'akka.extensions' auto starting management and bootstrap.");
            boxedUnit = Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                try {
                    ((AkkaManagement)AkkaManagement$.MODULE$.apply((ActorSystem)$this.system)).start().failed().foreach((Function1 & Serializable & scala.Serializable)ex -> {
                        this.autostartFailed$1(ex);
                        return BoxedUnit.UNIT;
                    }, (ExecutionContext)$this.system.dispatcher());
                    this.start();
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable ex2 = (Throwable)option.get();
                        this.autostartFailed$1(ex2);
                    }
                    throw throwable;
                }
            }, (ExecutionContext)system.dispatcher());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }
}

