/*
 * Decompiled with CFR 0.152.
 */
package akka.management.cluster.bootstrap;

import akka.AkkaVersion$;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.Props;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import akka.annotation.InternalApi;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import akka.discovery.Discovery$;
import akka.discovery.ServiceDiscovery;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.RouteResult;
import akka.management.cluster.bootstrap.ClusterBootstrap;
import akka.management.cluster.bootstrap.ClusterBootstrap$;
import akka.management.cluster.bootstrap.ClusterBootstrap$Internal$Initializing$;
import akka.management.cluster.bootstrap.ClusterBootstrap$Internal$NotRunning$;
import akka.management.cluster.bootstrap.ClusterBootstrapSettings;
import akka.management.cluster.bootstrap.ClusterBootstrapSettings$;
import akka.management.cluster.bootstrap.JoinDecider;
import akka.management.cluster.bootstrap.contactpoint.HttpClusterBootstrapRoutes;
import akka.management.cluster.bootstrap.internal.BootstrapCoordinator;
import akka.management.cluster.bootstrap.internal.BootstrapCoordinator$;
import akka.management.scaladsl.ManagementRouteProvider;
import akka.management.scaladsl.ManagementRouteProviderSettings;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.Function1;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tEc\u0001\u0002\u001a4\u0005qB\u0001b\u0014\u0001\u0003\u0002\u0003\u0006Y\u0001\u0015\u0005\u0006'\u0002!\t\u0001\u0016\u0005\b3\u0002\u0011\r\u0011\"\u0003[\u0011\u0019\t\u0007\u0001)A\u00057\"9!\r\u0001b\u0001\n\u001b\u0019\u0007bBAS\u0001\u0001\u0006i\u0001\u001a\u0005\n\u0003O\u0003!\u0019!C\u0001\u0003SC\u0001\"!-\u0001A\u0003%\u00111\u0016\u0005\u000b\u0003g\u0003\u0001R1A\u0005\u0002\u0005U\u0006\"CAa\u0001\t\u0007I\u0011BAb\u0011!\tY\r\u0001Q\u0001\n\u0005\u0015\u0007\u0002CAg\u0001\u0001\u0006I!a4\t\u000f\u0005-\b\u0001\"\u0011\u0002n\"9!\u0011\u0005\u0001\u0005\u0002\t\r\u0002\u0002\u0003B\u0016\u0001\u0011\u00051Ga\t\t\u0011\tm\u0002\u0001\"\u0001:\u0005{A\u0001B!\u0012\u0001\t\u0003I$qI\u0004\u0006gNB\t\u0001\u001e\u0004\u0006eMB\t!\u001e\u0005\u0006'N!\t\u0001 \u0005\u0006{N!\tE \u0005\u0007\u007fN!\t%!\u0001\t\u000f\u0005-1\u0003\"\u0011\u0002\u000e\u001dA\u0011\u0011C\n\t\u0002M\n\u0019B\u0002\u0005\u0002\u0018MA\taMA\r\u0011\u0019\u0019\u0016\u0004\"\u0001\u0002\u001c\u0019I\u0011QD\r\u0011\u0002G\u0005\u0012qD\u0004\b\u0003CK\u0002\u0012QAL\r\u001d\t\t*\u0007EA\u0003'CaaU\u000f\u0005\u0002\u0005U\u0005\"CA\u001e;\u0005\u0005I\u0011IA\u001f\u0011%\tY%HA\u0001\n\u0003\ti\u0005C\u0005\u0002Vu\t\t\u0011\"\u0001\u0002\u001a\"I\u00111M\u000f\u0002\u0002\u0013\u0005\u0013Q\r\u0005\n\u0003gj\u0012\u0011!C\u0001\u0003;C\u0011\"a \u001e\u0003\u0003%\t%!!\t\u0013\u0005\rU$!A\u0005B\u0005\u0015\u0005\"CAD;\u0005\u0005I\u0011BAE\u000f\u001d\t\u0019+\u0007EA\u0003s1q!a\t\u001a\u0011\u0003\u000b)\u0003\u0003\u0004TQ\u0011\u0005\u0011q\u0007\u0005\n\u0003wA\u0013\u0011!C!\u0003{A\u0011\"a\u0013)\u0003\u0003%\t!!\u0014\t\u0013\u0005U\u0003&!A\u0005\u0002\u0005]\u0003\"CA2Q\u0005\u0005I\u0011IA3\u0011%\t\u0019\bKA\u0001\n\u0003\t)\bC\u0005\u0002\u0000!\n\t\u0011\"\u0011\u0002\u0002\"I\u00111\u0011\u0015\u0002\u0002\u0013\u0005\u0013Q\u0011\u0005\n\u0003\u000fC\u0013\u0011!C\u0005\u0003\u0013\u0013\u0001c\u00117vgR,'OQ8piN$(/\u00199\u000b\u0005Q*\u0014!\u00032p_R\u001cHO]1q\u0015\t1t'A\u0004dYV\u001cH/\u001a:\u000b\u0005aJ\u0014AC7b]\u0006<W-\\3oi*\t!(\u0001\u0003bW.\f7\u0001A\n\u0005\u0001u\u001a\u0015\n\u0005\u0002?\u00036\tqHC\u0001A\u0003\u0015\u00198-\u00197b\u0013\t\u0011uH\u0001\u0004B]f\u0014VM\u001a\t\u0003\t\u001ek\u0011!\u0012\u0006\u0003\rf\nQ!Y2u_JL!\u0001S#\u0003\u0013\u0015CH/\u001a8tS>t\u0007C\u0001&N\u001b\u0005Y%B\u0001'8\u0003!\u00198-\u00197bINd\u0017B\u0001(L\u0005]i\u0015M\\1hK6,g\u000e\u001e*pkR,\u0007K]8wS\u0012,'/\u0001\u0004tsN$X-\u001c\t\u0003\tFK!AU#\u0003'\u0015CH/\u001a8eK\u0012\f5\r^8s'f\u001cH/Z7\u0002\rqJg.\u001b;?)\u0005)FC\u0001,Y!\t9\u0006!D\u00014\u0011\u0015y%\u0001q\u0001Q\u0003\rawnZ\u000b\u00027B\u0011AlX\u0007\u0002;*\u0011a,O\u0001\u0006KZ,g\u000e^\u0005\u0003Av\u0013a\u0002T8hO&tw-\u00113baR,'/\u0001\u0003m_\u001e\u0004\u0013!\u00042p_R\u001cHO]1q'R,\u0007/F\u0001e!\r)g\u000e]\u0007\u0002M*\u0011q\r[\u0001\u0007CR|W.[2\u000b\u0005%T\u0017AC2p]\u000e,(O]3oi*\u00111\u000e\\\u0001\u0005kRLGNC\u0001n\u0003\u0011Q\u0017M^1\n\u0005=4'aD!u_6L7MU3gKJ,gnY3\u0011\u0005E\\bB\u0001:\u0019\u001d\t9&#\u0001\tDYV\u001cH/\u001a:C_>$8\u000f\u001e:baB\u0011qkE\n\u0005'u2\u0018\u0010E\u0002EoZK!\u0001_#\u0003\u0017\u0015CH/\u001a8tS>t\u0017\n\u001a\t\u0003\tjL!a_#\u0003'\u0015CH/\u001a8tS>t\u0017\n\u001a)s_ZLG-\u001a:\u0015\u0003Q\fa\u0001\\8pWV\u0004H#\u0001:\u0002\u0007\u001d,G\u000fF\u0002W\u0003\u0007Aaa\u0014\fA\u0002\u0005\u0015\u0001c\u0001#\u0002\b%\u0019\u0011\u0011B#\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\\\u0001\u0010GJ,\u0017\r^3FqR,gn]5p]R\u0019a+a\u0004\t\u000b=;\u0002\u0019\u0001)\u0002\u0011%sG/\u001a:oC2\u00042!!\u0006\u001a\u001b\u0005\u0019\"\u0001C%oi\u0016\u0014h.\u00197\u0014\u0005eiDCAA\n\u00055\u0011un\u001c;tiJ\f\u0007o\u0015;faN\u00111$P\u0015\u00047!j\"\u0001D%oSRL\u0017\r\\5{S:<7\u0003\u0003\u0015>\u0003O\tY#!\r\u0011\u0007\u0005%2$D\u0001\u001a!\rq\u0014QF\u0005\u0004\u0003_y$a\u0002)s_\u0012,8\r\u001e\t\u0004}\u0005M\u0012bAA\u001b\u007f\ta1+\u001a:jC2L'0\u00192mKR\u0011\u0011\u0011\b\t\u0004\u0003SA\u0013!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002@A!\u0011\u0011IA$\u001b\t\t\u0019EC\u0002\u0002F1\fA\u0001\\1oO&!\u0011\u0011JA\"\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\n\t\u0004}\u0005E\u0013bAA*\u007f\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011LA0!\rq\u00141L\u0005\u0004\u0003;z$aA!os\"I\u0011\u0011\r\u0017\u0002\u0002\u0003\u0007\u0011qJ\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u001d\u0004CBA5\u0003_\nI&\u0004\u0002\u0002l)\u0019\u0011QN \u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002r\u0005-$\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\u001e\u0002~A\u0019a(!\u001f\n\u0007\u0005mtHA\u0004C_>dW-\u00198\t\u0013\u0005\u0005d&!AA\u0002\u0005e\u0013\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005=\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005}\u0012a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a#\u0011\t\u0005\u0005\u0013QR\u0005\u0005\u0003\u001f\u000b\u0019E\u0001\u0004PE*,7\r\u001e\u0002\u000b\u001d>$(+\u001e8oS:<7\u0003C\u000f>\u0003O\tY#!\r\u0015\u0005\u0005]\u0005cAA\u0015;Q!\u0011\u0011LAN\u0011%\t\t'IA\u0001\u0002\u0004\ty\u0005\u0006\u0003\u0002x\u0005}\u0005\"CA1G\u0005\u0005\t\u0019AA-\u0003)qu\u000e\u001e*v]:LgnZ\u0001\r\u0013:LG/[1mSjLgnZ\u0001\u000fE>|Go\u001d;sCB\u001cF/\u001a9!\u0003!\u0019X\r\u001e;j]\u001e\u001cXCAAV!\r9\u0016QV\u0005\u0004\u0003_\u001b$\u0001G\"mkN$XM\u001d\"p_R\u001cHO]1q'\u0016$H/\u001b8hg\u0006I1/\u001a;uS:<7\u000fI\u0001\nI&\u001c8m\u001c<fef,\"!a.\u0011\t\u0005e\u0016QX\u0007\u0003\u0003wS1!a-:\u0013\u0011\ty,a/\u0003!M+'O^5dK\u0012K7oY8wKJL\u0018a\u00036pS:$UmY5eKJ,\"!!2\u0011\u0007]\u000b9-C\u0002\u0002JN\u00121BS8j]\u0012+7-\u001b3fe\u0006a!n\\5o\t\u0016\u001c\u0017\u000eZ3sA\u0005!rl]3mM\u000e{g\u000e^1diB{\u0017N\u001c;Ve&\u0004b!!5\u0002V\u0006eWBAAj\u0015\tIw(\u0003\u0003\u0002X\u0006M'a\u0002)s_6L7/\u001a\t\u0005\u00037\f9/\u0004\u0002\u0002^*!\u0011q\\Aq\u0003\u0015iw\u000eZ3m\u0015\ra\u00151\u001d\u0006\u0004\u0003KL\u0014\u0001\u00025uiBLA!!;\u0002^\n\u0019QK]5\u0002\rI|W\u000f^3t)\u0011\tyOa\u0006\u0011\t\u0005E(\u0011\u0003\b\u0005\u0003g\u0014YA\u0004\u0003\u0002v\n\u001da\u0002BA|\u0005\u000bqA!!?\u0003\u00049!\u00111 B\u0001\u001b\t\tiPC\u0002\u0002\u0000n\na\u0001\u0010:p_Rt\u0014\"\u0001\u001e\n\u0007\u0005\u0015\u0018(C\u0002M\u0003GLAA!\u0003\u0002b\u000611/\u001a:wKJLAA!\u0004\u0003\u0010\u00059\u0001/Y2lC\u001e,'\u0002\u0002B\u0005\u0003CLAAa\u0005\u0003\u0016\t)!k\\;uK*!!Q\u0002B\b\u0011\u001d\u0011I\"\u0004a\u0001\u00057\tQC]8vi\u0016\u0004&o\u001c<jI\u0016\u00148+\u001a;uS:<7\u000fE\u0002K\u0005;I1Aa\bL\u0005}i\u0015M\\1hK6,g\u000e\u001e*pkR,\u0007K]8wS\u0012,'oU3ui&twm]\u0001\u0006gR\f'\u000f\u001e\u000b\u0003\u0005K\u00012A\u0010B\u0014\u0013\r\u0011Ic\u0010\u0002\u0005+:LG/\u0001\ff]N,(/Z*fY\u001a\u001cuN\u001c;bGR\u0004v.\u001b8uQ\ry!q\u0006\t\u0005\u0005c\u00119$\u0004\u0002\u00034)\u0019!QG\u001d\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003:\tM\"aC%oi\u0016\u0014h.\u00197Ba&\f1c]3u'\u0016dgmQ8oi\u0006\u001cG\u000fU8j]R$BA!\n\u0003@!9!\u0011\t\tA\u0002\u0005e\u0017a\u00022bg\u0016,&/\u001b\u0015\u0004!\t=\u0012\u0001E:fY\u001a\u001cuN\u001c;bGR\u0004v.\u001b8u+\t\u0011I\u0005\u0005\u0004\u0002R\n-\u0013\u0011\\\u0005\u0005\u0005\u001b\n\u0019N\u0001\u0004GkR,(/\u001a\u0015\u0004#\t=\u0002")
public final class ClusterBootstrap
implements ManagementRouteProvider {
    private ServiceDiscovery discovery;
    private final ExtendedActorSystem system;
    private final LoggingAdapter log;
    private final AtomicReference<Internal.BootstrapStep> bootstrapStep;
    private final ClusterBootstrapSettings settings;
    private final JoinDecider joinDecider;
    private final Promise<Uri> _selfContactPointUri;
    private volatile boolean bitmap$0;

    public static ClusterBootstrap createExtension(ExtendedActorSystem extendedActorSystem) {
        return ClusterBootstrap$.MODULE$.createExtension(extendedActorSystem);
    }

    public static ClusterBootstrap get(ActorSystem actorSystem) {
        return ClusterBootstrap$.MODULE$.get(actorSystem);
    }

    public static ClusterBootstrap$ lookup() {
        return ClusterBootstrap$.MODULE$.lookup();
    }

    public static Extension apply(ActorSystem actorSystem) {
        return ClusterBootstrap$.MODULE$.apply(actorSystem);
    }

    private LoggingAdapter log() {
        return this.log;
    }

    private final AtomicReference<Internal.BootstrapStep> bootstrapStep() {
        return this.bootstrapStep;
    }

    public ClusterBootstrapSettings settings() {
        return this.settings;
    }

    private ServiceDiscovery discovery$lzycompute() {
        ClusterBootstrap clusterBootstrap = this;
        synchronized (clusterBootstrap) {
            if (!this.bitmap$0) {
                ServiceDiscovery serviceDiscovery;
                String string = this.settings().contactPointDiscovery().discoveryMethod();
                if ("akka.discovery".equals(string)) {
                    ServiceDiscovery discovery = Discovery$.MODULE$.apply((ActorSystem)this.system).discovery();
                    this.log().info("Bootstrap using default `akka.discovery` method: {}", (Object)Logging$.MODULE$.simpleName((Object)discovery));
                    serviceDiscovery = discovery;
                } else {
                    this.log().info("Bootstrap using `akka.discovery` method: {}", (Object)string);
                    serviceDiscovery = Discovery$.MODULE$.apply((ActorSystem)this.system).loadServiceDiscovery(string);
                }
                this.discovery = serviceDiscovery;
                this.bitmap$0 = true;
            }
        }
        return this.discovery;
    }

    public ServiceDiscovery discovery() {
        return !this.bitmap$0 ? this.discovery$lzycompute() : this.discovery;
    }

    private JoinDecider joinDecider() {
        return this.joinDecider;
    }

    public Function1<RequestContext, Future<RouteResult>> routes(ManagementRouteProviderSettings routeProviderSettings) {
        this.log().info(new StringBuilder(34).append("Using self contact point address: ").append(routeProviderSettings.selfBaseUri()).toString());
        this.setSelfContactPoint(routeProviderSettings.selfBaseUri());
        return new HttpClusterBootstrapRoutes(this.settings()).routes();
    }

    public void start() {
        if (((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system)).settings().SeedNodes().nonEmpty()) {
            this.log().warning("Application is configured with specific `akka.cluster.seed-nodes`: {}, bailing out of the bootstrap process! If you want to use the automatic bootstrap mechanism, make sure to NOT set explicit seed nodes in the configuration. This node will attempt to join the configured seed nodes.", (Object)((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system)).settings().SeedNodes().mkString("[", ", ", "]"));
        } else if (this.bootstrapStep().compareAndSet(ClusterBootstrap$Internal$NotRunning$.MODULE$, ClusterBootstrap$Internal$Initializing$.MODULE$)) {
            this.log().info("Initiating bootstrap procedure using {} method...", (Object)this.settings().contactPointDiscovery().discoveryMethod());
            this.ensureSelfContactPoint();
            Props bootstrapProps = BootstrapCoordinator$.MODULE$.props(this.discovery(), this.joinDecider(), this.settings());
            ActorRef bootstrap = this.system.systemActorOf(bootstrapProps, "bootstrapCoordinator");
            this.selfContactPoint().foreach((Function1 & Serializable & scala.Serializable)uri -> {
                ClusterBootstrap.$anonfun$start$1(bootstrap, uri);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)this.system.dispatcher());
        } else {
            this.log().warning("Bootstrap already initiated, yet start() method was called again. Ignoring.");
        }
    }

    @InternalApi
    public void ensureSelfContactPoint() {
        this.system.scheduler().scheduleOnce(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (this.selfContactPoint().isCompleted()) break block0;
                $this._selfContactPointUri.failure((Throwable)new TimeoutException("Awaiting Bootstrap.selfContactPoint timed out."));
                this.log().error("'Bootstrap.selfContactPoint' was NOT set, but is required for the bootstrap to work if binding bootstrap routes manually and not via akka-management.");
            }
        }, (ExecutionContext)this.system.dispatcher());
    }

    @InternalApi
    public void setSelfContactPoint(Uri baseUri) {
        this._selfContactPointUri.success((Object)baseUri);
    }

    @InternalApi
    public Future<Uri> selfContactPoint() {
        return this._selfContactPointUri.future();
    }

    public static final /* synthetic */ void $anonfun$start$1(ActorRef bootstrap$1, Uri uri) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(bootstrap$1);
        BootstrapCoordinator.Protocol.InitiateBootstrapping x$1 = new BootstrapCoordinator.Protocol.InitiateBootstrapping(uri);
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public ClusterBootstrap(ExtendedActorSystem system) {
        this.system = system;
        this.log = Logging$.MODULE$.apply((ActorSystem)system, ClusterBootstrap.class, LogSource$.MODULE$.fromAnyClass());
        this.bootstrapStep = new AtomicReference<ClusterBootstrap$Internal$NotRunning$>(ClusterBootstrap$Internal$NotRunning$.MODULE$);
        AkkaVersion$.MODULE$.require("cluster-bootstrap", "2.5.27");
        this.settings = ClusterBootstrapSettings$.MODULE$.apply(system.settings().config(), this.log());
        this.joinDecider = (JoinDecider)system.dynamicAccess().createInstanceFor(this.settings().joinDecider().implClass(), (Seq)new .colon.colon((Object)new Tuple2(ActorSystem.class, (Object)system), (List)new .colon.colon((Object)new Tuple2(ClusterBootstrapSettings.class, (Object)this.settings()), (List)Nil$.MODULE$)), ClassTag$.MODULE$.apply(JoinDecider.class)).get();
        this._selfContactPointUri = Promise$.MODULE$.apply();
    }
}

