/*
 * Decompiled with CFR 0.152.
 */
package akka.discovery.kubernetes;

import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.discovery.Lookup;
import akka.discovery.ServiceDiscovery;
import akka.discovery.kubernetes.JsonFormat$;
import akka.discovery.kubernetes.KubernetesApiServiceDiscovery$;
import akka.discovery.kubernetes.PodList;
import akka.discovery.kubernetes.Settings;
import akka.discovery.kubernetes.Settings$;
import akka.dispatch.Dispatchers$;
import akka.dispatch.MessageDispatcher;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.http.scaladsl.ConnectionContext$;
import akka.http.scaladsl.Http$;
import akka.http.scaladsl.HttpExt;
import akka.http.scaladsl.HttpsConnectionContext;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpMethod;
import akka.http.scaladsl.model.HttpProtocol;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpRequest$;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.model.StatusCode;
import akka.http.scaladsl.model.StatusCodes;
import akka.http.scaladsl.model.StatusCodes$;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.model.Uri$;
import akka.http.scaladsl.model.headers.Authorization;
import akka.http.scaladsl.model.headers.HttpCredentials;
import akka.http.scaladsl.model.headers.OAuth2BearerToken;
import akka.http.scaladsl.unmarshalling.Unmarshal$;
import akka.http.scaladsl.unmarshalling.Unmarshaller$;
import akka.pki.kubernetes.PemManagersProvider$;
import akka.stream.Materializer$;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.NoSuchElementException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.util.Try$;
import scala.util.control.NoStackTrace;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\tmx!B\u001a5\u0011\u0003Yd!B\u001f5\u0011\u0003q\u0004\"B#\u0002\t\u00031\u0005BB$\u0002\t\u0003!\u0004J\u0002\u0004\u0002\b\u0005\u0001\u0011\u0011\u0002\u0005\n\u0003[!!\u0011!Q\u0001\n%Da!\u0012\u0003\u0005\u0002\u0005=bABA\u001c\u0003\u0019\u000bI\u0004C\u0005s\u000f\tU\r\u0011\"\u0001\u0002H!I\u0011\u0011J\u0004\u0003\u0012\u0003\u0006I!\u001b\u0005\u000b\u0003\u0017:!Q3A\u0005\u0002\u0005\u001d\u0003\"CA'\u000f\tE\t\u0015!\u0003j\u0011)\tye\u0002BK\u0002\u0013\u0005\u0011\u0011\u000b\u0005\u000b\u0003G:!\u0011#Q\u0001\n\u0005M\u0003BB#\b\t\u0003\t)\u0007C\u0005\u0002p\u001d\t\t\u0011\"\u0001\u0002r!I\u0011\u0011P\u0004\u0012\u0002\u0013\u0005\u00111\u0010\u0005\n\u0003\u001f;\u0011\u0013!C\u0001\u0003wB\u0011\"!%\b#\u0003%\t!a%\t\u0013\u0005]u!!A\u0005B\u0005e\u0005\"CAU\u000f\u0005\u0005I\u0011AAV\u0011%\t\u0019lBA\u0001\n\u0003\t)\fC\u0005\u0002B\u001e\t\t\u0011\"\u0011\u0002D\"I\u0011QZ\u0004\u0002\u0002\u0013\u0005\u0011q\u001a\u0005\n\u0003'<\u0011\u0011!C!\u0003+D\u0011\"!7\b\u0003\u0003%\t%a7\t\u0013\u0005uw!!A\u0005B\u0005}\u0007\"CAq\u000f\u0005\u0005I\u0011IAr\u000f%\t9/AA\u0001\u0012\u0013\tIOB\u0005\u00028\u0005\t\t\u0011#\u0003\u0002l\"1Q)\bC\u0001\u0005\u0007A\u0011\"!8\u001e\u0003\u0003%)%a8\t\u0013\t\u0015Q$!A\u0005\u0002\n\u001d\u0001\"\u0003B\b;\u0005\u0005I\u0011\u0011B\t\u0011%\u0011y\"HA\u0001\n\u0013\u0011\tCB\u0003>i\u0001\u0011I\u0003\u0003\u0006\u00034\r\u0012\t\u0011)A\u0006\u0005kAa!R\u0012\u0005\u0002\t\u0005\u0003\"CA/G\t\u0007I\u0011\u0002B%\u0011!\u0011\tf\tQ\u0001\n\t-\u0003\"\u0003B*G\t\u0007I\u0011\u0002B+\u0011!\u0011if\tQ\u0001\n\t]\u0003\"\u0003B0G\t\u0007I\u0011\u0002B1\u0011!\u0011yg\tQ\u0001\n\t\r\u0004\"\u0003B9G\t\u0007I\u0011\u0002B:\u0011!\u0011)i\tQ\u0001\n\tU\u0004b\u0002BDG\u0011\u0005#\u0011\u0012\u0005\b\u0005[\u001bC\u0011\u0002BX\u0011\u001d\u0011ym\tC\u0005\u0005#Dq!a\u0014$\t\u0013\u0011i\u000fC\u0004\u0003p\u000e\"IA!=\u0002;-+(-\u001a:oKR,7/\u00119j'\u0016\u0014h/[2f\t&\u001c8m\u001c<fefT!!\u000e\u001c\u0002\u0015-,(-\u001a:oKR,7O\u0003\u00028q\u0005IA-[:d_Z,'/\u001f\u0006\u0002s\u0005!\u0011m[6b\u0007\u0001\u0001\"\u0001P\u0001\u000e\u0003Q\u0012QdS;cKJtW\r^3t\u0003BL7+\u001a:wS\u000e,G)[:d_Z,'/_\n\u0003\u0003}\u0002\"\u0001Q\"\u000e\u0003\u0005S\u0011AQ\u0001\u0006g\u000e\fG.Y\u0005\u0003\t\u0006\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001<\u0003\u001d!\u0018M]4fiN$r!S0ecN,(\u0010E\u0002K\u001fFk\u0011a\u0013\u0006\u0003\u00196\u000b\u0011\"[7nkR\f'\r\\3\u000b\u00059\u000b\u0015AC2pY2,7\r^5p]&\u0011\u0001k\u0013\u0002\u0004'\u0016\f\bC\u0001*]\u001d\t\u0019&L\u0004\u0002U3:\u0011Q\u000bW\u0007\u0002-*\u0011qKO\u0001\u0007yI|w\u000e\u001e \n\u0003eJ!a\u000e\u001d\n\u0005m3\u0014\u0001E*feZL7-\u001a#jg\u000e|g/\u001a:z\u0013\tifL\u0001\bSKN|GN^3e)\u0006\u0014x-\u001a;\u000b\u0005m3\u0004\"\u00021\u0004\u0001\u0004\t\u0017a\u00029pI2K7\u000f\u001e\t\u0003y\tL!a\u0019\u001b\u0003\u000fA{G\rT5ti\")Qm\u0001a\u0001M\u0006A\u0001o\u001c:u\u001d\u0006lW\rE\u0002AO&L!\u0001[!\u0003\r=\u0003H/[8o!\tQgN\u0004\u0002lYB\u0011Q+Q\u0005\u0003[\u0006\u000ba\u0001\u0015:fI\u00164\u0017BA8q\u0005\u0019\u0019FO]5oO*\u0011Q.\u0011\u0005\u0006e\u000e\u0001\r![\u0001\ra>$g*Y7fgB\f7-\u001a\u0005\u0006i\u000e\u0001\r![\u0001\na>$Gi\\7bS:DQA^\u0002A\u0002]\fQA]1x\u0013B\u0004\"\u0001\u0011=\n\u0005e\f%a\u0002\"p_2,\u0017M\u001c\u0005\u0006w\u000e\u0001\rAZ\u0001\u000eG>tG/Y5oKJt\u0015-\\3)\u0005\ri\bc\u0001@\u0002\u00045\tqPC\u0002\u0002\u0002a\n!\"\u00198o_R\fG/[8o\u0013\r\t)a \u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018N\u0001\fLk\n,'O\\3uKN\f\u0005/[#yG\u0016\u0004H/[8o'\u0015!\u00111BA\u000f!\u0011\ti!a\u0006\u000f\t\u0005=\u00111\u0003\b\u0004+\u0006E\u0011\"\u0001\"\n\u0007\u0005U\u0011)A\u0004qC\u000e\\\u0017mZ3\n\t\u0005e\u00111\u0004\u0002\u0011%VtG/[7f\u000bb\u001cW\r\u001d;j_:T1!!\u0006B!\u0011\ty\"!\u000b\u000e\u0005\u0005\u0005\"\u0002BA\u0012\u0003K\tqaY8oiJ|GNC\u0002\u0002(\u0005\u000bA!\u001e;jY&!\u00111FA\u0011\u00051qun\u0015;bG.$&/Y2f\u0003\ri7o\u001a\u000b\u0005\u0003c\t)\u0004E\u0002\u00024\u0011i\u0011!\u0001\u0005\u0007\u0003[1\u0001\u0019A5\u0003\u001f-+(-\u001a:oKR,7oU3ukB\u001cbaB \u0002<\u0005\u0005\u0003c\u0001!\u0002>%\u0019\u0011qH!\u0003\u000fA\u0013x\u000eZ;diB!\u0011QBA\"\u0013\u0011\t)%a\u0007\u0003\u0019M+'/[1mSj\f'\r\\3\u0016\u0003%\fQ\u0002]8e\u001d\u0006lWm\u001d9bG\u0016\u0004\u0013\u0001C1qSR{7.\u001a8\u0002\u0013\u0005\u0004\u0018\u000eV8lK:\u0004\u0013\u0001H2mS\u0016tG\u000f\u0013;uaN\u001cuN\u001c8fGRLwN\\\"p]R,\u0007\u0010^\u000b\u0003\u0003'\u0002B!!\u0016\u0002`5\u0011\u0011q\u000b\u0006\u0005\u00033\nY&\u0001\u0005tG\u0006d\u0017\rZ:m\u0015\r\ti\u0006O\u0001\u0005QR$\b/\u0003\u0003\u0002b\u0005]#A\u0006%uiB\u001c8i\u001c8oK\u000e$\u0018n\u001c8D_:$X\r\u001f;\u0002;\rd\u0017.\u001a8u\u0011R$\bo]\"p]:,7\r^5p]\u000e{g\u000e^3yi\u0002\"\u0002\"a\u001a\u0002j\u0005-\u0014Q\u000e\t\u0004\u0003g9\u0001\"\u0002:\u000f\u0001\u0004I\u0007BBA&\u001d\u0001\u0007\u0011\u000eC\u0004\u0002P9\u0001\r!a\u0015\u0002\t\r|\u0007/\u001f\u000b\t\u0003O\n\u0019(!\u001e\u0002x!9!o\u0004I\u0001\u0002\u0004I\u0007\u0002CA&\u001fA\u0005\t\u0019A5\t\u0013\u0005=s\u0002%AA\u0002\u0005M\u0013AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003{R3![A@W\t\t\t\t\u0005\u0003\u0002\u0004\u0006-UBAAC\u0015\u0011\t9)!#\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0001\u0003&!\u0011QRAC\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!!&+\t\u0005M\u0013qP\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005m\u0005\u0003BAO\u0003Ok!!a(\u000b\t\u0005\u0005\u00161U\u0001\u0005Y\u0006twM\u0003\u0002\u0002&\u0006!!.\u0019<b\u0013\ry\u0017qT\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003[\u00032\u0001QAX\u0013\r\t\t,\u0011\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003o\u000bi\fE\u0002A\u0003sK1!a/B\u0005\r\te.\u001f\u0005\n\u0003\u007f+\u0012\u0011!a\u0001\u0003[\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAc!\u0019\t9-!3\u000286\tQ*C\u0002\u0002L6\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019q/!5\t\u0013\u0005}v#!AA\u0002\u0005]\u0016A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a'\u0002X\"I\u0011q\u0018\r\u0002\u0002\u0003\u0007\u0011QV\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011QV\u0001\ti>\u001cFO]5oOR\u0011\u00111T\u0001\u0007KF,\u0018\r\\:\u0015\u0007]\f)\u000fC\u0005\u0002@n\t\t\u00111\u0001\u00028\u0006y1*\u001e2fe:,G/Z:TKR,\b\u000fE\u0002\u00024u\u0019R!HAw\u0003s\u0004\"\"a<\u0002v&L\u00171KA4\u001b\t\t\tPC\u0002\u0002t\u0006\u000bqA];oi&lW-\u0003\u0003\u0002x\u0006E(!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogA!\u00111 B\u0001\u001b\t\tiP\u0003\u0003\u0002\u0000\u0006\r\u0016AA5p\u0013\u0011\t)%!@\u0015\u0005\u0005%\u0018!B1qa2LH\u0003CA4\u0005\u0013\u0011YA!\u0004\t\u000bI\u0004\u0003\u0019A5\t\r\u0005-\u0003\u00051\u0001j\u0011\u001d\ty\u0005\ta\u0001\u0003'\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\u0014\tm\u0001\u0003\u0002!h\u0005+\u0001r\u0001\u0011B\fS&\f\u0019&C\u0002\u0003\u001a\u0005\u0013a\u0001V;qY\u0016\u001c\u0004\"\u0003B\u000fC\u0005\u0005\t\u0019AA4\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005G\u0001B!!(\u0003&%!!qEAP\u0005\u0019y%M[3diN\u00191Ea\u000b\u0011\t\t5\"qF\u0007\u0002m%\u0019!\u0011\u0007\u001c\u0003!M+'O^5dK\u0012K7oY8wKJL\u0018AB:zgR,W\u000e\u0005\u0003\u00038\tuRB\u0001B\u001d\u0015\r\u0011Y\u0004O\u0001\u0006C\u000e$xN]\u0005\u0005\u0005\u007f\u0011IDA\u0006BGR|'oU=ti\u0016lGC\u0001B\")\u0011\u0011)Ea\u0012\u0011\u0005q\u001a\u0003b\u0002B\u001aK\u0001\u000f!QG\u000b\u0003\u0005\u0017\u0002B!!\u0016\u0003N%!!qJA,\u0005\u001dAE\u000f\u001e9FqR\fQ\u0001\u001b;ua\u0002\n\u0001b]3ui&twm]\u000b\u0003\u0005/\u00022\u0001\u0010B-\u0013\r\u0011Y\u0006\u000e\u0002\t'\u0016$H/\u001b8hg\u0006I1/\u001a;uS:<7\u000fI\u0001\u0004Y><WC\u0001B2!\u0011\u0011)Ga\u001b\u000e\u0005\t\u001d$b\u0001B5q\u0005)QM^3oi&!!Q\u000eB4\u00059aunZ4j]\u001e\fE-\u00199uKJ\fA\u0001\\8hA\u0005y1.\u001e2fe:,G/Z:TKR,\b/\u0006\u0002\u0003vA1!q\u000fB?\u0005\u0003k!A!\u001f\u000b\u0007\tm\u0014)\u0001\u0006d_:\u001cWO\u001d:f]RLAAa \u0003z\t1a)\u001e;ve\u0016\u00042Aa!\b\u001d\ta\u0004!\u0001\tlk\n,'O\\3uKN\u001cV\r^;qA\u00051An\\8lkB$bAa#\u0003\u0014\nu\u0005C\u0002B<\u0005{\u0012i\tE\u0002S\u0005\u001fK1A!%_\u0005!\u0011Vm]8mm\u0016$\u0007b\u0002BK]\u0001\u0007!qS\u0001\u0006cV,'/\u001f\t\u0005\u0005[\u0011I*C\u0002\u0003\u001cZ\u0012a\u0001T8pWV\u0004\bb\u0002BP]\u0001\u0007!\u0011U\u0001\u000fe\u0016\u001cx\u000e\u001c<f)&lWm\\;u!\u0011\u0011\u0019K!+\u000e\u0005\t\u0015&\u0002\u0002BT\u0005s\n\u0001\u0002Z;sCRLwN\\\u0005\u0005\u0005W\u0013)K\u0001\bGS:LG/\u001a#ve\u0006$\u0018n\u001c8\u0002\u001d=\u0004H/[8o)>4U\u000f^;sKV!!\u0011\u0017B])\u0019\u0011\u0019L!2\u0003LB1!q\u000fB?\u0005k\u0003BAa.\u0003:2\u0001Aa\u0002B^_\t\u0007!Q\u0018\u0002\u0002)F!!qXA\\!\r\u0001%\u0011Y\u0005\u0004\u0005\u0007\f%a\u0002(pi\"Lgn\u001a\u0005\b\u0005\u000f|\u0003\u0019\u0001Be\u0003\u0019y\u0007\u000f^5p]B!\u0001i\u001aB[\u0011\u0019\u0011im\fa\u0001S\u00069a-Y5m\u001bN<\u0017A\u00039pIJ+\u0017/^3tiRA!1\u001bBq\u0005K\u0014I\u000f\u0005\u0003AO\nU\u0007\u0003\u0002Bl\u0005;l!A!7\u000b\t\tm\u0017qK\u0001\u0006[>$W\r\\\u0005\u0005\u0005?\u0014INA\u0006IiR\u0004(+Z9vKN$\bB\u0002Bra\u0001\u0007\u0011.A\u0003u_.,g\u000e\u0003\u0004\u0003hB\u0002\r![\u0001\n]\u0006lWm\u001d9bG\u0016DaAa;1\u0001\u0004I\u0017!\u00047bE\u0016d7+\u001a7fGR|'\u000f\u0006\u0002\u0002T\u0005Y\"/Z1e\u0007>tg-[4WCJ4%o\\7GS2,7/_:uK6$RA\u001aBz\u0005oDaA!>3\u0001\u0004I\u0017\u0001\u00029bi\"DaA!?3\u0001\u0004I\u0017\u0001\u00028b[\u0016\u0004")
public class KubernetesApiServiceDiscovery
extends ServiceDiscovery {
    private final ActorSystem system;
    private final HttpExt http;
    private final Settings settings;
    private final LoggingAdapter log;
    private final Future<KubernetesSetup> kubernetesSetup;

    private HttpExt http() {
        return this.http;
    }

    private Settings settings() {
        return this.settings;
    }

    private LoggingAdapter log() {
        return this.log;
    }

    private Future<KubernetesSetup> kubernetesSetup() {
        return this.kubernetesSetup;
    }

    public Future<ServiceDiscovery.Resolved> lookup(Lookup query, FiniteDuration resolveTimeout) {
        String labelSelector = this.settings().podLabelSelector(query.serviceName());
        return this.kubernetesSetup().flatMap((Function1 & Serializable)setup -> {
            this.log().info("Querying for pods with label selector: [{}]. Namespace: [{}]. Port: [{}]", (Object)labelSelector, (Object)setup.podNamespace(), (Object)query.portName());
            return this.optionToFuture(this.podRequest(setup.apiToken(), setup.podNamespace(), labelSelector), new StringBuilder(76).append("Unable to form request; check Kubernetes environment (expecting env vars ").append(this.settings().apiServiceHostEnvName()).append(", ").append(this.settings().apiServicePortEnvName()).append(")").toString()).flatMap((Function1 & Serializable)request -> this.http().singleRequest(request, setup.clientHttpsConnectionContext(), this.http().singleRequest$default$3(), this.http().singleRequest$default$4()).flatMap((Function1 & Serializable)response -> response.entity().toStrict(resolveTimeout, Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)$this.system)).flatMap((Function1 & Serializable)entity -> {
                Future future;
                StatusCode statusCode = response.status();
                StatusCodes.Success success = StatusCodes$.MODULE$.OK();
                StatusCode statusCode2 = statusCode;
                if (!(success != null ? !success.equals(statusCode2) : statusCode2 != null)) {
                    this.log().debug("Kubernetes API entity: [{}]", (Object)entity.data().utf8String());
                    Future unmarshalled = Unmarshal$.MODULE$.apply(entity).to(JsonFormat$.MODULE$.sprayJsonUnmarshaller(JsonFormat$.MODULE$.podListFormat()), (ExecutionContext)$this.system.dispatcher(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)$this.system));
                    unmarshalled.failed().foreach((Function1 & Serializable)t -> {
                        KubernetesApiServiceDiscovery.$anonfun$lookup$5(this, response, entity, t);
                        return BoxedUnit.UNIT;
                    }, (ExecutionContext)$this.system.dispatcher());
                    future = unmarshalled;
                } else {
                    StatusCodes.ClientError clientError = StatusCodes$.MODULE$.Forbidden();
                    StatusCode statusCode3 = statusCode;
                    if (!(clientError != null ? !clientError.equals(statusCode3) : statusCode3 != null)) {
                        Unmarshal$.MODULE$.apply(entity).to(Unmarshaller$.MODULE$.stringUnmarshaller(), (ExecutionContext)$this.system.dispatcher(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)$this.system)).foreach((Function1 & Serializable)body -> {
                            KubernetesApiServiceDiscovery.$anonfun$lookup$6(this, body);
                            return BoxedUnit.UNIT;
                        }, (ExecutionContext)$this.system.dispatcher());
                        future = Future$.MODULE$.failed((Throwable)new KubernetesApiException("Forbidden when communicating with the Kubernetes API. Check RBAC settings."));
                    } else {
                        Unmarshal$.MODULE$.apply(entity).to(Unmarshaller$.MODULE$.stringUnmarshaller(), (ExecutionContext)$this.system.dispatcher(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)$this.system)).foreach((Function1 & Serializable)body -> {
                            KubernetesApiServiceDiscovery.$anonfun$lookup$7(this, statusCode, body);
                            return BoxedUnit.UNIT;
                        }, (ExecutionContext)$this.system.dispatcher());
                        future = Future$.MODULE$.failed((Throwable)new KubernetesApiException(new StringBuilder(36).append("Non-200 from Kubernetes API server: ").append(statusCode).toString()));
                    }
                }
                return future.map((Function1 & Serializable)podList -> {
                    Seq<ServiceDiscovery.ResolvedTarget> addresses;
                    block0: {
                        addresses = KubernetesApiServiceDiscovery$.MODULE$.targets((PodList)podList, (Option<String>)query.portName(), setup.podNamespace(), this.settings().podDomain(), this.settings().rawIp(), this.settings().containerName());
                        if (!addresses.isEmpty() || !podList.items().nonEmpty() || !this.log().isInfoEnabled()) break block0;
                        Set containerPortNames = ((IterableOnceOps)((IterableOps)((IterableOps)((IterableOps)podList.items().flatMap((Function1 & Serializable)x$4 -> x$4.spec())).flatMap((Function1 & Serializable)x$5 -> x$5.containers())).flatMap((Function1 & Serializable)x$6 -> x$6.ports())).flatten(Predef$.MODULE$.$conforms())).toSet();
                        this.log().info("No targets found from pod list. Is the correct port name configured? Current configuration: [{}]. Ports on pods: [{}]", (Object)query.portName(), (Object)containerPortNames);
                    }
                    return ServiceDiscovery.Resolved$.MODULE$.apply(query.serviceName(), addresses);
                }, (ExecutionContext)$this.system.dispatcher());
            }, (ExecutionContext)$this.system.dispatcher()), (ExecutionContext)$this.system.dispatcher()), (ExecutionContext)$this.system.dispatcher());
        }, (ExecutionContext)this.system.dispatcher());
    }

    private <T> Future<T> optionToFuture(Option<T> option, String failMsg) {
        return (Future)option.fold((Function0 & Serializable)() -> Future$.MODULE$.failed((Throwable)new NoSuchElementException(failMsg)), (Function1 & Serializable)result -> Future$.MODULE$.successful(result));
    }

    private Option<HttpRequest> podRequest(String token, String namespace, String labelSelector) {
        return package$.MODULE$.env().get((Object)this.settings().apiServiceHostEnvName()).flatMap((Function1 & Serializable)host -> package$.MODULE$.env().get((Object)this.settings().apiServicePortEnvName()).flatMap((Function1 & Serializable)portStr -> Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(portStr))).toOption().map((Function1 & Serializable)port -> KubernetesApiServiceDiscovery.$anonfun$podRequest$4(namespace, labelSelector, host, token, BoxesRunTime.unboxToInt((Object)port)))));
    }

    private HttpsConnectionContext clientHttpsConnectionContext() {
        Iterable certificates = PemManagersProvider$.MODULE$.loadCertificates(this.settings().apiCaPath());
        KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        keyStore.load(null);
        factory.init(keyStore, (char[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Char()));
        KeyManager[] km = factory.getKeyManagers();
        TrustManager[] tm = PemManagersProvider$.MODULE$.buildTrustManagers(certificates);
        SecureRandom random = new SecureRandom();
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        sslContext.init(km, tm, random);
        return ConnectionContext$.MODULE$.httpsClient(sslContext);
    }

    private Option<String> readConfigVarFromFilesystem(String path, String name) {
        Path file = Paths.get(path, new String[0]);
        if (Files.exists(file, new LinkOption[0])) {
            Some some;
            try {
                some = new Some((Object)new String(Files.readAllBytes(file), "utf-8"));
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    this.log().error(e, "Error reading {} from {}", (Object)name, (Object)path);
                    some = None$.MODULE$;
                }
                throw throwable;
            }
            return some;
        }
        this.log().warning("Unable to read {} from {} because it doesn't exist.", (Object)name, (Object)path);
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$kubernetesSetup$3(String check$ifrefutable$1) {
        String string = check$ifrefutable$1;
        return string != null;
    }

    public static final /* synthetic */ boolean $anonfun$kubernetesSetup$8(String check$ifrefutable$2) {
        String string = check$ifrefutable$2;
        return string != null;
    }

    public static final /* synthetic */ Future $anonfun$kubernetesSetup$4(KubernetesApiServiceDiscovery $this, ExecutionContext blockingDispatcher$1, String apiToken) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> (String)$this.settings().podNamespace().orElse((Function0 & Serializable)() -> $this.readConfigVarFromFilesystem($this.settings().podNamespacePath(), "pod-namespace")).getOrElse((Function0 & Serializable)() -> "default"), blockingDispatcher$1).withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)KubernetesApiServiceDiscovery.$anonfun$kubernetesSetup$8(check$ifrefutable$2)), blockingDispatcher$1).flatMap((Function1 & Serializable)namespace -> Future$.MODULE$.apply((Function0 & Serializable)() -> $this.clientHttpsConnectionContext(), blockingDispatcher$1).map((Function1 & Serializable)httpsContext -> new KubernetesSetup((String)namespace, apiToken, (HttpsConnectionContext)httpsContext), blockingDispatcher$1), blockingDispatcher$1);
    }

    public static final /* synthetic */ void $anonfun$lookup$5(KubernetesApiServiceDiscovery $this, HttpResponse response$1, HttpEntity.Strict entity$1, Throwable t) {
        $this.log().warning("Failed to unmarshal Kubernetes API response.  Status code: [{}]; Response body: [{}]. Ex: [{}]", (Object)response$1.status().value(), (Object)entity$1, (Object)t.getMessage());
    }

    public static final /* synthetic */ void $anonfun$lookup$6(KubernetesApiServiceDiscovery $this, String body) {
        $this.log().warning("Forbidden to communicate with Kubernetes API server; check RBAC settings. Response: [{}]", (Object)body);
    }

    public static final /* synthetic */ void $anonfun$lookup$7(KubernetesApiServiceDiscovery $this, StatusCode x1$1, String body) {
        $this.log().warning("Non-200 when communicating with Kubernetes API server. Status code: [{}]. Response body: [{}]", (Object)x1$1, (Object)body);
    }

    public static final /* synthetic */ HttpRequest $anonfun$podRequest$4(String namespace$2, String labelSelector$2, String host$1, String token$1, int port) {
        Uri uri;
        Uri.Path path = Uri.Path$.Empty$.MODULE$.$div("api").$div("v1").$div("namespaces").$div(namespace$2).$div("pods");
        Uri.Query query = Uri.Query$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"labelSelector"), (Object)labelSelector$2)}));
        String x$1 = "https";
        String x$2 = host$1;
        int x$3 = port;
        String x$4 = Uri$.MODULE$.from$default$2();
        String x$5 = Uri$.MODULE$.from$default$5();
        Option x$6 = Uri$.MODULE$.from$default$6();
        Option x$7 = Uri$.MODULE$.from$default$7();
        Uri.ParsingMode x$8 = Uri$.MODULE$.from$default$8();
        Uri x$9 = uri = Uri$.MODULE$.from("https", x$4, x$2, x$3, x$5, x$6, x$7, x$8).withPath(path).withQuery(query);
        .colon.colon x$10 = new .colon.colon((Object)new Authorization((HttpCredentials)new OAuth2BearerToken(token$1)), (List)Nil$.MODULE$);
        HttpMethod x$11 = HttpRequest$.MODULE$.apply$default$1();
        RequestEntity x$12 = HttpRequest$.MODULE$.apply$default$4();
        HttpProtocol x$13 = HttpRequest$.MODULE$.apply$default$5();
        return HttpRequest$.MODULE$.apply(x$11, x$9, (Seq)x$10, x$12, x$13);
    }

    public KubernetesApiServiceDiscovery(ActorSystem system) {
        this.system = system;
        this.http = Http$.MODULE$.apply((ClassicActorSystemProvider)system);
        this.settings = (Settings)Settings$.MODULE$.apply(system);
        this.log = Logging$.MODULE$.apply(system, KubernetesApiServiceDiscovery.class, LogSource$.MODULE$.fromAnyClass());
        this.log().debug("Settings {}", (Object)this.settings());
        MessageDispatcher blockingDispatcher = system.dispatchers().lookup(Dispatchers$.MODULE$.DefaultBlockingDispatcherId());
        this.kubernetesSetup = Future$.MODULE$.apply((Function0 & Serializable)() -> (String)this.readConfigVarFromFilesystem(this.settings().apiTokenPath(), "api-token").getOrElse((Function0 & Serializable)() -> ""), (ExecutionContext)blockingDispatcher).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)KubernetesApiServiceDiscovery.$anonfun$kubernetesSetup$3(check$ifrefutable$1)), (ExecutionContext)blockingDispatcher).flatMap(arg_0 -> KubernetesApiServiceDiscovery.$anonfun$kubernetesSetup$4(this, (ExecutionContext)blockingDispatcher, arg_0), (ExecutionContext)blockingDispatcher);
    }

    public static class KubernetesApiException
    extends RuntimeException
    implements NoStackTrace {
        public /* synthetic */ Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        @Override
        public Throwable fillInStackTrace() {
            return NoStackTrace.fillInStackTrace$((NoStackTrace)this);
        }

        public KubernetesApiException(String msg) {
            super(msg);
            NoStackTrace.$init$((NoStackTrace)this);
        }
    }

    private static final class KubernetesSetup
    implements Product,
    Serializable {
        private final String podNamespace;
        private final String apiToken;
        private final HttpsConnectionContext clientHttpsConnectionContext;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String podNamespace() {
            return this.podNamespace;
        }

        public String apiToken() {
            return this.apiToken;
        }

        public HttpsConnectionContext clientHttpsConnectionContext() {
            return this.clientHttpsConnectionContext;
        }

        public KubernetesSetup copy(String podNamespace, String apiToken, HttpsConnectionContext clientHttpsConnectionContext) {
            return new KubernetesSetup(podNamespace, apiToken, clientHttpsConnectionContext);
        }

        public String copy$default$1() {
            return this.podNamespace();
        }

        public String copy$default$2() {
            return this.apiToken();
        }

        public HttpsConnectionContext copy$default$3() {
            return this.clientHttpsConnectionContext();
        }

        public String productPrefix() {
            return "KubernetesSetup";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.podNamespace();
                }
                case 1: {
                    return this.apiToken();
                }
                case 2: {
                    return this.clientHttpsConnectionContext();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof KubernetesSetup;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "podNamespace";
                }
                case 1: {
                    return "apiToken";
                }
                case 2: {
                    return "clientHttpsConnectionContext";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof KubernetesSetup)) return false;
            boolean bl = true;
            if (!bl) return false;
            KubernetesSetup kubernetesSetup = (KubernetesSetup)x$1;
            String string = this.podNamespace();
            String string2 = kubernetesSetup.podNamespace();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.apiToken();
            String string4 = kubernetesSetup.apiToken();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            HttpsConnectionContext httpsConnectionContext = this.clientHttpsConnectionContext();
            HttpsConnectionContext httpsConnectionContext2 = kubernetesSetup.clientHttpsConnectionContext();
            if (httpsConnectionContext == null) {
                if (httpsConnectionContext2 == null) return true;
                return false;
            } else {
                if (!httpsConnectionContext.equals(httpsConnectionContext2)) return false;
                return true;
            }
        }

        public KubernetesSetup(String podNamespace, String apiToken, HttpsConnectionContext clientHttpsConnectionContext) {
            this.podNamespace = podNamespace;
            this.apiToken = apiToken;
            this.clientHttpsConnectionContext = clientHttpsConnectionContext;
            Product.$init$((Product)this);
        }
    }
}

