/*
 * Decompiled with CFR 0.152.
 */
package akka.discovery.kubernetes;

import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.discovery.Lookup;
import akka.discovery.ServiceDiscovery;
import akka.discovery.kubernetes.JsonFormat$;
import akka.discovery.kubernetes.KubernetesApiServiceDiscovery$;
import akka.discovery.kubernetes.PodList;
import akka.discovery.kubernetes.Settings;
import akka.discovery.kubernetes.Settings$;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.http.scaladsl.ConnectionContext$;
import akka.http.scaladsl.Http$;
import akka.http.scaladsl.HttpExt;
import akka.http.scaladsl.HttpsConnectionContext;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpMethod;
import akka.http.scaladsl.model.HttpProtocol;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpRequest$;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.model.StatusCode;
import akka.http.scaladsl.model.StatusCodes;
import akka.http.scaladsl.model.StatusCodes$;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.model.Uri$;
import akka.http.scaladsl.model.headers.Authorization;
import akka.http.scaladsl.model.headers.HttpCredentials;
import akka.http.scaladsl.model.headers.OAuth2BearerToken;
import akka.http.scaladsl.unmarshalling.Unmarshal$;
import akka.http.scaladsl.unmarshalling.Unmarshaller$;
import akka.pki.kubernetes.PemManagersProvider$;
import akka.stream.Materializer$;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.util.NoSuchElementException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.util.Try$;
import scala.util.control.NoStackTrace;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\t-q!\u0002\u000f\u001e\u0011\u0003!c!\u0002\u0014\u001e\u0011\u00039\u0003\"\u0002\u0018\u0002\t\u0003y\u0003B\u0002\u0019\u0002\t\u0003i\u0012G\u0002\u0003m\u0003\u0001i\u0007\u0002C@\u0005\u0005\u0003\u0005\u000b\u0011\u0002*\t\r9\"A\u0011AA\u0001\r\u00151S\u0004AA\u0005\u0011)\t\u0019b\u0002B\u0001B\u0003-\u0011Q\u0003\u0005\u0007]\u001d!\t!!\t\t\u0013\u0005%rA1A\u0005\n\u0005-\u0002\u0002CA\u001e\u000f\u0001\u0006I!!\f\t\u0013\u0005urA1A\u0005\n\u0005}\u0002\u0002CA$\u000f\u0001\u0006I!!\u0011\t\u0013\u0005%sA1A\u0005\n\u0005-\u0003\u0002CA-\u000f\u0001\u0006I!!\u0014\t\u0013\u0005msA1A\u0005\n\u0005u\u0003\u0002CA:\u000f\u0001\u0006I!a\u0018\t\u0013\u0005UtA1A\u0005\n\u0005]\u0004\u0002CA@\u000f\u0001\u0006I!!\u001f\t\u000f\u0005\u0005u\u0001\"\u0011\u0002\u0004\"I\u0011\u0011W\u0004C\u0002\u0013%\u00111\u0017\u0005\b\u0003k;\u0001\u0015!\u0003S\u0011!YvA1A\u0005\n\u0005M\u0006bBA\\\u000f\u0001\u0006IA\u0015\u0005\b\u0003s;A\u0011BA^\u0011\u001d\t)m\u0002C\u0005\u0003\u000fDq!!<\b\t\u0013\ty/A\u000fLk\n,'O\\3uKN\f\u0005/[*feZL7-\u001a#jg\u000e|g/\u001a:z\u0015\tqr$\u0001\u0006lk\n,'O\\3uKNT!\u0001I\u0011\u0002\u0013\u0011L7oY8wKJL(\"\u0001\u0012\u0002\t\u0005\\7.Y\u0002\u0001!\t)\u0013!D\u0001\u001e\u0005uYUOY3s]\u0016$Xm]!qSN+'O^5dK\u0012K7oY8wKJL8CA\u0001)!\tIC&D\u0001+\u0015\u0005Y\u0013!B:dC2\f\u0017BA\u0017+\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001J\u0001\bi\u0006\u0014x-\u001a;t)\u001d\u0011\u0004*\u0014.]=\u000e\u00042a\r\u001d;\u001b\u0005!$BA\u001b7\u0003%IW.\\;uC\ndWM\u0003\u00028U\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005e\"$aA*fcB\u00111(\u0012\b\u0003y\rs!!\u0010\"\u000f\u0005y\nU\"A \u000b\u0005\u0001\u001b\u0013A\u0002\u001fs_>$h(C\u0001#\u0013\t\u0001\u0013%\u0003\u0002E?\u0005\u00012+\u001a:wS\u000e,G)[:d_Z,'/_\u0005\u0003\r\u001e\u0013aBU3t_24X\r\u001a+be\u001e,GO\u0003\u0002E?!)\u0011j\u0001a\u0001\u0015\u00069\u0001o\u001c3MSN$\bCA\u0013L\u0013\taUDA\u0004Q_\u0012d\u0015n\u001d;\t\u000b9\u001b\u0001\u0019A(\u0002\u0011A|'\u000f\u001e(b[\u0016\u00042!\u000b)S\u0013\t\t&F\u0001\u0004PaRLwN\u001c\t\u0003'^s!\u0001V+\u0011\u0005yR\u0013B\u0001,+\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001,\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005YS\u0003\"B.\u0004\u0001\u0004\u0011\u0016\u0001\u00049pI:\u000bW.Z:qC\u000e,\u0007\"B/\u0004\u0001\u0004\u0011\u0016!\u00039pI\u0012{W.Y5o\u0011\u0015y6\u00011\u0001a\u0003\u0015\u0011\u0018m^%q!\tI\u0013-\u0003\u0002cU\t9!i\\8mK\u0006t\u0007\"\u00023\u0004\u0001\u0004y\u0015!D2p]R\f\u0017N\\3s\u001d\u0006lW\r\u000b\u0002\u0004MB\u0011qM[\u0007\u0002Q*\u0011\u0011.I\u0001\u000bC:tw\u000e^1uS>t\u0017BA6i\u0005-Ie\u000e^3s]\u0006d\u0017\t]5\u0003--+(-\u001a:oKR,7/\u00119j\u000bb\u001cW\r\u001d;j_:\u001c2\u0001\u00028x!\tyGO\u0004\u0002qe:\u0011a(]\u0005\u0002W%\u00111OK\u0001\ba\u0006\u001c7.Y4f\u0013\t)hO\u0001\tSk:$\u0018.\\3Fq\u000e,\u0007\u000f^5p]*\u00111O\u000b\t\u0003qvl\u0011!\u001f\u0006\u0003un\fqaY8oiJ|GN\u0003\u0002}U\u0005!Q\u000f^5m\u0013\tq\u0018P\u0001\u0007O_N#\u0018mY6Ue\u0006\u001cW-A\u0002ng\u001e$B!a\u0001\u0002\bA\u0019\u0011Q\u0001\u0003\u000e\u0003\u0005AQa \u0004A\u0002I\u001b2aBA\u0006!\u0011\ti!a\u0004\u000e\u0003}I1!!\u0005 \u0005A\u0019VM\u001d<jG\u0016$\u0015n]2pm\u0016\u0014\u00180\u0001\u0004tsN$X-\u001c\t\u0005\u0003/\ti\"\u0004\u0002\u0002\u001a)\u0019\u00111D\u0011\u0002\u000b\u0005\u001cGo\u001c:\n\t\u0005}\u0011\u0011\u0004\u0002\f\u0003\u000e$xN]*zgR,W\u000e\u0006\u0002\u0002$Q!\u0011QEA\u0014!\t)s\u0001C\u0004\u0002\u0014%\u0001\u001d!!\u0006\u0002\t!$H\u000f]\u000b\u0003\u0003[\u0001B!a\f\u000285\u0011\u0011\u0011\u0007\u0006\u0005\u0003g\t)$\u0001\u0005tG\u0006d\u0017\rZ:m\u0015\r\tI#I\u0005\u0005\u0003s\t\tDA\u0004IiR\u0004X\t\u001f;\u0002\u000b!$H\u000f\u001d\u0011\u0002\u0011M,G\u000f^5oON,\"!!\u0011\u0011\u0007\u0015\n\u0019%C\u0002\u0002Fu\u0011\u0001bU3ui&twm]\u0001\ng\u0016$H/\u001b8hg\u0002\n1\u0001\\8h+\t\ti\u0005\u0005\u0003\u0002P\u0005USBAA)\u0015\r\t\u0019&I\u0001\u0006KZ,g\u000e^\u0005\u0005\u0003/\n\tF\u0001\bM_\u001e<\u0017N\\4BI\u0006\u0004H/\u001a:\u0002\t1|w\rI\u0001\u000bgNd7i\u001c8uKb$XCAA0!\u0011\t\t'a\u001c\u000e\u0005\u0005\r$\u0002BA3\u0003O\n1a]:m\u0015\u0011\tI'a\u001b\u0002\u00079,GO\u0003\u0002\u0002n\u0005)!.\u0019<bq&!\u0011\u0011OA2\u0005)\u00196\u000bT\"p]R,\u0007\u0010^\u0001\fgNd7i\u001c8uKb$\b%\u0001\tdY&,g\u000e^*tY\u000e{g\u000e^3yiV\u0011\u0011\u0011\u0010\t\u0005\u0003_\tY(\u0003\u0003\u0002~\u0005E\"A\u0006%uiB\u001c8i\u001c8oK\u000e$\u0018n\u001c8D_:$X\r\u001f;\u0002#\rd\u0017.\u001a8u'Nd7i\u001c8uKb$\b%\u0001\u0004m_>\\W\u000f\u001d\u000b\u0007\u0003\u000b\u000b9*!)\u0011\r\u0005\u001d\u0015QRAI\u001b\t\tIIC\u0002\u0002\f*\n!bY8oGV\u0014(/\u001a8u\u0013\u0011\ty)!#\u0003\r\u0019+H/\u001e:f!\rY\u00141S\u0005\u0004\u0003+;%\u0001\u0003*fg>dg/\u001a3\t\u000f\u0005eE\u00031\u0001\u0002\u001c\u0006)\u0011/^3ssB!\u0011QBAO\u0013\r\tyj\b\u0002\u0007\u0019>|7.\u001e9\t\u000f\u0005\rF\u00031\u0001\u0002&\u0006q!/Z:pYZ,G+[7f_V$\b\u0003BAT\u0003[k!!!+\u000b\t\u0005-\u0016\u0011R\u0001\tIV\u0014\u0018\r^5p]&!\u0011qVAU\u000591\u0015N\\5uK\u0012+(/\u0019;j_:\f\u0001\"\u00199j)>\\WM\\\u000b\u0002%\u0006I\u0011\r]5U_.,g\u000eI\u0001\u000ea>$g*Y7fgB\f7-\u001a\u0011\u00027I,\u0017\rZ\"p]\u001aLwMV1s\rJ|WNR5mKNL8\u000f^3n)\u0015y\u0015QXAa\u0011\u0019\ty,\u0007a\u0001%\u0006!\u0001/\u0019;i\u0011\u0019\t\u0019-\u0007a\u0001%\u0006!a.Y7f\u00039y\u0007\u000f^5p]R{g)\u001e;ve\u0016,B!!3\u0002RR1\u00111ZAr\u0003S\u0004b!a\"\u0002\u000e\u00065\u0007\u0003BAh\u0003#d\u0001\u0001B\u0004\u0002Tj\u0011\r!!6\u0003\u0003Q\u000bB!a6\u0002^B\u0019\u0011&!7\n\u0007\u0005m'FA\u0004O_RD\u0017N\\4\u0011\u0007%\ny.C\u0002\u0002b*\u00121!\u00118z\u0011\u001d\t)O\u0007a\u0001\u0003O\faa\u001c9uS>t\u0007\u0003B\u0015Q\u0003\u001bDa!a;\u001b\u0001\u0004\u0011\u0016a\u00024bS2l5oZ\u0001\u000ba>$'+Z9vKN$H\u0003CAy\u0003\u007f\u0014\u0019Aa\u0002\u0011\t%\u0002\u00161\u001f\t\u0005\u0003k\fY0\u0004\u0002\u0002x*!\u0011\u0011`A\u0019\u0003\u0015iw\u000eZ3m\u0013\u0011\ti0a>\u0003\u0017!#H\u000f\u001d*fcV,7\u000f\u001e\u0005\u0007\u0005\u0003Y\u0002\u0019\u0001*\u0002\u000bQ|7.\u001a8\t\r\t\u00151\u00041\u0001S\u0003%q\u0017-\\3ta\u0006\u001cW\r\u0003\u0004\u0003\nm\u0001\rAU\u0001\u000eY\u0006\u0014W\r\\*fY\u0016\u001cGo\u001c:")
public class KubernetesApiServiceDiscovery
extends ServiceDiscovery {
    private final ActorSystem system;
    private final HttpExt http;
    private final Settings settings;
    private final LoggingAdapter log;
    private final SSLContext sslContext;
    private final HttpsConnectionContext clientSslContext;
    private final String apiToken;
    private final String podNamespace;

    private HttpExt http() {
        return this.http;
    }

    private Settings settings() {
        return this.settings;
    }

    private LoggingAdapter log() {
        return this.log;
    }

    private SSLContext sslContext() {
        return this.sslContext;
    }

    private HttpsConnectionContext clientSslContext() {
        return this.clientSslContext;
    }

    public Future<ServiceDiscovery.Resolved> lookup(Lookup query, FiniteDuration resolveTimeout) {
        String labelSelector = this.settings().podLabelSelector(query.serviceName());
        this.log().info("Querying for pods with label selector: [{}]. Namespace: [{}]. Port: [{}]", (Object)labelSelector, (Object)this.podNamespace(), (Object)query.portName());
        return this.optionToFuture(this.podRequest(this.apiToken(), this.podNamespace(), labelSelector), new StringBuilder(76).append("Unable to form request; check Kubernetes environment (expecting env vars ").append(this.settings().apiServiceHostEnvName()).append(", ").append(this.settings().apiServicePortEnvName()).append(")").toString()).flatMap((Function1 & Serializable)request -> this.http().singleRequest(request, this.clientSslContext(), this.http().singleRequest$default$3(), this.http().singleRequest$default$4()).flatMap((Function1 & Serializable)response -> response.entity().toStrict(resolveTimeout, Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)$this.system)).flatMap((Function1 & Serializable)entity -> {
            Future future;
            StatusCode statusCode = response.status();
            StatusCodes.Success success = StatusCodes$.MODULE$.OK();
            StatusCode statusCode2 = statusCode;
            if (!(success != null ? !success.equals(statusCode2) : statusCode2 != null)) {
                this.log().debug("Kubernetes API entity: [{}]", (Object)entity.data().utf8String());
                Future unmarshalled = Unmarshal$.MODULE$.apply(entity).to(JsonFormat$.MODULE$.sprayJsonUnmarshaller(JsonFormat$.MODULE$.podListFormat()), (ExecutionContext)$this.system.dispatcher(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)$this.system));
                unmarshalled.failed().foreach((Function1 & Serializable)t -> {
                    KubernetesApiServiceDiscovery.$anonfun$lookup$4(this, response, entity, t);
                    return BoxedUnit.UNIT;
                }, (ExecutionContext)$this.system.dispatcher());
                future = unmarshalled;
            } else {
                StatusCodes.ClientError clientError = StatusCodes$.MODULE$.Forbidden();
                StatusCode statusCode3 = statusCode;
                if (!(clientError != null ? !clientError.equals(statusCode3) : statusCode3 != null)) {
                    Unmarshal$.MODULE$.apply(entity).to(Unmarshaller$.MODULE$.stringUnmarshaller(), (ExecutionContext)$this.system.dispatcher(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)$this.system)).foreach((Function1 & Serializable)body -> {
                        KubernetesApiServiceDiscovery.$anonfun$lookup$5(this, body);
                        return BoxedUnit.UNIT;
                    }, (ExecutionContext)$this.system.dispatcher());
                    future = Future$.MODULE$.failed((Throwable)new KubernetesApiException("Forbidden when communicating with the Kubernetes API. Check RBAC settings."));
                } else {
                    Unmarshal$.MODULE$.apply(entity).to(Unmarshaller$.MODULE$.stringUnmarshaller(), (ExecutionContext)$this.system.dispatcher(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)$this.system)).foreach((Function1 & Serializable)body -> {
                        KubernetesApiServiceDiscovery.$anonfun$lookup$6(this, statusCode, body);
                        return BoxedUnit.UNIT;
                    }, (ExecutionContext)$this.system.dispatcher());
                    future = Future$.MODULE$.failed((Throwable)new KubernetesApiException(new StringBuilder(36).append("Non-200 from Kubernetes API server: ").append(statusCode).toString()));
                }
            }
            return future.map((Function1 & Serializable)podList -> {
                Seq<ServiceDiscovery.ResolvedTarget> addresses;
                block0: {
                    addresses = KubernetesApiServiceDiscovery$.MODULE$.targets((PodList)podList, (Option<String>)query.portName(), this.podNamespace(), this.settings().podDomain(), this.settings().rawIp(), this.settings().containerName());
                    if (!addresses.isEmpty() || !podList.items().nonEmpty() || !this.log().isInfoEnabled()) break block0;
                    Set containerPortNames = ((IterableOnceOps)((IterableOps)((IterableOps)((IterableOps)podList.items().flatMap((Function1 & Serializable)x$4 -> x$4.spec())).flatMap((Function1 & Serializable)x$5 -> x$5.containers())).flatMap((Function1 & Serializable)x$6 -> x$6.ports())).flatten(Predef$.MODULE$.$conforms())).toSet();
                    this.log().info("No targets found from pod list. Is the correct port name configured? Current configuration: [{}]. Ports on pods: [{}]", (Object)query.portName(), (Object)containerPortNames);
                }
                return ServiceDiscovery.Resolved$.MODULE$.apply(query.serviceName(), addresses);
            }, (ExecutionContext)$this.system.dispatcher());
        }, (ExecutionContext)$this.system.dispatcher()), (ExecutionContext)$this.system.dispatcher()), (ExecutionContext)this.system.dispatcher());
    }

    private String apiToken() {
        return this.apiToken;
    }

    private String podNamespace() {
        return this.podNamespace;
    }

    private Option<String> readConfigVarFromFilesystem(String path, String name) {
        Some some;
        Path file = Paths.get(path, new String[0]);
        if (Files.exists(file, new LinkOption[0])) {
            try {
                some = new Some((Object)new String(Files.readAllBytes(file), "utf-8"));
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                this.log().error(e, "Error reading {} from {}", (Object)name, (Object)path);
                None$ none$ = None$.MODULE$;
                some = none$;
            }
        } else {
            this.log().warning("Unable to read {} from {} because it doesn't exist.", (Object)name, (Object)path);
            some = None$.MODULE$;
        }
        return some;
    }

    private <T> Future<T> optionToFuture(Option<T> option, String failMsg) {
        return (Future)option.fold((Function0 & Serializable)() -> Future$.MODULE$.failed((Throwable)new NoSuchElementException(failMsg)), (Function1 & Serializable)result -> Future$.MODULE$.successful(result));
    }

    private Option<HttpRequest> podRequest(String token, String namespace, String labelSelector) {
        return package$.MODULE$.env().get((Object)this.settings().apiServiceHostEnvName()).flatMap((Function1 & Serializable)host -> package$.MODULE$.env().get((Object)this.settings().apiServicePortEnvName()).flatMap((Function1 & Serializable)portStr -> Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(portStr))).toOption().map((Function1 & Serializable)port -> KubernetesApiServiceDiscovery.$anonfun$podRequest$4(namespace, labelSelector, host, token, BoxesRunTime.unboxToInt((Object)port)))));
    }

    public static final /* synthetic */ void $anonfun$lookup$4(KubernetesApiServiceDiscovery $this, HttpResponse response$1, HttpEntity.Strict entity$1, Throwable t) {
        $this.log().warning("Failed to unmarshal Kubernetes API response.  Status code: [{}]; Response body: [{}]. Ex: [{}]", (Object)response$1.status().value(), (Object)entity$1, (Object)t.getMessage());
    }

    public static final /* synthetic */ void $anonfun$lookup$5(KubernetesApiServiceDiscovery $this, String body) {
        $this.log().warning("Forbidden to communicate with Kubernetes API server; check RBAC settings. Response: [{}]", (Object)body);
    }

    public static final /* synthetic */ void $anonfun$lookup$6(KubernetesApiServiceDiscovery $this, StatusCode x1$1, String body) {
        $this.log().warning("Non-200 when communicating with Kubernetes API server. Status code: [{}]. Response body: [{}]", (Object)x1$1, (Object)body);
    }

    public static final /* synthetic */ HttpRequest $anonfun$podRequest$4(String namespace$1, String labelSelector$1, String host$1, String token$1, int port) {
        Uri uri;
        Uri.Path path = Uri.Path$.Empty$.MODULE$.$div("api").$div("v1").$div("namespaces").$div(namespace$1).$div("pods");
        Uri.Query query = Uri.Query$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"labelSelector"), (Object)labelSelector$1)}));
        String x$1 = "https";
        String x$2 = host$1;
        int x$3 = port;
        String x$4 = Uri$.MODULE$.from$default$2();
        String x$5 = Uri$.MODULE$.from$default$5();
        Option x$6 = Uri$.MODULE$.from$default$6();
        Option x$7 = Uri$.MODULE$.from$default$7();
        Uri.ParsingMode x$8 = Uri$.MODULE$.from$default$8();
        Uri x$9 = uri = Uri$.MODULE$.from("https", x$4, x$2, x$3, x$5, x$6, x$7, x$8).withPath(path).withQuery(query);
        Seq x$10 = (Seq)new .colon.colon((Object)new Authorization((HttpCredentials)new OAuth2BearerToken(token$1)), (List)Nil$.MODULE$);
        HttpMethod x$11 = HttpRequest$.MODULE$.apply$default$1();
        RequestEntity x$12 = HttpRequest$.MODULE$.apply$default$4();
        HttpProtocol x$13 = HttpRequest$.MODULE$.apply$default$5();
        return HttpRequest$.MODULE$.apply(x$11, x$9, x$10, x$12, x$13);
    }

    public KubernetesApiServiceDiscovery(ActorSystem system) {
        this.system = system;
        this.http = Http$.MODULE$.apply((ClassicActorSystemProvider)system);
        this.settings = (Settings)Settings$.MODULE$.apply(system);
        this.log = Logging$.MODULE$.apply(system, (Object)this.getClass(), LogSource$.MODULE$.fromAnyClass());
        Certificate certificate = PemManagersProvider$.MODULE$.loadCertificate(this.settings().apiCaPath());
        KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        keyStore.load(null);
        factory.init(keyStore, (char[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Char()));
        KeyManager[] km = factory.getKeyManagers();
        TrustManager[] tm = PemManagersProvider$.MODULE$.buildTrustManagers(certificate);
        SecureRandom random = new SecureRandom();
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        sslContext.init(km, tm, random);
        this.sslContext = sslContext;
        this.clientSslContext = ConnectionContext$.MODULE$.httpsClient(this.sslContext());
        this.log().debug("Settings {}", (Object)this.settings());
        this.apiToken = (String)this.readConfigVarFromFilesystem(this.settings().apiTokenPath(), "api-token").getOrElse((Function0 & Serializable)() -> "");
        this.podNamespace = (String)this.settings().podNamespace().orElse((Function0 & Serializable)() -> this.readConfigVarFromFilesystem(this.settings().podNamespacePath(), "pod-namespace")).getOrElse((Function0 & Serializable)() -> "default");
    }

    public static class KubernetesApiException
    extends RuntimeException
    implements NoStackTrace {
        public /* synthetic */ Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        @Override
        public Throwable fillInStackTrace() {
            return NoStackTrace.fillInStackTrace$((NoStackTrace)this);
        }

        public KubernetesApiException(String msg) {
            super(msg);
            NoStackTrace.$init$((NoStackTrace)this);
        }
    }
}

