/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.s3.impl.auth;

import akka.NotUsed;
import akka.NotUsed$;
import akka.annotation.InternalApi;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.headers.RawHeader;
import akka.stream.alpakka.s3.impl.auth.CanonicalRequest;
import akka.stream.alpakka.s3.impl.auth.CanonicalRequest$;
import akka.stream.alpakka.s3.impl.auth.SigningKey;
import akka.stream.alpakka.s3.impl.auth.package$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import java.io.Serializable;
import java.security.MessageDigest;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import scala.Function1;
import scala.Option;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

@InternalApi
public final class Signer$ {
    public static final Signer$ MODULE$ = new Signer$();
    private static final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmssX");

    private DateTimeFormatter dateFormatter() {
        return dateFormatter;
    }

    public Source<HttpRequest, NotUsed> signedRequest(HttpRequest request, SigningKey key, boolean signAnonymousRequests) {
        if (!signAnonymousRequests && key.anonymous()) {
            return Source$.MODULE$.single((Object)request);
        }
        Source hashedBody = (Source)request.entity().dataBytes().via(package$.MODULE$.digest(package$.MODULE$.digest$default$1())).map((Function1 & Serializable)hash -> package$.MODULE$.encodeHex((byte[])hash.toArray((ClassTag)ClassTag$.MODULE$.Byte())));
        return ((Source)hashedBody.map((Function1 & Serializable)hb -> {
            Vector headersToAdd = (Vector)((IterableOps)scala.package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new RawHeader[]{new RawHeader("x-amz-date", key.requestDate().format(MODULE$.dateFormatter())), new RawHeader("x-amz-content-sha256", hb)}))).$plus$plus(MODULE$.sessionHeader(key));
            HttpRequest reqWithHeaders = request.withHeaders((Seq)request.headers().$plus$plus((IterableOnce)headersToAdd));
            CanonicalRequest cr = CanonicalRequest$.MODULE$.from(reqWithHeaders);
            HttpHeader authHeader = MODULE$.authorizationHeader("AWS4-HMAC-SHA256", key, key.requestDate(), cr);
            return reqWithHeaders.withHeaders((Seq)reqWithHeaders.headers().$colon$plus((Object)authHeader));
        })).mapMaterializedValue((Function1 & Serializable)x$1 -> NotUsed$.MODULE$);
    }

    private Option<HttpHeader> sessionHeader(SigningKey key) {
        return key.sessionToken().map((Function1 & Serializable)x$2 -> new RawHeader("X-Amz-Security-Token", x$2));
    }

    private HttpHeader authorizationHeader(String algorithm, SigningKey key, ZonedDateTime requestDate, CanonicalRequest canonicalRequest) {
        return new RawHeader("Authorization", this.authorizationString(algorithm, key, requestDate, canonicalRequest));
    }

    private String authorizationString(String algorithm, SigningKey key, ZonedDateTime requestDate, CanonicalRequest canonicalRequest) {
        String sign = key.hexEncodedSignature(this.stringToSign(algorithm, key, requestDate, canonicalRequest).getBytes());
        return new StringBuilder(40).append(algorithm).append(" Credential=").append(key.credentialString()).append(", SignedHeaders=").append(canonicalRequest.signedHeaders()).append(", Signature=").append(sign).toString();
    }

    public String stringToSign(String algorithm, SigningKey signingKey, ZonedDateTime requestDate, CanonicalRequest canonicalRequest) {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        String hashedRequest = package$.MODULE$.encodeHex(digest.digest(canonicalRequest.canonicalString().getBytes()));
        String date = requestDate.format(this.dateFormatter());
        String scope = signingKey.scope().scopeString();
        return new StringBuilder(3).append(algorithm).append("\n").append(date).append("\n").append(scope).append("\n").append(hashedRequest).toString();
    }

    private Signer$() {
    }
}

