/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.s3.impl;

import akka.NotUsed;
import akka.NotUsed$;
import akka.annotation.InternalApi;
import akka.dispatch.ExecutionContexts$;
import akka.stream.ActorAttributes$;
import akka.stream.Attributes;
import akka.stream.Attributes$;
import akka.stream.FlowShape;
import akka.stream.FlowShape$;
import akka.stream.Inlet;
import akka.stream.Inlet$;
import akka.stream.Outlet;
import akka.stream.Outlet$;
import akka.stream.alpakka.s3.impl.Chunk;
import akka.stream.alpakka.s3.impl.DiskBuffer$;
import akka.stream.alpakka.s3.impl.DiskChunk;
import akka.stream.scaladsl.FileIO$;
import akka.stream.scaladsl.Source;
import akka.stream.stage.GraphStage;
import akka.stream.stage.GraphStageLogic;
import akka.stream.stage.InHandler;
import akka.stream.stage.OutHandler;
import akka.util.ByteString;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.BufferOverflowException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicInteger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u000514Q!\u0004\b\u0003\u001daA\u0001\"\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\tk\u0001\u0011\t\u0011)A\u0005_!Aa\u0007\u0001B\u0001B\u0003%q\u0007C\u0003E\u0001\u0011\u0005Q\tC\u0004K\u0001\t\u0007I\u0011A&\t\r=\u0003\u0001\u0015!\u0003M\u0011\u001d\u0001\u0006A1A\u0005\u0002ECa!\u0016\u0001!\u0002\u0013\u0011\u0006b\u0002,\u0001\u0005\u0004%\te\u0016\u0005\u00071\u0002\u0001\u000b\u0011B\u0010\t\u000be\u0003A\u0011\t.\t\u000by\u0003A\u0011I0\u0003\u0015\u0011K7o\u001b\"vM\u001a,'O\u0003\u0002\u0010!\u0005!\u0011.\u001c9m\u0015\t\t\"#\u0001\u0002tg)\u00111\u0003F\u0001\bC2\u0004\u0018m[6b\u0015\t)b#\u0001\u0004tiJ,\u0017-\u001c\u0006\u0002/\u0005!\u0011m[6b'\t\u0001\u0011\u0004E\u0002\u001b;}i\u0011a\u0007\u0006\u00039Q\tQa\u001d;bO\u0016L!AH\u000e\u0003\u0015\u001d\u0013\u0018\r\u001d5Ti\u0006<W\r\u0005\u0003!C\rJS\"\u0001\u000b\n\u0005\t\"\"!\u0003$m_^\u001c\u0006.\u00199f!\t!s%D\u0001&\u0015\t1c#\u0001\u0003vi&d\u0017B\u0001\u0015&\u0005)\u0011\u0015\u0010^3TiJLgn\u001a\t\u0003U-j\u0011AD\u0005\u0003Y9\u0011Qa\u00115v].\f1#\\1y\u001b\u0006$XM]5bY&T\u0018\r^5p]N\u001c\u0001\u0001\u0005\u00021g5\t\u0011GC\u00013\u0003\u0015\u00198-\u00197b\u0013\t!\u0014GA\u0002J]R\fq!\\1y'&TX-\u0001\u0005uK6\u0004\b+\u0019;i!\r\u0001\u0004HO\u0005\u0003sE\u0012aa\u00149uS>t\u0007CA\u001eC\u001b\u0005a$BA\u001f?\u0003\u00111\u0017\u000e\\3\u000b\u0005}\u0002\u0015a\u00018j_*\t\u0011)\u0001\u0003kCZ\f\u0017BA\"=\u0005\u0011\u0001\u0016\r\u001e5\u0002\rqJg.\u001b;?)\u00111u\tS%\u0011\u0005)\u0002\u0001\"B\u0017\u0005\u0001\u0004y\u0003\"B\u001b\u0005\u0001\u0004y\u0003\"\u0002\u001c\u0005\u0001\u00049\u0014AA5o+\u0005a\u0005c\u0001\u0011NG%\u0011a\n\u0006\u0002\u0006\u0013:dW\r^\u0001\u0004S:\u0004\u0013aA8viV\t!\u000bE\u0002!'&J!\u0001\u0016\u000b\u0003\r=+H\u000f\\3u\u0003\u0011yW\u000f\u001e\u0011\u0002\u000bMD\u0017\r]3\u0016\u0003}\taa\u001d5ba\u0016\u0004\u0013!E5oSRL\u0017\r\\!uiJL'-\u001e;fgV\t1\f\u0005\u0002!9&\u0011Q\f\u0006\u0002\u000b\u0003R$(/\u001b2vi\u0016\u001c\u0018aC2sK\u0006$X\rT8hS\u000e$\"\u0001Y2\u0011\u0005i\t\u0017B\u00012\u001c\u0005=9%/\u00199i'R\fw-\u001a'pO&\u001c\u0007\"\u00023\r\u0001\u0004Y\u0016\u0001B1uiJD#\u0001\u00014\u0011\u0005\u001dTW\"\u00015\u000b\u0005%4\u0012AC1o]>$\u0018\r^5p]&\u00111\u000e\u001b\u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018\u000e")
@InternalApi
public final class DiskBuffer
extends GraphStage<FlowShape<ByteString, Chunk>> {
    public final int akka$stream$alpakka$s3$impl$DiskBuffer$$maxMaterializations;
    public final int akka$stream$alpakka$s3$impl$DiskBuffer$$maxSize;
    public final Option<Path> akka$stream$alpakka$s3$impl$DiskBuffer$$tempPath;
    private final Inlet<ByteString> in;
    private final Outlet<Chunk> out;
    private final FlowShape<ByteString, Chunk> shape;

    public Inlet<ByteString> in() {
        return this.in;
    }

    public Outlet<Chunk> out() {
        return this.out;
    }

    public FlowShape<ByteString, Chunk> shape() {
        return this.shape;
    }

    public Attributes initialAttributes() {
        return super.initialAttributes().and(Attributes$.MODULE$.name("DiskBuffer")).and((Attributes.Attribute)ActorAttributes$.MODULE$.IODispatcher());
    }

    public GraphStageLogic createLogic(Attributes attr) {
        return new OutHandler(this){
            private final File path;
            private int length;
            private final FileOutputStream pathOut;
            private final /* synthetic */ DiskBuffer $outer;

            public void onUpstreamFailure(Throwable ex) throws Exception {
                InHandler.onUpstreamFailure$((InHandler)this, (Throwable)ex);
            }

            public void onDownstreamFinish() throws Exception {
                OutHandler.onDownstreamFinish$((OutHandler)this);
            }

            public void onDownstreamFinish(Throwable cause) throws Exception {
                OutHandler.onDownstreamFinish$((OutHandler)this, (Throwable)cause);
            }

            private File path() {
                return this.path;
            }

            private int length() {
                return this.length;
            }

            private void length_$eq(int x$1) {
                this.length = x$1;
            }

            private FileOutputStream pathOut() {
                return this.pathOut;
            }

            public void onPull() {
                if (this.isClosed(this.$outer.in())) {
                    this.emit();
                    return;
                }
                this.pull(this.$outer.in());
            }

            public void onPush() {
                ByteString elem = (ByteString)this.grab(this.$outer.in());
                this.length_$eq(this.length() + elem.size());
                if (this.length() > this.$outer.akka$stream$alpakka$s3$impl$DiskBuffer$$maxSize) {
                    throw new BufferOverflowException();
                }
                this.pathOut().write((byte[])elem.toArray((ClassTag)ClassTag$.MODULE$.Byte()));
                this.pull(this.$outer.in());
            }

            public void onUpstreamFinish() {
                if (this.isAvailable(this.$outer.out())) {
                    this.emit();
                }
                this.completeStage();
            }

            public void postStop() {
                try {
                    this.pathOut().close();
                }
                catch (Throwable throwable) {}
            }

            private void emit() {
                this.pathOut().close();
                AtomicInteger deleteCounter = new AtomicInteger(this.$outer.akka$stream$alpakka$s3$impl$DiskBuffer$$maxMaterializations);
                Source src = FileIO$.MODULE$.fromPath(this.path().toPath(), 65536).mapMaterializedValue((Function1 & Serializable)f -> {
                    block0: {
                        if (deleteCounter.decrementAndGet() > 0) break block0;
                        f.onComplete((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$emit$2(this, x$1)), ExecutionContexts$.MODULE$.parasitic());
                    }
                    return NotUsed$.MODULE$;
                });
                this.emit(this.$outer.out(), new DiskChunk((Source<ByteString, NotUsed>)src, this.length()), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.completeStage());
            }

            public static final /* synthetic */ boolean $anonfun$emit$2($anon$1 $this, Try x$1) {
                return $this.path().delete();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.shape());
                OutHandler.$init$((OutHandler)this);
                InHandler.$init$((InHandler)this);
                this.path = ((Path)$outer.akka$stream$alpakka$s3$impl$DiskBuffer$$tempPath.map((Function1 & Serializable)dir -> Files.createTempFile(dir, "s3-buffer-", ".bin", new FileAttribute[0])).getOrElse((Function0 & Serializable)() -> Files.createTempFile("s3-buffer-", ".bin", new FileAttribute[0]))).toFile();
                this.path().deleteOnExit();
                this.length = 0;
                this.pathOut = new FileOutputStream(this.path());
                this.setHandlers($outer.in(), $outer.out(), this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$emit$1(akka.stream.alpakka.s3.impl.DiskBuffer$$anon$1 java.util.concurrent.atomic.AtomicInteger scala.concurrent.Future ), $anonfun$emit$2$adapted(akka.stream.alpakka.s3.impl.DiskBuffer$$anon$1 scala.util.Try ), $anonfun$emit$3(akka.stream.alpakka.s3.impl.DiskBuffer$$anon$1 ), $anonfun$path$1(java.nio.file.Path ), $anonfun$path$2()}, serializedLambda);
            }
        };
    }

    public DiskBuffer(int maxMaterializations, int maxSize, Option<Path> tempPath) {
        this.akka$stream$alpakka$s3$impl$DiskBuffer$$maxMaterializations = maxMaterializations;
        this.akka$stream$alpakka$s3$impl$DiskBuffer$$maxSize = maxSize;
        this.akka$stream$alpakka$s3$impl$DiskBuffer$$tempPath = tempPath;
        Predef$.MODULE$.require(maxMaterializations > 0, (Function0 & Serializable)() -> "maxMaterializations should be at least 1");
        Predef$.MODULE$.require(maxSize > 0, (Function0 & Serializable)() -> "maximumSize should be at least 1");
        this.in = Inlet$.MODULE$.apply("DiskBuffer.in");
        this.out = Outlet$.MODULE$.apply("DiskBuffer.out");
        this.shape = FlowShape$.MODULE$.of(this.in(), this.out());
    }
}

