/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.s3.headers;

import akka.annotation.InternalApi;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.headers.RawHeader;
import akka.stream.alpakka.s3.headers.ServerSideEncryption;
import akka.stream.alpakka.s3.impl.InitiateMultipartUpload$;
import akka.stream.alpakka.s3.impl.PutObject$;
import akka.stream.alpakka.s3.impl.S3Request;
import java.io.Serializable;
import java.util.Objects;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005]a\u0001\u0002\t\u0012\u0005qA\u0001\"\t\u0001\u0003\u0006\u0004%\tA\t\u0005\ta\u0001\u0011\t\u0011)A\u0005G!A\u0011\u0007\u0001BC\u0002\u0013\u0005!\u0007\u0003\u00058\u0001\t\u0005\t\u0015!\u00034\u0011\u0019A\u0004\u0001\"\u0001\u0012s!1!\u0003\u0001C!'uBaa\u0016\u0001\u0005BMA\u0006\"\u00022\u0001\t\u0003\u0019\u0007\"B3\u0001\t\u00031\u0007\"\u00025\u0001\t\u0013I\u0007b\u00027\u0001#\u0003%I!\u001c\u0005\bo\u0002\t\n\u0011\"\u0003y\u0011\u0015Q\b\u0001\"\u0011|\u0011\u0015a\b\u0001\"\u0011~\u0011\u001d\ti\u0001\u0001C!\u0003\u001f\u00111aS'T\u0015\t\u00112#A\u0004iK\u0006$WM]:\u000b\u0005Q)\u0012AA:4\u0015\t1r#A\u0004bYB\f7n[1\u000b\u0005aI\u0012AB:ue\u0016\fWNC\u0001\u001b\u0003\u0011\t7n[1\u0004\u0001M\u0011\u0001!\b\t\u0003=}i\u0011!E\u0005\u0003AE\u0011AcU3sm\u0016\u00148+\u001b3f\u000b:\u001c'/\u001f9uS>t\u0017!B6fs&#W#A\u0012\u0011\u0005\u0011jcBA\u0013,!\t1\u0013&D\u0001(\u0015\tA3$\u0001\u0004=e>|GO\u0010\u0006\u0002U\u0005)1oY1mC&\u0011A&K\u0001\u0007!J,G-\u001a4\n\u00059z#AB*ue&twM\u0003\u0002-S\u000511.Z=JI\u0002\nqaY8oi\u0016DH/F\u00014!\r!TgI\u0007\u0002S%\u0011a'\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u0011\r|g\u000e^3yi\u0002\na\u0001P5oSRtDc\u0001\u001e<yA\u0011a\u0004\u0001\u0005\u0006C\u0015\u0001\ra\t\u0005\u0006c\u0015\u0001\raM\u000b\u0002}A\u0019q\b\u0012$\u000e\u0003\u0001S!!\u0011\"\u0002\u0013%lW.\u001e;bE2,'BA\"*\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u000b\u0002\u00131aU3r!\t9e*D\u0001I\u0015\tI%*A\u0003n_\u0012,GN\u0003\u0002L\u0019\u0006A1oY1mC\u0012\u001cHN\u0003\u0002N3\u0005!\u0001\u000e\u001e;q\u0013\ty\u0005J\u0001\u0006IiR\u0004\b*Z1eKJD#AB)\u0011\u0005I+V\"A*\u000b\u0005QK\u0012AC1o]>$\u0018\r^5p]&\u0011ak\u0015\u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018.\u0001\u0006iK\u0006$WM]:G_J$\"AP-\t\u000bi;\u0001\u0019A.\u0002\u000fI,\u0017/^3tiB\u0011AlX\u0007\u0002;*\u0011alE\u0001\u0005S6\u0004H.\u0003\u0002a;\nI1k\r*fcV,7\u000f\u001e\u0015\u0003\u000fE\u000b\u0011b^5uQ.+\u00170\u00133\u0015\u0005i\"\u0007\"B\u0011\t\u0001\u0004\u0019\u0013aC<ji\"\u001cuN\u001c;fqR$\"AO4\t\u000bEJ\u0001\u0019A\u0012\u0002\t\r|\u0007/\u001f\u000b\u0004u)\\\u0007bB\u0011\u000b!\u0003\u0005\ra\t\u0005\bc)\u0001\n\u00111\u00014\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012A\u001c\u0016\u0003G=\\\u0013\u0001\u001d\t\u0003cVl\u0011A\u001d\u0006\u0003gR\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005QK\u0013B\u0001<s\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\u0005I(FA\u001ap\u0003!!xn\u0015;sS:<G#A\u0012\u0002\r\u0015\fX/\u00197t)\rq\u00181\u0001\t\u0003i}L1!!\u0001*\u0005\u001d\u0011un\u001c7fC:Dq!!\u0002\u000f\u0001\u0004\t9!A\u0003pi\",'\u000fE\u00025\u0003\u0013I1!a\u0003*\u0005\r\te._\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011\u0011\u0003\t\u0004i\u0005M\u0011bAA\u000bS\t\u0019\u0011J\u001c;")
public final class KMS
extends ServerSideEncryption {
    private final String keyId;
    private final Option<String> context;

    public String keyId() {
        return this.keyId;
    }

    public Option<String> context() {
        return this.context;
    }

    @Override
    @InternalApi
    public Seq<HttpHeader> headers() {
        RawHeader rawHeader = new RawHeader("x-amz-server-side-encryption", "aws:kms");
        RawHeader rawHeader2 = new RawHeader("x-amz-server-side-encryption-aws-kms-key-id", this.keyId());
        List baseHeaders = Nil$.MODULE$.$colon$colon((Object)rawHeader2).$colon$colon((Object)rawHeader);
        List headers = (List)baseHeaders.$plus$plus((IterableOnce)Option$.MODULE$.option2Iterable(this.context().map((Function1 & Serializable)ctx -> new RawHeader("x-amz-server-side-encryption-context", ctx))).toSeq());
        return headers;
    }

    @Override
    @InternalApi
    public Seq<HttpHeader> headersFor(S3Request request) {
        S3Request s3Request = request;
        if (PutObject$.MODULE$.equals(s3Request) ? true : InitiateMultipartUpload$.MODULE$.equals(s3Request)) {
            return this.headers();
        }
        return Nil$.MODULE$;
    }

    public KMS withKeyId(String keyId) {
        return this.copy(keyId, this.copy$default$2());
    }

    public KMS withContext(String context) {
        Some x$1 = new Some((Object)context);
        String x$2 = this.copy$default$1();
        return this.copy(x$2, (Option<String>)x$1);
    }

    private KMS copy(String keyId, Option<String> context) {
        return new KMS(keyId, context);
    }

    private String copy$default$1() {
        return this.keyId();
    }

    private Option<String> copy$default$2() {
        return this.context();
    }

    public String toString() {
        return new StringBuilder(41).append("ServerSideEncryption.KMS(").append("keyId=").append(this.keyId()).append(",").append("context=").append(this.context()).append(")").toString();
    }

    public boolean equals(Object other) {
        Object object = other;
        if (object instanceof KMS) {
            KMS kMS = (KMS)object;
            return Objects.equals(this.keyId(), kMS.keyId()) && Objects.equals(this.context(), kMS.context());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.keyId(), this.context());
    }

    public KMS(String keyId, Option<String> context) {
        this.keyId = keyId;
        this.context = context;
    }
}

