/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.s3.impl;

import akka.Done;
import akka.Done$;
import akka.NotUsed;
import akka.NotUsed$;
import akka.actor.ActorSystem;
import akka.annotation.InternalApi;
import akka.dispatch.ExecutionContexts;
import akka.event.LoggingAdapter;
import akka.http.javadsl.model.HttpHeader;
import akka.http.javadsl.model.ResponseEntity;
import akka.http.scaladsl.ClientTransport;
import akka.http.scaladsl.ClientTransport$;
import akka.http.scaladsl.Http$;
import akka.http.scaladsl.HttpExt;
import akka.http.scaladsl.HttpsConnectionContext;
import akka.http.scaladsl.model.ContentType;
import akka.http.scaladsl.model.ContentTypes$;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpEntity$;
import akka.http.scaladsl.model.HttpMethod;
import akka.http.scaladsl.model.HttpMethods$;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.model.HttpResponse$;
import akka.http.scaladsl.model.OptHttpResponse$;
import akka.http.scaladsl.model.StatusCode;
import akka.http.scaladsl.model.StatusCodes;
import akka.http.scaladsl.model.StatusCodes$;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.model.headers.BasicHttpCredentials;
import akka.http.scaladsl.model.headers.ByteRange;
import akka.http.scaladsl.model.headers.ByteRange$;
import akka.http.scaladsl.model.headers.Content$minusLength$;
import akka.http.scaladsl.model.headers.Content$minusType$;
import akka.http.scaladsl.model.headers.HttpCredentials;
import akka.http.scaladsl.model.headers.Range$;
import akka.http.scaladsl.settings.ClientConnectionSettings;
import akka.http.scaladsl.settings.ClientConnectionSettings$;
import akka.http.scaladsl.settings.ConnectionPoolSettings;
import akka.http.scaladsl.settings.ConnectionPoolSettings$;
import akka.http.scaladsl.unmarshalling.Unmarshal$;
import akka.http.scaladsl.unmarshalling.Unmarshaller;
import akka.http.scaladsl.unmarshalling.Unmarshaller$;
import akka.stream.ActorMaterializer;
import akka.stream.Attributes;
import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.alpakka.s3.BucketAccess;
import akka.stream.alpakka.s3.BucketAccess$AccessDenied$;
import akka.stream.alpakka.s3.BucketAccess$AccessGranted$;
import akka.stream.alpakka.s3.BucketAccess$NotExists$;
import akka.stream.alpakka.s3.BufferType;
import akka.stream.alpakka.s3.DiskBufferType;
import akka.stream.alpakka.s3.FailedUpload$;
import akka.stream.alpakka.s3.ListBucketResultCommonPrefixes;
import akka.stream.alpakka.s3.ListBucketResultContents;
import akka.stream.alpakka.s3.MemoryBufferType$;
import akka.stream.alpakka.s3.MultipartUploadResult;
import akka.stream.alpakka.s3.MultipartUploadResult$;
import akka.stream.alpakka.s3.ObjectMetadata;
import akka.stream.alpakka.s3.ObjectMetadata$;
import akka.stream.alpakka.s3.RetrySettings;
import akka.stream.alpakka.s3.S3Exception;
import akka.stream.alpakka.s3.S3Exception$;
import akka.stream.alpakka.s3.S3Ext;
import akka.stream.alpakka.s3.S3Ext$;
import akka.stream.alpakka.s3.S3Headers;
import akka.stream.alpakka.s3.S3Settings;
import akka.stream.alpakka.s3.S3SettingsPath;
import akka.stream.alpakka.s3.S3SettingsValue;
import akka.stream.alpakka.s3.headers.ServerSideEncryption;
import akka.stream.alpakka.s3.impl.CheckBucket$;
import akka.stream.alpakka.s3.impl.Chunk;
import akka.stream.alpakka.s3.impl.CompleteMultipartUploadResult;
import akka.stream.alpakka.s3.impl.CopyPart$;
import akka.stream.alpakka.s3.impl.CopyPartition;
import akka.stream.alpakka.s3.impl.CopyPartition$;
import akka.stream.alpakka.s3.impl.DeleteBucket$;
import akka.stream.alpakka.s3.impl.DeleteObject$;
import akka.stream.alpakka.s3.impl.DiskBuffer;
import akka.stream.alpakka.s3.impl.FailedUploadPart;
import akka.stream.alpakka.s3.impl.GetObject$;
import akka.stream.alpakka.s3.impl.HeadObject$;
import akka.stream.alpakka.s3.impl.HttpRequests$;
import akka.stream.alpakka.s3.impl.InitiateMultipartUpload$;
import akka.stream.alpakka.s3.impl.ListBucket$;
import akka.stream.alpakka.s3.impl.ListBucketResult;
import akka.stream.alpakka.s3.impl.MakeBucket$;
import akka.stream.alpakka.s3.impl.Marshalling$;
import akka.stream.alpakka.s3.impl.MemoryBuffer;
import akka.stream.alpakka.s3.impl.MultipartCopy;
import akka.stream.alpakka.s3.impl.MultipartUpload;
import akka.stream.alpakka.s3.impl.PutObject$;
import akka.stream.alpakka.s3.impl.S3Location;
import akka.stream.alpakka.s3.impl.S3Stream;
import akka.stream.alpakka.s3.impl.S3Stream$Finished$;
import akka.stream.alpakka.s3.impl.S3Stream$Starting$;
import akka.stream.alpakka.s3.impl.SplitAfterSize$;
import akka.stream.alpakka.s3.impl.SuccessfulUploadPart;
import akka.stream.alpakka.s3.impl.UploadPart$;
import akka.stream.alpakka.s3.impl.UploadPartResponse;
import akka.stream.alpakka.s3.impl.auth.CredentialScope;
import akka.stream.alpakka.s3.impl.auth.Signer$;
import akka.stream.alpakka.s3.impl.auth.SigningKey;
import akka.stream.alpakka.s3.impl.auth.SigningKey$;
import akka.stream.alpakka.s3.impl.backport.RetryFlow$;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.FlowOps;
import akka.stream.scaladsl.Keep$;
import akka.stream.scaladsl.RunnableGraph;
import akka.stream.scaladsl.Sink;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import akka.stream.scaladsl.SubFlow;
import akka.stream.stage.GraphStage;
import akka.util.ByteString;
import akka.util.ByteString$;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@InternalApi
public final class S3Stream$ {
    public static final S3Stream$ MODULE$ = new S3Stream$();
    private static final int MinChunkSize = 0x500000;
    private static final Flow<ByteString, ByteString, NotUsed> atLeastOneByteString = (Flow)Flow$.MODULE$.apply().orElse((Graph)Source$.MODULE$.single((Object)ByteString$.MODULE$.empty()));

    public int MinChunkSize() {
        return MinChunkSize;
    }

    public SigningKey signingKey(S3Settings settings) {
        ZonedDateTime requestDate = ZonedDateTime.now(ZoneOffset.UTC);
        return new SigningKey(requestDate, settings.credentialsProvider(), new CredentialScope(requestDate.toLocalDate(), settings.s3RegionProvider().getRegion(), "s3"), SigningKey$.MODULE$.apply$default$4());
    }

    public Source<Option<Tuple2<Source<ByteString, NotUsed>, ObjectMetadata>>, NotUsed> download(S3Location s3Location, Option<ByteRange> range, Option<String> versionId2, S3Headers s3Headers) {
        Seq<akka.http.scaladsl.model.HttpHeader> headers = s3Headers.headersFor(GetObject$.MODULE$);
        return Source$.MODULE$.setup((Function2 & Serializable)(mat, attr) -> {
            ActorMaterializer materializer = mat;
            S3Location x$1 = s3Location;
            Option x$2 = range;
            Option x$3 = versionId2;
            Seq x$4 = headers;
            HttpMethod x$5 = MODULE$.issueRequest$default$2();
            ActorMaterializer x$6 = mat;
            Attributes x$7 = attr;
            return (Source)MODULE$.issueRequest(x$1, x$5, (Option<ByteRange>)x$2, (Option<String>)x$3, (Seq<akka.http.scaladsl.model.HttpHeader>)x$4, x$6, x$7).map((Function1 & Serializable)response -> response.withEntity((ResponseEntity)response.entity().withoutSizeLimit())).mapAsync(1, (Function1 & Serializable)resp -> MODULE$.entityForSuccess((HttpResponse)resp, (Materializer)materializer)).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                akka.http.scaladsl.model.ResponseEntity entity = (akka.http.scaladsl.model.ResponseEntity)tuple2._1();
                Seq headers = (Seq)tuple2._2();
                Option option = Option$.MODULE$.apply((Object)new Tuple2((Object)entity.dataBytes().mapMaterializedValue((Function1 & Serializable)x$1 -> NotUsed$.MODULE$), (Object)MODULE$.computeMetaData((Seq<akka.http.scaladsl.model.HttpHeader>)headers, entity)));
                return option;
            }).recover((PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof S3Exception) {
                        S3Exception s3Exception = (S3Exception)A1;
                        String string = s3Exception.code();
                        String string2 = "NoSuchKey";
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            object = None$.MODULE$;
                            return (B1)object;
                        }
                    }
                    object = function1.apply(x1);
                    return (B1)object;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    if (!(throwable instanceof S3Exception)) return false;
                    S3Exception s3Exception = (S3Exception)throwable;
                    String string = s3Exception.code();
                    String string2 = "NoSuchKey";
                    if (string != null) {
                        if (!string.equals(string2)) return false;
                        return true;
                    }
                    if (string2 == null) return true;
                    return false;
                }
            });
        }).mapMaterializedValue((Function1 & Serializable)x$2 -> NotUsed$.MODULE$);
    }

    public <T> Future<Option<Tuple2<S3Stream.ListBucketState, T>>> listBucketCall(String bucket, Option<String> prefix, Option<String> delimiter, S3Headers s3Headers, Option<String> token, Function1<ListBucketResult, T> resultTransformer, ActorMaterializer mat, Attributes attr) {
        S3Settings conf = this.resolveSettings(attr, mat.system());
        return this.signAndGetAs(HttpRequests$.MODULE$.listBucket(bucket, prefix, token, delimiter, s3Headers.headersFor(ListBucket$.MODULE$), conf), Marshalling$.MODULE$.listBucketResultUnmarshaller(), mat, attr).map((Function1 & Serializable)res -> new Some(res.continuationToken().fold((Function0 & Serializable)() -> new Tuple2((Object)S3Stream$Finished$.MODULE$, resultTransformer.apply(res)), (Function1 & Serializable)t -> new Tuple2((Object)new S3Stream.Running((String)t), resultTransformer.apply(res)))), (ExecutionContext)mat.executionContext());
    }

    public Source<ListBucketResultContents, NotUsed> listBucket(String bucket, Option<String> prefix, S3Headers s3Headers) {
        return Source$.MODULE$.setup((Function2 & Serializable)(mat, attr) -> {
            ActorMaterializer materializer = mat;
            Attributes attributes = attr;
            return (Source)Source$.MODULE$.unfoldAsync((Object)S3Stream$Starting$.MODULE$, (Function1 & Serializable)x0$1 -> {
                Future future;
                S3Stream.ListBucketState listBucketState = x0$1;
                if (S3Stream$Finished$.MODULE$.equals(listBucketState)) {
                    future = Future$.MODULE$.successful((Object)None$.MODULE$);
                } else if (S3Stream$Starting$.MODULE$.equals(listBucketState)) {
                    future = this.listBucketCallOnlyContents$1((Option)None$.MODULE$, materializer, attributes, bucket, prefix, s3Headers);
                } else if (listBucketState instanceof S3Stream.Running) {
                    S3Stream.Running running = (S3Stream.Running)listBucketState;
                    String token = running.continuationToken();
                    future = this.listBucketCallOnlyContents$1((Option)new Some((Object)token), materializer, attributes, bucket, prefix, s3Headers);
                } else {
                    throw new MatchError((Object)listBucketState);
                }
                return future;
            }).mapConcat((Function1 & Serializable)x -> (Seq)Predef$.MODULE$.identity(x));
        }).mapMaterializedValue((Function1 & Serializable)x$4 -> NotUsed$.MODULE$);
    }

    public Option<String> listBucket$default$2() {
        return None$.MODULE$;
    }

    public Source<Tuple2<Seq<ListBucketResultContents>, Seq<ListBucketResultCommonPrefixes>>, NotUsed> listBucketAndCommonPrefixes(String bucket, String delimiter, Option<String> prefix, S3Headers s3Headers) {
        return Source$.MODULE$.setup((Function2 & Serializable)(mat, attr) -> {
            ActorMaterializer materializer = mat;
            Attributes attributes = attr;
            return Source$.MODULE$.unfoldAsync((Object)S3Stream$Starting$.MODULE$, (Function1 & Serializable)x0$1 -> {
                Future future;
                S3Stream.ListBucketState listBucketState = x0$1;
                if (S3Stream$Finished$.MODULE$.equals(listBucketState)) {
                    future = Future$.MODULE$.successful((Object)None$.MODULE$);
                } else if (S3Stream$Starting$.MODULE$.equals(listBucketState)) {
                    future = this.listBucketCallContentsAndCommonPrefixes$1((Option)None$.MODULE$, materializer, attributes, bucket, prefix, delimiter, s3Headers);
                } else if (listBucketState instanceof S3Stream.Running) {
                    S3Stream.Running running = (S3Stream.Running)listBucketState;
                    String token = running.continuationToken();
                    future = this.listBucketCallContentsAndCommonPrefixes$1((Option)new Some((Object)token), materializer, attributes, bucket, prefix, delimiter, s3Headers);
                } else {
                    throw new MatchError((Object)listBucketState);
                }
                return future;
            });
        }).mapMaterializedValue((Function1 & Serializable)x$5 -> NotUsed$.MODULE$);
    }

    public Option<String> listBucketAndCommonPrefixes$default$3() {
        return None$.MODULE$;
    }

    public Source<Option<ObjectMetadata>, NotUsed> getObjectMetadata(String bucket, String key, Option<String> versionId2, S3Headers s3Headers) {
        return Source$.MODULE$.setup((Function2 & Serializable)(mat, attr) -> {
            ActorMaterializer materializer = mat;
            Seq<akka.http.scaladsl.model.HttpHeader> headers = s3Headers.headersFor(HeadObject$.MODULE$);
            S3Location x$1 = new S3Location(bucket, key);
            HttpMethod x$2 = HttpMethods$.MODULE$.HEAD();
            Option x$3 = versionId2;
            Seq<akka.http.scaladsl.model.HttpHeader> x$4 = headers;
            Option<ByteRange> x$5 = MODULE$.issueRequest$default$3();
            ActorMaterializer x$6 = mat;
            Attributes x$7 = attr;
            return (Source)MODULE$.issueRequest(x$1, x$2, x$5, (Option<String>)x$3, x$4, x$6, x$7).flatMapConcat((Function1 & Serializable)x0$1 -> {
                HttpResponse httpResponse;
                HttpResponse httpResponse2;
                HttpResponse httpResponse3 = x0$1;
                if (httpResponse3 != null && !OptHttpResponse$.MODULE$.isEmpty$extension(httpResponse2 = HttpResponse$.MODULE$.unapply(httpResponse3))) {
                    StatusCode statusCode = httpResponse2._1();
                    Seq headers = httpResponse2._2();
                    akka.http.scaladsl.model.ResponseEntity entity = httpResponse2._3();
                    StatusCodes.Success success = StatusCodes$.MODULE$.OK();
                    StatusCode statusCode2 = statusCode;
                    if (success == null) {
                        if (statusCode2 == null) return Source$.MODULE$.fromFuture(HttpEntity.HttpEntityScalaDSLSugar$.MODULE$.discardBytes$extension(HttpEntity$.MODULE$.HttpEntityScalaDSLSugar((HttpEntity)entity.withoutSizeLimit()), (Materializer)materializer).future().map((Function1 & Serializable)x$6 -> new Some((Object)MODULE$.computeMetaData((Seq<akka.http.scaladsl.model.HttpHeader>)headers, entity)), (ExecutionContext)mat.executionContext()));
                    } else if (success.equals(statusCode2)) {
                        return Source$.MODULE$.fromFuture(HttpEntity.HttpEntityScalaDSLSugar$.MODULE$.discardBytes$extension(HttpEntity$.MODULE$.HttpEntityScalaDSLSugar((HttpEntity)entity.withoutSizeLimit()), (Materializer)materializer).future().map((Function1 & Serializable)x$6 -> new Some((Object)MODULE$.computeMetaData((Seq<akka.http.scaladsl.model.HttpHeader>)headers, entity)), (ExecutionContext)mat.executionContext()));
                    }
                }
                if (httpResponse3 != null && !OptHttpResponse$.MODULE$.isEmpty$extension(httpResponse = HttpResponse$.MODULE$.unapply(httpResponse3))) {
                    StatusCode statusCode = httpResponse._1();
                    akka.http.scaladsl.model.ResponseEntity entity = httpResponse._3();
                    StatusCodes.ClientError clientError = StatusCodes$.MODULE$.NotFound();
                    StatusCode statusCode3 = statusCode;
                    if (clientError == null) {
                        if (statusCode3 == null) return Source$.MODULE$.fromFuture(HttpEntity.HttpEntityScalaDSLSugar$.MODULE$.discardBytes$extension(HttpEntity$.MODULE$.HttpEntityScalaDSLSugar((HttpEntity)entity), (Materializer)materializer).future().map((Function1 & Serializable)x$7 -> None$.MODULE$, (ExecutionContext)mat.executionContext()));
                    } else if (clientError.equals(statusCode3)) {
                        return Source$.MODULE$.fromFuture(HttpEntity.HttpEntityScalaDSLSugar$.MODULE$.discardBytes$extension(HttpEntity$.MODULE$.HttpEntityScalaDSLSugar((HttpEntity)entity), (Materializer)materializer).future().map((Function1 & Serializable)x$7 -> None$.MODULE$, (ExecutionContext)mat.executionContext()));
                    }
                }
                if (httpResponse3 == null) throw new MatchError((Object)httpResponse3);
                HttpResponse httpResponse4 = HttpResponse$.MODULE$.unapply(httpResponse3);
                if (OptHttpResponse$.MODULE$.isEmpty$extension(httpResponse4)) throw new MatchError((Object)httpResponse3);
                StatusCode code = httpResponse4._1();
                akka.http.scaladsl.model.ResponseEntity entity = httpResponse4._3();
                return Source$.MODULE$.fromFuture(MODULE$.unmarshalError(code, entity, (Materializer)materializer));
            });
        }).mapMaterializedValue((Function1 & Serializable)x$8 -> NotUsed$.MODULE$);
    }

    private Future<Nothing$> unmarshalError(StatusCode code, akka.http.scaladsl.model.ResponseEntity entity, Materializer mat) {
        return Unmarshal$.MODULE$.apply((Object)entity).to(Unmarshaller$.MODULE$.stringUnmarshaller(), (ExecutionContext)mat.executionContext(), mat).map((Function1 & Serializable)err -> {
            throw S3Exception$.MODULE$.apply((String)err, code);
        }, (ExecutionContext)mat.executionContext());
    }

    public Source<Done, NotUsed> deleteObject(S3Location s3Location, Option<String> versionId2, S3Headers s3Headers) {
        return Source$.MODULE$.setup((Function2 & Serializable)(mat, attr) -> {
            ActorMaterializer m = mat;
            Seq<akka.http.scaladsl.model.HttpHeader> headers = s3Headers.headersFor(DeleteObject$.MODULE$);
            S3Location x$1 = s3Location;
            HttpMethod x$2 = HttpMethods$.MODULE$.DELETE();
            Option x$3 = versionId2;
            Seq<akka.http.scaladsl.model.HttpHeader> x$4 = headers;
            Option<ByteRange> x$5 = MODULE$.issueRequest$default$3();
            ActorMaterializer x$6 = mat;
            Attributes x$7 = attr;
            return (Source)MODULE$.issueRequest(x$1, x$2, x$5, (Option<String>)x$3, x$4, x$6, x$7).flatMapConcat((Function1 & Serializable)x0$1 -> {
                HttpResponse httpResponse;
                HttpResponse httpResponse2 = x0$1;
                if (httpResponse2 != null && !OptHttpResponse$.MODULE$.isEmpty$extension(httpResponse = HttpResponse$.MODULE$.unapply(httpResponse2))) {
                    StatusCode statusCode = httpResponse._1();
                    akka.http.scaladsl.model.ResponseEntity entity = httpResponse._3();
                    StatusCodes.Success success = StatusCodes$.MODULE$.NoContent();
                    StatusCode statusCode2 = statusCode;
                    if (success == null) {
                        if (statusCode2 == null) return Source$.MODULE$.fromFuture(HttpEntity.HttpEntityScalaDSLSugar$.MODULE$.discardBytes$extension(HttpEntity$.MODULE$.HttpEntityScalaDSLSugar((HttpEntity)entity), (Materializer)m).future().map((Function1 & Serializable)x$9 -> Done$.MODULE$, (ExecutionContext)mat.executionContext()));
                    } else if (success.equals(statusCode2)) {
                        return Source$.MODULE$.fromFuture(HttpEntity.HttpEntityScalaDSLSugar$.MODULE$.discardBytes$extension(HttpEntity$.MODULE$.HttpEntityScalaDSLSugar((HttpEntity)entity), (Materializer)m).future().map((Function1 & Serializable)x$9 -> Done$.MODULE$, (ExecutionContext)mat.executionContext()));
                    }
                }
                if (httpResponse2 == null) throw new MatchError((Object)httpResponse2);
                HttpResponse httpResponse3 = HttpResponse$.MODULE$.unapply(httpResponse2);
                if (OptHttpResponse$.MODULE$.isEmpty$extension(httpResponse3)) throw new MatchError((Object)httpResponse2);
                StatusCode code = httpResponse3._1();
                akka.http.scaladsl.model.ResponseEntity entity = httpResponse3._3();
                return Source$.MODULE$.fromFuture(MODULE$.unmarshalError(code, entity, (Materializer)m));
            });
        }).mapMaterializedValue((Function1 & Serializable)x$10 -> NotUsed$.MODULE$);
    }

    public Source<Done, NotUsed> deleteObjectsByPrefix(String bucket, Option<String> prefix, S3Headers s3Headers) {
        return (Source)this.listBucket(bucket, prefix, s3Headers).flatMapConcat((Function1 & Serializable)listBucketResultContents -> MODULE$.deleteObject(new S3Location(bucket, listBucketResultContents.key()), (Option<String>)None$.MODULE$, s3Headers));
    }

    public Source<ObjectMetadata, NotUsed> putObject(S3Location s3Location, ContentType contentType2, Source<ByteString, ?> data, long contentLength2, S3Headers s3Headers) {
        Seq<akka.http.scaladsl.model.HttpHeader> headers = s3Headers.headersFor(PutObject$.MODULE$);
        return Source$.MODULE$.setup((Function2 & Serializable)(mat, attr) -> {
            ActorMaterializer materializer = mat;
            Attributes attributes = attr;
            ActorSystem sys = mat.system();
            S3Settings conf = MODULE$.resolveSettings((Attributes)attr, mat.system());
            HttpRequest req = HttpRequests$.MODULE$.uploadRequest(s3Location, data, contentLength2, contentType2, headers, conf);
            return (Source)MODULE$.signAndRequest(req, MODULE$.signAndRequest$default$2(), sys, materializer, attributes).flatMapConcat((Function1 & Serializable)x0$1 -> {
                HttpResponse httpResponse;
                HttpResponse httpResponse2 = x0$1;
                if (httpResponse2 != null && !OptHttpResponse$.MODULE$.isEmpty$extension(httpResponse = HttpResponse$.MODULE$.unapply(httpResponse2))) {
                    StatusCode statusCode = httpResponse._1();
                    Seq h = httpResponse._2();
                    akka.http.scaladsl.model.ResponseEntity entity = httpResponse._3();
                    StatusCodes.Success success = StatusCodes$.MODULE$.OK();
                    StatusCode statusCode2 = statusCode;
                    if (success == null) {
                        if (statusCode2 == null) return Source$.MODULE$.fromFuture(HttpEntity.HttpEntityScalaDSLSugar$.MODULE$.discardBytes$extension(HttpEntity$.MODULE$.HttpEntityScalaDSLSugar((HttpEntity)entity), (Materializer)materializer).future().map((Function1 & Serializable)x$11 -> ObjectMetadata$.MODULE$.apply((Seq<akka.http.scaladsl.model.HttpHeader>)((Seq)h.$colon$plus((Object)Content$minusLength$.MODULE$.apply(BoxesRunTime.unboxToLong((Object)entity.contentLengthOption().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)))))), (ExecutionContext)mat.executionContext()));
                    } else if (success.equals(statusCode2)) {
                        return Source$.MODULE$.fromFuture(HttpEntity.HttpEntityScalaDSLSugar$.MODULE$.discardBytes$extension(HttpEntity$.MODULE$.HttpEntityScalaDSLSugar((HttpEntity)entity), (Materializer)materializer).future().map((Function1 & Serializable)x$11 -> ObjectMetadata$.MODULE$.apply((Seq<akka.http.scaladsl.model.HttpHeader>)((Seq)h.$colon$plus((Object)Content$minusLength$.MODULE$.apply(BoxesRunTime.unboxToLong((Object)entity.contentLengthOption().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)))))), (ExecutionContext)mat.executionContext()));
                    }
                }
                if (httpResponse2 == null) throw new MatchError((Object)httpResponse2);
                HttpResponse httpResponse3 = HttpResponse$.MODULE$.unapply(httpResponse2);
                if (OptHttpResponse$.MODULE$.isEmpty$extension(httpResponse3)) throw new MatchError((Object)httpResponse2);
                StatusCode code = httpResponse3._1();
                akka.http.scaladsl.model.ResponseEntity entity = httpResponse3._3();
                return Source$.MODULE$.fromFuture(MODULE$.unmarshalError(code, entity, (Materializer)materializer));
            });
        }).mapMaterializedValue((Function1 & Serializable)x$12 -> NotUsed$.MODULE$);
    }

    public Source<HttpResponse, NotUsed> request(S3Location s3Location, HttpMethod method, Option<ByteRange> rangeOption, Option<String> versionId2, Seq<akka.http.scaladsl.model.HttpHeader> s3Headers) {
        return Source$.MODULE$.setup((Function2 & Serializable)(mat, attr) -> MODULE$.issueRequest(s3Location, method, rangeOption, versionId2, s3Headers, (ActorMaterializer)mat, (Attributes)attr)).mapMaterializedValue((Function1 & Serializable)x$13 -> NotUsed$.MODULE$);
    }

    public HttpMethod request$default$2() {
        return HttpMethods$.MODULE$.GET();
    }

    public Option<ByteRange> request$default$3() {
        return None$.MODULE$;
    }

    public Option<String> request$default$4() {
        return None$.MODULE$;
    }

    public Seq<akka.http.scaladsl.model.HttpHeader> request$default$5() {
        return (Seq)Seq$.MODULE$.empty();
    }

    private Source<HttpResponse, NotUsed> issueRequest(S3Location s3Location, HttpMethod method, Option<ByteRange> rangeOption, Option<String> versionId2, Seq<akka.http.scaladsl.model.HttpHeader> s3Headers, ActorMaterializer mat, Attributes attr) {
        ActorSystem sys = mat.system();
        S3Settings conf = this.resolveSettings(attr, sys);
        return this.signAndRequest(this.requestHeaders(HttpRequests$.MODULE$.getDownloadRequest(s3Location, method, s3Headers, versionId2, conf), rangeOption), this.signAndRequest$default$2(), sys, mat, attr);
    }

    private HttpMethod issueRequest$default$2() {
        return HttpMethods$.MODULE$.GET();
    }

    private Option<ByteRange> issueRequest$default$3() {
        return None$.MODULE$;
    }

    private HttpRequest requestHeaders(HttpRequest downloadRequest, Option<ByteRange> rangeOption) {
        HttpRequest httpRequest;
        Option<ByteRange> option = rangeOption;
        if (option instanceof Some) {
            Some some = (Some)option;
            ByteRange range = (ByteRange)some.value();
            httpRequest = (HttpRequest)downloadRequest.addHeader((HttpHeader)Range$.MODULE$.apply(range, (Seq)Nil$.MODULE$));
        } else {
            httpRequest = downloadRequest;
        }
        return httpRequest;
    }

    public Source<Done, NotUsed> makeBucketSource(String bucket, S3Headers headers) {
        return this.bucketManagementRequest(bucket, HttpMethods$.MODULE$.PUT(), headers.headersFor(MakeBucket$.MODULE$), (Function2 & Serializable)(response, materializer) -> MODULE$.processBucketLifecycleResponse((HttpResponse)response, (Materializer)materializer));
    }

    public Future<Done> makeBucket(String bucket, S3Headers headers, Materializer mat, Attributes attr) {
        return (Future)this.makeBucketSource(bucket, headers).withAttributes(attr).runWith((Graph)Sink$.MODULE$.ignore(), mat);
    }

    public Source<Done, NotUsed> deleteBucketSource(String bucket, S3Headers headers) {
        return this.bucketManagementRequest(bucket, HttpMethods$.MODULE$.DELETE(), headers.headersFor(DeleteBucket$.MODULE$), (Function2 & Serializable)(response, materializer) -> MODULE$.processBucketLifecycleResponse((HttpResponse)response, (Materializer)materializer));
    }

    public Future<Done> deleteBucket(String bucket, S3Headers headers, Materializer mat, Attributes attr) {
        return (Future)this.deleteBucketSource(bucket, headers).withAttributes(attr).runWith((Graph)Sink$.MODULE$.ignore(), mat);
    }

    public Source<BucketAccess, NotUsed> checkIfBucketExistsSource(String bucketName, S3Headers headers) {
        return this.bucketManagementRequest(bucketName, HttpMethods$.MODULE$.HEAD(), headers.headersFor(CheckBucket$.MODULE$), (Function2 & Serializable)(response, materializer) -> MODULE$.processCheckIfExistsResponse((HttpResponse)response, (Materializer)materializer));
    }

    public Future<BucketAccess> checkIfBucketExists(String bucket, S3Headers headers, Materializer mat, Attributes attr) {
        return (Future)this.checkIfBucketExistsSource(bucket, headers).withAttributes(attr).runWith((Graph)Sink$.MODULE$.head(), mat);
    }

    private <T> Source<T, NotUsed> bucketManagementRequest(String bucket, HttpMethod method, Seq<akka.http.scaladsl.model.HttpHeader> headers, Function2<HttpResponse, Materializer, Future<T>> process) {
        return Source$.MODULE$.setup((Function2 & Serializable)(mat, attr) -> {
            ActorMaterializer materializer = mat;
            Attributes attributes = attr;
            ActorSystem sys = mat.system();
            S3Settings conf = MODULE$.resolveSettings((Attributes)attr, mat.system());
            S3Location location = new S3Location(bucket, "");
            return (Source)MODULE$.signAndRequest(MODULE$.requestHeaders(HttpRequests$.MODULE$.bucketManagementRequest(location, method, HttpRequests$.MODULE$.bucketManagementRequest$default$3(), conf), (Option<ByteRange>)None$.MODULE$), MODULE$.signAndRequest$default$2(), sys, materializer, attributes).mapAsync(1, (Function1 & Serializable)response -> (Future)process.apply(response, mat));
        }).mapMaterializedValue((Function1 & Serializable)x$14 -> NotUsed$.MODULE$);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Future<Done> processBucketLifecycleResponse(HttpResponse response, Materializer materializer) {
        HttpResponse httpResponse;
        Materializer mat = materializer;
        HttpResponse httpResponse2 = response;
        if (httpResponse2 != null && !OptHttpResponse$.MODULE$.isEmpty$extension(httpResponse = HttpResponse$.MODULE$.unapply(httpResponse2))) {
            StatusCode status = httpResponse._1();
            akka.http.scaladsl.model.ResponseEntity entity = httpResponse._3();
            if (status.isSuccess()) {
                return HttpEntity.HttpEntityScalaDSLSugar$.MODULE$.discardBytes$extension(HttpEntity$.MODULE$.HttpEntityScalaDSLSugar((HttpEntity)entity), mat).future();
            }
        }
        if (httpResponse2 == null) throw new MatchError((Object)httpResponse2);
        HttpResponse httpResponse3 = HttpResponse$.MODULE$.unapply(httpResponse2);
        if (OptHttpResponse$.MODULE$.isEmpty$extension(httpResponse3)) throw new MatchError((Object)httpResponse2);
        StatusCode code = httpResponse3._1();
        akka.http.scaladsl.model.ResponseEntity entity = httpResponse3._3();
        return this.unmarshalError(code, entity, mat);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Future<BucketAccess> processCheckIfExistsResponse(HttpResponse response, Materializer materializer) {
        HttpResponse httpResponse;
        Materializer mat = materializer;
        HttpResponse httpResponse2 = response;
        if (httpResponse2 != null && !OptHttpResponse$.MODULE$.isEmpty$extension(httpResponse = HttpResponse$.MODULE$.unapply(httpResponse2))) {
            boolean bl;
            StatusCode statusCode = httpResponse._1();
            akka.http.scaladsl.model.ResponseEntity entity = httpResponse._3();
            StatusCodes.ClientError clientError = StatusCodes$.MODULE$.NotFound();
            StatusCode statusCode2 = statusCode;
            if (!(clientError != null ? !clientError.equals(statusCode2) : statusCode2 != null)) {
                bl = true;
            } else {
                StatusCodes.ClientError clientError2 = StatusCodes$.MODULE$.Forbidden();
                StatusCode statusCode3 = statusCode;
                if (!(clientError2 != null ? !clientError2.equals(statusCode3) : statusCode3 != null)) {
                    bl = true;
                } else {
                    StatusCodes.Success success = StatusCodes$.MODULE$.OK();
                    StatusCode statusCode4 = statusCode;
                    bl = !(success != null ? !success.equals(statusCode4) : statusCode4 != null);
                }
            }
            if (bl) {
                return HttpEntity.HttpEntityScalaDSLSugar$.MODULE$.discardBytes$extension(HttpEntity$.MODULE$.HttpEntityScalaDSLSugar((HttpEntity)entity), mat).future().map((Function1 & Serializable)x$15 -> {
                    BucketAccess bucketAccess;
                    StatusCode statusCode = httpResponse2.status();
                    StatusCodes.ClientError clientError = StatusCodes$.MODULE$.NotFound();
                    StatusCode statusCode2 = statusCode;
                    if (!(clientError != null ? !clientError.equals(statusCode2) : statusCode2 != null)) {
                        bucketAccess = BucketAccess$NotExists$.MODULE$;
                    } else {
                        StatusCodes.ClientError clientError2 = StatusCodes$.MODULE$.Forbidden();
                        StatusCode statusCode3 = statusCode;
                        if (!(clientError2 != null ? !clientError2.equals(statusCode3) : statusCode3 != null)) {
                            bucketAccess = BucketAccess$AccessDenied$.MODULE$;
                        } else {
                            StatusCodes.Success success = StatusCodes$.MODULE$.OK();
                            StatusCode statusCode4 = statusCode;
                            if (!(success != null ? !success.equals(statusCode4) : statusCode4 != null)) {
                                bucketAccess = BucketAccess$AccessGranted$.MODULE$;
                            } else {
                                throw new IllegalArgumentException(new StringBuilder(16).append("received status ").append(statusCode).toString());
                            }
                        }
                    }
                    return bucketAccess;
                }, (ExecutionContext)materializer.executionContext());
            }
        }
        if (httpResponse2 == null) throw new MatchError((Object)httpResponse2);
        HttpResponse httpResponse3 = HttpResponse$.MODULE$.unapply(httpResponse2);
        if (OptHttpResponse$.MODULE$.isEmpty$extension(httpResponse3)) throw new MatchError((Object)httpResponse2);
        StatusCode code = httpResponse3._1();
        akka.http.scaladsl.model.ResponseEntity entity = httpResponse3._3();
        return this.unmarshalError(code, entity, mat);
    }

    public Sink<ByteString, Future<MultipartUploadResult>> multipartUpload(S3Location s3Location, ContentType contentType2, S3Headers s3Headers, int chunkSize, int chunkingParallelism) {
        return this.chunkAndRequest(s3Location, contentType2, s3Headers, chunkSize, chunkingParallelism).toMat(this.completionSink(s3Location, s3Headers.serverSideEncryption()), Keep$.MODULE$.right());
    }

    public ContentType multipartUpload$default$2() {
        return ContentTypes$.MODULE$.application$divoctet$minusstream();
    }

    public int multipartUpload$default$4() {
        return this.MinChunkSize();
    }

    public int multipartUpload$default$5() {
        return 4;
    }

    private Source<MultipartUpload, NotUsed> initiateMultipartUpload(S3Location s3Location, ContentType contentType2, Seq<akka.http.scaladsl.model.HttpHeader> s3Headers) {
        return Source$.MODULE$.setup((Function2 & Serializable)(mat, attr) -> {
            ActorMaterializer materializer = mat;
            Attributes attributes = attr;
            ActorSystem sys = mat.system();
            S3Settings conf = MODULE$.resolveSettings((Attributes)attr, mat.system());
            HttpRequest req = HttpRequests$.MODULE$.initiateMultipartUploadRequest(s3Location, contentType2, s3Headers, conf);
            return (Source)MODULE$.signAndRequest(req, MODULE$.signAndRequest$default$2(), sys, materializer, attributes).flatMapConcat((Function1 & Serializable)x0$1 -> {
                HttpResponse httpResponse;
                HttpResponse httpResponse2 = x0$1;
                if (httpResponse2 != null && !OptHttpResponse$.MODULE$.isEmpty$extension(httpResponse = HttpResponse$.MODULE$.unapply(httpResponse2))) {
                    StatusCode status = httpResponse._1();
                    akka.http.scaladsl.model.ResponseEntity entity = httpResponse._3();
                    if (status.isSuccess()) {
                        return Source$.MODULE$.fromFuture(Unmarshal$.MODULE$.apply((Object)entity).to(Marshalling$.MODULE$.multipartUploadUnmarshaller(), (ExecutionContext)mat.executionContext(), (Materializer)materializer));
                    }
                }
                if (httpResponse2 == null) throw new MatchError((Object)httpResponse2);
                HttpResponse httpResponse3 = HttpResponse$.MODULE$.unapply(httpResponse2);
                if (OptHttpResponse$.MODULE$.isEmpty$extension(httpResponse3)) throw new MatchError((Object)httpResponse2);
                StatusCode code = httpResponse3._1();
                akka.http.scaladsl.model.ResponseEntity entity = httpResponse3._3();
                return Source$.MODULE$.fromFuture(MODULE$.unmarshalError(code, entity, (Materializer)materializer));
            });
        }).mapMaterializedValue((Function1 & Serializable)x$16 -> NotUsed$.MODULE$);
    }

    public RunnableGraph<Future<MultipartUploadResult>> multipartCopy(S3Location sourceLocation, S3Location targetLocation, Option<String> sourceVersionId, ContentType contentType2, S3Headers s3Headers, int chunkSize, int chunkingParallelism) {
        Source eventualMaybeObjectSize = (Source)this.getObjectMetadata(sourceLocation.bucket(), sourceLocation.key(), sourceVersionId, s3Headers).map((Function1 & Serializable)x$17 -> x$17.map((Function1 & Serializable)x$18 -> BoxesRunTime.boxToLong((long)x$18.contentLength())));
        Source eventualPartitions = (Source)eventualMaybeObjectSize.map((Function1 & Serializable)x$19 -> (List)x$19.map((Function1 & Serializable)objectSize -> S3Stream$.MODULE$.createPartitions(chunkSize, sourceLocation, BoxesRunTime.unboxToLong((Object)objectSize))).getOrElse((Function0 & Serializable)() -> Nil$.MODULE$));
        Source<Tuple2<HttpRequest, MultipartCopy>, NotUsed$> copyRequests = this.createCopyRequests(targetLocation, sourceVersionId, contentType2, s3Headers, (Source<List<CopyPartition>, NotUsed>)eventualPartitions, chunkingParallelism);
        return this.processUploadCopyPartRequests(copyRequests, chunkingParallelism).toMat(this.completionSink(targetLocation, s3Headers.serverSideEncryption()), Keep$.MODULE$.right());
    }

    public Option<String> multipartCopy$default$3() {
        return None$.MODULE$;
    }

    public ContentType multipartCopy$default$4() {
        return ContentTypes$.MODULE$.application$divoctet$minusstream();
    }

    public int multipartCopy$default$6() {
        return this.MinChunkSize();
    }

    public int multipartCopy$default$7() {
        return 4;
    }

    private ObjectMetadata computeMetaData(Seq<akka.http.scaladsl.model.HttpHeader> headers, akka.http.scaladsl.model.ResponseEntity entity) {
        return ObjectMetadata$.MODULE$.apply((Seq<akka.http.scaladsl.model.HttpHeader>)((Seq)headers.$plus$plus((IterableOnce)new .colon.colon((Object)Content$minusLength$.MODULE$.apply(BoxesRunTime.unboxToLong((Object)entity.contentLengthOption().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L))), (List)new .colon.colon((Object)Content$minusType$.MODULE$.apply(entity.contentType()), (List)new .colon.colon((Object)new S3Stream.CustomContentTypeHeader(entity.contentType()), (List)Nil$.MODULE$))))));
    }

    private Future<CompleteMultipartUploadResult> completeMultipartUpload(S3Location s3Location, Seq<SuccessfulUploadPart> parts, Option<ServerSideEncryption> sse, ActorMaterializer mat, Attributes attr) {
        S3Settings conf = this.resolveSettings(attr, mat.system());
        IndexedSeq headers = (IndexedSeq)Option$.MODULE$.option2Iterable(sse).toIndexedSeq().flatMap((Function1 & Serializable)x$22 -> x$22.headersFor(UploadPart$.MODULE$));
        return (Future)((Source)Source$.MODULE$.fromFuture(HttpRequests$.MODULE$.completeMultipartUploadRequest(((SuccessfulUploadPart)parts.head()).multipartUpload(), (Seq<Tuple2<Object, String>>)((Seq)parts.map((Function1 & Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)p.index())), (Object)p.etag()))), (Seq<akka.http.scaladsl.model.HttpHeader>)headers, (ExecutionContext)mat.executionContext(), conf)).flatMapConcat((Function1 & Serializable)x$23 -> MODULE$.signAndGetAs((HttpRequest)x$23, (Function2 & Serializable)(x$24, x$25) -> S3Stream$.populateResult$1(x$24, x$25), (Unmarshaller)Marshalling$.MODULE$.completeMultipartUploadResultUnmarshaller(), mat, attr))).runWith((Graph)Sink$.MODULE$.head(), (Materializer)mat);
    }

    private Source<Tuple2<MultipartUpload, Object>, NotUsed> initiateUpload(S3Location s3Location, ContentType contentType2, Seq<akka.http.scaladsl.model.HttpHeader> s3Headers) {
        return (Source)Source$.MODULE$.single((Object)s3Location).flatMapConcat((Function1 & Serializable)x$26 -> MODULE$.initiateMultipartUpload((S3Location)x$26, contentType2, s3Headers)).mapConcat((Function1 & Serializable)r -> package$.MODULE$.Stream().continually((Function0 & Serializable)() -> r)).zip((Graph)Source$.MODULE$.fromIterator((Function0 & Serializable)() -> package$.MODULE$.Iterator().from(1)));
    }

    public Flow<ByteString, ByteString, NotUsed> atLeastOneByteString() {
        return atLeastOneByteString;
    }

    private Option<ConnectionPoolSettings> poolSettings(S3Settings settings, ActorSystem system) {
        return settings.forwardProxy().map((Function1 & Serializable)proxy -> {
            S3Stream.ChangeTargetEndpointTransport changeTargetEndpointTransport;
            block7: {
                String string;
                block5: {
                    InetSocketAddress address;
                    block6: {
                        address = InetSocketAddress.createUnresolved(proxy.host(), proxy.port());
                        string = proxy.scheme();
                        switch (string == null ? 0 : string.hashCode()) {
                            case 3213448: {
                                if (!"http".equals(string)) break block5;
                                break block6;
                            }
                            case 99617003: {
                                if ("https".equals(string)) {
                                    break;
                                }
                                break block5;
                            }
                            default: {
                                break block5;
                            }
                        }
                        changeTargetEndpointTransport = (ClientTransport)proxy.credentials().fold((Function0 & Serializable)() -> ClientTransport$.MODULE$.httpsProxy(address), (Function1 & Serializable)c -> ClientTransport$.MODULE$.httpsProxy(address, (HttpCredentials)new BasicHttpCredentials(c.username(), c.password())));
                        break block7;
                    }
                    changeTargetEndpointTransport = new S3Stream.ChangeTargetEndpointTransport(address);
                    break block7;
                }
                throw new MatchError((Object)string);
            }
            S3Stream.ChangeTargetEndpointTransport transport = changeTargetEndpointTransport;
            return ((ConnectionPoolSettings)ConnectionPoolSettings$.MODULE$.apply(system)).withConnectionSettings(((ClientConnectionSettings)ClientConnectionSettings$.MODULE$.apply(system)).withTransport((ClientTransport)transport));
        });
    }

    private Future<HttpResponse> singleRequest(HttpRequest req, S3Settings settings, ActorSystem system) {
        return (Future)this.poolSettings(settings, system).fold((Function0 & Serializable)() -> {
            HttpExt qual$1 = Http$.MODULE$.apply(system);
            HttpRequest x$1 = req;
            HttpsConnectionContext x$2 = qual$1.singleRequest$default$2();
            ConnectionPoolSettings x$3 = qual$1.singleRequest$default$3();
            LoggingAdapter x$4 = qual$1.singleRequest$default$4();
            return qual$1.singleRequest(x$1, x$2, x$3, x$4);
        }, (Function1 & Serializable)s -> {
            HttpExt qual$2 = Http$.MODULE$.apply(system);
            HttpRequest x$5 = req;
            ConnectionPoolSettings x$6 = s;
            HttpsConnectionContext x$7 = qual$2.singleRequest$default$2();
            LoggingAdapter x$8 = qual$2.singleRequest$default$4();
            return qual$2.singleRequest(x$5, x$7, x$6, x$8);
        });
    }

    private <T> Flow<Tuple2<HttpRequest, T>, Tuple2<Try<HttpResponse>, T>, NotUsed> superPool(S3Settings settings, ActorSystem sys) {
        return (Flow)this.poolSettings(settings, sys).fold((Function0 & Serializable)() -> {
            HttpExt qual$1 = Http$.MODULE$.apply(sys);
            HttpsConnectionContext x$1 = qual$1.superPool$default$1();
            ConnectionPoolSettings x$2 = qual$1.superPool$default$2();
            LoggingAdapter x$3 = qual$1.superPool$default$3();
            return qual$1.superPool(x$1, x$2, x$3);
        }, (Function1 & Serializable)s -> {
            HttpExt qual$2 = Http$.MODULE$.apply(sys);
            ConnectionPoolSettings x$4 = s;
            HttpsConnectionContext x$5 = qual$2.superPool$default$1();
            LoggingAdapter x$6 = qual$2.superPool$default$3();
            return qual$2.superPool(x$5, x$4, x$6);
        });
    }

    private Flow<ByteString, UploadPartResponse, NotUsed> chunkAndRequest(S3Location s3Location, ContentType contentType2, S3Headers s3Headers, int chunkSize, int parallelism) {
        Predef$.MODULE$.assert(chunkSize >= this.MinChunkSize(), (Function0 & Serializable)() -> new StringBuilder(130).append("Chunk size must be at least 5 MB = ").append(MODULE$.MinChunkSize()).append(" bytes (was ").append(chunkSize).append(" bytes). See http://docs.aws.amazon.com/AmazonS3/latest/API/mpUploadUploadPart.html").toString());
        int chunkBufferSize = chunkSize * 2;
        Source<Tuple2<MultipartUpload, Object>, NotUsed> requestInfo = this.initiateUpload(s3Location, contentType2, s3Headers.headersFor(InitiateMultipartUpload$.MODULE$));
        IndexedSeq headers = (IndexedSeq)Option$.MODULE$.option2Iterable(s3Headers.serverSideEncryption()).toIndexedSeq().flatMap((Function1 & Serializable)x$28 -> x$28.headersFor(UploadPart$.MODULE$));
        return Flow$.MODULE$.setup((Function2 & Serializable)(mat, attr) -> {
            S3Settings conf = MODULE$.resolveSettings((Attributes)attr, mat.system());
            ActorSystem sys = mat.system();
            ActorMaterializer materializer = mat;
            Flow atLeastOne = (Flow)Flow$.MODULE$.apply().prefixAndTail(1).flatMapConcat((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Seq prefix = (Seq)tuple2._1();
                Source tail = (Source)tuple2._2();
                Source source = prefix.nonEmpty() ? (Source)Source$.MODULE$.apply((Iterable)prefix).concat((Graph)tail) : Source$.MODULE$.single((Object)new Chunk((Source<ByteString, NotUsed>)Source$.MODULE$.empty(), 0));
                return source;
            });
            Flow retriableFlow = ((Flow)Flow$.MODULE$.apply().map((Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2;
                Chunk chunkedPayload;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = x0$2;
                        if (tuple22 == null) break block2;
                        chunkedPayload = (Chunk)tuple22._1();
                        tuple2 = (Tuple2)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                MultipartUpload uploadInfo = (MultipartUpload)tuple2._1();
                int chunkIndex = tuple2._2$mcI$sp();
                HttpRequest partRequest = HttpRequests$.MODULE$.uploadPartRequest(uploadInfo, chunkIndex, chunkedPayload.data(), chunkedPayload.size(), (Seq<akka.http.scaladsl.model.HttpHeader>)headers, conf);
                Tuple2 tuple23 = new Tuple2((Object)partRequest, (Object)new Tuple2((Object)uploadInfo, (Object)BoxesRunTime.boxToInteger((int)chunkIndex)));
                return tuple23;
            }).flatMapConcat((Function1 & Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                HttpRequest req = (HttpRequest)tuple2._1();
                Tuple2 info = (Tuple2)tuple2._2();
                Source source = (Source)Signer$.MODULE$.signedRequest(req, MODULE$.signingKey(conf)).zip((Graph)Source$.MODULE$.single((Object)info));
                return source;
            })).via(MODULE$.superPool(conf, sys));
            return (Flow)((SubFlow)((Flow)((FlowOps)((SubFlow)SplitAfterSize$.MODULE$.apply(chunkSize, chunkBufferSize, MODULE$.atLeastOneByteString()).via((Graph)S3Stream$.getChunkBuffer$1(chunkSize, chunkBufferSize, conf.multipartUploadSettings().retrySettings().maxRetries(), conf))).mergeSubstreamsWithParallelism(parallelism)).filter((Function1 & Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)S3Stream$.$anonfun$chunkAndRequest$7(x$29)))).via((Graph)atLeastOne).zip((Graph)requestInfo).groupBy(parallelism, (Function1 & Serializable)x0$4 -> BoxesRunTime.boxToInteger((int)S3Stream$.$anonfun$chunkAndRequest$8(parallelism, x0$4))).via(RetryFlow$.MODULE$.withBackoff(conf.multipartUploadSettings().retrySettings().minBackoff(), conf.multipartUploadSettings().retrySettings().maxBackoff(), conf.multipartUploadSettings().retrySettings().randomFactor(), conf.multipartUploadSettings().retrySettings().maxRetries(), retriableFlow, (arg_0, arg_1) -> S3Stream$.$anonfun$chunkAndRequest$9((Materializer)materializer, arg_0, arg_1))).mapAsync(1, arg_0 -> S3Stream$.$anonfun$chunkAndRequest$10(conf, (Materializer)materializer, arg_0))).mergeSubstreamsWithParallelism(parallelism);
        }).mapMaterializedValue((Function1 & Serializable)x$30 -> NotUsed$.MODULE$);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Future<Product> handleChunkResponse(Try<HttpResponse> response, MultipartUpload upload, int index, RetrySettings retrySettings, Materializer mat) {
        boolean bl = false;
        Success success = null;
        Try<HttpResponse> try_ = response;
        if (try_ instanceof Success) {
            bl = true;
            success = (Success)try_;
            HttpResponse r = (HttpResponse)success.value();
            if (r.status().isFailure()) {
                String retryInfo = this.isTransientError(r.status()) ? new StringBuilder(49).append(" after exhausting all retry attempts (settings: ").append(retrySettings).append(")").toString() : "";
                return Unmarshal$.MODULE$.apply((Object)r.entity()).to(Unmarshaller$.MODULE$.stringUnmarshaller(), (ExecutionContext)mat.executionContext(), mat).map((Function1 & Serializable)errorBody -> new FailedUploadPart(upload, index, new RuntimeException(new StringBuilder(68).append("Upload part ").append(index).append(" request failed").append(retryInfo).append(". Response header: (").append(r).append("), response body: (").append((String)errorBody).append(").").toString())), (ExecutionContext)mat.executionContext());
            }
        }
        if (bl) {
            HttpResponse r = (HttpResponse)success.value();
            HttpEntity.HttpEntityScalaDSLSugar$.MODULE$.discardBytes$extension(HttpEntity$.MODULE$.HttpEntityScalaDSLSugar((HttpEntity)r.entity()), mat);
            Option etag = r.headers().find((Function1 & Serializable)x$31 -> BoxesRunTime.boxToBoolean((boolean)S3Stream$.$anonfun$handleChunkResponse$2(x$31))).map((Function1 & Serializable)x$32 -> x$32.value());
            return (Future)etag.map((Function1 & Serializable)t -> Future$.MODULE$.successful((Object)new SuccessfulUploadPart(upload, index, (String)t))).getOrElse((Function0 & Serializable)() -> Future$.MODULE$.successful((Object)new FailedUploadPart(upload, index, new RuntimeException(new StringBuilder(20).append("Cannot find etag in ").append(r).toString()))));
        }
        if (!(try_ instanceof Failure)) throw new MatchError(try_);
        Failure failure = (Failure)try_;
        Throwable e = failure.exception();
        return Future$.MODULE$.successful((Object)new FailedUploadPart(upload, index, e));
    }

    private boolean isTransientError(StatusCode status) {
        return status.intValue() >= 500;
    }

    private Sink<UploadPartResponse, Future<MultipartUploadResult>> completionSink(S3Location s3Location, Option<ServerSideEncryption> sse) {
        return Sink$.MODULE$.setup((Function2 & Serializable)(mat, attr) -> {
            ActorMaterializer materializer = mat;
            Attributes attributes = attr;
            ActorSystem sys = mat.system();
            return Sink$.MODULE$.seq().mapMaterializedValue((Function1 & Serializable)responseFuture -> responseFuture.flatMap((Function1 & Serializable)responses -> {
                Seq successes = (Seq)responses.collect((PartialFunction)new Serializable(){
                    private static final long serialVersionUID = 0L;

                    public final <A1 extends UploadPartResponse, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 instanceof SuccessfulUploadPart) {
                            SuccessfulUploadPart successfulUploadPart = (SuccessfulUploadPart)A1;
                            object = successfulUploadPart;
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(UploadPartResponse x1) {
                        UploadPartResponse uploadPartResponse = x1;
                        boolean bl = uploadPartResponse instanceof SuccessfulUploadPart;
                        return bl;
                    }
                });
                Seq failures = (Seq)responses.collect((PartialFunction)new Serializable(){
                    private static final long serialVersionUID = 0L;

                    public final <A1 extends UploadPartResponse, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x2;
                        if (A1 instanceof FailedUploadPart) {
                            FailedUploadPart failedUploadPart = (FailedUploadPart)A1;
                            object = failedUploadPart;
                        } else {
                            object = function1.apply(x2);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(UploadPartResponse x2) {
                        UploadPartResponse uploadPartResponse = x2;
                        boolean bl = uploadPartResponse instanceof FailedUploadPart;
                        return bl;
                    }
                });
                return responses.isEmpty() ? Future$.MODULE$.failed((Throwable)new RuntimeException("No Responses")) : (failures.isEmpty() ? Future$.MODULE$.successful(successes.sortBy((Function1 & Serializable)x$33 -> BoxesRunTime.boxToInteger((int)x$33.index()), (Ordering)Ordering.Int$.MODULE$)) : Future$.MODULE$.failed((Throwable)FailedUpload$.MODULE$.apply((Seq<Throwable>)((Seq)failures.map((Function1 & Serializable)x$34 -> x$34.exception())))));
            }, (ExecutionContext)sys.dispatcher()).flatMap((Function1 & Serializable)x$35 -> MODULE$.completeMultipartUpload(s3Location, (Seq<SuccessfulUploadPart>)x$35, sse, materializer, attributes), (ExecutionContext)sys.dispatcher())).mapMaterializedValue((Function1 & Serializable)x$36 -> x$36.map((Function1 & Serializable)r -> MultipartUploadResult$.MODULE$.apply(r.location(), r.bucket(), r.key(), r.etag(), r.versionId()), (ExecutionContext)sys.dispatcher()));
        }).mapMaterializedValue((Function1 & Serializable)x$37 -> x$37.flatMap((Function1 & Serializable)x -> (Future)Predef$.MODULE$.identity(x), (ExecutionContext)ExecutionContexts.sameThreadExecutionContext$.MODULE$));
    }

    private <T> Future<T> signAndGetAs(HttpRequest request, Unmarshaller<akka.http.scaladsl.model.ResponseEntity, T> um, ActorMaterializer mat, Attributes attr) {
        ActorSystem sys = mat.system();
        return ((Future)this.signAndRequest(request, this.signAndRequest$default$2(), sys, mat, attr).runWith((Graph)Sink$.MODULE$.head(), (Materializer)mat)).flatMap((Function1 & Serializable)response -> MODULE$.entityForSuccess((HttpResponse)response, (Materializer)mat).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)S3Stream$.$anonfun$signAndGetAs$2(check$ifrefutable$1)), (ExecutionContext)mat.executionContext()).flatMap((Function1 & Serializable)x$38 -> {
            Tuple2 tuple2 = x$38;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            akka.http.scaladsl.model.ResponseEntity entity = (akka.http.scaladsl.model.ResponseEntity)tuple2._1();
            Future future = Unmarshal$.MODULE$.apply((Object)entity).to(um, (ExecutionContext)mat.executionContext(), (Materializer)mat).map((Function1 & Serializable)t -> t, (ExecutionContext)mat.executionContext());
            return future;
        }, (ExecutionContext)mat.executionContext()), (ExecutionContext)mat.executionContext());
    }

    private <T> Source<T, NotUsed> signAndGetAs(HttpRequest request, Function2<T, Seq<akka.http.scaladsl.model.HttpHeader>, T> f, Unmarshaller<akka.http.scaladsl.model.ResponseEntity, T> um, ActorMaterializer mat, Attributes attr) {
        ActorSystem sys = mat.system();
        return (Source)this.signAndRequest(request, this.signAndRequest$default$2(), sys, mat, attr).mapAsync(1, (Function1 & Serializable)resp -> MODULE$.entityForSuccess((HttpResponse)resp, (Materializer)mat)).mapAsync(1, (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            akka.http.scaladsl.model.ResponseEntity entity = (akka.http.scaladsl.model.ResponseEntity)tuple2._1();
            Seq headers = (Seq)tuple2._2();
            Future future = Unmarshal$.MODULE$.apply((Object)entity).to(um, (ExecutionContext)mat.executionContext(), (Materializer)mat).map((Function1 & Serializable)x$39 -> new Tuple2(x$39, (Object)headers), (ExecutionContext)mat.executionContext());
            return future;
        }).map(f.tupled());
    }

    private Source<HttpResponse, NotUsed> signAndRequest(HttpRequest request, int retries, ActorSystem sys, ActorMaterializer mat, Attributes attr) {
        S3Settings conf = this.resolveSettings(attr, sys);
        return (Source)Signer$.MODULE$.signedRequest(request, this.signingKey(conf)).mapAsync(1, (Function1 & Serializable)req -> MODULE$.singleRequest((HttpRequest)req, conf, sys)).flatMapConcat((Function1 & Serializable)x0$1 -> {
            HttpResponse httpResponse = x0$1;
            if (httpResponse == null) return Source$.MODULE$.single((Object)httpResponse);
            HttpResponse httpResponse2 = HttpResponse$.MODULE$.unapply(httpResponse);
            if (OptHttpResponse$.MODULE$.isEmpty$extension(httpResponse2)) return Source$.MODULE$.single((Object)httpResponse);
            StatusCode status = httpResponse2._1();
            akka.http.scaladsl.model.ResponseEntity entity = httpResponse2._3();
            if (retries <= 0) return Source$.MODULE$.single((Object)httpResponse);
            if (!RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(500), 599).contains(status.intValue())) return Source$.MODULE$.single((Object)httpResponse);
            HttpEntity.HttpEntityScalaDSLSugar$.MODULE$.discardBytes$extension(HttpEntity$.MODULE$.HttpEntityScalaDSLSugar((HttpEntity)entity), (Materializer)mat);
            return MODULE$.signAndRequest(request, retries - 1, sys, mat, attr);
        });
    }

    private int signAndRequest$default$2() {
        return 3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Future<Tuple2<akka.http.scaladsl.model.ResponseEntity, Seq<akka.http.scaladsl.model.HttpHeader>>> entityForSuccess(HttpResponse resp, Materializer mat) {
        HttpResponse httpResponse;
        HttpResponse httpResponse2 = resp;
        if (httpResponse2 != null && !OptHttpResponse$.MODULE$.isEmpty$extension(httpResponse = HttpResponse$.MODULE$.unapply(httpResponse2))) {
            StatusCode status = httpResponse._1();
            Seq headers = httpResponse._2();
            akka.http.scaladsl.model.ResponseEntity entity = httpResponse._3();
            if (status.isSuccess() && !status.isRedirection()) {
                return Future$.MODULE$.successful((Object)new Tuple2((Object)entity, (Object)headers));
            }
        }
        if (httpResponse2 == null) throw new MatchError((Object)httpResponse2);
        HttpResponse httpResponse3 = HttpResponse$.MODULE$.unapply(httpResponse2);
        if (OptHttpResponse$.MODULE$.isEmpty$extension(httpResponse3)) throw new MatchError((Object)httpResponse2);
        StatusCode code = httpResponse3._1();
        akka.http.scaladsl.model.ResponseEntity entity = httpResponse3._3();
        return this.unmarshalError(code, entity, mat);
    }

    public List<CopyPartition> createPartitions(int chunkSize, S3Location sourceLocation, long objectSize) {
        List list;
        if (objectSize <= 0L || objectSize < (long)chunkSize) {
            CopyPartition copyPartition = new CopyPartition(1, sourceLocation, CopyPartition$.MODULE$.apply$default$3());
            list = Nil$.MODULE$.$colon$colon((Object)copyPartition);
        } else {
            list = ((List)((IterableOps)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)objectSize)).by((Object)BoxesRunTime.boxToLong((long)chunkSize)).toList().$colon$plus((Object)BoxesRunTime.boxToLong((long)objectSize))).sliding(2).toList().zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                List ls = (List)tuple2._1();
                int index = tuple2._2$mcI$sp();
                CopyPartition copyPartition = new CopyPartition(index + 1, sourceLocation, (Option<ByteRange.Slice>)new Some((Object)ByteRange$.MODULE$.apply(BoxesRunTime.unboxToLong((Object)ls.head()), BoxesRunTime.unboxToLong((Object)ls.last()))));
                return copyPartition;
            });
        }
        return list;
    }

    private Source<Tuple2<HttpRequest, MultipartCopy>, NotUsed$> createCopyRequests(S3Location location, Option<String> sourceVersionId, ContentType contentType2, S3Headers s3Headers, Source<List<CopyPartition>, NotUsed> partitions, int parallelism) {
        Source<Tuple2<MultipartUpload, Object>, NotUsed> requestInfo = this.initiateUpload(location, contentType2, s3Headers.headersFor(InitiateMultipartUpload$.MODULE$));
        IndexedSeq headers = (IndexedSeq)Option$.MODULE$.option2Iterable(s3Headers.serverSideEncryption()).toIndexedSeq().flatMap((Function1 & Serializable)x$40 -> x$40.headersFor(CopyPart$.MODULE$));
        return Source$.MODULE$.setup((Function2 & Serializable)(mat, attr) -> {
            S3Settings conf = MODULE$.resolveSettings((Attributes)attr, mat.system());
            return (Source)requestInfo.zipWith((Graph)partitions, (Function2 & Serializable)(x0$1, x1$1) -> {
                List ls;
                Tuple2 tuple2;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = new Tuple2(x0$1, x1$1);
                        if (tuple22 == null) break block2;
                        tuple2 = (Tuple2)tuple22._1();
                        ls = (List)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                MultipartUpload upload = (MultipartUpload)tuple2._1();
                List list = ls.map((Function1 & Serializable)cp -> {
                    MultipartCopy multipartCopy = new MultipartCopy(upload, (CopyPartition)cp);
                    HttpRequest request = HttpRequests$.MODULE$.uploadCopyPartRequest(multipartCopy, sourceVersionId, (Seq<akka.http.scaladsl.model.HttpHeader>)headers, conf);
                    return new Tuple2((Object)request, (Object)multipartCopy);
                });
                return list;
            }).mapConcat((Function1 & Serializable)x -> (List)Predef$.MODULE$.identity(x)).flatMapConcat((Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                HttpRequest req = (HttpRequest)tuple2._1();
                MultipartCopy info = (MultipartCopy)tuple2._2();
                Source source = (Source)Signer$.MODULE$.signedRequest(req, MODULE$.signingKey(conf)).zip((Graph)Source$.MODULE$.single((Object)info));
                return source;
            });
        }).mapMaterializedValue((Function1 & Serializable)x$41 -> NotUsed$.MODULE$);
    }

    private Source<Product, Future<NotUsed>> processUploadCopyPartRequests(Source<Tuple2<HttpRequest, MultipartCopy>, NotUsed> requests, int parallelism) {
        return Source$.MODULE$.setup((Function2 & Serializable)(mat, attr) -> {
            ActorMaterializer materializer = mat;
            ActorSystem sys = mat.system();
            S3Settings settings = MODULE$.resolveSettings((Attributes)attr, mat.system());
            return (Source)requests.via(MODULE$.superPool(settings, sys)).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Try try_ = (Try)tuple2._1();
                    MultipartCopy multipartCopy = (MultipartCopy)tuple2._2();
                    if (try_ instanceof Success) {
                        Future future;
                        Success success = (Success)try_;
                        HttpResponse r = (HttpResponse)success.value();
                        akka.http.scaladsl.model.ResponseEntity entity = r.entity();
                        MultipartUpload upload = multipartCopy.multipartUpload();
                        int index = multipartCopy.copyPartition().partNumber();
                        StatusCode statusCode = r.status();
                        StatusCodes.Success success2 = StatusCodes$.MODULE$.OK();
                        StatusCode statusCode2 = statusCode;
                        if (!(success2 != null ? !success2.equals(statusCode2) : statusCode2 != null)) {
                            future = Unmarshal$.MODULE$.apply((Object)entity).to(Marshalling$.MODULE$.copyPartResultUnmarshaller(), (ExecutionContext)mat.executionContext(), (Materializer)materializer).map((Function1 & Serializable)cp -> new SuccessfulUploadPart(upload, index, cp.eTag()), (ExecutionContext)mat.executionContext());
                            return future;
                        } else {
                            if (statusCode == null) throw new MatchError((Object)statusCode);
                            StatusCode statusCode3 = statusCode;
                            future = MODULE$.unmarshalError(statusCode3, entity, (Materializer)materializer);
                        }
                        return future;
                    }
                }
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                Try try_ = (Try)tuple2._1();
                MultipartCopy multipartCopy = (MultipartCopy)tuple2._2();
                if (!(try_ instanceof Failure)) throw new MatchError((Object)tuple2);
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                return Future$.MODULE$.successful((Object)new FailedUploadPart(multipartCopy.multipartUpload(), multipartCopy.copyPartition().partNumber(), ex));
            }).mapAsync(parallelism, (Function1 & Serializable)x -> (Future)Predef$.MODULE$.identity(x));
        });
    }

    private S3Settings resolveSettings(Attributes attr, ActorSystem sys) {
        return (S3Settings)attr.get(ClassTag$.MODULE$.apply(S3SettingsValue.class)).map((Function1 & Serializable)x$42 -> x$42.settings()).getOrElse((Function0 & Serializable)() -> {
            S3Ext s3Extension = (S3Ext)S3Ext$.MODULE$.apply(sys);
            return (S3Settings)attr.get(ClassTag$.MODULE$.apply(S3SettingsPath.class)).map((Function1 & Serializable)settingsPath -> s3Extension.settings(settingsPath.path())).getOrElse((Function0 & Serializable)() -> s3Extension.settings());
        });
    }

    private final Future listBucketCallOnlyContents$1(Option token, ActorMaterializer mat, Attributes attr, String bucket$1, Option prefix$1, S3Headers s3Headers$1) {
        return this.listBucketCall(bucket$1, (Option<String>)prefix$1, (Option<String>)None$.MODULE$, s3Headers$1, (Option<String>)token, (Function1 & Serializable)x$3 -> x$3.contents(), mat, attr);
    }

    private final Future listBucketCallContentsAndCommonPrefixes$1(Option token, ActorMaterializer mat, Attributes attr, String bucket$2, Option prefix$2, String delimiter$1, S3Headers s3Headers$2) {
        return this.listBucketCall(bucket$2, (Option<String>)prefix$2, (Option<String>)new Some((Object)delimiter$1), s3Headers$2, (Option<String>)token, (Function1 & Serializable)listBucketResult -> new Tuple2(listBucketResult.contents(), listBucketResult.commonPrefixes()), mat, attr);
    }

    public static final /* synthetic */ boolean $anonfun$completeMultipartUpload$1(akka.http.scaladsl.model.HttpHeader x$20) {
        String string = x$20.lowercaseName();
        String string2 = "x-amz-version-id";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final CompleteMultipartUploadResult populateResult$1(CompleteMultipartUploadResult result, Seq headers) {
        Option versionId2;
        Option x$1 = versionId2 = headers.find((Function1 & Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)S3Stream$.$anonfun$completeMultipartUpload$1(x$20))).map((Function1 & Serializable)x$21 -> x$21.value());
        Uri x$2 = result.copy$default$1();
        String x$3 = result.copy$default$2();
        String x$4 = result.copy$default$3();
        String x$5 = result.copy$default$4();
        return result.copy(x$2, x$3, x$4, x$5, (Option<String>)x$1);
    }

    private static final GraphStage getChunkBuffer$1(int chunkSize, int bufferSize, int maxRetriesPerChunk, S3Settings settings) {
        GraphStage graphStage;
        BufferType bufferType = settings.bufferType();
        if (MemoryBufferType$.MODULE$.equals(bufferType)) {
            graphStage = new MemoryBuffer(bufferSize);
        } else if (bufferType instanceof DiskBufferType) {
            DiskBufferType diskBufferType = (DiskBufferType)bufferType;
            graphStage = new DiskBuffer((maxRetriesPerChunk + 1) * 2, bufferSize, diskBufferType.path());
        } else {
            throw new MatchError((Object)bufferType);
        }
        return graphStage;
    }

    public static final /* synthetic */ boolean $anonfun$chunkAndRequest$7(Chunk x$29) {
        return x$29.size() > 0;
    }

    public static final /* synthetic */ int $anonfun$chunkAndRequest$8(int parallelism$1, Tuple2 x0$4) {
        Tuple2 tuple2;
        Tuple2 tuple22 = x0$4;
        if (tuple22 == null || (tuple2 = (Tuple2)tuple22._2()) == null) {
            throw new MatchError((Object)tuple22);
        }
        int chunkIndex = tuple2._2$mcI$sp();
        int n = chunkIndex % parallelism$1;
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ Option $anonfun$chunkAndRequest$9(Materializer materializer$7, Tuple2 x0$5, Tuple2 x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$5, (Object)x1$1);
        if (tuple2 != null) {
            Try try_;
            Tuple2 chunkAndUploadInfo = (Tuple2)tuple2._1();
            Tuple2 tuple22 = (Tuple2)tuple2._2();
            if (tuple22 != null && (try_ = (Try)tuple22._1()) instanceof Success) {
                None$ none$;
                Success success = (Success)try_;
                HttpResponse r = (HttpResponse)success.value();
                if (MODULE$.isTransientError(r.status())) {
                    HttpEntity.HttpEntityScalaDSLSugar$.MODULE$.discardBytes$extension(HttpEntity$.MODULE$.HttpEntityScalaDSLSugar((HttpEntity)r.entity()), materializer$7);
                    none$ = new Some((Object)chunkAndUploadInfo);
                    return none$;
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Tuple2 chunkAndUploadInfo = (Tuple2)tuple2._1();
        Tuple2 tuple23 = (Tuple2)tuple2._2();
        if (tuple23 == null) throw new MatchError((Object)tuple2);
        Try try_ = (Try)tuple23._1();
        if (!(try_ instanceof Failure)) throw new MatchError((Object)tuple2);
        return new Some((Object)chunkAndUploadInfo);
    }

    public static final /* synthetic */ Future $anonfun$chunkAndRequest$10(S3Settings conf$1, Materializer materializer$7, Tuple2 x0$6) {
        Tuple2 tuple2;
        Try response;
        block3: {
            Tuple2 tuple22;
            block2: {
                tuple22 = x0$6;
                if (tuple22 == null) break block2;
                response = (Try)tuple22._1();
                tuple2 = (Tuple2)tuple22._2();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)tuple22);
        }
        MultipartUpload upload = (MultipartUpload)tuple2._1();
        int index = tuple2._2$mcI$sp();
        Future<Product> future = MODULE$.handleChunkResponse((Try<HttpResponse>)response, upload, index, conf$1.multipartUploadSettings().retrySettings(), materializer$7);
        return future;
    }

    public static final /* synthetic */ boolean $anonfun$handleChunkResponse$2(akka.http.scaladsl.model.HttpHeader x$31) {
        String string = x$31.lowercaseName();
        String string2 = "etag";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$signAndGetAs$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    private S3Stream$() {
    }
}

